/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.html.HtmlPeer;
import com.lowagie.text.html.HtmlTagMap;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.xml.SAXiTextHandler;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class SAXmyHtmlHandler
extends SAXiTextHandler<HtmlPeer> {
    private Properties bodyAttributes = new Properties();
    private boolean tableBorder = false;

    public SAXmyHtmlHandler(DocListener document) {
        this(document, new HtmlTagMap());
    }

    public SAXmyHtmlHandler(DocListener document, HtmlTagMap htmlTags) {
        this(document, htmlTags, (BaseFont)null);
    }

    public SAXmyHtmlHandler(DocListener document, HtmlTagMap htmlTags, BaseFont bf2) {
        super(document, htmlTags, bf2);
    }

    public SAXmyHtmlHandler(DocListener document, BaseFont bf2) {
        this(document, new HtmlTagMap(), bf2);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) {
        String lowerCaseName = name.toLowerCase();
        if (HtmlTagMap.isHtml(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isHead(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isTitle(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isMeta(lowerCaseName)) {
            String meta = null;
            String content = null;
            if (attrs != null) {
                for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
                    String attribute = attrs.getQName(i2);
                    if (attribute.equalsIgnoreCase("content")) {
                        content = attrs.getValue(i2);
                        continue;
                    }
                    if (!attribute.equalsIgnoreCase("name")) continue;
                    meta = attrs.getValue(i2);
                }
            }
            if (meta != null && content != null) {
                this.bodyAttributes.put(meta, content);
            }
            return;
        }
        if (HtmlTagMap.isLink(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isBody(lowerCaseName)) {
            HtmlPeer peer = new HtmlPeer("itext", lowerCaseName);
            peer.addAlias("top", "topmargin");
            peer.addAlias("bottom", "bottommargin");
            peer.addAlias("right", "rightmargin");
            peer.addAlias("left", "leftmargin");
            this.bodyAttributes.putAll((Map<?, ?>)peer.getAttributes(attrs));
            this.handleStartingTags(peer.getTag(), this.bodyAttributes);
            return;
        }
        if (this.myTags.containsKey(lowerCaseName)) {
            HtmlPeer peer = (HtmlPeer)this.myTags.get(lowerCaseName);
            if ("table".equals(peer.getTag()) || "cell".equals(peer.getTag())) {
                String value;
                Properties p2 = peer.getAttributes(attrs);
                if ("table".equals(peer.getTag()) && (value = p2.getProperty("borderwidth")) != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (Float.parseFloat(stringBuilder.append(value).append("f").toString()) > 0.0f) {
                        this.tableBorder = true;
                    }
                }
                if (this.tableBorder) {
                    p2.put("left", String.valueOf(true));
                    p2.put("right", String.valueOf(true));
                    p2.put("top", String.valueOf(true));
                    p2.put("bottom", String.valueOf(true));
                }
                this.handleStartingTags(peer.getTag(), p2);
                return;
            }
            this.handleStartingTags(peer.getTag(), peer.getAttributes(attrs));
            return;
        }
        Properties attributes = new Properties();
        if (attrs != null) {
            for (int i3 = 0; i3 < attrs.getLength(); ++i3) {
                String attribute = attrs.getQName(i3).toLowerCase();
                attributes.setProperty(attribute, attrs.getValue(i3).toLowerCase());
            }
        }
        this.handleStartingTags(lowerCaseName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        String lowerCaseName = name.toLowerCase();
        if ("paragraph".equals(lowerCaseName)) {
            try {
                this.document.add((Element)this.stack.pop());
                return;
            }
            catch (DocumentException e2) {
                throw new ExceptionConverter(e2);
            }
        }
        if (HtmlTagMap.isHead(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isTitle(lowerCaseName)) {
            if (this.currentChunk != null) {
                this.bodyAttributes.put("title", this.currentChunk.getContent());
                this.currentChunk = null;
            }
            return;
        }
        if (HtmlTagMap.isMeta(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isLink(lowerCaseName)) {
            return;
        }
        if (HtmlTagMap.isBody(lowerCaseName)) {
            return;
        }
        if (this.myTags.containsKey(lowerCaseName)) {
            HtmlPeer peer = (HtmlPeer)this.myTags.get(lowerCaseName);
            if ("table".equals(peer.getTag())) {
                this.tableBorder = false;
            }
            super.handleEndingTags(peer.getTag());
            return;
        }
        this.handleEndingTags(lowerCaseName);
    }
}

