/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import java.awt.Color;

public final class HtmlEncoder {
    private static final String[] htmlCode;

    private HtmlEncoder() {
    }

    public static String encode(String string) {
        int n2 = string.length();
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            char character = string.charAt(i2);
            if (character < '\u0100') {
                buffer.append(htmlCode[character]);
                continue;
            }
            buffer.append("&#").append((int)character).append(';');
        }
        return buffer.toString();
    }

    public static String encode(Color color) {
        StringBuilder buffer = new StringBuilder("#");
        if (color.getRed() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getRed(), 16));
        if (color.getGreen() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getGreen(), 16));
        if (color.getBlue() < 16) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(color.getBlue(), 16));
        return buffer.toString();
    }

    public static String getAlignment(int alignment) {
        switch (alignment) {
            case 0: {
                return "Left";
            }
            case 1: {
                return "Center";
            }
            case 2: {
                return "Right";
            }
            case 3: 
            case 8: {
                return "Justify";
            }
            case 4: {
                return "Top";
            }
            case 5: {
                return "Middle";
            }
            case 6: {
                return "Bottom";
            }
            case 7: {
                return "Baseline";
            }
        }
        return "";
    }

    static {
        int i2;
        htmlCode = new String[256];
        for (i2 = 0; i2 < 10; ++i2) {
            HtmlEncoder.htmlCode[i2] = "&#00" + i2 + ";";
        }
        for (i2 = 10; i2 < 32; ++i2) {
            HtmlEncoder.htmlCode[i2] = "&#0" + i2 + ";";
        }
        for (i2 = 32; i2 < 128; ++i2) {
            HtmlEncoder.htmlCode[i2] = String.valueOf((char)i2);
        }
        HtmlEncoder.htmlCode[9] = "\t";
        HtmlEncoder.htmlCode[10] = "<br />\n";
        HtmlEncoder.htmlCode[34] = "&quot;";
        HtmlEncoder.htmlCode[38] = "&amp;";
        HtmlEncoder.htmlCode[60] = "&lt;";
        HtmlEncoder.htmlCode[62] = "&gt;";
        for (i2 = 128; i2 < 256; ++i2) {
            HtmlEncoder.htmlCode[i2] = "&#" + i2 + ";";
        }
    }
}

