/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.LargeElement;
import com.lowagie.text.Phrase;
import com.lowagie.text.Row;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.TableRectangle;
import com.lowagie.text.alignment.HorizontalAlignment;
import com.lowagie.text.alignment.VerticalAlignment;
import com.lowagie.text.alignment.WithHorizontalAlignment;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;

public class Table
extends TableRectangle
implements LargeElement,
WithHorizontalAlignment {
    protected boolean autoFillEmptyCells = false;
    protected boolean convert2pdfptable = false;
    protected boolean notAddedYet = true;
    protected boolean complete = true;
    boolean tableFitsPage = false;
    boolean cellsFitPage = false;
    float offset = Float.NaN;
    private int columns;
    private ArrayList<Row> rows = new ArrayList();
    private Point curPosition = new Point(0, 0);
    private Cell defaultCell = new Cell(true);
    private int lastHeaderRow = -1;
    private int alignment = 1;
    private float cellpadding;
    private float cellspacing;
    private float width = 80.0f;
    private boolean locked = false;
    private float[] widths;
    private boolean mTableInserted = false;

    public Table(int columns) throws BadElementException {
        this(columns, 1);
    }

    public Table(int columns, int rows) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(1.0f);
        this.defaultCell.setBorder(15);
        if (columns <= 0) {
            throw new BadElementException(MessageLocalization.getComposedMessage("a.table.should.have.at.least.1.column"));
        }
        this.columns = columns;
        for (int i2 = 0; i2 < rows; ++i2) {
            this.rows.add(new Row(columns));
        }
        this.curPosition = new Point(0, 0);
        this.widths = new float[columns];
        float width = 100.0f / (float)columns;
        for (int i3 = 0; i3 < columns; ++i3) {
            this.widths[i3] = width;
        }
    }

    public Table(Table t2) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.cloneNonPositionParameters(t2);
        this.columns = t2.columns;
        this.rows = t2.rows;
        this.curPosition = t2.curPosition;
        this.defaultCell = t2.defaultCell;
        this.lastHeaderRow = t2.lastHeaderRow;
        this.alignment = t2.alignment;
        this.cellpadding = t2.cellpadding;
        this.cellspacing = t2.cellspacing;
        this.width = t2.width;
        this.widths = t2.widths;
        this.autoFillEmptyCells = t2.autoFillEmptyCells;
        this.tableFitsPage = t2.tableFitsPage;
        this.cellsFitPage = t2.cellsFitPage;
        this.offset = t2.offset;
        this.convert2pdfptable = t2.convert2pdfptable;
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 22;
    }

    @Override
    public ArrayList<Element> getChunks() {
        return new ArrayList<Element>();
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public int getColumns() {
        return this.columns;
    }

    public int size() {
        return this.rows.size();
    }

    public Dimension getDimension() {
        return new Dimension(this.columns, this.size());
    }

    public Cell getDefaultCell() {
        return this.defaultCell;
    }

    public void setDefaultCell(Cell value) {
        this.defaultCell = value;
    }

    public int getLastHeaderRow() {
        return this.lastHeaderRow;
    }

    public void setLastHeaderRow(int value) {
        this.lastHeaderRow = value;
    }

    public int endHeaders() {
        this.lastHeaderRow = this.curPosition.x - 1;
        return this.lastHeaderRow;
    }

    public int getAlignment() {
        return this.alignment;
    }

    @Deprecated
    public void setAlignment(int value) {
        this.alignment = value;
    }

    @Deprecated
    public void setAlignment(String alignment) {
        if ("Left".equalsIgnoreCase(alignment)) {
            this.alignment = 0;
            return;
        }
        if ("right".equalsIgnoreCase(alignment)) {
            this.alignment = 2;
            return;
        }
        this.alignment = 1;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        if (alignment == null) {
            return;
        }
        this.alignment = alignment.getId();
    }

    public float getPadding() {
        return this.cellpadding;
    }

    public void setPadding(float value) {
        this.cellpadding = value;
    }

    public float getSpacing() {
        return this.cellspacing;
    }

    public void setSpacing(float value) {
        this.cellspacing = value;
    }

    public void setAutoFillEmptyCells(boolean aDoAutoFill) {
        this.autoFillEmptyCells = aDoAutoFill;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public float[] getProportionalWidths() {
        return this.widths;
    }

    public void setWidths(float[] widths) throws BadElementException {
        if (widths.length != this.columns) {
            throw new BadElementException(MessageLocalization.getComposedMessage("wrong.number.of.columns"));
        }
        float hundredPercent = 0.0f;
        for (int i2 = 0; i2 < this.columns; ++i2) {
            hundredPercent += widths[i2];
        }
        this.widths[this.columns - 1] = 100.0f;
        for (int i3 = 0; i3 < this.columns - 1; ++i3) {
            float width;
            this.widths[i3] = width = 100.0f * widths[i3] / hundredPercent;
            int n2 = this.columns - 1;
            this.widths[n2] = this.widths[n2] - width;
        }
    }

    public void setWidths(int[] widths) throws DocumentException {
        float[] tb = new float[widths.length];
        for (int k2 = 0; k2 < widths.length; ++k2) {
            tb[k2] = widths[k2];
        }
        this.setWidths(tb);
    }

    public boolean isTableFitsPage() {
        return this.tableFitsPage;
    }

    public void setTableFitsPage(boolean fitPage) {
        this.tableFitsPage = fitPage;
        if (fitPage) {
            this.setCellsFitPage(true);
        }
    }

    public boolean isCellsFitPage() {
        return this.cellsFitPage;
    }

    public void setCellsFitPage(boolean fitPage) {
        this.cellsFitPage = fitPage;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public boolean isConvert2pdfptable() {
        return this.convert2pdfptable;
    }

    public void setConvert2pdfptable(boolean convert2pdfptable) {
        this.convert2pdfptable = convert2pdfptable;
    }

    public void addCell(Cell aCell, int row, int column) throws BadElementException {
        this.addCell(aCell, new Point(row, column));
    }

    public void addCell(Cell aCell, Point aLocation) throws BadElementException {
        if (aCell == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("addcell.cell.has.null.value"));
        }
        if (aLocation == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("addcell.point.has.null.value"));
        }
        if (aCell.isTable()) {
            this.insertTable((Table)aCell.getElements().next(), aLocation);
        }
        if (aLocation.x < 0) {
            throw new BadElementException(MessageLocalization.getComposedMessage("row.coordinate.of.location.must.be.gt.eq.0"));
        }
        if (aLocation.y <= 0 && aLocation.y > this.columns) {
            throw new BadElementException(MessageLocalization.getComposedMessage("column.coordinate.of.location.must.be.gt.eq.0.and.lt.nr.of.columns"));
        }
        if (!this.isValidLocation(aCell, aLocation)) {
            throw new BadElementException(MessageLocalization.getComposedMessage("adding.a.cell.at.the.location.1.2.with.a.colspan.of.3.and.a.rowspan.of.4.is.illegal.beyond.boundaries.overlapping", String.valueOf(aLocation.x), String.valueOf(aLocation.y), String.valueOf(aCell.getColspan()), String.valueOf(aCell.getRowspan())));
        }
        if (aCell.getBorder() == -1) {
            aCell.setBorder(this.defaultCell.getBorder());
        }
        aCell.fill();
        this.placeCell(this.rows, aCell, aLocation);
        this.setCurrentLocationToNextValidPosition(aLocation);
    }

    public void addCell(Cell cell) {
        try {
            this.addCell(cell, this.curPosition);
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
    }

    public void addCell(Phrase content) throws BadElementException {
        this.addCell(content, this.curPosition);
    }

    public void addCell(Phrase content, Point location) throws BadElementException {
        Cell cell = new Cell(content);
        cell.setBorder(this.defaultCell.getBorder());
        cell.setBorderWidth(this.defaultCell.getBorderWidth());
        cell.setBorderColor(this.defaultCell.getBorderColor());
        cell.setBackgroundColor(this.defaultCell.getBackgroundColor());
        Optional<HorizontalAlignment> optionalHorizontalAlignment = HorizontalAlignment.of(this.defaultCell.getHorizontalAlignment());
        cell.setHorizontalAlignment(optionalHorizontalAlignment.orElse(HorizontalAlignment.UNDEFINED));
        Optional<VerticalAlignment> optionalVerticalAlignment = VerticalAlignment.of(this.defaultCell.getVerticalAlignment());
        cell.setVerticalAlignment(optionalVerticalAlignment.orElse(VerticalAlignment.UNDEFINED));
        cell.setColspan(this.defaultCell.getColspan());
        cell.setRowspan(this.defaultCell.getRowspan());
        this.addCell(cell, location);
    }

    public void addCell(String content) throws BadElementException {
        this.addCell(new Phrase(content), this.curPosition);
    }

    public void addCell(String content, Point location) throws BadElementException {
        this.addCell(new Phrase(content), location);
    }

    public void insertTable(Table aTable) {
        if (aTable == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("inserttable.table.has.null.value"));
        }
        this.insertTable(aTable, this.curPosition);
    }

    public void insertTable(Table aTable, int row, int column) {
        if (aTable == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("inserttable.table.has.null.value"));
        }
        this.insertTable(aTable, new Point(row, column));
    }

    public void insertTable(Table aTable, Point aLocation) {
        if (aTable == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("inserttable.table.has.null.value"));
        }
        if (aLocation == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("inserttable.point.has.null.value"));
        }
        this.mTableInserted = true;
        aTable.complete();
        if (aLocation.y > this.columns) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("inserttable.wrong.columnposition.1.of.location.max.eq.2", String.valueOf(aLocation.y), String.valueOf(this.columns)));
        }
        int rowCount = aLocation.x + 1 - this.rows.size();
        if (rowCount > 0) {
            for (int i2 = 0; i2 < rowCount; ++i2) {
                this.rows.add(new Row(this.columns));
            }
        }
        this.rows.get(aLocation.x).setElement(aTable, aLocation.y);
        this.setCurrentLocationToNextValidPosition(aLocation);
    }

    public void addColumns(int aColumns) {
        int j2;
        ArrayList<Row> newRows = new ArrayList<Row>(this.rows.size());
        int newColumns = this.columns + aColumns;
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            Row row = new Row(newColumns);
            for (j2 = 0; j2 < this.columns; ++j2) {
                row.setElement(this.rows.get(i2).getCell(j2), j2);
            }
            for (j2 = this.columns; j2 < newColumns && i2 < this.curPosition.x; ++j2) {
                row.setElement(null, j2);
            }
            newRows.add(row);
        }
        float[] newWidths = new float[newColumns];
        System.arraycopy(this.widths, 0, newWidths, 0, this.columns);
        for (j2 = this.columns; j2 < newColumns; ++j2) {
            newWidths[j2] = 0.0f;
        }
        this.columns = newColumns;
        this.widths = newWidths;
        this.rows = newRows;
    }

    public void deleteColumn(int column) throws BadElementException {
        float[] newWidths = new float[--this.columns];
        System.arraycopy(this.widths, 0, newWidths, 0, column);
        System.arraycopy(this.widths, column + 1, newWidths, column, this.columns - column);
        this.setWidths(newWidths);
        System.arraycopy(this.widths, 0, newWidths, 0, this.columns);
        this.widths = newWidths;
        int size = this.rows.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Row row = this.rows.get(i2);
            row.deleteColumn(column);
            this.rows.set(i2, row);
        }
        if (column == this.columns) {
            this.curPosition.setLocation(this.curPosition.x + 1, 0);
        }
    }

    public boolean deleteRow(int row) {
        if (row < 0 || row >= this.rows.size()) {
            return false;
        }
        this.rows.remove(row);
        this.curPosition.setLocation(this.curPosition.x - 1, this.curPosition.y);
        return true;
    }

    public void deleteAllRows() {
        this.rows.clear();
        this.rows.add(new Row(this.columns));
        this.curPosition.setLocation(0, 0);
        this.lastHeaderRow = -1;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public void complete() {
        if (this.mTableInserted) {
            this.mergeInsertedTables();
            this.mTableInserted = false;
        }
        if (this.autoFillEmptyCells) {
            this.fillEmptyMatrixCells();
        }
    }

    public TableRectangle getElement(int row, int column) {
        return this.rows.get(row).getCell(column);
    }

    private void mergeInsertedTables() {
        Table lDummyTable;
        int i2;
        int j2;
        int[] lDummyWidths = new int[this.columns];
        float[][] lDummyColumnWidths = new float[this.columns][];
        int[] lDummyHeights = new int[this.rows.size()];
        boolean isTable = false;
        int lTotalRows = 0;
        int lTotalColumns = 0;
        for (j2 = 0; j2 < this.columns; ++j2) {
            int lNewMaxColumns = 1;
            float[] tmpWidths = null;
            for (i2 = 0; i2 < this.rows.size(); ++i2) {
                if (!(this.rows.get(i2).getCell(j2) instanceof Table)) continue;
                isTable = true;
                lDummyTable = (Table)this.rows.get(i2).getCell(j2);
                if (tmpWidths == null) {
                    tmpWidths = lDummyTable.widths;
                    lNewMaxColumns = tmpWidths.length;
                    continue;
                }
                int cols = lDummyTable.getDimension().width;
                float[] tmpWidthsN = new float[cols * tmpWidths.length];
                float tpW = 0.0f;
                float btW = 0.0f;
                float totW = 0.0f;
                int tpI = 0;
                int btI = 0;
                int totI = 0;
                tpW += tmpWidths[0];
                btW += lDummyTable.widths[0];
                while (tpI < tmpWidths.length && btI < cols) {
                    if (btW > tpW) {
                        tmpWidthsN[totI] = tpW - totW;
                        if (++tpI < tmpWidths.length) {
                            tpW += tmpWidths[tpI];
                        }
                    } else {
                        tmpWidthsN[totI] = btW - totW;
                        ++btI;
                        if ((double)Math.abs(btW - tpW) < 1.0E-4 && ++tpI < tmpWidths.length) {
                            tpW += tmpWidths[tpI];
                        }
                        if (btI < cols) {
                            btW += lDummyTable.widths[btI];
                        }
                    }
                    totW += tmpWidthsN[totI];
                    ++totI;
                }
                tmpWidths = new float[totI];
                System.arraycopy(tmpWidthsN, 0, tmpWidths, 0, totI);
                lNewMaxColumns = totI;
            }
            lDummyColumnWidths[j2] = tmpWidths;
            lTotalColumns += lNewMaxColumns;
            lDummyWidths[j2] = lNewMaxColumns;
        }
        for (i2 = 0; i2 < this.rows.size(); ++i2) {
            int lNewMaxRows = 1;
            for (j2 = 0; j2 < this.columns; ++j2) {
                if (!(this.rows.get(i2).getCell(j2) instanceof Table)) continue;
                isTable = true;
                lDummyTable = (Table)this.rows.get(i2).getCell(j2);
                if (lDummyTable.getDimension().height <= lNewMaxRows) continue;
                lNewMaxRows = lDummyTable.getDimension().height;
            }
            lTotalRows += lNewMaxRows;
            lDummyHeights[i2] = lNewMaxRows;
        }
        if (lTotalColumns != this.columns || lTotalRows != this.rows.size() || isTable) {
            float[] lNewWidths = new float[lTotalColumns];
            int lDummy = 0;
            for (int tel = 0; tel < this.widths.length; ++tel) {
                if (lDummyWidths[tel] != 1) {
                    for (int tel2 = 0; tel2 < lDummyWidths[tel]; ++tel2) {
                        lNewWidths[lDummy] = this.widths[tel] * lDummyColumnWidths[tel][tel2] / 100.0f;
                        ++lDummy;
                    }
                    continue;
                }
                lNewWidths[lDummy] = this.widths[tel];
                ++lDummy;
            }
            ArrayList<Row> newRows = new ArrayList<Row>(lTotalRows);
            for (i2 = 0; i2 < lTotalRows; ++i2) {
                newRows.add(new Row(lTotalColumns));
            }
            int lDummyRow = 0;
            for (i2 = 0; i2 < this.rows.size(); ++i2) {
                int lDummyColumn = 0;
                for (j2 = 0; j2 < this.columns; ++j2) {
                    if (this.rows.get(i2).getCell(j2) instanceof Table) {
                        lDummyTable = (Table)this.rows.get(i2).getCell(j2);
                        int[] colMap = new int[lDummyTable.widths.length + 1];
                        int ct = 0;
                        for (int cb = 0; cb < lDummyTable.widths.length; ++cb) {
                            colMap[cb] = lDummyColumn + ct;
                            float wb = lDummyTable.widths[cb];
                            float wt = 0.0f;
                            while (ct < lDummyWidths[j2]) {
                                int n2 = ct++;
                                if (!((double)Math.abs(wb - (wt += lDummyColumnWidths[j2][n2])) < 1.0E-4)) continue;
                            }
                        }
                        colMap[cb] = lDummyColumn + ct;
                        for (int k2 = 0; k2 < lDummyTable.getDimension().height; ++k2) {
                            for (int l2 = 0; l2 < lDummyTable.getDimension().width; ++l2) {
                                TableRectangle lDummyElement = lDummyTable.getElement(k2, l2);
                                if (lDummyElement == null) continue;
                                int col = lDummyColumn + l2;
                                if (lDummyElement instanceof Cell) {
                                    Cell lDummyC = (Cell)lDummyElement;
                                    col = colMap[l2];
                                    int ot = colMap[l2 + lDummyC.getColspan()];
                                    lDummyC.setColspan(ot - col);
                                }
                                newRows.get(k2 + lDummyRow).addElement(lDummyElement, col);
                            }
                        }
                    } else {
                        TableRectangle aElement = this.getElement(i2, j2);
                        if (aElement instanceof Cell) {
                            ((Cell)aElement).setRowspan(((Cell)this.rows.get(i2).getCell(j2)).getRowspan() + lDummyHeights[i2] - 1);
                            ((Cell)aElement).setColspan(((Cell)this.rows.get(i2).getCell(j2)).getColspan() + lDummyWidths[j2] - 1);
                            this.placeCell(newRows, (Cell)aElement, new Point(lDummyRow, lDummyColumn));
                        }
                    }
                    lDummyColumn += lDummyWidths[j2];
                }
                lDummyRow += lDummyHeights[i2];
            }
            this.columns = lTotalColumns;
            this.rows = newRows;
            this.widths = lNewWidths;
        }
    }

    private void fillEmptyMatrixCells() {
        try {
            for (int i2 = 0; i2 < this.rows.size(); ++i2) {
                for (int j2 = 0; j2 < this.columns; ++j2) {
                    if (this.rows.get(i2).isReserved(j2)) continue;
                    this.addCell(this.defaultCell, new Point(i2, j2));
                }
            }
        }
        catch (BadElementException bee) {
            throw new ExceptionConverter(bee);
        }
    }

    private boolean isValidLocation(Cell aCell, Point aLocation) {
        if (aLocation.x < this.rows.size()) {
            if (aLocation.y + aCell.getColspan() > this.columns) {
                return false;
            }
            int difx = this.rows.size() - aLocation.x > aCell.getRowspan() ? aCell.getRowspan() : this.rows.size() - aLocation.x;
            int dify = this.columns - aLocation.y > aCell.getColspan() ? aCell.getColspan() : this.columns - aLocation.y;
            for (int i2 = aLocation.x; i2 < aLocation.x + difx; ++i2) {
                for (int j2 = aLocation.y; j2 < aLocation.y + dify; ++j2) {
                    if (!this.rows.get(i2).isReserved(j2)) continue;
                    return false;
                }
            }
        } else {
            return aLocation.y + aCell.getColspan() <= this.columns;
        }
        return true;
    }

    private void assumeTableDefaults(Cell aCell) {
        Optional<Enum> of;
        if (aCell.getBorder() == -1) {
            aCell.setBorder(this.defaultCell.getBorder());
        }
        if (aCell.getBorderWidth() == -1.0f) {
            aCell.setBorderWidth(this.defaultCell.getBorderWidth());
        }
        if (aCell.getBorderColor() == null) {
            aCell.setBorderColor(this.defaultCell.getBorderColor());
        }
        if (aCell.getBackgroundColor() == null) {
            aCell.setBackgroundColor(this.defaultCell.getBackgroundColor());
        }
        if (aCell.getHorizontalAlignment() == -1) {
            of = HorizontalAlignment.of(this.defaultCell.getHorizontalAlignment());
            aCell.setHorizontalAlignment(of.orElse(HorizontalAlignment.UNDEFINED));
        }
        if (aCell.getVerticalAlignment() == -1) {
            of = VerticalAlignment.of(this.defaultCell.getVerticalAlignment());
            aCell.setVerticalAlignment((VerticalAlignment)((Object)of.orElse((HorizontalAlignment)((Object)VerticalAlignment.UNDEFINED))));
        }
    }

    private void placeCell(ArrayList<Row> someRows, Cell aCell, Point aPosition) {
        Row row;
        int i2;
        int rowCount = aPosition.x + aCell.getRowspan() - someRows.size();
        this.assumeTableDefaults(aCell);
        if (aPosition.x + aCell.getRowspan() > someRows.size()) {
            for (i2 = 0; i2 < rowCount; ++i2) {
                row = new Row(this.columns);
                someRows.add(row);
            }
        }
        for (i2 = aPosition.x + 1; i2 < aPosition.x + aCell.getRowspan(); ++i2) {
            if (someRows.get(i2).reserve(aPosition.y, aCell.getColspan())) continue;
            throw new RuntimeException(MessageLocalization.getComposedMessage("addcell.error.in.reserve"));
        }
        row = someRows.get(aPosition.x);
        row.addElement(aCell, aPosition.y);
    }

    private void setCurrentLocationToNextValidPosition(Point aLocation) {
        int i2 = aLocation.x;
        int j2 = aLocation.y;
        do {
            if (j2 + 1 == this.columns) {
                ++i2;
                j2 = 0;
                continue;
            }
            ++j2;
        } while (i2 < this.rows.size() && j2 < this.columns && this.rows.get(i2).isReserved(j2));
        this.curPosition = new Point(i2, j2);
    }

    public float[] getWidths(float left, float totalWidth) {
        float[] w2 = new float[this.columns + 1];
        float wPercentage = this.locked ? 100.0f * this.width / totalWidth : this.width;
        switch (this.alignment) {
            case 0: {
                w2[0] = left;
                break;
            }
            case 2: {
                w2[0] = left + totalWidth * (100.0f - wPercentage) / 100.0f;
                break;
            }
            default: {
                w2[0] = left + totalWidth * (100.0f - wPercentage) / 200.0f;
            }
        }
        totalWidth = totalWidth * wPercentage / 100.0f;
        for (int i2 = 1; i2 < this.columns; ++i2) {
            w2[i2] = w2[i2 - 1] + this.widths[i2 - 1] * totalWidth / 100.0f;
        }
        w2[this.columns] = w2[0] + totalWidth;
        return w2;
    }

    public Iterator iterator() {
        return this.rows.iterator();
    }

    public PdfPTable createPdfPTable() throws BadElementException {
        if (!this.convert2pdfptable) {
            throw new BadElementException(MessageLocalization.getComposedMessage("no.error.just.an.old.style.table"));
        }
        this.setAutoFillEmptyCells(true);
        this.complete();
        PdfPTable pdfptable = new PdfPTable(this.widths);
        pdfptable.setComplete(this.complete);
        if (this.isNotAddedYet()) {
            pdfptable.setSkipFirstHeader(true);
        }
        SimpleTable t_evt = new SimpleTable();
        t_evt.cloneNonPositionParameters(this);
        t_evt.setCellspacing(this.cellspacing);
        pdfptable.setTableEvent(t_evt);
        pdfptable.setHeaderRows(this.lastHeaderRow + 1);
        pdfptable.setSplitLate(this.cellsFitPage);
        pdfptable.setKeepTogether(this.tableFitsPage);
        if (!Float.isNaN(this.offset)) {
            pdfptable.setSpacingBefore(this.offset);
        }
        pdfptable.setHorizontalAlignment(this.alignment);
        if (this.locked) {
            pdfptable.setTotalWidth(this.width);
            pdfptable.setLockedWidth(true);
        } else {
            pdfptable.setWidthPercentage(this.width);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            for (int i2 = 0; i2 < row.getColumns(); ++i2) {
                PdfPCell pcell;
                TableRectangle cell = row.getCell(i2);
                if (cell == null) continue;
                if (cell instanceof Table) {
                    pcell = new PdfPCell(((Table)cell).createPdfPTable());
                } else if (cell instanceof Cell) {
                    pcell = ((Cell)cell).createPdfPCell();
                    pcell.setPadding(this.cellpadding + this.cellspacing / 2.0f);
                    SimpleCell c_evt = new SimpleCell(false);
                    c_evt.cloneNonPositionParameters((Cell)cell);
                    c_evt.setSpacing(this.cellspacing * 2.0f);
                    pcell.setCellEvent(c_evt);
                } else {
                    pcell = new PdfPCell();
                }
                pdfptable.addCell(pcell);
            }
        }
        return pdfptable;
    }

    public boolean isNotAddedYet() {
        return this.notAddedYet;
    }

    public void setNotAddedYet(boolean notAddedYet) {
        this.notAddedYet = notAddedYet;
    }

    @Override
    public void flushContent() {
        this.setNotAddedYet(false);
        ArrayList<Row> headerRows = new ArrayList<Row>();
        for (int i2 = 0; i2 < this.getLastHeaderRow() + 1; ++i2) {
            headerRows.add(this.rows.get(i2));
        }
        this.rows = headerRows;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Deprecated
    public Cell getDefaultLayout() {
        return this.getDefaultCell();
    }

    @Deprecated
    public void setDefaultLayout(Cell value) {
        this.defaultCell = value;
    }
}

