/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.factories.RomanNumberFactory;

public class RomanList
extends List {
    public RomanList() {
        super(true);
    }

    public RomanList(int symbolIndent) {
        super(true, symbolIndent);
    }

    public RomanList(boolean lowercase, int symbolIndent) {
        super(true, symbolIndent);
        this.lowercase = lowercase;
    }

    @Override
    public boolean add(Element o2) {
        if (o2 instanceof ListItem) {
            ListItem item = (ListItem)o2;
            Chunk chunk = new Chunk(this.preSymbol, this.symbol.getFont());
            chunk.append(RomanNumberFactory.getString(this.first + this.list.size(), this.lowercase));
            chunk.append(this.postSymbol);
            item.setListSymbol(chunk);
            item.setIndentationLeft(this.symbolIndent, this.autoindent);
            item.setIndentationRight(0.0f);
            this.list.add(item);
        } else if (o2 instanceof List) {
            List nested = (List)o2;
            nested.setIndentationLeft(nested.getIndentationLeft() + this.symbolIndent);
            --this.first;
            return this.list.add(nested);
        }
        return false;
    }

    @Override
    public boolean add(String s2) {
        return this.add(new ListItem(s2));
    }
}

