/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingUtils;
import com.idrsolutions.pdf.color.shading.Tri;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class Shape67 {
    private final GeneralPath shape = new GeneralPath();
    final float minX;
    final float minY;
    final float maxX;
    final float maxY;
    Tri[] tris;

    Shape67(Point2D[] sp, Color[] colors, int nSteps) {
        this.shape.moveTo(sp[0].getX(), sp[0].getY());
        this.shape.curveTo(sp[1].getX(), sp[1].getY(), sp[2].getX(), sp[2].getY(), sp[3].getX(), sp[3].getY());
        this.shape.curveTo(sp[4].getX(), sp[4].getY(), sp[5].getX(), sp[5].getY(), sp[6].getX(), sp[6].getY());
        this.shape.curveTo(sp[7].getX(), sp[7].getY(), sp[8].getX(), sp[8].getY(), sp[9].getX(), sp[9].getY());
        this.shape.curveTo(sp[10].getX(), sp[10].getY(), sp[11].getX(), sp[11].getY(), sp[0].getX(), sp[0].getY());
        this.shape.closePath();
        Rectangle2D bounds = this.shape.getBounds2D();
        this.mapBilinear(sp, colors, nSteps);
        this.minY = (float)bounds.getMinY();
        this.minX = (float)bounds.getMinX();
        this.maxX = (float)bounds.getMaxX();
        this.maxY = (float)bounds.getMaxY();
    }

    private void mapBilinear(Point2D[] pointsArr, Color[] colors, int nSteps) {
        Point2D[] C1 = Shape67.curvePoints(pointsArr[0], pointsArr[11], pointsArr[10], pointsArr[9], nSteps);
        Point2D[] C2 = Shape67.curvePoints(pointsArr[3], pointsArr[4], pointsArr[5], pointsArr[6], nSteps);
        Point2D[] D1 = Shape67.curvePoints(pointsArr[0], pointsArr[1], pointsArr[2], pointsArr[3], nSteps);
        Point2D[] D2 = Shape67.curvePoints(pointsArr[9], pointsArr[8], pointsArr[7], pointsArr[6], nSteps);
        int szuv = C1.length;
        int uvDim = szuv * szuv;
        float[] xPoints = new float[uvDim];
        float[] yPoints = new float[uvDim];
        int[] cc = new int[uvDim];
        float stepUV = 1.0f / (float)(szuv - 1);
        float v2 = -stepUV;
        int[][] pointColors = new int[4][3];
        for (int i2 = 0; i2 < 4; ++i2) {
            pointColors[i2] = new int[]{colors[i2].getRed(), colors[i2].getGreen(), colors[i2].getBlue()};
        }
        int p2 = 0;
        int[] temp = new int[3];
        double xC1 = C1[nSteps].getX();
        double yC1 = C1[nSteps].getY();
        double xC2 = C2[nSteps].getX();
        double yC2 = C2[nSteps].getY();
        double x0C1 = C1[0].getX();
        double y0C1 = C1[0].getY();
        double x0C2 = C2[0].getX();
        double y0C2 = C2[0].getY();
        for (int i3 = 0; i3 < szuv; ++i3) {
            double vMinus = 1.0f - (v2 += stepUV);
            float u2 = -stepUV;
            for (int j2 = 0; j2 < szuv; ++j2) {
                double uMinus = 1.0f - (u2 += stepUV);
                double scx = vMinus * C1[j2].getX() + (double)v2 * C2[j2].getX();
                double scy = vMinus * C1[j2].getY() + (double)v2 * C2[j2].getY();
                double sdx = uMinus * D1[i3].getX() + (double)u2 * D2[i3].getX();
                double sdy = uMinus * D1[i3].getY() + (double)u2 * D2[i3].getY();
                double sbx = vMinus * (uMinus * x0C1 + (double)u2 * xC1) + (double)v2 * (uMinus * x0C2 + (double)u2 * xC2);
                double sby = vMinus * (uMinus * y0C1 + (double)u2 * yC1) + (double)v2 * (uMinus * y0C2 + (double)u2 * yC2);
                xPoints[p2] = (float)(scx + sdx - sbx);
                yPoints[p2] = (float)(scy + sdy - sby);
                for (int ci = 0; ci < 3; ++ci) {
                    temp[ci] = (int)(vMinus * (uMinus * (double)pointColors[0][ci] + (double)(u2 * (float)pointColors[3][ci])) + (double)v2 * (uMinus * (double)pointColors[1][ci] + (double)(u2 * (float)pointColors[2][ci])));
                }
                cc[p2++] = temp[0] << 16 | temp[1] << 8 | temp[2];
            }
        }
        int d2 = szuv - 1;
        this.tris = new Tri[d2 * d2 * 2];
        Shape67.mapPatchToTriangles(xPoints, yPoints, cc, szuv, this.tris);
        Shape67.updateBounds(this.tris);
    }

    private static void updateBounds(Tri[] tris) {
        for (Tri tri : tris) {
            tri.minX = Math.min(Math.min(tri.x1, tri.x2), tri.x3);
            tri.maxX = Math.max(Math.max(tri.x1, tri.x2), tri.x3);
            tri.minY = Math.min(Math.min(tri.y1, tri.y2), tri.y3);
            tri.maxY = Math.max(Math.max(tri.y1, tri.y2), tri.y3);
        }
    }

    private static void mapPatchToTriangles(float[] xPoints, float[] yPoints, int[] cc, int szv, Tri[] tris) {
        int d2 = szv - 1;
        int trip = 0;
        for (int i2 = 0; i2 < d2; ++i2) {
            int s0 = i2 * szv;
            int s1 = (i2 + 1) * szv;
            for (int j2 = 0; j2 < d2; ++j2) {
                int p1 = s0 + j2;
                int p2 = p1 + 1;
                int p3 = s1 + j2;
                int p4 = p3 + 1;
                Tri tri = new Tri();
                tri.x1 = xPoints[p1];
                tri.y1 = yPoints[p1];
                tri.x2 = xPoints[p2];
                tri.y2 = yPoints[p2];
                tri.x3 = xPoints[p3];
                tri.y3 = yPoints[p3];
                tri.c1 = cc[p1];
                tri.c2 = cc[p2];
                tri.c3 = cc[p3];
                tris[trip++] = tri;
                tri = new Tri();
                tri.x1 = xPoints[p2];
                tri.y1 = yPoints[p2];
                tri.x2 = xPoints[p4];
                tri.y2 = yPoints[p4];
                tri.x3 = xPoints[p3];
                tri.y3 = yPoints[p3];
                tri.c1 = cc[p2];
                tri.c2 = cc[p4];
                tri.c3 = cc[p3];
                tris[trip++] = tri;
            }
        }
    }

    public GeneralPath getShape() {
        return this.shape;
    }

    private static Point2D[] curvePoints(Point2D p1, Point2D p2, Point2D p3, Point2D p4, int nSteps) {
        Point2D[] arr = new Point2D[nSteps + 1];
        arr[0] = p1;
        for (int i2 = 1; i2 <= nSteps; ++i2) {
            float t2 = 1.0f / (float)nSteps * (float)i2;
            arr[i2] = ShadingUtils.findDistancedPoint(t2, p1, p2, p3, p4);
        }
        return arr;
    }

    static int findPointColorInTris(Tri tri, float x2, float y2) {
        float d1 = x2 - tri.x3;
        float d2 = tri.x3 - tri.x2;
        float d3 = tri.x1 - tri.x3;
        float d4 = y2 - tri.y3;
        float d5 = tri.y2 - tri.y3;
        float d6 = d5 * d3 + d2 * (tri.y1 - tri.y3);
        if (d6 == 0.0f) {
            return 0;
        }
        float w1 = (d5 * d1 + d2 * d4) / d6;
        float w2 = ((tri.y3 - tri.y1) * d1 + d3 * d4) / d6;
        float w3 = 1.0f - w1 - w2;
        if (!(w1 < 0.0f || w2 < 0.0f || w3 < 0.0f)) {
            int v1 = tri.c1 >> 16 & 0xFF;
            int v2 = tri.c2 >> 16 & 0xFF;
            int v3 = tri.c3 >> 16 & 0xFF;
            int red = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
            v1 = tri.c1 >> 8 & 0xFF;
            v2 = tri.c2 >> 8 & 0xFF;
            v3 = tri.c3 >> 8 & 0xFF;
            int green = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
            v1 = tri.c1 & 0xFF;
            v2 = tri.c2 & 0xFF;
            v3 = tri.c3 & 0xFF;
            int blue = (int)(w1 * (float)v1 + w2 * (float)v2 + w3 * (float)v3);
            return 0xFF000000 | red << 16 | green << 8 | blue;
        }
        return 0;
    }
}

