/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import java.awt.Color;
import java.awt.geom.Point2D;
import org.jpedal.color.GenericColorSpace;

final class ShadingUtils {
    private ShadingUtils() {
    }

    public static Point2D findDistancedPoint(double t2, Point2D sp, Point2D c1, Point2D c2, Point2D ep) {
        double d2 = 1.0 - t2;
        double dCube = d2 * d2 * d2;
        double dSqr = d2 * d2;
        double tCube = t2 * t2 * t2;
        double tSqr = t2 * t2;
        double xCoord = dCube * sp.getX() + 3.0 * t2 * dSqr * c1.getX() + 3.0 * tSqr * d2 * c2.getX() + tCube * ep.getX();
        double yCoord = dCube * sp.getY() + 3.0 * t2 * dSqr * c1.getY() + 3.0 * tSqr * d2 * c2.getY() + tCube * ep.getY();
        return new Point2D.Double(xCoord, yCoord);
    }

    static void setBackground(int w2, int h2, int[] data, GenericColorSpace shadingColorSpace, float[] background) {
        shadingColorSpace.setColor(background);
        Color c2 = new Color(shadingColorSpace.getColor().getRGB());
        for (int i2 = 0; i2 < h2; ++i2) {
            for (int j2 = 0; j2 < w2; ++j2) {
                int base = (i2 * w2 + j2) * 4;
                data[base] = c2.getRed();
                data[base + 1] = c2.getGreen();
                data[base + 2] = c2.getBlue();
                data[base + 3] = 255;
            }
        }
    }

    public static void setBackgroundColor(int w2, int h2, int[] data, GenericColorSpace shadingColorSpace, float[] background) {
        shadingColorSpace.setColor(background);
        int cint = shadingColorSpace.getColor().getRGB();
        for (int i2 = 0; i2 < h2; ++i2) {
            for (int j2 = 0; j2 < w2; ++j2) {
                data[i2 * w2 + j2] = cint;
            }
        }
    }
}

