/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.PaintContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class Shading123
implements PaintContext {
    private static final int FUNCTION = 1;
    private static final int AXIAL = 2;
    private static final int RADIAL = 3;
    private final GenericColorSpace shadingColorSpace;
    private final PDFFunction[] function;
    private final float[] background;
    private final boolean hasLeftExt;
    private final boolean hasRightExt;
    private float t0;
    private float t1 = 1.0f;
    private float t2;
    private float t3 = 1.0f;
    private float x0;
    private float x1;
    private float y0;
    private float y1;
    private float r0;
    private float r1;
    private final float deltaX;
    private final float deltaY;
    private final float deltaR;
    private final float deltaC;
    private final float deltaT;
    private final float powerR0;
    private final float xObjX;
    private final float xObjY;
    private int colT0;
    private int colT1;
    private int lumW;
    private int lumH;
    private float lumX;
    private float lumY;
    private final float multiXY;
    private Rectangle2D bboxRect;
    private float[][] toUserSpace = Matrix.getIdentity();
    private final float[][] toShadeSpace;
    private int[] lumPixels;
    private final int type;
    private static final int NSTEPS = 15;
    private static final int WSTEPS = 16;
    private int[] colorArr;

    Shading123(int type, GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, PDFFunction[] function, float[] xObjCoords) {
        this.type = type;
        this.shadingColorSpace = shadingColorSpace;
        this.function = function;
        this.xObjX = xObjCoords[0];
        this.xObjY = xObjCoords[1];
        float[] domain = shadingObject.getFloatArray(1026641277);
        if (domain != null) {
            this.t0 = domain[0];
            this.t1 = domain[1];
            if (domain.length > 2) {
                this.t2 = domain[2];
                this.t3 = domain[3];
            }
        }
        this.background = background;
        boolean[] extension = shadingObject.getBooleanArray(1144345468);
        if (extension == null) {
            extension = new boolean[]{false, false};
        }
        this.hasLeftExt = extension[0];
        this.hasRightExt = extension[1];
        float[] bbox = shadingObject.getFloatArray(303185736);
        if (bbox != null) {
            this.bboxRect = Shading123.addPath(bbox);
        }
        float[][] caller = mm != null ? mm : Matrix.getIdentity();
        Object shadeMatrix = Matrix.getIdentity();
        float[] inputs = shadingObject.getFloatArray(1145198201);
        if (inputs != null) {
            shadeMatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        float[][] shader = Matrix.concatenate(caller, shadeMatrix);
        this.toShadeSpace = Matrix.inverse(shader);
        float[] coords = shadingObject.getFloatArray(1061308290);
        switch (type) {
            case 1: {
                this.populateColors();
                break;
            }
            case 2: {
                this.x0 = coords[0];
                this.y0 = coords[1];
                this.x1 = coords[2];
                this.y1 = coords[3];
                this.colT0 = 0xFF000000 | this.calculateColor(new float[]{this.t0});
                this.colT1 = 0xFF000000 | this.calculateColor(new float[]{this.t1});
                break;
            }
            case 3: {
                this.x0 = coords[0];
                this.y0 = coords[1];
                this.r0 = coords[2];
                this.x1 = coords[3];
                this.y1 = coords[4];
                this.r1 = coords[5];
                this.colT0 = 0xFF000000 | this.calculateColor(new float[]{this.t0});
                this.colT1 = 0xFF000000 | this.calculateColor(new float[]{this.t1});
            }
        }
        this.deltaX = this.x1 - this.x0;
        this.deltaY = this.y1 - this.y0;
        this.deltaR = this.r1 - this.r0;
        this.deltaT = this.t1 - this.t0;
        this.multiXY = this.deltaX * this.deltaX + this.deltaY * this.deltaY;
        this.deltaC = this.multiXY - this.deltaR * this.deltaR;
        this.powerR0 = this.r0 * this.r0;
    }

    private void populateColors() {
        this.colorArr = new int[256];
        float[] tv2 = new float[2];
        float xGap = this.t1 - this.t0;
        float yGap = this.t3 - this.t2;
        for (int y2 = 0; y2 <= 15; ++y2) {
            for (int x2 = 0; x2 <= 15; ++x2) {
                tv2[0] = this.t0 + xGap / 15.0f * (float)x2;
                tv2[1] = this.t2 + yGap / 15.0f * (float)y2;
                this.colorArr[x2 * 16 + y2] = this.calculateColor(tv2);
            }
        }
    }

    private static Rectangle2D addPath(float[] bbox) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(bbox[0], bbox[1]);
        gp.lineTo(bbox[2], bbox[1]);
        gp.lineTo(bbox[2], bbox[3]);
        gp.lineTo(bbox[0], bbox[3]);
        gp.lineTo(bbox[0], bbox[1]);
        gp.closePath();
        return gp.getBounds2D();
    }

    @Override
    public Raster getRaster(int startX, int startY, int w2, int h2) {
        WritableRaster raster = new BufferedImage(w2, h2, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w2, h2, data, this.shadingColorSpace, this.background);
        }
        float[] src = new float[2];
        float[] tv = new float[1];
        int lum = 0;
        for (int i2 = 0; i2 < h2; ++i2) {
            for (int j2 = 0; j2 < w2; ++j2) {
                boolean hasLum = false;
                src[0] = startX + j2;
                src[1] = startY + i2;
                Matrix.transformPixel(this.toUserSpace, src);
                src[0] = src[0] - this.xObjX;
                src[1] = src[1] - this.xObjY;
                if (this.lumPixels != null) {
                    int xLoc;
                    int yLoc;
                    int loc;
                    float lx1 = src[0];
                    float ly1 = src[1];
                    float lx2 = this.lumX + (float)this.lumW;
                    float ly2 = this.lumY + (float)this.lumH;
                    if (lx1 >= this.lumX && lx1 <= lx2 && ly1 >= this.lumY && ly1 <= ly2 && (loc = (yLoc = (int)(ly1 - this.lumY)) * this.lumW + (xLoc = (int)(lx1 - this.lumX))) < this.lumPixels.length) {
                        hasLum = true;
                        lum = this.lumPixels[loc];
                    }
                }
                Matrix.transformPixel(this.toShadeSpace, src);
                float x2 = src[0];
                float y2 = src[1];
                if (this.bboxRect != null && !this.bboxRect.contains(x2, y2)) continue;
                int t2 = 0;
                switch (this.type) {
                    case 1: {
                        t2 = this.getFunctionColor(x2, y2);
                        break;
                    }
                    case 2: {
                        t2 = this.getAxialColor(x2, y2, tv);
                        break;
                    }
                    case 3: {
                        t2 = this.getRadialColor(x2, y2, tv);
                    }
                }
                if (t2 == 0) continue;
                data[i2 * w2 + j2] = t2;
                if (!hasLum) continue;
                int r2 = lum >> 16 & 0xFF;
                int g2 = lum >> 8 & 0xFF;
                int b2 = lum & 0xFF;
                int yy = r2 * 77 + g2 * 152 + b2 * 28;
                int resA = t2 >> 24 & 0xFF;
                resA = resA * yy >> 16;
                data[i2 * w2 + j2] = resA << 24 | t2 & 0xFFFFFF;
            }
        }
        return raster;
    }

    private int getFunctionColor(float x2, float y2) {
        if (x2 < this.t0 || x2 > this.t1 || y2 < this.t2 || y2 > this.t3) {
            return 0;
        }
        float xf = (x2 - this.t0) / (this.t1 - this.t0) * 15.0f;
        float yf = (y2 - this.t2) / (this.t3 - this.t2) * 15.0f;
        int xx = (int)xf;
        int yy = (int)yf;
        if (xx < 15 && yy < 15) {
            int c00 = this.colorArr[xx * 16 + yy];
            int c10 = this.colorArr[(xx + 1) * 16 + yy];
            int c01 = this.colorArr[xx * 16 + (yy + 1)];
            int c11 = this.colorArr[(xx + 1) * 16 + (yy + 1)];
            return Shading123.interpolate4(c00, c10, c01, c11, xf - (float)xx, yf - (float)yy);
        }
        return this.colorArr[xx * 16 + yy];
    }

    private static int interpolate4(int c00, int c10, int c01, int c11, float gapX, float gapY) {
        int COLOR_X1 = Shading123.interpolate2(c00, c10, gapX);
        int COLOR_X2 = Shading123.interpolate2(c01, c11, gapX);
        return Shading123.interpolate2(COLOR_X1, COLOR_X2, gapY);
    }

    private static int interpolate2(int c1, int c2, float gap) {
        float INT_TO_FLOAT_CONST = 0.003921569f;
        float red1 = (float)(c1 >> 16 & 0xFF) * 0.003921569f;
        float green1 = (float)(c1 >> 8 & 0xFF) * 0.003921569f;
        float blue1 = (float)(c1 & 0xFF) * 0.003921569f;
        float red2 = (float)(c2 >> 16 & 0xFF) * 0.003921569f;
        float green2 = (float)(c2 >> 8 & 0xFF) * 0.003921569f;
        float blue2 = (float)(c2 & 0xFF) * 0.003921569f;
        float gapR = red2 - red1;
        float gapG = green2 - green1;
        float gapB = blue2 - blue1;
        float red = red1 + gapR * gap;
        float green = green1 + gapG * gap;
        float blue = blue1 + gapB * gap;
        int rr = (int)(red * 255.0f);
        int gg = (int)(green * 255.0f);
        int bb2 = (int)(blue * 255.0f);
        return 0xFF000000 | rr << 16 | gg << 8 | bb2;
    }

    private int getAxialColor(float x2, float y2, float[] tv) {
        float xp = (this.deltaX * (x2 - this.x0) + this.deltaY * (y2 - this.y0)) / this.multiXY;
        int t2 = 0;
        if (xp == 0.0f) {
            return this.colT0;
        }
        if (xp == 1.0f) {
            return this.colT1;
        }
        if (xp > 0.0f && xp < 1.0f) {
            tv[0] = this.t0 + this.deltaT * xp;
            t2 = this.calculateColor(tv);
        } else if (xp < 0.0f && this.hasLeftExt) {
            t2 = this.colT0;
        } else if (xp > 1.0f && this.hasRightExt) {
            t2 = this.colT1;
        }
        return t2;
    }

    private int getRadialColor(float x2, float y2, float[] tv) {
        float xx = x2;
        float yy = y2;
        float xDiff = xx - this.x0;
        float yDiff = yy - this.y0;
        float p2 = -xDiff * this.deltaX - yDiff * this.deltaY - this.r0 * this.deltaR;
        float q2 = xDiff * xDiff + yDiff * yDiff - this.powerR0;
        float sqrt = (float)Math.sqrt(p2 * p2 - this.deltaC * q2);
        float sA = (sqrt - p2) / this.deltaC;
        float sB = (-p2 - sqrt) / this.deltaC;
        if (this.deltaC < 0.0f) {
            xx = sA;
            yy = sB;
        } else {
            xx = sB;
            yy = sA;
        }
        int t2 = 0;
        if (yy >= 0.0f && yy <= 1.0f) {
            tv[0] = yy * this.deltaT + this.t0;
            t2 = this.calculateColor(tv);
        } else if (this.hasRightExt && yy >= 0.0f && this.r1 + yy * this.deltaR >= 0.0f) {
            t2 = this.colT1;
        } else if (xx >= 0.0f && xx <= 1.0f) {
            tv[0] = xx * this.deltaT + this.t0;
            t2 = this.calculateColor(tv);
        } else if (this.hasLeftExt && yy <= 0.0f && this.r1 + yy * this.deltaR >= 0.0f) {
            tv[0] = yy * this.deltaT + this.t0;
            t2 = this.calculateColor(tv);
        } else if (this.hasLeftExt && xx <= 1.0f && this.r1 + xx * this.deltaR >= 0.0f) {
            t2 = this.colT0;
        }
        return t2;
    }

    private int calculateColor(float[] val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, val);
        this.shadingColorSpace.setColor(colValues);
        return this.shadingColorSpace.getColor().getRGB();
    }

    public void setLuminosityMask(BufferedImage image, float x2, float y2) {
        this.lumPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        this.lumX = x2;
        this.lumY = y2;
        this.lumW = image.getWidth();
        this.lumH = image.getHeight();
    }

    public void updateXForm(float[][] xFormMatrix, float[][] gm) {
        float[][] xm = xFormMatrix;
        if (gm != null) {
            xm = Matrix.concatenate(xm, Matrix.inverse(gm));
        }
        this.toUserSpace = Matrix.inverse(xm);
    }

    public int getAverageColor() {
        return this.calculateColor(new float[]{(this.t0 + this.t1) * 0.5f});
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }
}

