/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class FreeFormShadeContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private float[][] toUserSpace = Matrix.getIdentity();
    private final float[][] toShadeSpace;
    private final float[] decodeArr;
    private final PDFFunction[] function;
    private final int nComp;
    private final float[] triCoords;
    private final float[] triMinMax;
    private final int[] intersects;
    private final List<Color> triColors;
    private final int triCount;
    private int[] lumPixels;
    private float lumX;
    private float lumY;
    private float lumW;
    private float lumH;
    private int lumIW;

    FreeFormShadeContext(GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, PDFFunction[] function) {
        this.shadingColorSpace = shadingColorSpace;
        int bitsPerComponent = shadingObject.getInt(-1344207655);
        int bitsPerFlag = shadingObject.getInt(1500422077);
        int bitsPerCoordinate = shadingObject.getInt(-335950113);
        this.decodeArr = shadingObject.getFloatArray(859785322);
        this.function = function;
        this.background = background;
        this.nComp = (this.decodeArr.length - 4) / 2;
        float[][] caller = mm != null ? mm : Matrix.getIdentity();
        Object shadeMatrix = Matrix.getIdentity();
        float[] inputs = shadingObject.getFloatArray(1145198201);
        if (inputs != null) {
            shadeMatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        float[][] shader = Matrix.concatenate(caller, shadeMatrix);
        this.toShadeSpace = Matrix.inverse(shader);
        boolean hasSmallBits = bitsPerFlag < 8 || bitsPerComponent < 8 || bitsPerCoordinate < 8;
        BitReader reader = new BitReader(shadingObject.getDecodedStream(), hasSmallBits);
        double bitCoordScaling = 1.0 / (double)((1L << bitsPerCoordinate) - 1L);
        double bitCompScaling = 1.0 / (double)((1L << bitsPerComponent) - 1L);
        ArrayList<Point2D> trianglesPoints = new ArrayList<Point2D>();
        this.triColors = new ArrayList<Color>();
        while (reader.getPointer() < reader.getTotalBitLen()) {
            int flag = reader.getPositive(bitsPerFlag);
            Point2D p2 = FreeFormShadeContext.getPointCoords(reader, bitCoordScaling, bitsPerCoordinate, this.decodeArr);
            Color c2 = this.getPointColor(reader, bitCompScaling, bitsPerComponent);
            switch (flag) {
                case 0: {
                    break;
                }
                case 1: {
                    Point2D[] temp = new Point2D[]{(Point2D)trianglesPoints.get(trianglesPoints.size() - 2), (Point2D)trianglesPoints.get(trianglesPoints.size() - 1)};
                    trianglesPoints.addAll(Arrays.asList(temp));
                    Color[] tc = new Color[]{this.triColors.get(this.triColors.size() - 2), this.triColors.get(this.triColors.size() - 1)};
                    this.triColors.addAll(Arrays.asList(tc));
                    break;
                }
                case 2: {
                    Point2D[] ff = new Point2D[]{(Point2D)trianglesPoints.get(trianglesPoints.size() - 3), (Point2D)trianglesPoints.get(trianglesPoints.size() - 1)};
                    trianglesPoints.addAll(Arrays.asList(ff));
                    Color[] fc = new Color[]{this.triColors.get(this.triColors.size() - 3), this.triColors.get(this.triColors.size() - 1)};
                    this.triColors.addAll(Arrays.asList(fc));
                }
            }
            trianglesPoints.add(p2);
            this.triColors.add(c2);
        }
        this.triCoords = new float[trianglesPoints.size() * 2];
        int p3 = 0;
        for (Point2D trianglesPoint : trianglesPoints) {
            this.triCoords[p3++] = (float)trianglesPoint.getX();
            this.triCoords[p3++] = (float)trianglesPoint.getY();
        }
        this.triCount = this.triCoords.length / 6;
        this.triMinMax = new float[this.triCount * 4];
        this.intersects = new int[this.triCount];
        this.fillMinMax();
    }

    private void fillMinMax() {
        int i2;
        int t2 = 0;
        for (i2 = 0; i2 < this.triCount; ++i2) {
            int pp = i2 * 3 << 1;
            float x1 = this.triCoords[pp];
            float y1 = this.triCoords[pp + 1];
            float x2 = this.triCoords[pp + 2];
            float y2 = this.triCoords[pp + 3];
            float x3 = this.triCoords[pp + 4];
            float y3 = this.triCoords[pp + 5];
            this.triMinMax[t2++] = Math.min(x1, Math.min(x2, x3));
            this.triMinMax[t2++] = Math.min(y1, Math.min(y2, y3));
            this.triMinMax[t2++] = Math.max(x1, Math.max(x2, x3));
            this.triMinMax[t2++] = Math.max(y1, Math.max(y2, y3));
        }
        for (i2 = 0; i2 < this.triCount; ++i2) {
            this.intersects[i2] = i2;
        }
    }

    public void updateXForm(float[][] xFormMatrix, float[][] gm) {
        float[][] xm = xFormMatrix;
        if (gm != null) {
            xm = Matrix.concatenate(xm, Matrix.inverse(gm));
        }
        this.toUserSpace = Matrix.inverse(xm);
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    private static Point2D getPointCoords(BitReader reader, double bitScaling, int bps, float[] decode) {
        long x_ = reader.readBitsAsLong(bps);
        long y_ = reader.readBitsAsLong(bps);
        double x2 = (double)x_ * bitScaling * (double)(decode[1] - decode[0]) + (double)decode[0];
        double y2 = (double)y_ * bitScaling * (double)(decode[3] - decode[2]) + (double)decode[2];
        return new Point2D.Double(x2, y2);
    }

    private Color getPointColor(BitReader reader, double bitScaling, int bps) {
        float[] components = new float[this.nComp];
        int i2 = 0;
        int j2 = 4;
        while (i2 < this.nComp) {
            long ci = reader.readBitsAsLong(bps);
            components[i2] = (float)((double)ci * bitScaling * (double)(this.decodeArr[j2 + 1] - this.decodeArr[j2]) + (double)this.decodeArr[j2]);
            ++i2;
            j2 += 2;
        }
        return this.calculateColor(components);
    }

    @Override
    public Raster getRaster(int startX, int startY, int w2, int h2) {
        float y2;
        float x2;
        float y1;
        float x1;
        int t2;
        WritableRaster raster = new BufferedImage(w2, h2, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w2, h2, data, this.shadingColorSpace, this.background);
        }
        int lum = 0;
        boolean hasLum = false;
        float[] src = new float[]{startX, startY};
        float[] src2 = new float[]{startX + w2, startY + h2};
        Matrix.transformPixel(this.toUserSpace, src);
        Matrix.transformPixel(this.toShadeSpace, src);
        Matrix.transformPixel(this.toUserSpace, src2);
        Matrix.transformPixel(this.toShadeSpace, src2);
        float rMinX = Math.min(src[0], src2[0]);
        float rMinY = Math.min(src[1], src2[1]);
        float rMaxX = Math.max(src[0], src2[0]);
        float rMaxY = Math.max(src[1], src2[1]);
        int triCount2 = 0;
        int pp = 0;
        for (t2 = 0; t2 < this.triCount; ++t2) {
            x1 = this.triMinMax[pp++];
            y1 = this.triMinMax[pp++];
            x2 = this.triMinMax[pp++];
            y2 = this.triMinMax[pp++];
            if (!(x1 <= rMaxX) || !(y1 <= rMaxY) || !(rMinX <= x2) || !(rMinY <= y2)) continue;
            this.intersects[triCount2] = t2 * 3;
            ++triCount2;
        }
        for (int i2 = 0; i2 < h2; ++i2) {
            block2: for (int j2 = 0; j2 < w2; ++j2) {
                src[0] = startX + j2;
                src[1] = startY + i2;
                Matrix.transformPixel(this.toUserSpace, src);
                if (this.lumPixels != null) {
                    int xLoc;
                    int yLoc;
                    int loc;
                    x1 = src[0];
                    y1 = src[1];
                    float xend = this.lumX + this.lumW;
                    float yend = this.lumY + this.lumH;
                    if (x1 >= this.lumX && x1 <= xend && y1 >= this.lumY && y1 <= yend && (loc = (yLoc = (int)(y1 - this.lumY)) * this.lumIW + (xLoc = (int)(x1 - this.lumX))) < this.lumPixels.length) {
                        hasLum = true;
                        lum = this.lumPixels[loc];
                    }
                }
                Matrix.transformPixel(this.toShadeSpace, src);
                float x3 = src[0];
                float y3 = src[1];
                for (t2 = 0; t2 < triCount2; ++t2) {
                    int p2 = this.intersects[t2];
                    pp = p2 << 1;
                    x1 = this.triCoords[pp];
                    y1 = this.triCoords[pp + 1];
                    x2 = this.triCoords[pp + 2];
                    y2 = this.triCoords[pp + 3];
                    float x32 = this.triCoords[pp + 4];
                    float y32 = this.triCoords[pp + 5];
                    float d1 = x3 - x32;
                    float d2 = x32 - x2;
                    float d3 = x1 - x32;
                    float d4 = y3 - y32;
                    float d5 = y2 - y32;
                    float d6 = d5 * d3 + d2 * (y1 - y32);
                    if (d6 == 0.0f) continue;
                    float w1 = (d5 * d1 + d2 * d4) / d6;
                    float w22 = ((y32 - y1) * d1 + d3 * d4) / d6;
                    float w3 = 1.0f - w1 - w22;
                    if (w1 < 0.0f || w22 < 0.0f || w3 < 0.0f) continue;
                    int c1 = this.triColors.get(p2).getRGB();
                    int c2 = this.triColors.get(p2 + 1).getRGB();
                    int c3 = this.triColors.get(p2 + 2).getRGB();
                    int v1 = c1 >> 16 & 0xFF;
                    int v2 = c2 >> 16 & 0xFF;
                    int v3 = c3 >> 16 & 0xFF;
                    int r2 = (int)(w1 * (float)v1 + w22 * (float)v2 + w3 * (float)v3);
                    v1 = c1 >> 8 & 0xFF;
                    v2 = c2 >> 8 & 0xFF;
                    v3 = c3 >> 8 & 0xFF;
                    int g2 = (int)(w1 * (float)v1 + w22 * (float)v2 + w3 * (float)v3);
                    v1 = c1 & 0xFF;
                    v2 = c2 & 0xFF;
                    v3 = c3 & 0xFF;
                    int b2 = (int)(w1 * (float)v1 + w22 * (float)v2 + w3 * (float)v3);
                    int pix = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
                    if (hasLum) {
                        r2 = lum >> 16 & 0xFF;
                        g2 = lum >> 8 & 0xFF;
                        b2 = lum & 0xFF;
                        int yy = r2 * 77 + g2 * 152 + b2 * 28;
                        int resA = pix >> 24 & 0xFF;
                        resA = resA * yy >> 16;
                        data[i2 * w2 + j2] = resA << 24 | pix & 0xFFFFFF;
                        continue block2;
                    }
                    data[i2 * w2 + j2] = pix;
                    continue block2;
                }
            }
        }
        return raster;
    }

    public void setLuminosityMask(BufferedImage image, float x2, float y2, float w2, float h2) {
        this.lumPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        this.lumX = x2;
        this.lumY = y2;
        this.lumIW = image.getWidth();
        this.lumW = w2;
        this.lumH = h2;
    }

    private Color calculateColor(float[] val) {
        if (this.function != null) {
            float[] colValues = ShadingFactory.applyFunctions(this.function, val);
            this.shadingColorSpace.setColor(colValues);
        } else {
            this.shadingColorSpace.setColor(val);
        }
        return new Color(this.shadingColorSpace.getColor().getRGB());
    }
}

