/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import com.idrsolutions.pdf.color.shading.Shape67;
import com.idrsolutions.pdf.color.shading.Tri;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.Matrix;

class CoonsContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private final int bitsPerCoordinate;
    private final int bitsPerComponent;
    private final int bitsPerFlag;
    private int colCompCount;
    private final float[] decodeArr;
    private final ArrayList<Point2D> pp;
    private final ArrayList<Color> pc;
    private final ArrayList<Shape67> shapes;
    private BitReader reader;
    private final PDFFunction[] function;
    private final float[][] toShadeSpace;
    private float[][] inversed = Matrix.getIdentity();

    CoonsContext(GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, PDFFunction[] function) {
        this.shadingColorSpace = shadingColorSpace;
        this.background = background;
        this.bitsPerComponent = shadingObject.getInt(-1344207655);
        this.bitsPerFlag = shadingObject.getInt(1500422077);
        this.bitsPerCoordinate = shadingObject.getInt(-335950113);
        this.decodeArr = shadingObject.getFloatArray(859785322);
        boolean hasSmallBits = this.bitsPerFlag < 8 || this.bitsPerComponent < 8 || this.bitsPerCoordinate < 8;
        this.reader = new BitReader(shadingObject.getDecodedStream(), hasSmallBits);
        this.colCompCount = shadingColorSpace.getColorComponentCount();
        if (this.decodeArr != null) {
            this.colCompCount = (this.decodeArr.length - 4) / 2;
        }
        float[][] caller = mm != null ? mm : Matrix.getIdentity();
        Object shadeMatrix = Matrix.getIdentity();
        float[] inputs = shadingObject.getFloatArray(1145198201);
        if (inputs != null) {
            shadeMatrix = new float[][]{{inputs[0], inputs[1], 0.0f}, {inputs[2], inputs[3], 0.0f}, {inputs[4], inputs[5], 1.0f}};
        }
        float[][] shader = Matrix.concatenate(caller, shadeMatrix);
        this.toShadeSpace = Matrix.inverse(shader);
        this.function = function;
        this.pp = new ArrayList();
        this.pc = new ArrayList();
        this.shapes = new ArrayList();
        this.process();
        this.adjustPoints();
        Collections.reverse(this.shapes);
    }

    void updateXForm(float[][] xFormMatrix, float[][] gm) {
        float[][] xm = xFormMatrix;
        if (gm != null) {
            xm = Matrix.concatenate(xm, Matrix.inverse(gm));
        }
        this.inversed = Matrix.concatenate(this.toShadeSpace, Matrix.inverse(xm));
    }

    private void process() {
        while (this.reader.getPointer() < this.reader.getTotalBitLen()) {
            int flag = this.reader.getPositive(this.bitsPerFlag);
            Point2D[] a42 = new Point2D[4];
            Color[] a22 = new Color[2];
            float[] cc = new float[this.colCompCount];
            switch (flag) {
                case 0: {
                    this.case0(cc);
                    break;
                }
                case 1: {
                    this.setColor(a22, a42, cc, 9, 8, 7, 6, 3, 2);
                    break;
                }
                case 2: {
                    this.setColor(a22, a42, cc, 6, 5, 4, 3, 2, 1);
                    break;
                }
                case 3: {
                    this.setColor(a22, a42, cc, 3, 2, 1, 12, 1, 4);
                }
            }
        }
    }

    private void setColor(Color[] a22, Point2D[] a42, float[] cc, int i1, int i2, int i3, int i4, int i5, int i6) {
        int i7;
        a42[0] = this.pp.get(this.pp.size() - i1);
        a42[1] = this.pp.get(this.pp.size() - i2);
        a42[2] = this.pp.get(this.pp.size() - i3);
        a42[3] = this.pp.get(this.pp.size() - i4);
        this.pp.addAll(Arrays.asList(a42).subList(0, 4));
        for (i7 = 0; i7 < 8; ++i7) {
            Point2D p2 = this.getPointCoords();
            this.pp.add(p2);
        }
        a22[0] = this.pc.get(this.pc.size() - i5);
        a22[1] = this.pc.get(this.pc.size() - i6);
        this.pc.addAll(Arrays.asList(a22));
        for (i7 = 0; i7 < 2; ++i7) {
            for (int z2 = 0; z2 < this.colCompCount; ++z2) {
                cc[z2] = this.reader.getFloat(this.bitsPerComponent);
            }
            Color color = this.calculateColor(cc);
            this.pc.add(color);
        }
    }

    private void case0(float[] cc) {
        int i2;
        for (i2 = 0; i2 < 12; ++i2) {
            Point2D p2 = this.getPointCoords();
            this.pp.add(p2);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            for (int z2 = 0; z2 < this.colCompCount; ++z2) {
                cc[z2] = this.reader.getFloat(this.bitsPerComponent);
            }
            Color color = this.calculateColor(cc);
            this.pc.add(color);
        }
    }

    private void adjustPoints() {
        if (this.decodeArr != null) {
            float xMin = this.decodeArr[0];
            float xMax = this.decodeArr[1];
            float yMin = this.decodeArr[2];
            float yMax = this.decodeArr[3];
            float xw = xMax - xMin;
            float yw = yMax - yMin;
            ArrayList<Point2D.Float> tempPoints = new ArrayList<Point2D.Float>();
            for (Point2D p2 : this.pp) {
                float xx = (float)p2.getX();
                float yy = (float)p2.getY();
                xx = xw * xx + xMin;
                yy = yw * yy + yMin;
                tempPoints.add(new Point2D.Float(xx, yy));
            }
            this.pp.clear();
            this.pp.addAll(tempPoints);
        }
        Point2D[] pArr = new Point2D[this.pp.size()];
        for (int i2 = 0; i2 < pArr.length; ++i2) {
            pArr[i2] = this.pp.get(i2);
        }
        int totalPatches = this.pp.size() / 12;
        int nSteps = totalPatches > 10 ? 8 : 16;
        int offset = 0;
        for (int i3 = 0; i3 < totalPatches; ++i3) {
            Point2D[] pointArr = new Point2D[12];
            Color[] colors = new Color[]{this.pc.get(i3 * 4), this.pc.get(i3 * 4 + 1), this.pc.get(i3 * 4 + 2), this.pc.get(i3 * 4 + 3)};
            System.arraycopy(pArr, offset, pointArr, 0, 12);
            Shape67 sh = new Shape67(pointArr, colors, nSteps);
            this.shapes.add(sh);
            offset += 12;
        }
    }

    private Point2D getPointCoords() {
        float x2 = this.reader.getFloat(this.bitsPerCoordinate);
        float y2 = this.reader.getFloat(this.bitsPerCoordinate);
        return new Point2D.Float(x2, y2);
    }

    @Override
    public void dispose() {
        this.reader = null;
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xStart, int yStart, int w2, int h2) {
        WritableRaster raster = new BufferedImage(w2, h2, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            ShadingUtils.setBackgroundColor(w2, h2, data, this.shadingColorSpace, this.background);
        }
        float x2 = xStart + w2;
        float y2 = yStart + h2;
        float[] src1 = new float[]{xStart, yStart};
        float[] src2 = new float[]{x2, y2};
        Matrix.transformPixel(this.inversed, src1);
        Matrix.transformPixel(this.inversed, src2);
        float rMinX = Math.min(src1[0], src2[0]);
        float rMinY = Math.min(src1[1], src2[1]);
        float rMaxX = Math.max(src1[0], src2[0]);
        float rMaxY = Math.max(src1[1], src2[1]);
        ArrayList<Tri> foundTris = new ArrayList<Tri>();
        for (Shape67 sh : this.shapes) {
            if (!(sh.minX < rMaxX) || !(sh.minY < rMaxY) || !(rMinX < sh.maxX) || !(rMinY < sh.maxY)) continue;
            for (Tri tr : sh.tris) {
                if (!(tr.minX < rMaxX) || !(tr.minY < tr.maxY) || !(rMinX < tr.maxX) || !(rMinY < tr.maxY)) continue;
                foundTris.add(tr);
            }
        }
        float[] src = new float[2];
        for (int y3 = 0; y3 < h2; ++y3) {
            block3: for (int x3 = 0; x3 < w2; ++x3) {
                src[0] = x3 + xStart;
                src[1] = y3 + yStart;
                Matrix.transformPixel(this.inversed, src);
                for (Tri tr : foundTris) {
                    if (data[y3 * w2 + x3] != 0) continue block3;
                    int result = Shape67.findPointColorInTris(tr, src[0], src[1]);
                    if (result == 0) continue;
                    data[y3 * w2 + x3] = result;
                }
            }
        }
        return raster;
    }

    private Color calculateColor(float[] val) {
        if (this.function == null) {
            this.shadingColorSpace.setColor(val);
        } else {
            float[] colValues = ShadingFactory.applyFunctions(this.function, val);
            this.shadingColorSpace.setColor(colValues);
        }
        return new Color(this.shadingColorSpace.getColor().getRGB());
    }
}

