/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

public class BitReader {
    private int p;
    private int pos;
    private final byte[] data;
    private final boolean hasSmallBits;
    private int bufferSize;
    private int buffer;
    private long bufferL;
    private final int totalBitLen;

    public BitReader(byte[] data, boolean hasSmallBits) {
        this.hasSmallBits = hasSmallBits;
        this.data = data;
        this.totalBitLen = this.data.length * 8;
    }

    private int readBits(int lenToRead) {
        if (this.hasSmallBits) {
            while (this.bufferSize < lenToRead) {
                int b2 = this.data[this.pos] & 0xFF;
                ++this.pos;
                this.buffer = this.buffer << 8 | b2;
                this.bufferSize += 8;
            }
            this.bufferSize -= lenToRead;
            this.p += lenToRead;
            return this.buffer >>> this.bufferSize & (1 << lenToRead) - 1;
        }
        int retVal = 0;
        int len = lenToRead / 8;
        for (int i2 = 0; i2 < len; ++i2) {
            retVal <<= 8;
            retVal |= this.data[this.p / 8] & 0xFF;
            this.p += 8;
        }
        return retVal;
    }

    public long readBitsAsLong(int len) {
        if (this.hasSmallBits) {
            while (this.bufferSize < len) {
                int b2 = this.data[this.pos] & 0xFF;
                ++this.pos;
                this.bufferL = this.bufferL << 8 | (long)b2;
                this.bufferSize += 8;
            }
            this.bufferSize -= len;
            this.p += len;
            return this.bufferL >>> this.bufferSize & (1L << len) - 1L;
        }
        long retVal = 0L;
        int len2 = len >> 3;
        for (int i2 = 0; i2 < len2; ++i2) {
            retVal <<= 8;
            retVal |= (long)(this.data[this.p / 8] & 0xFF);
            this.p += 8;
        }
        return retVal;
    }

    public int getPositive(int bitLen) {
        return this.readBits(bitLen);
    }

    public float getFloat(int bitLen) {
        int value = this.readBits(bitLen);
        switch (bitLen) {
            case 1: {
                return value;
            }
            case 2: {
                return (float)value / 3.0f;
            }
            case 4: {
                return (float)value / 15.0f;
            }
            case 8: {
                return (float)value / 255.0f;
            }
            case 16: {
                return (float)value / 65535.0f;
            }
            case 24: {
                return (float)value / 1.6777215E7f;
            }
            case 32: {
                return (float)((long)value & 0xFFFFFFFFL) / 4.2949673E9f;
            }
        }
        return 0.0f;
    }

    public int getPointer() {
        return this.p;
    }

    public int getTotalBitLen() {
        return this.totalBitLen;
    }
}

