/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class SMaskComposite
implements CompositeContext {
    private final float fixedAlpha;
    private final ColorModel srcModel;
    private final ColorModel dstModel;

    SMaskComposite(ColorModel srcColorModel, ColorModel dstColorModel, float alpha) {
        this.srcModel = srcColorModel;
        this.dstModel = dstColorModel;
        this.fixedAlpha = alpha;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int snComp = this.srcModel.getNumComponents();
        int bnComp = this.dstModel.getNumComponents();
        int bnColors = this.dstModel.getNumColorComponents();
        int width = Math.min(Math.min(src.getWidth(), dstIn.getWidth()), dstOut.getWidth());
        int height = Math.min(Math.min(src.getHeight(), dstIn.getHeight()), dstOut.getHeight());
        float[] sColors = new float[snComp];
        float[] bColors = new float[bnComp];
        boolean hasAlphaB = this.dstModel.hasAlpha();
        Object srcPixel = null;
        Object dstPixel = null;
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                dstPixel = dstIn.getDataElements(x2, y2, dstPixel);
                bColors = this.dstModel.getNormalizedComponents(dstPixel, bColors, 0);
                srcPixel = src.getDataElements(x2, y2, srcPixel);
                sColors = this.srcModel.getNormalizedComponents(srcPixel, sColors, 0);
                float qM = sColors[0];
                float qS = qM * this.fixedAlpha;
                float aB2 = hasAlphaB ? bColors[bnColors] : 1.0f;
                float aR2 = 0.0f;
                if (aB2 != 0.0f) {
                    aR2 = aB2 + qS - aB2 * qS;
                    for (int i2 = 0; i2 < bnColors; ++i2) {
                        float cB = bColors[i2];
                        bColors[i2] = cB + qS - qS * cB;
                    }
                }
                if (hasAlphaB) {
                    bColors[bnColors] = aR2;
                }
                dstPixel = this.dstModel.getDataElements(bColors, 0, dstPixel);
                dstOut.setDataElements(x2, y2, dstPixel);
            }
        }
    }
}

