/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.utils.LogWriter;

class Blender
implements CompositeContext {
    private final float fixedAlpha;
    private final boolean srcPA;
    private final boolean backPA;
    private final boolean srcHasAlpha;
    private final boolean backHasAlpha;
    private final int bm;

    Blender(ColorModel srcColorModel, ColorModel dstColorModel, int blendMode, float alpha) {
        this.srcPA = srcColorModel.isAlphaPremultiplied();
        this.backPA = dstColorModel.isAlphaPremultiplied();
        this.fixedAlpha = alpha;
        this.bm = blendMode;
        this.srcHasAlpha = srcColorModel.hasAlpha();
        this.backHasAlpha = dstColorModel.hasAlpha();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster srcRaster, Raster backdropRaster, WritableRaster dstOut) {
        try {
            int width = Math.min(srcRaster.getWidth(), backdropRaster.getWidth());
            int height = Math.min(srcRaster.getHeight(), backdropRaster.getHeight());
            int[] src = new int[width];
            int[] out = new int[width];
            int[] backdrop = new int[width];
            for (int y2 = 0; y2 < height; ++y2) {
                srcRaster.getDataElements(0, y2, width, 1, src);
                Blender.preToNormal(src, this.srcHasAlpha, this.srcPA);
                Blender.populateBackdropLine(backdropRaster, y2, width, backdrop);
                Blender.preToNormal(backdrop, this.backHasAlpha, this.backPA);
                Blender.blend(this.bm, width, src, backdrop, out, this.fixedAlpha);
                Blender.writeOutputLine(dstOut, out, y2, width);
            }
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2 + " on blend compose");
        }
    }

    private static void writeOutputLine(WritableRaster dstOut, int[] out, int y2, int width) {
        int transferType = dstOut.getTransferType();
        if (transferType == 3) {
            dstOut.setDataElements(0, y2, width, 1, out);
        } else if (transferType == 0) {
            byte[] backdropByte = new byte[width * 3];
            for (int x2 = 0; x2 < width; ++x2) {
                backdropByte[x2 * 3] = (byte)(out[x2] >> 16 & 0xFF);
                backdropByte[x2 * 3 + 1] = (byte)(out[x2] >> 8 & 0xFF);
                backdropByte[x2 * 3 + 2] = (byte)(out[x2] & 0xFF);
            }
            dstOut.setDataElements(0, y2, width, 1, backdropByte);
        }
    }

    private static void populateBackdropLine(Raster backdropRaster, int y2, int width, int[] backdrop) {
        int transferType = backdropRaster.getTransferType();
        if (transferType == 3) {
            backdropRaster.getDataElements(0, y2, width, 1, backdrop);
        } else if (transferType == 0) {
            int bands = backdropRaster.getNumBands();
            byte[] backdropByte = new byte[width * bands];
            backdropRaster.getDataElements(0, y2, width, 1, backdropByte);
            for (int x2 = 0; x2 < width; ++x2) {
                backdrop[x2] = (backdropByte[x2 * bands] & 0xFF) << 16 | (backdropByte[x2 * bands + 1] & 0xFF) << 8 | backdropByte[x2 * bands + 2] & 0xFF;
            }
        }
    }

    private static void preToNormal(int[] pixels, boolean hasAlpha, boolean hasPA) {
        block4: {
            int len;
            block3: {
                len = pixels.length;
                if (!hasPA) break block3;
                for (int i2 = 0; i2 < len; ++i2) {
                    int p2 = pixels[i2];
                    int w2 = hasAlpha ? p2 >>> 24 : 255;
                    int x2 = p2 >> 16 & 0xFF;
                    int y2 = p2 >> 8 & 0xFF;
                    int z2 = p2 & 0xFF;
                    if (w2 != 0) {
                        x2 = x2 * 255 / w2;
                        y2 = y2 * 255 / w2;
                        z2 = z2 * 255 / w2;
                        pixels[i2] = w2 << 24 | x2 << 16 | y2 << 8 | z2;
                        continue;
                    }
                    pixels[i2] = 0;
                }
                break block4;
            }
            if (hasAlpha) break block4;
            for (int i3 = 0; i3 < len; ++i3) {
                pixels[i3] = 0xFF000000 | pixels[i3];
            }
        }
    }

    private static void blend(int bm2, int width, int[] src, int[] backdrop, int[] out, float fa) {
        switch (bm2) {
            case 1451587725: {
                Blender.multiply(width, src, backdrop, out, fa);
                break;
            }
            case 1110792305: {
                Blender.screen(width, src, backdrop, out, fa);
                break;
            }
            case 1113290622: {
                Blender.overlay(width, src, backdrop, out, fa);
                break;
            }
            case 1786342520: {
                Blender.hardlight(width, src, backdrop, out, fa);
                break;
            }
            case 2020441219: {
                Blender.softlight(width, src, backdrop, out, fa);
                break;
            }
            case 2071170184: {
                Blender.colorDodge(width, src, backdrop, out, fa);
                break;
            }
            case 1367441811: {
                Blender.colorBurn(width, src, backdrop, out, fa);
                break;
            }
            case 1111181679: {
                Blender.darken(width, src, backdrop, out, fa);
                break;
            }
            case 945843829: {
                Blender.lighten(width, src, backdrop, out, fa);
                break;
            }
            case 1802796208: {
                Blender.difference(width, src, backdrop, out, fa);
                break;
            }
            case -1955824744: {
                Blender.exclusion(width, src, backdrop, out, fa);
            }
        }
    }

    private static void multiply(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                ro = rb * rs;
                go = gb * gs;
                bo2 = bb2 * bs2;
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void screen(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                ro = rb + rs - rb * rs;
                go = gb + gs - gb * gs;
                bo2 = bb2 + bs2 - bb2 * bs2;
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void overlay(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                if (rb <= 0.5f) {
                    ro = rs * 2.0f * rb;
                } else {
                    ro = 2.0f * rb - 1.0f;
                    ro = rs + ro - ro * rs;
                }
                if (gb <= 0.5f) {
                    go = gs * 2.0f * gb;
                } else {
                    go = 2.0f * gb - 1.0f;
                    go = gs + go - go * gs;
                }
                if (bb2 <= 0.5f) {
                    bo2 = bs2 * 2.0f * bb2;
                } else {
                    bo2 = 2.0f * bb2 - 1.0f;
                    bo2 = bs2 + bo2 - bo2 * bs2;
                }
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void hardlight(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                if (rs <= 0.5f) {
                    ro = rb * 2.0f * rs;
                } else {
                    ro = 2.0f * rs - 1.0f;
                    ro = rb + ro - ro * rb;
                }
                if (gs <= 0.5f) {
                    go = gb * 2.0f * gs;
                } else {
                    go = 2.0f * gs - 1.0f;
                    go = gb + go - go * gb;
                }
                if (bs2 <= 0.5f) {
                    bo2 = bb2 * 2.0f * bs2;
                } else {
                    bo2 = 2.0f * bs2 - 1.0f;
                    bo2 = bb2 + bo2 - bo2 * bb2;
                }
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void softlight(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                float bx;
                if (rs <= 0.5f) {
                    ro = rb - (1.0f - 2.0f * rs) * rb * (1.0f - rb);
                } else {
                    bx = rb <= 0.25f ? ((16.0f * rb - 12.0f) * rb + 4.0f) * rb : (float)Math.sqrt(rb);
                    ro = rb + (2.0f * rs - 1.0f) * (bx - rb);
                }
                if (gs <= 0.5f) {
                    go = gb - (1.0f - 2.0f * gs) * gb * (1.0f - gb);
                } else {
                    bx = gb <= 0.25f ? ((16.0f * gb - 12.0f) * gb + 4.0f) * gb : (float)Math.sqrt(gb);
                    go = gb + (2.0f * gs - 1.0f) * (bx - gb);
                }
                if (bs2 <= 0.5f) {
                    bo2 = bb2 - (1.0f - 2.0f * bs2) * bb2 * (1.0f - bb2);
                } else {
                    bx = bb2 <= 0.25f ? ((16.0f * bb2 - 12.0f) * bb2 + 4.0f) * bb2 : (float)Math.sqrt(bb2);
                    bo2 = bb2 + (2.0f * bs2 - 1.0f) * (bx - bb2);
                }
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void darken(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                ro = Math.min(rs, rb);
                go = Math.min(gs, gb);
                bo2 = Math.min(bs2, bb2);
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void lighten(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                ro = Math.max(rs, rb);
                go = Math.max(gs, gb);
                bo2 = Math.max(bs2, bb2);
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void colorDodge(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                ro = rs == 1.0f ? 1.0f : Math.min(1.0f, rb / (1.0f - rs));
                go = gs == 1.0f ? 1.0f : Math.min(1.0f, gb / (1.0f - gs));
                bo2 = bs2 == 1.0f ? 1.0f : Math.min(1.0f, bb2 / (1.0f - bs2));
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void colorBurn(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                ro = rs == 0.0f ? 0.0f : 1.0f - Math.min(1.0f, (1.0f - rb) / rs);
                go = gs == 0.0f ? 0.0f : 1.0f - Math.min(1.0f, (1.0f - gb) / gs);
                bo2 = bs2 == 0.0f ? 0.0f : 1.0f - Math.min(1.0f, (1.0f - bb2) / bs2);
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void difference(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                ro = Math.abs(rb - rs);
                go = Math.abs(gb - gs);
                bo2 = Math.abs(bb2 - bs2);
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }

    private static void exclusion(int width, int[] src, int[] backdrop, int[] out, float fa) {
        for (int i2 = 0; i2 < width; ++i2) {
            float bo2;
            float go;
            float ro;
            int s2 = src[i2];
            int b2 = backdrop[i2];
            float as2 = (float)(s2 >> 24 & 0xFF) / 255.0f;
            float rs = (float)(s2 >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s2 >> 8 & 0xFF) / 255.0f;
            float bs2 = (float)(s2 & 0xFF) / 255.0f;
            float ab2 = (float)(b2 >> 24 & 0xFF) / 255.0f;
            float rb = (float)(b2 >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b2 >> 8 & 0xFF) / 255.0f;
            float bb2 = (float)(b2 & 0xFF) / 255.0f;
            float as1 = 1.0f - (as2 *= fa);
            float ab1 = 1.0f - ab2;
            float ao2 = as2 + ab2 * as1;
            if (rb == 1.0f && gb == 1.0f && bb2 == 1.0f) {
                ro = rs;
                go = gs;
                bo2 = bs2;
            } else {
                ro = rb + rs - 2.0f * rb * rs;
                go = gb + gs - 2.0f * gb * gs;
                bo2 = bb2 + bs2 - 2.0f * bb2 * bs2;
            }
            ro = (as1 * ab2 * rb + ab1 * as2 * rs + ab2 * as2 * ro) / ao2;
            go = (as1 * ab2 * gb + ab1 * as2 * gs + ab2 * as2 * go) / ao2;
            bo2 = (as1 * ab2 * bb2 + ab1 * as2 * bs2 + ab2 * as2 * bo2) / ao2;
            out[i2] = (int)(ao2 * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo2 * 255.0f);
        }
    }
}

