/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class BlendContext
implements CompositeContext {
    private final int blendMode;

    BlendContext(int blendMode) {
        this.blendMode = blendMode;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int height = Math.min(src.getHeight(), dstIn.getHeight());
        int[] srcPixels = new int[width];
        int[] dstInPixels = new int[width];
        int[] dstOutPixels = new int[width];
        for (int y2 = 0; y2 < height; ++y2) {
            src.getDataElements(0, y2, width, 1, srcPixels);
            dstIn.getDataElements(0, y2, width, 1, dstInPixels);
            int oldS = 0;
            int oldD = 0;
            int oldR = 0;
            for (int x2 = 0; x2 < width; ++x2) {
                int s2 = srcPixels[x2];
                int d2 = dstInPixels[x2];
                if (s2 == oldS && d2 == oldD) {
                    dstOutPixels[x2] = oldR;
                    continue;
                }
                oldS = s2;
                oldD = d2;
                int[] sp = BlendContext.getRGBA(s2);
                int[] dp = BlendContext.getRGBA(d2);
                int[] result = BlendContext.setResult(sp, dp, this.blendMode);
                if (sp[3] != 255) {
                    double sr = (double)result[0] / 255.0;
                    double sg = (double)result[1] / 255.0;
                    double sb = (double)result[2] / 255.0;
                    double sa = (double)sp[3] / 255.0;
                    double dr = (double)dp[0] / 255.0;
                    double dg = (double)dp[1] / 255.0;
                    double db = (double)dp[2] / 255.0;
                    sr = (1.0 - sa) * dr + sa * sr;
                    sg = (1.0 - sa) * dg + sa * sg;
                    sb = (1.0 - sa) * db + sa * sb;
                    result[0] = (int)(sr * 255.0);
                    result[1] = (int)(sg * 255.0);
                    result[2] = (int)(sb * 255.0);
                }
                dstOutPixels[x2] = oldR = Math.min(255, sp[3] + dp[3]) << 24 | result[0] << 16 | result[1] << 8 | result[2];
            }
            dstOut.setDataElements(0, y2, width, 1, dstOutPixels);
        }
    }

    private static int[] setResult(int[] sp, int[] dp, int blendMode) {
        int[] result = new int[4];
        switch (blendMode) {
            case 1590581: {
                result = BlendContext.doHue(sp, dp);
                break;
            }
            case -2004966240: {
                result = BlendContext.doSaturation(sp, dp);
                break;
            }
            case 1060912981: {
                result = BlendContext.doColor(sp, dp);
                break;
            }
            case -2139971891: {
                result = BlendContext.doLuminosity(sp, dp);
                break;
            }
        }
        return result;
    }

    private static int[] getRGBA(int argb) {
        return new int[]{argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF};
    }

    private static int[] doColor(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        int[] result = new int[3];
        double sr = (double)src[0] / 255.0;
        double sg = (double)src[1] / 255.0;
        double sb = (double)src[2] / 255.0;
        double dr = (double)dst[0] / 255.0;
        double dg = (double)dst[1] / 255.0;
        double db = (double)dst[2] / 255.0;
        double[] rgb = BlendContext.setLum(sr, sg, sb, BlendContext.lum(dr, dg, db));
        result[0] = (int)(255.0 * rgb[0]);
        result[1] = (int)(255.0 * rgb[1]);
        result[2] = (int)(255.0 * rgb[2]);
        return result;
    }

    private static int[] doLuminosity(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        int[] result = new int[3];
        double sr = (double)src[0] / 255.0;
        double sg = (double)src[1] / 255.0;
        double sb = (double)src[2] / 255.0;
        double dr = (double)dst[0] / 255.0;
        double dg = (double)dst[1] / 255.0;
        double db = (double)dst[2] / 255.0;
        double[] rgb = BlendContext.setLum(dr, dg, db, BlendContext.lum(sr, sg, sb));
        result[0] = (int)(255.0 * rgb[0]);
        result[1] = (int)(255.0 * rgb[1]);
        result[2] = (int)(255.0 * rgb[2]);
        return result;
    }

    private static int[] doHue(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        double[] srcHSL = new double[3];
        BlendContext.rgbToHSL(src[0], src[1], src[2], srcHSL);
        double[] dstHSL = new double[3];
        BlendContext.rgbToHSL(dst[0], dst[1], dst[2], dstHSL);
        int[] result = new int[4];
        BlendContext.hslToRGB(srcHSL[0], dstHSL[1], dstHSL[2], result);
        return result;
    }

    private static int[] doSaturation(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        double[] srcHSL = new double[3];
        BlendContext.rgbToHSL(src[0], src[1], src[2], srcHSL);
        double[] dstHSL = new double[3];
        BlendContext.rgbToHSL(dst[0], dst[1], dst[2], dstHSL);
        int[] result = new int[4];
        BlendContext.hslToRGB(dstHSL[0], srcHSL[1], dstHSL[2], result);
        return result;
    }

    private static double lum(double r2, double g2, double b2) {
        return 0.3 * r2 + 0.59 * g2 + 0.11 * b2;
    }

    private static double[] setLum(double r2, double g2, double b2, double l2) {
        double d2 = l2 - BlendContext.lum(r2, g2, b2);
        return BlendContext.clipColor(r2 += d2, g2 += d2, b2 += d2);
    }

    private static double[] clipColor(double r2, double g2, double b2) {
        double l2 = BlendContext.lum(r2, g2, b2);
        double n2 = Math.min(Math.min(r2, g2), b2);
        double x2 = Math.max(Math.max(r2, g2), b2);
        if (n2 < 0.0) {
            r2 = l2 + (r2 - l2) * l2 / (l2 - n2);
            g2 = l2 + (g2 - l2) * l2 / (l2 - n2);
            b2 = l2 + (b2 - l2) * l2 / (l2 - n2);
        }
        if (x2 > 1.0) {
            r2 = l2 + (r2 - l2) * (1.0 - l2) / (x2 - l2);
            g2 = l2 + (g2 - l2) * (1.0 - l2) / (x2 - l2);
            b2 = l2 + (b2 - l2) * (1.0 - l2) / (x2 - l2);
        }
        return new double[]{r2, g2, b2};
    }

    private static void rgbToHSL(int r2, int g2, int b2, double[] hsl) {
        double S2;
        double H2;
        double rr = (double)r2 / 255.0;
        double gg = (double)g2 / 255.0;
        double bb2 = (double)b2 / 255.0;
        double var_Min = Math.min(Math.min(rr, gg), bb2);
        double var_Max = Math.max(Math.max(rr, gg), bb2);
        double del_Max = var_Max - var_Min;
        double L2 = (var_Max + var_Min) / 2.0;
        if (del_Max - 0.01 <= 0.0) {
            H2 = 0.0;
            S2 = 0.0;
        } else {
            S2 = L2 < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0 - var_Max - var_Min);
            double del_R = ((var_Max - rr) / 6.0 + del_Max / 2.0) / del_Max;
            double del_G = ((var_Max - gg) / 6.0 + del_Max / 2.0) / del_Max;
            double del_B = ((var_Max - bb2) / 6.0 + del_Max / 2.0) / del_Max;
            H2 = rr == var_Max ? del_B - del_G : (gg == var_Max ? 0.3333333432674408 + del_R - del_B : 0.6666666865348816 + del_G - del_R);
            if (H2 < 0.0) {
                H2 += 1.0;
            }
            if (H2 > 1.0) {
                H2 -= 1.0;
            }
        }
        hsl[0] = H2;
        hsl[1] = S2;
        hsl[2] = L2;
    }

    private static void hslToRGB(double h2, double s2, double l2, int[] rgb) {
        int B2;
        int G2;
        int R2;
        if (s2 - 0.01 <= 0.0) {
            R2 = (int)(l2 * 255.0);
            G2 = (int)(l2 * 255.0);
            B2 = (int)(l2 * 255.0);
        } else {
            double v2 = l2 < 0.5 ? l2 * (1.0 + s2) : l2 + s2 - s2 * l2;
            double v1 = 2.0 * l2 - v2;
            R2 = (int)(255.0 * BlendContext.hueToRGB(v1, v2, h2 + 0.3333333333333333));
            G2 = (int)(255.0 * BlendContext.hueToRGB(v1, v2, h2));
            B2 = (int)(255.0 * BlendContext.hueToRGB(v1, v2, h2 - 0.3333333333333333));
        }
        rgb[0] = R2;
        rgb[1] = G2;
        rgb[2] = B2;
    }

    private static double hueToRGB(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666666666666 - vH) * 6.0;
        }
        return v1;
    }
}

