/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa.shadings;

import com.idrsolutions.pdf.color.shading.ShadedPaint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import org.jpedal.color.PdfPaint;

public class XFAShadedPaint
extends ShadedPaint {
    private final Paint xfaShadeCont;

    XFAShadedPaint(float[] coords, int xDir, int yDir, PdfPaint startColor, PdfPaint endColor, int type) {
        float startX = coords[0];
        float startY = coords[1];
        float endX = coords[2];
        float endY = coords[3];
        Color[] colors = new Color[]{new Color(startColor.getRGB()), new Color(endColor.getRGB())};
        Color[] colors3 = new Color[]{new Color(startColor.getRGB()), new Color(startColor.getRGB()), new Color(endColor.getRGB())};
        float[] dist = new float[]{0.0f, 1.0f};
        float[] dist3 = new float[]{0.0f, 0.9f, 1.0f};
        switch (type) {
            case 0: {
                if (xDir == -1) {
                    this.xfaShadeCont = new LinearGradientPaint(endX, endY, startX, startY, dist, colors);
                    break;
                }
                if (yDir == 1) {
                    this.xfaShadeCont = new LinearGradientPaint(startX, endY, startX, startY, dist, colors);
                    break;
                }
                if (yDir == -1) {
                    this.xfaShadeCont = new LinearGradientPaint(startX, startY, startX, endY, dist, colors);
                    break;
                }
                this.xfaShadeCont = new LinearGradientPaint(startX, startY, endX, endY, dist, colors);
                break;
            }
            case 1: {
                float radius = (endX - startX) / 2.0f;
                float cx = startX + radius;
                float cy = startY + (endY - startY) / 2.0f;
                if (xDir == -1) {
                    colors[0] = new Color(endColor.getRGB());
                    colors[1] = new Color(startColor.getRGB());
                }
                this.xfaShadeCont = new RadialGradientPaint(cx, cy, radius, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
                break;
            }
            case 2: 
            case 3: {
                BufferedImage img = new BufferedImage(10, 10, 1);
                Graphics2D g2 = (Graphics2D)img.getGraphics();
                g2.setColor(colors[0]);
                g2.fillRect(0, 0, 10, 10);
                g2.setColor(colors[1]);
                g2.drawLine(5, 0, 10, 5);
                g2.drawLine(10, 5, 5, 10);
                g2.drawLine(5, 10, 0, 5);
                g2.drawLine(0, 5, 5, 0);
                this.xfaShadeCont = new TexturePaint(img, new Rectangle(0, 0, 10, 10));
                break;
            }
            case 4: {
                this.xfaShadeCont = new LinearGradientPaint(startX, startY, startX + 5.0f, startY + 5.0f, dist3, colors3, MultipleGradientPaint.CycleMethod.REPEAT);
                break;
            }
            case 5: {
                this.xfaShadeCont = new LinearGradientPaint(startX + 5.0f, startY, startX, startY + 5.0f, dist3, colors3, MultipleGradientPaint.CycleMethod.REPEAT);
                break;
            }
            case 6: {
                this.xfaShadeCont = new LinearGradientPaint(startX, startY, startX, startY + 10.0f, dist3, colors3, MultipleGradientPaint.CycleMethod.REPEAT);
                break;
            }
            case 7: {
                this.xfaShadeCont = new LinearGradientPaint(startX, startY, startX + 10.0f, startY, dist3, colors3, MultipleGradientPaint.CycleMethod.REPEAT);
                break;
            }
            default: {
                this.xfaShadeCont = colors[0];
            }
        }
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle db, Rectangle2D ub, AffineTransform xform, RenderingHints hints) {
        return this.xfaShadeCont.createContext(cm, db, ub, xform, hints);
    }
}

