/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XBox;
import com.idrsolutions.pdf.acroforms.xfa.XFAUtils;
import com.idrsolutions.pdf.acroforms.xfa.XRect;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XPageArea {
    private double[] contentAreaCoords = new double[4];
    private String id;
    private String name;
    private String contentAreaId;
    private String contentAreaName;
    private boolean isLandscape;
    private double longVal;
    private double shortVal;
    private int maxOccur = Integer.MAX_VALUE;
    private static final String JAREAOCCUR = "JAO";

    XPageArea(Node node) {
        int z2;
        block14: for (z2 = 0; z2 < node.getAttributes().getLength(); ++z2) {
            Node attr = node.getAttributes().item(z2);
            String attrName = attr.getNodeName();
            String attrValue = attr.getNodeValue();
            switch (attrName.hashCode()) {
                case 3355: {
                    this.id = attrValue;
                    continue block14;
                }
                case 3373707: {
                    this.name = attrValue;
                }
            }
        }
        block15: for (z2 = 0; z2 < node.getChildNodes().getLength(); ++z2) {
            Node child = node.getChildNodes().item(z2);
            if (child.getNodeType() != 1) continue;
            Element childEle = (Element)child;
            switch (child.getNodeName().hashCode()) {
                case -389704538: {
                    XBox box = new XBox(child);
                    this.contentAreaCoords = box.getXYWHwithMargin();
                    this.contentAreaId = box.getId();
                    this.contentAreaName = box.getName();
                    continue block15;
                }
                case -1078030475: {
                    NamedNodeMap nm = child.getAttributes();
                    block16: for (int q2 = 0; q2 < nm.getLength(); ++q2) {
                        String value = nm.item(q2).getNodeValue();
                        switch (nm.item(q2).getNodeName().hashCode()) {
                            case 3327612: {
                                this.longVal = XFAUtils.convertToPoints(value);
                                continue block16;
                            }
                            case 109413500: {
                                this.shortVal = XFAUtils.convertToPoints(value);
                                continue block16;
                            }
                            case -1439500848: {
                                if (value.hashCode() != 1430647483) continue block16;
                                this.isLandscape = true;
                            }
                        }
                    }
                    continue block15;
                }
                case 105559020: {
                    String maxStr = childEle.getAttribute("max");
                    this.maxOccur = maxStr.isEmpty() ? this.maxOccur : Integer.parseInt(maxStr);
                }
            }
        }
    }

    public double[] getFullPageCoords() {
        double[] temp = new double[4];
        if (this.longVal > 0.0) {
            temp[3] = Math.max(this.longVal, temp[3]);
            temp[2] = Math.max(this.shortVal, temp[2]);
        }
        if (this.isLandscape) {
            temp[2] = this.longVal > 0.0 ? this.longVal : temp[2];
            temp[3] = this.shortVal > 0.0 ? this.shortVal : temp[3];
        }
        return temp;
    }

    public double[] getContentAreaCoords() {
        return this.contentAreaCoords;
    }

    public XRect getContentAreaRect() {
        return new XRect(this.contentAreaCoords[0], this.contentAreaCoords[1], this.contentAreaCoords[2], this.contentAreaCoords[3]);
    }

    public double getContentEndPlace() {
        XRect rect = this.getContentAreaRect();
        return rect.getY() + rect.getH();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getContentAreaId() {
        return this.contentAreaId;
    }

    public String getContentAreaName() {
        return this.contentAreaName;
    }

    public int getMaxOccur() {
        return this.maxOccur;
    }

    public static void addOccurConsume(Node node) {
        Element nodeEle = (Element)node;
        String curOccur = nodeEle.getAttribute(JAREAOCCUR);
        if (curOccur.isEmpty()) {
            nodeEle.setAttribute(JAREAOCCUR, "1");
        } else {
            int count = Integer.parseInt(curOccur);
            nodeEle.setAttribute(JAREAOCCUR, String.valueOf(count + 1));
        }
    }

    public static int getOccurConsume(Node node) {
        Element nodeEle = (Element)node;
        String curOccur = nodeEle.getAttribute(JAREAOCCUR);
        return curOccur.isEmpty() ? 0 : Integer.parseInt(curOccur);
    }
}

