/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public final class XFormCalc {
    public static final String AND = "and";
    public static final String ELSE = "else";
    public static final String ELSEIF = "elseif";
    public static final String ENDIF = "endif";
    public static final String EQ = "eq";
    public static final String GE = "ge";
    public static final String GT = "gt";
    public static final String IF = "if";
    public static final String INFINITY = "infinity";
    public static final String LE = "le";
    public static final String LT = "lt";
    public static final String NAN = "nan";
    public static final String NE = "ne";
    public static final String NOT = "not";
    public static final String NULL = "null";
    public static final String OR = "or";
    public static final String THEN = "then";
    public static final String THIS = "this";
    public static final String BREAK = "break";
    public static final String CONTINUE = "continue";
    public static final String DO = "do";
    public static final String DOWNTO = "downto";
    public static final String END = "end";
    public static final String ENDFOR = "endfor";
    public static final String ENDFUNC = "endfunc";
    public static final String ENDWHILE = "endwhile";
    public static final String EXIT = "exit";
    public static final String FOR = "for";
    public static final String FOREACH = "foreach";
    public static final String FUNC = "func";
    public static final String IN = "in";
    public static final String RETURN = "return";
    public static final String STEP = "step";
    public static final String THROW = "throw";
    public static final String UPTO = "upto";
    public static final String VAR = "var";
    public static final String WHILE = "while";
    public static final String[] KEYWORDS = new String[]{"if", "then", "elseif", "else", "endif", "or", "and", "not", "eq", "ne", "le", "ge", "lt", "gt", "this", "null", "nan", "infinity"};
    public static final String[] RESERVEDKEYWORDS = new String[]{"while", "do", "endwhile", "end", "for", "upto", "downto", "step", "endfor", "foreach", "in", "break", "continue", "var", "func", "endfunc", "throw", "return", "exit"};
    public static final String[] OPERTORS = new String[]{"+", "{", "}", "-", "%", "*", "/", ";", "{", "}"};

    private XFormCalc() {
    }

    public static String removeLineBreaks(String s2) {
        return s2.replaceAll("\n", "").replaceAll("\r", "");
    }

    public static String replaceExpressionFOR(String s2) {
        if (s2.startsWith("for ")) {
            s2 = s2.replaceFirst("for ", "for(");
        } else if (s2.trim().startsWith(ENDFOR) && s2.trim().length() == ENDFOR.length()) {
            s2 = s2.replaceAll(ENDFOR, "}");
        }
        return s2;
    }

    public static double finanApr(double principal, double payment, int periods) {
        double p2 = 0.0;
        double guess = 0.0;
        double increment = 0.01;
        while (payment > p2) {
            double r2 = (guess += 0.01) / 100.0 / 12.0;
            p2 = principal * r2 * Math.pow(1.0 + r2, periods) / (Math.pow(1.0 + r2, periods) - 1.0);
        }
        double rate = guess - 0.01;
        return (double)Math.round(rate * Math.pow(10.0, 1.0)) / Math.pow(10.0, 1.0);
    }

    public static double finanCTerm(double rate, double fv, double pv) {
        if (fv < pv || fv < 0.0 || pv < 0.0) {
            return 0.0;
        }
        for (int z2 = 0; z2 < Integer.MAX_VALUE; ++z2) {
            double years = z2;
            for (int i2 = 0; i2 < 12; ++i2) {
                double months = i2;
                double thisMonth = pv + pv * rate * (double)(i2 + 1) / 12.0;
                if (!(thisMonth > fv)) continue;
                double dayDecimal = (fv - (pv + pv * rate * (double)i2 / 12.0)) / 30.0;
                double cTerm = years + (months + dayDecimal) / 12.0;
                return (double)Math.round(cTerm * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
            }
            double temp = pv * (rate + 1.0);
            if (temp > fv) break;
            pv = temp;
        }
        return 0.0;
    }

    public static double finanFV(double payment, double rate, double periods) {
        if (rate <= 0.0) {
            return payment * periods;
        }
        return payment * (Math.pow(1.0 + rate, periods) - 1.0) / rate;
    }

    public static double finanIPmt(double principal, double rate, double payment, int startMon, int counts) {
        int totalMonths = startMon + counts - 1;
        double interestPaid = 0.0;
        for (int i2 = 1; i2 <= totalMonths; ++i2) {
            double taxCalculated = principal * rate / 12.0;
            principal = principal - payment + taxCalculated;
            if (i2 < startMon) continue;
            interestPaid += taxCalculated;
        }
        return (double)Math.round(interestPaid * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    public static double finanNPV(double[] args) {
        double r1;
        double npv = 0.0;
        double trate = r1 = args[0] + 1.0;
        int iSize = args.length;
        for (int i2 = 1; i2 < iSize; ++i2) {
            npv += args[i2] / trate;
            trate *= r1;
        }
        return (double)Math.round(npv * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    public static double finanPmt(double principal, double periodRate, int periods) {
        double payment = periodRate * principal / (1.0 - Math.pow(1.0 + periodRate, -periods));
        return (double)Math.round(payment * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    public static double finanPPmt(double principal, double rate, double monthlyPay, double firstMon, double totalMon) {
        return -1.0;
    }

    public static double finanPV(double payment, double rate, double periods) {
        double present = XFormCalc.finanFV(payment, rate, periods) / Math.pow(1.0 + rate, periods);
        return (double)Math.round(present * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    public static double finanRate(double fv, double pv, double periods) {
        double ratio = fv / pv;
        double sqrs = 1.0 / periods;
        double rate = Math.pow(ratio, sqrs) - 1.0;
        return (double)Math.round(rate * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    public static double finanTerm(double paymentEnd, double rate, double fv) {
        double principal = 0.0;
        int count = 0;
        while (principal < fv) {
            principal += paymentEnd;
            principal += principal * rate;
            ++count;
        }
        return count;
    }

    public static double mathAbs(double x2) {
        return Math.abs(x2);
    }

    public static double mathAvg(double[] nums) {
        double total = 0.0;
        for (double n2 : nums) {
            total += n2;
        }
        return total / (double)nums.length;
    }

    public static double mathCeil(double x2) {
        return Math.ceil(x2);
    }

    public static double mathCount(double[] nums) {
        double total = 0.0;
        for (double n2 : nums) {
            total += n2;
        }
        return total;
    }

    public static double mathFloor(double x2) {
        return Math.floor(x2);
    }

    public static double mathMax(double[] nums) {
        double max = nums[0];
        for (double n2 : nums) {
            max = n2 > max ? n2 : max;
        }
        return max;
    }

    public static double mathMin(double[] nums) {
        double min = nums[0];
        for (double n2 : nums) {
            min = n2 < min ? n2 : min;
        }
        return min;
    }

    public static double mathModulus(double a10, double b2) {
        return a10 % b2;
    }

    public static double mathSum(double[] nums) {
        double total = 0.0;
        for (double n2 : nums) {
            total += n2;
        }
        return total;
    }

    public static String getFormattedText(String outputFormat, String userData) {
        try {
            String[] formats;
            String matchPattern = "[A-Za-z0-9]*";
            String formatPattern = "[AXO9\\-\\+\\.\\^:,\\(\\) ]*";
            String specialPattern = "[\\-\\+\\.\\^:,\\(\\) ]";
            for (String f2 : formats = outputFormat.split("\\|")) {
                String quoteLess;
                if (f2.startsWith("text{")) {
                    f2 = f2.substring(f2.indexOf(123) + 1, f2.lastIndexOf(125));
                }
                StringBuilder quoteLessStr = new StringBuilder(f2);
                if (f2.contains("'")) {
                    quoteLessStr = new StringBuilder("");
                    boolean canPut = true;
                    for (int i2 = 0; i2 < f2.length(); ++i2) {
                        String temp = String.valueOf(f2.charAt(i2)).intern();
                        if ("'".equals(temp)) {
                            boolean bl2 = canPut = !canPut;
                        }
                        if (!canPut || "'".equals(temp)) continue;
                        quoteLessStr.append(temp);
                    }
                }
                if (!(quoteLess = quoteLessStr.toString()).matches("[AXO9\\-\\+\\.\\^:,\\(\\) ]*")) continue;
                String dataNoSpecial = userData.replaceAll("[\\-\\+\\.\\^:,\\(\\) ]", "");
                String regexNoSpecial = quoteLess.replaceAll("[\\-\\+\\.\\^:,\\(\\) ]", "");
                if (!dataNoSpecial.matches(regexNoSpecial = regexNoSpecial.replaceAll("A", "[A-Za-z]{1}").replaceAll("9", "\\\\d{1}").replaceAll("O", "\\\\w{1}").replaceAll("0", "\\\\w{1}"))) continue;
                StringBuilder sb = new StringBuilder();
                int count = 0;
                boolean canPut = true;
                for (int z2 = 0; z2 < f2.length(); ++z2) {
                    String s2 = String.valueOf(f2.charAt(z2)).intern();
                    if ("'".equals(s2)) {
                        boolean bl3 = canPut = !canPut;
                    }
                    if (s2.matches("[A-Za-z0-9]*") && canPut) {
                        s2 = String.valueOf(dataNoSpecial.charAt(count)).intern();
                        ++count;
                    }
                    sb.append(s2);
                }
                return sb.toString().replaceAll("'", "");
            }
            return userData;
        }
        catch (Exception e2) {
            return userData;
        }
    }

    public static String getFormattedNumeric(String outputFormat, String userData) {
        if (userData == null || userData.isEmpty()) {
            if (outputFormat.startsWith("null{") && outputFormat.indexOf("'}") > 0) {
                return outputFormat.substring(outputFormat.indexOf("null{") + 6, outputFormat.indexOf("'}"));
            }
            return userData;
        }
        try {
            int z2;
            double userDouble = Double.parseDouble(userData);
            ArrayList<String> chunkList = new ArrayList<String>();
            ArrayList<Boolean> expList = new ArrayList<Boolean>();
            if (outputFormat.startsWith("null{")) {
                outputFormat = outputFormat.substring(outputFormat.indexOf(124) + 1);
            } else if (outputFormat.startsWith("num{")) {
                outputFormat = outputFormat.substring(4, outputFormat.lastIndexOf(125));
            }
            if (outputFormat.contains("'")) {
                String temp = "";
                for (z2 = 0; z2 < outputFormat.length(); ++z2) {
                    if ("'".equals(String.valueOf(outputFormat.charAt(z2)).intern())) {
                        if (temp.contains("'") && z2 != 0) {
                            if (temp.startsWith("'")) {
                                chunkList.add(temp.replace("'", ""));
                                expList.add(false);
                                temp = "";
                                continue;
                            }
                            chunkList.add(temp.substring(0, temp.indexOf(39)));
                            expList.add(true);
                            chunkList.add(temp.substring(temp.indexOf(39) + 1));
                            expList.add(false);
                            temp = "";
                            continue;
                        }
                        temp = temp + outputFormat.charAt(z2);
                        continue;
                    }
                    temp = temp + outputFormat.charAt(z2);
                }
                if (!temp.isEmpty()) {
                    chunkList.add(temp);
                    expList.add(true);
                }
            } else {
                chunkList.add(outputFormat);
                expList.add(true);
            }
            StringBuilder fullString = new StringBuilder("");
            for (z2 = 0; z2 < chunkList.size(); ++z2) {
                String toBeFormat = (String)chunkList.get(z2);
                if (((Boolean)expList.get(z2)).booleanValue()) {
                    if (toBeFormat.matches("[$zZ98,.Ss]+")) {
                        toBeFormat = toBeFormat.replace('9', '0').replace('Z', '#').replace('z', '#');
                        DecimalFormat dFormat = new DecimalFormat(toBeFormat);
                        dFormat.setRoundingMode(RoundingMode.DOWN);
                        toBeFormat = dFormat.format(userDouble);
                        toBeFormat = toBeFormat.replace("$", "");
                    } else {
                        return userData;
                    }
                }
                fullString.append(toBeFormat);
            }
            return fullString.toString();
        }
        catch (Exception e2) {
            return userData;
        }
    }

    public static String getFormattedDateTime(String outputFormat, String userData) {
        switch (outputFormat) {
            case "date.default{}": {
                outputFormat = "dd MMM yyyy";
                break;
            }
            case "date.short{}": {
                outputFormat = "dd/MM/yy";
                break;
            }
            case "date.medium{}": {
                outputFormat = "dd MMM yyyy";
                break;
            }
            case "date.long{}": {
                outputFormat = "dd MMMM yyyy";
                break;
            }
            case "date.full{}": {
                outputFormat = "EEEE, dd MMMM yyyy";
                break;
            }
            default: {
                outputFormat = outputFormat.replaceAll("Y", "y");
                outputFormat = outputFormat.replaceAll("D", "d");
            }
        }
        String inputFormat = "yyyy-MM-dd";
        if (userData.contains("/")) {
            inputFormat = "yyyy/MM/dd";
        }
        SimpleDateFormat fromUser = new SimpleDateFormat(inputFormat);
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(outputFormat);
            return formatter.format(fromUser.parse(userData));
        }
        catch (Exception e2) {
            return userData;
        }
    }

    public static String getFormattedDateTime(String input, String output, String userData) {
        String outputFormat;
        switch (outputFormat = output.replaceAll("date", "").replaceAll("\\{", "").replaceAll("\\}", "")) {
            case ".default": {
                outputFormat = "dd MMM yyyy";
                break;
            }
            case ".short": {
                outputFormat = "dd/MM/yy";
                break;
            }
            case ".medium": {
                outputFormat = "dd MMM yyyy";
                break;
            }
            case ".long": {
                outputFormat = "dd MMMM yyyy";
                break;
            }
            case ".full": {
                outputFormat = "EEEE, dd MMMM yyyy";
                break;
            }
            default: {
                outputFormat = outputFormat.replaceAll("Y", "y");
                outputFormat = outputFormat.replaceAll("D", "d");
            }
        }
        String inputFormat = userData.contains("-") ? "yyyy-MM-dd" : "yyyy/MM/dd";
        try {
            SimpleDateFormat fromUser = new SimpleDateFormat(inputFormat);
            SimpleDateFormat formatter = new SimpleDateFormat(outputFormat);
            return formatter.format(fromUser.parse(userData));
        }
        catch (Exception e2) {
            return userData;
        }
    }
}

