/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFAUtils;
import com.idrsolutions.pdf.acroforms.xfa.XFontInfo;
import java.util.Stack;
import org.jpedal.color.PdfColor;

public class XFAStyle {
    private static final int FONTFAMILYCSS = 108532386;
    private static final int FONTWEIGHTCSS = 598800822;
    private static final int FONTSIZECSS = -1586082113;
    private static final int TEXTALIGNCSS = 746232421;
    private static final int COLORCSS = 94842723;
    private int textAlign;
    private StringBuilder styleData = new StringBuilder();
    private final XFontInfo fontInfo;

    public XFAStyle(String styleString, XFontInfo xFontInfo, String data, int hAlign) {
        this.textAlign = hAlign;
        this.styleData.append(data);
        this.fontInfo = new XFontInfo(xFontInfo.getTypeFace(), xFontInfo.getSize(), xFontInfo.getWeight(), xFontInfo.getPosture(), xFontInfo.getColor());
        if (styleString != null) {
            String[] styles;
            block27: for (String s2 : styles = styleString.split(";")) {
                String[] temp = s2.split(":");
                String attr = temp[0];
                String value = temp[1];
                switch (attr.hashCode()) {
                    case 108532386: {
                        this.fontInfo.setTypeFace(value);
                        continue block27;
                    }
                    case -1586082113: {
                        double fs = Math.round(XFAUtils.convertToPoints(value));
                        this.fontInfo.setSize((int)fs);
                        continue block27;
                    }
                    case 598800822: {
                        switch (value) {
                            case "normal": {
                                this.fontInfo.setWeight(0);
                                break;
                            }
                            case "bold": {
                                this.fontInfo.setWeight(1);
                                break;
                            }
                            case "italic": {
                                this.fontInfo.setWeight(2);
                            }
                        }
                        continue block27;
                    }
                    case 746232421: {
                        switch (value) {
                            case "left": {
                                this.textAlign = 3317767;
                                break;
                            }
                            case "center": {
                                this.textAlign = -1364013995;
                                break;
                            }
                            case "right": {
                                this.textAlign = 108511772;
                            }
                        }
                        continue block27;
                    }
                    case 94842723: {
                        PdfColor pdfColor = XFAUtils.getPdfColorFromStyle(value);
                        if (pdfColor == null) continue block27;
                        this.fontInfo.setColor(pdfColor);
                    }
                }
            }
        }
    }

    private static XFontInfo getFontInfoFromStyle(String str, XFontInfo defaultFontInfo) {
        XFontInfo curFontInfo = new XFontInfo(defaultFontInfo.getTypeFace(), defaultFontInfo.getSize(), defaultFontInfo.getWeight(), defaultFontInfo.getPosture(), defaultFontInfo.getColor());
        if (str != null) {
            String[] styles;
            block16: for (String s2 : styles = str.split(";")) {
                String[] temp = s2.split(":");
                String attr = temp[0];
                String value = temp[1];
                switch (attr.hashCode()) {
                    case 108532386: {
                        curFontInfo.setTypeFace(value);
                        continue block16;
                    }
                    case -1586082113: {
                        double fs = Math.round(XFAUtils.convertToPoints(value));
                        curFontInfo.setSize((int)fs);
                        continue block16;
                    }
                    case 598800822: {
                        switch (value) {
                            case "normal": {
                                curFontInfo.setWeight(0);
                                break;
                            }
                            case "bold": {
                                curFontInfo.setWeight(1);
                                break;
                            }
                            case "italic": {
                                curFontInfo.setWeight(2);
                            }
                        }
                        continue block16;
                    }
                    case 94842723: {
                        PdfColor pdfColor = XFAUtils.getPdfColorFromStyle(value);
                        if (pdfColor == null) continue block16;
                        curFontInfo.setColor(pdfColor);
                    }
                }
            }
        }
        return curFontInfo;
    }

    public XFAStyle(String styleString, XFontInfo defaultFontInfo, String data, int hAlign, Stack<String> styleStack) {
        this.textAlign = hAlign;
        this.styleData.append(data);
        if (!styleStack.isEmpty() && styleStack.size() > 1) {
            String tempStyleStr = (String)styleStack.get(styleStack.size() - 2);
            XFontInfo tempFontInfo = XFAStyle.getFontInfoFromStyle(tempStyleStr, defaultFontInfo);
            this.fontInfo = new XFontInfo(tempFontInfo.getTypeFace(), tempFontInfo.getSize(), tempFontInfo.getWeight(), tempFontInfo.getPosture(), tempFontInfo.getColor());
        } else {
            this.fontInfo = new XFontInfo(defaultFontInfo.getTypeFace(), defaultFontInfo.getSize(), defaultFontInfo.getWeight(), defaultFontInfo.getPosture(), defaultFontInfo.getColor());
        }
        if (styleString != null) {
            String[] styles;
            block27: for (String s2 : styles = styleString.split(";")) {
                String[] temp = s2.split(":");
                String attr = temp[0];
                String value = temp[1];
                switch (attr.hashCode()) {
                    case 108532386: {
                        this.fontInfo.setTypeFace(value);
                        continue block27;
                    }
                    case -1586082113: {
                        double fs = Math.round(XFAUtils.convertToPoints(value));
                        this.fontInfo.setSize((int)fs);
                        continue block27;
                    }
                    case 598800822: {
                        switch (value) {
                            case "normal": {
                                this.fontInfo.setWeight(0);
                                break;
                            }
                            case "bold": {
                                this.fontInfo.setWeight(1);
                                break;
                            }
                            case "italic": {
                                this.fontInfo.setWeight(2);
                            }
                        }
                        continue block27;
                    }
                    case 746232421: {
                        switch (value) {
                            case "left": {
                                this.textAlign = 3317767;
                                break;
                            }
                            case "center": {
                                this.textAlign = -1364013995;
                                break;
                            }
                            case "right": {
                                this.textAlign = 108511772;
                            }
                        }
                        continue block27;
                    }
                    case 94842723: {
                        PdfColor pdfColor = XFAUtils.getPdfColorFromStyle(value);
                        if (pdfColor == null) continue block27;
                        this.fontInfo.setColor(pdfColor);
                    }
                }
            }
        }
    }

    public String getStyleData() {
        return this.styleData.toString();
    }

    public void setStyleData(String data) {
        this.styleData = new StringBuilder(data);
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public XFontInfo getFontInfo() {
        return this.fontInfo;
    }
}

