/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.image.JDeli;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.pdf.acroforms.xfa.XBox;
import com.idrsolutions.pdf.acroforms.xfa.XFAPageContent;
import com.idrsolutions.pdf.acroforms.xfa.XFAUtils;
import com.idrsolutions.pdf.acroforms.xfa.XFontInfo;
import com.idrsolutions.pdf.acroforms.xfa.XPageArea;
import com.idrsolutions.pdf.acroforms.xfa.XQuery;
import com.idrsolutions.pdf.acroforms.xfa.XRect;
import com.idrsolutions.pdf.acroforms.xfa.XSubForm;
import com.idrsolutions.pdf.acroforms.xfa.objects.XFADraw;
import com.idrsolutions.pdf.acroforms.xfa.objects.XFAField;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.NameLookup;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRendererXFA;
import org.jpedal.objects.acroforms.FormTypes;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.FormAppearanceObject;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.parser.FontResolver;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.XFAStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SecureDocumentBuilderFactory;
import org.jpedal.utils.SecureTransformerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XFAFormStream
extends FormStream {
    private static final boolean showScriptErrors = LogWriter.isRunningFromIDE;
    private byte[] config;
    private byte[] dataset;
    private byte[] formData;
    private byte[] template;
    private byte[] localeSet;
    private FormTypes formType;
    private String dynamicRender;
    private final HashMap<Integer, XFAPageContent> pageMapXFA;
    private final HashMap<Integer, FormObject[]> pageFormMap;
    private Document copiedDocument;
    private final boolean alwaysUseXFA;

    public XFAFormStream(PdfObject acroFormObj, PdfObjectReader inCurrentPdfFile, AcroRendererXFA formRenderer) {
        block8: {
            this.formType = FormTypes.XFA_DYNAMIC;
            this.dynamicRender = "";
            this.pageMapXFA = new HashMap();
            this.pageFormMap = new HashMap();
            this.alwaysUseXFA = formRenderer.alwaysuseXFA();
            this.currentPdfFile = inCurrentPdfFile;
            this.readXFA(acroFormObj);
            PdfFontFactory fontFactory = new PdfFontFactory(this.currentPdfFile);
            XFAStreamDecoder decoder = new XFAStreamDecoder(inCurrentPdfFile, null, formRenderer);
            byte[] template = this.getXFA(1013350773);
            byte[] dataRoot = this.getXFA(1130793076);
            if (template != null) {
                try {
                    Document dataDoc;
                    Document templateDoc;
                    DocumentBuilder builder;
                    block7: {
                        SecureDocumentBuilderFactory factory = new SecureDocumentBuilderFactory();
                        factory.setIgnoringElementContentWhitespace(true);
                        factory.setNamespaceAware(false);
                        builder = factory.newDocumentBuilder();
                        templateDoc = builder.parse(new ByteArrayInputStream(template));
                        dataDoc = null;
                        if (dataRoot != null) {
                            try {
                                dataDoc = builder.parse(new ByteArrayInputStream(dataRoot));
                                NodeList list = dataDoc.getElementsByTagName("dd:dataDescription");
                                if (list.getLength() > 0) {
                                    Node parent = list.item(0).getParentNode();
                                    parent.removeChild(list.item(0));
                                }
                                XFAFormStream.renamePrefixRecursive(dataDoc.getDocumentElement());
                            }
                            catch (Exception e2) {
                                if (!showScriptErrors) break block7;
                                LogWriter.writeLog("XFAFormStream : this XFA file contains bad dataset " + e2);
                            }
                        }
                    }
                    XFAFormStream.handleProtoTypes(templateDoc);
                    this.copiedDocument = builder.newDocument();
                    Node copiedRoot = this.copiedDocument.importNode(templateDoc.getDocumentElement(), true);
                    this.copiedDocument.appendChild(copiedRoot);
                    XFAFormStream.handleImages(this.copiedDocument, this.currentPdfFile);
                    XQuery.combineDataWithTemp(templateDoc, dataDoc);
                    XFAFormStream.adjustTextDrawings(templateDoc, decoder, fontFactory, this.currentPdfFile.getObjectStore());
                    XFAFormStream.adjustCaptionFields(templateDoc, decoder, fontFactory, this.currentPdfFile.getObjectStore());
                    XFAFormStream.fillWidgetHeight(templateDoc);
                    XFAFormStream.fillDynamicFormHeight(templateDoc);
                    XFAFormStream.fillGlobalPosition(templateDoc);
                    XFAFormStream.generateCarpet(templateDoc, this.pageMapXFA);
                    XFAFormStream.fillPageFormMap(this.pageMapXFA, this.currentPdfFile, this.pageFormMap);
                }
                catch (Exception e3) {
                    if (!showScriptErrors) break block8;
                    LogWriter.writeLog("XFAFormStream : this XFA file contains unrecognized tags " + e3);
                }
            }
        }
    }

    private static void renamePrefixRecursive(Node node) {
        Document document = node.getOwnerDocument();
        if (node.getNodeType() == 1) {
            String ss = node.getNodeName();
            int nsIndex = ss.indexOf(58);
            if (nsIndex != -1 && !ss.startsWith("xfa:")) {
                ss = ss.substring(nsIndex + 1);
                document.renameNode(node, null, ss);
            }
            NamedNodeMap nnm = node.getAttributes();
            int len = nnm.getLength();
            for (int i2 = 0; i2 < len; ++i2) {
                Node temp = nnm.item(i2);
                ss = temp.getNodeName();
                nsIndex = ss.indexOf(58);
                if (nsIndex == -1 || ss.startsWith("xfa:")) continue;
                ss = ss.substring(nsIndex + 1);
                document.renameNode(temp, null, ss);
            }
        }
        NodeList list = node.getChildNodes();
        for (int i3 = 0; i3 < list.getLength(); ++i3) {
            XFAFormStream.renamePrefixRecursive(list.item(i3));
        }
    }

    public byte[] getAlteredTemplateBytes() {
        TransformerFactory transformerFactory = SecureTransformerFactory.newInstance();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.copiedDocument);
            StreamResult result = new StreamResult(bos);
            transformer.transform(source, result);
            bos.close();
            bos.flush();
        }
        catch (Exception e2) {
            LogWriter.writeLog(e2);
        }
        return bos.toByteArray();
    }

    private static void handleImages(Document dom, PdfObjectReader currentPdfFile) {
        NodeList draws = dom.getElementsByTagName("draw");
        for (int i2 = 0; i2 < draws.getLength(); ++i2) {
            NodeList images = ((Element)draws.item(i2)).getElementsByTagName("image");
            if (images.getLength() <= 0) continue;
            Element image = (Element)images.item(0);
            String cType = image.getAttribute("contentType");
            String href = image.getAttribute("href");
            if (!href.isEmpty()) {
                NameLookup nameLookup = currentPdfFile.getNamesLookup();
                if (!nameLookup.containsKey(href)) continue;
                byte[] dataBytes = (byte[])nameLookup.get(href);
                try {
                    BufferedImage bi2 = JDeli.read(new ByteArrayInputStream(dataBytes));
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    JDeli.write(bi2, OutputFormat.PNG, (OutputStream)bos);
                    bos.close();
                    bos.flush();
                    image.setTextContent(Base64.getEncoder().encodeToString(bos.toByteArray()));
                    image.setAttribute("contentType", "image/png");
                    image.removeAttribute("href");
                }
                catch (Exception e2) {
                    if (!showScriptErrors) continue;
                    System.err.println("XFA embedded image not recognized in XFAFormStream " + e2);
                }
                continue;
            }
            if (!"image/tif".equals(cType)) continue;
            byte[] dataBytes = XFAFormStream.decode64(image.getTextContent());
            try {
                BufferedImage bi3 = JDeli.read(dataBytes);
                if (bi3 == null) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                JDeli.write(bi3, OutputFormat.PNG, (OutputStream)bos);
                bos.close();
                bos.flush();
                image.setTextContent(Base64.getEncoder().encodeToString(bos.toByteArray()));
                image.setAttribute("contentType", "image/png");
                continue;
            }
            catch (Exception e3) {
                if (!showScriptErrors) continue;
                System.err.println("XFA embedded image not recognized in XFAFormStream " + e3);
            }
        }
    }

    public static byte[] decode64(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            int cp = str.codePointAt(i2);
            char cc = str.charAt(i2);
            if (!(cp == 43 || cp == 61 || cp == 47 || cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122) && (cp < 48 || cp > 57)) continue;
            sb.append(cc);
        }
        return Base64.getDecoder().decode(sb.toString());
    }

    private static void handleProtoTypes(Document template) {
        NodeList protoList = template.getElementsByTagName("proto");
        if (protoList.getLength() > 0) {
            String[] names;
            Node protoNode = protoList.item(0);
            if (!protoNode.hasChildNodes()) {
                return;
            }
            for (String query : names = new String[]{"subform", "field", "draw"}) {
                NodeList list = template.getElementsByTagName(query);
                for (int i2 = 0; i2 < list.getLength(); ++i2) {
                    Node found;
                    Node node = list.item(i2);
                    if (!node.hasAttributes()) continue;
                    Node useAtr = node.getAttributes().getNamedItem("use");
                    Node node2 = useAtr = useAtr != null ? useAtr : node.getAttributes().getNamedItem("useHref");
                    if (useAtr == null) continue;
                    String value = useAtr.getNodeValue();
                    String lookupAtr = "name";
                    if (value.contains(".")) {
                        value = value.substring(value.lastIndexOf(46) + 1);
                    }
                    if (value.startsWith("#")) {
                        value = value.substring(1);
                        lookupAtr = "id";
                    }
                    if ((found = XQuery.findNodeWithAttrAndValue(template, lookupAtr, value)) == null) continue;
                    Element nodeEle = (Element)node;
                    Element protoEle = (Element)found.cloneNode(true);
                    XFAFormStream.mergeTwoNodes(nodeEle, protoEle);
                }
            }
            protoNode.getParentNode().removeChild(protoNode);
        }
    }

    private static void mergeTwoNodes(Node main, Node protoClone) {
        XFAFormStream.mergeAttributes(main, protoClone);
        ArrayList<Node> listToAdd = new ArrayList<Node>();
        for (int i2 = 0; i2 < protoClone.getChildNodes().getLength(); ++i2) {
            Node child = protoClone.getChildNodes().item(i2);
            Node mainChild = XFAFormStream.lookForChild(main, child.getNodeName().hashCode());
            if (mainChild != null) continue;
            listToAdd.add(child.cloneNode(true));
        }
        for (Node item : listToAdd) {
            main.appendChild(item);
        }
    }

    private static void mergeAttributes(Node fixed, Node merge) {
        if (fixed.getNodeType() == 1) {
            Element fixedEle = (Element)fixed;
            Element mergeEle = (Element)merge;
            block3: for (int i2 = 0; i2 < mergeEle.getAttributes().getLength(); ++i2) {
                Node atr = mergeEle.getAttributes().item(i2);
                switch (atr.getNodeName().hashCode()) {
                    case -147412686: 
                    case 3355: 
                    case 116103: 
                    case 3373707: {
                        continue block3;
                    }
                    default: {
                        if (!fixedEle.getAttribute(atr.getNodeName()).isEmpty()) continue block3;
                        fixedEle.setAttribute(atr.getNodeName(), atr.getNodeValue());
                    }
                }
            }
        }
    }

    private static void adjustTextDrawings(Document template, PdfStreamDecoder decoder, PdfFontFactory fontFactory, ObjectStore objectStore) {
        XBox drawBox;
        HashMap<String, PdfFont> fontCacheMap = new HashMap<String, PdfFont>();
        List<Node> htmlDrawlist = XQuery.findDrawsContainsHTML(template);
        for (Node current : htmlDrawlist) {
            Node exNode = XFAFormStream.singleNodePicker(current, -1290477827);
            Node fontNode = XFAFormStream.singleNodePicker(current, 3148879);
            XFontInfo fontInfo = fontNode == null ? new XFontInfo("Arial", 10, 0) : XFontInfo.getFontInfoFromNode(fontNode);
            if (exNode == null) continue;
            String exData = "";
            try (StringWriter buffer = new StringWriter();){
                Transformer transformer = SecureTransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(exNode.getFirstChild()), new StreamResult(buffer));
                exData = buffer.toString();
            }
            catch (Exception e2) {
                LogWriter.writeLog(e2);
            }
            drawBox = new XBox(current);
            double[] dArray = new double[]{drawBox.getX(), drawBox.getY(), drawBox.getW(), drawBox.getH()};
            double[] coords = dArray;
            double estimH = XFADraw.getHtmlDataHeight(coords, drawBox, fontInfo, exData, 3317767, decoder, fontCacheMap, fontFactory, objectStore);
            if (!(estimH > drawBox.getH())) continue;
            estimH = estimH + drawBox.getMarginBottom() + drawBox.getMarginTop();
            Element currentEle = (Element)current;
            currentEle.setAttribute("h", estimH + "pt");
        }
        List<Node> normalDrawlist = XQuery.findDrawsContainsNormal(template);
        for (Node current : normalDrawlist) {
            double size;
            Node valueNode;
            XFontInfo fontInfo = new XFontInfo("Arial", 10, 0);
            Node fontNode = XFAFormStream.singleNodePicker(current, 3148879);
            if (fontNode != null) {
                fontInfo = XFontInfo.getFontInfoFromNode(fontNode);
            }
            if ((valueNode = XFAFormStream.lookForChild(current, 111972721)) == null) continue;
            drawBox = new XBox(current);
            if (drawBox.hasH) continue;
            String data = valueNode.getTextContent();
            int lines = 1;
            if (!drawBox.hasMinW) {
                lines = XFAFormStream.getTotalLines(drawBox.getW(), data, fontInfo, decoder, fontCacheMap, fontFactory, objectStore).size();
            }
            if (!((size = (double)(fontInfo.getSize() * lines)) > drawBox.getH())) continue;
            size = size + drawBox.getMarginBottom() + drawBox.getMarginTop();
            Element currentEle = (Element)current;
            String atrName = "h";
            if (currentEle.hasAttributes()) {
                Node hNode = currentEle.getAttributes().getNamedItem("h");
                atrName = hNode != null ? "h" : "minH";
            }
            currentEle.setAttribute(atrName, size + "pt");
        }
        fontCacheMap.clear();
    }

    private static void adjustCaptionFields(Document template, PdfStreamDecoder decoder, PdfFontFactory fontFactory, ObjectStore objectStore) {
        NodeList captionlist = template.getElementsByTagName("caption");
        for (int i2 = 0; i2 < captionlist.getLength(); ++i2) {
            int lines;
            Node caption = captionlist.item(i2);
            String captionData = null;
            Node exNode = XFAFormStream.lookForChild(caption, -1290477827);
            if (exNode != null) {
                try (StringWriter buffer = new StringWriter();){
                    TransformerFactory transFactory = SecureTransformerFactory.newInstance();
                    Transformer transformer = transFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(new DOMSource(exNode.getFirstChild()), new StreamResult(buffer));
                    captionData = buffer.toString();
                }
                catch (Exception e2) {
                    LogWriter.writeLog("XFAFormStream : exdata reading exception " + e2);
                }
            } else {
                Node valueNode = XFAFormStream.lookForChild(caption, 111972721);
                if (valueNode != null) {
                    captionData = valueNode.getTextContent();
                }
            }
            if (captionData == null) continue;
            Node field = caption.getParentNode();
            int capPlace = 3317767;
            double reserveValue = 0.0;
            Node fontNode = XFAFormStream.lookForChild(caption, 3148879);
            XFontInfo fontInfo = new XFontInfo();
            if (fontNode == null) {
                fontNode = XFAFormStream.lookForChild(field, 3148879);
            }
            if (fontNode != null) {
                fontInfo = XFontInfo.getFontInfoFromNode(fontNode);
            }
            if (!caption.hasAttributes()) continue;
            Node reserveAtr = caption.getAttributes().getNamedItem("reserve");
            Node placeAtr = caption.getAttributes().getNamedItem("placement");
            if (reserveAtr != null) {
                reserveValue = XFAUtils.convertToPoints(reserveAtr.getNodeValue());
            }
            if (placeAtr != null) {
                capPlace = placeAtr.getNodeValue().hashCode();
            }
            if (reserveValue == 0.0) continue;
            XBox fieldBox = new XBox(field);
            if (reserveValue < 0.0) {
                Node checkBtnNode = XFAFormStream.singleNodePicker(field, 282923610);
                reserveValue = checkBtnNode != null ? fieldBox.getW() - 12.0 : Math.abs(reserveValue);
            }
            HashMap<String, PdfFont> fontCacheMap = new HashMap<String, PdfFont>();
            double size = fontInfo.getSize();
            if (capPlace != 3317767 && capPlace != 108511772 || exNode != null || !((size *= (double)(lines = XFAFormStream.getTotalLines(reserveValue, captionData, fontInfo, decoder, fontCacheMap, fontFactory, objectStore).size())) > fieldBox.getH())) continue;
            String atrName = "h";
            Element fieldEle = (Element)field;
            if (field.hasAttributes()) {
                Node hNode = field.getAttributes().getNamedItem("h");
                atrName = hNode != null ? "h" : "minH";
            }
            fieldEle.setAttribute(atrName, size + "pt");
        }
    }

    public FormTypes getPDFFormType() {
        return this.formType;
    }

    @Override
    public byte[] getXFA(int type) {
        byte[] returnValue = null;
        switch (type) {
            case 1043741046: {
                returnValue = this.config;
                break;
            }
            case 1130793076: {
                returnValue = this.dataset;
                break;
            }
            case 1013350773: {
                returnValue = this.template;
                break;
            }
            case 1951819392: {
                returnValue = this.localeSet;
                break;
            }
            case 4145725: {
                returnValue = this.formData;
                break;
            }
        }
        return returnValue;
    }

    private void readXFA(PdfObject acroFormObj) {
        Node configNode;
        PdfArrayIterator XFAasArray = null;
        PdfObject XFAasStream = acroFormObj.getDictionary(2627089);
        if (XFAasStream == null && (XFAasArray = acroFormObj.getMixedArray(2627089)) != null && XFAasArray.getTokenCount() == 0) {
            XFAasArray = null;
        }
        if (XFAasStream != null) {
            this.readAsStream(XFAasStream);
        } else {
            this.readAsArray(XFAasArray);
        }
        if (this.config != null && (configNode = XFAFormStream.xfaConfigToNode(this.config)) != null) {
            this.parseConfig(configNode);
        }
        if (!this.alwaysUseXFA && (this.dynamicRender.isEmpty() || "forbidden".equals(this.dynamicRender))) {
            this.dataset = null;
            this.config = null;
            this.template = null;
            this.localeSet = null;
            this.pageMapXFA.clear();
            this.formType = FormTypes.XFA_LEGACY;
            this.isXFA = false;
        } else {
            this.isXFA = true;
            this.formType = FormTypes.XFA_DYNAMIC;
        }
    }

    private void readAsArray(PdfArrayIterator XFAasArray) {
        while (XFAasArray != null && XFAasArray.hasMoreTokens()) {
            int type = XFAasArray.getNextValueAsConstant(true);
            StreamObject obj = new StreamObject(XFAasArray.getNextValueAsString(true));
            this.currentPdfFile.readObject(obj);
            byte[] objData = obj.getDecodedStream();
            switch (type) {
                case 1043741046: {
                    this.config = objData;
                    break;
                }
                case 1130793076: {
                    this.dataset = objData;
                    break;
                }
                case 1013350773: {
                    this.template = objData;
                    break;
                }
                case 1951819392: {
                    this.localeSet = objData;
                    break;
                }
                case 4145725: {
                    this.formData = objData;
                    break;
                }
            }
        }
    }

    private void readAsStream(PdfObject XFAasStream) {
        int localeSetStart;
        int dataSetStart;
        int templateStart;
        byte[] decodedStream = XFAasStream.getDecodedStream();
        String xdpString = new String(decodedStream);
        int configStart = xdpString.indexOf("<config");
        if (configStart != -1) {
            int configEnd = xdpString.indexOf("</config");
            String configString = xdpString.substring(configStart, configEnd) + "</config>";
            this.config = configString.getBytes();
            String xdpSuffix = xdpString.substring(0, configStart);
            String xdpPrefix = xdpString.substring(configEnd);
            xdpString = xdpSuffix + xdpPrefix;
        }
        if ((templateStart = xdpString.indexOf("<template")) != -1) {
            int templateEnd = xdpString.lastIndexOf("</template");
            String templateString = xdpString.substring(templateStart, templateEnd) + "</template>";
            this.template = templateString.getBytes();
        }
        if ((dataSetStart = xdpString.indexOf("<xfa:datasets")) != -1) {
            int dataSetEnd = xdpString.indexOf("</xfa:datasets");
            String dataSetString = xdpString.substring(dataSetStart, dataSetEnd) + "</xfa:datasets>";
            this.dataset = dataSetString.getBytes();
        }
        if ((localeSetStart = xdpString.lastIndexOf("<localeSet")) != -1) {
            int localeSetEnd = xdpString.lastIndexOf("</localeSet");
            String localeSetString = xdpString.substring(localeSetStart, localeSetEnd) + "</localeSet>";
            this.localeSet = localeSetString.getBytes();
        }
    }

    private static Node xfaConfigToNode(byte[] decodedStream) {
        Document document;
        SecureDocumentBuilderFactory factory = new SecureDocumentBuilderFactory();
        try {
            document = factory.newDocumentBuilder().parse(new ByteArrayInputStream(decodedStream));
        }
        catch (Exception e2) {
            LogWriter.writeLog("Exception " + e2);
            return null;
        }
        NodeList nodes = document.getElementsByTagName("config");
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Element element = (Element)nodes.item(i2);
            String att = element.getAttribute("xmlns");
            if (att.isEmpty()) continue;
            return element;
        }
        return null;
    }

    @Override
    public boolean hasXFADataSet() {
        return this.dataset != null;
    }

    public FormObject[] createAppearanceString(int pageNumber) {
        return this.dynamiceFormPicker(pageNumber);
    }

    private static void fillPageFormMap(HashMap<Integer, XFAPageContent> pageMapXFA, PdfObjectReader currentPdfFile, HashMap<Integer, FormObject[]> pageFormMap) {
        HashMap<String, PdfFont> fontCache = new HashMap<String, PdfFont>();
        for (int z2 = 0; z2 < pageMapXFA.size(); ++z2) {
            ArrayList<XFAField> formList = new ArrayList<XFAField>();
            ArrayList<Node> fieldList = new ArrayList<Node>();
            XFAPageContent xpc = pageMapXFA.get(z2 + 1);
            if (xpc != null) {
                Node pageAreaNode = xpc.getPageAreaNode();
                XFAFormStream.nodePicker(pageAreaNode, 97427706, fieldList, new ArrayList<Node>(), 0);
                for (Node node : xpc.getNodeList()) {
                    if (node.getNodeName().hashCode() != 97427706) continue;
                    fieldList.add(node);
                }
                for (Node fn : fieldList) {
                    try {
                        XFAField xfw = new XFAField(null, fn, pageAreaNode, z2 + 1, null, currentPdfFile, xpc, null, fontCache);
                        formList.add(xfw);
                    }
                    catch (Exception e2) {
                        LogWriter.writeLog("invalid xfa field found");
                    }
                }
            }
            FormObject[] f2 = formList.toArray(new FormObject[0]);
            pageFormMap.put(z2 + 1, f2);
        }
        fontCache.clear();
    }

    private FormObject[] dynamiceFormPicker(int pageNumber) {
        FormObject[] formObject = this.pageFormMap.get(pageNumber);
        HashMap tabMap = new HashMap();
        double maxY = 0.0;
        for (FormObject obj : formObject) {
            if (obj == null) continue;
            int x2 = obj.getBoundingRectangle().x;
            Double y2 = obj.getBounding2DRectangleForTabbing().getY();
            maxY = Math.max(y2, maxY);
            if (tabMap.containsKey(y2)) {
                ArrayList fList = (ArrayList)tabMap.get(y2);
                int insertion = -1;
                for (int z2 = 0; z2 < fList.size(); ++z2) {
                    int nextX = ((FormObject)fList.get((int)z2)).getBoundingRectangle().x;
                    if (nextX >= x2) continue;
                    insertion = z2;
                }
                if (insertion == -1) {
                    fList.add(0, obj);
                    continue;
                }
                fList.add(insertion + 1, obj);
                continue;
            }
            ArrayList<FormObject> list = new ArrayList<FormObject>();
            list.add(obj);
            tabMap.put(y2, list);
        }
        FormObject[] finalList = new FormObject[formObject.length];
        int objCount = 0;
        Object[] keys = new Object[tabMap.size()];
        int cc = 0;
        Object[] x2 = tabMap.keySet().toArray();
        int y2 = x2.length;
        for (int i2 = 0; i2 < y2; ++i2) {
            Object k2;
            keys[cc] = k2 = x2[i2];
            ++cc;
        }
        Arrays.sort(keys);
        for (int k3 = keys.length; k3 > 0; --k3) {
            ArrayList objList = (ArrayList)tabMap.get(keys[k3 - 1]);
            if (objList == null) continue;
            Iterator iterator = objList.iterator();
            while (iterator.hasNext()) {
                FormObject f2;
                finalList[objCount] = f2 = (FormObject)iterator.next();
                ++objCount;
            }
        }
        return finalList;
    }

    public static void setupAppearances(XFAField xf, boolean isSelected) {
        xf.setAppreancesUsed(isSelected);
        xf.setAppreancesUsed(true);
        String ref = xf.getObjectRefAsString();
        FormObject AP = new FormObject(ref);
        FormObject N2 = new FormObject(ref);
        FormObject R2 = new FormObject(ref);
        AP.setDictionary(30, N2);
        AP.setDictionary(34, R2);
        xf.setDictionary(4384, AP);
        FormAppearanceObject On = new FormAppearanceObject(ref);
        XFAFormStream.copyInParms(On, xf);
        N2.setDictionary(7998, On);
        FormAppearanceObject ROn = new FormAppearanceObject(ref);
        XFAFormStream.copyInParms(ROn, xf);
        R2.setDictionary(7998, ROn);
        On.setSelected(true);
        ROn.setRollover(true);
        ROn.setSelected(true);
        if (xf.getXFARawDataType() != XFAField.XFARawDataType.SIGNATURE && xf.getXFARawDataType() != XFAField.XFARawDataType.BUTTON) {
            FormAppearanceObject Off = new FormAppearanceObject(ref);
            XFAFormStream.copyInParms(Off, xf);
            Off.setSelected(false);
            N2.setDictionary(2045494, Off);
            FormAppearanceObject ROff = new FormAppearanceObject(ref);
            XFAFormStream.copyInParms(ROff, xf);
            R2.setDictionary(2045494, ROff);
            ROff.setRollover(true);
            ROff.setSelected(false);
        }
    }

    private static void copyInParms(FormAppearanceObject obj, XFAField xf) {
        obj.setSubtype(xf.getSubtype());
        switch (xf.getSubtype()) {
            case 8: 
            case 9: {
                obj.setXfaCheckButtonShapeType(xf.getCheckButtonShape());
                obj.setXFACheckButtonMarkType(xf.getCheckButtonMarkType());
            }
        }
        obj.setBorderStroke(xf.getBorderStroke());
        obj.setFloatArray(4631, xf.getDictionary(7451).getFloatArray(4631));
        Rectangle rect = xf.getBoundingRectangle();
        obj.setWidth(rect.width);
        obj.setHeight(rect.height);
    }

    public static void nodePicker(Node nodeToParse, int type, ArrayList<Node> requiredList, ArrayList<Node> tempList, int indent) {
        if (nodeToParse == null) {
            return;
        }
        if (nodeToParse.getNodeName().hashCode() == type) {
            requiredList.add(nodeToParse);
        }
        tempList.add(nodeToParse);
        NodeList setOfNodes = nodeToParse.getChildNodes();
        for (int i2 = 0; i2 < setOfNodes.getLength(); ++i2) {
            XFAFormStream.nodePicker(setOfNodes.item(i2), type, requiredList, tempList, indent + 3);
        }
    }

    public static Node singleNodePicker(Node nodeToParse, int type) {
        ArrayList<Node> requiredList = new ArrayList<Node>();
        XFAFormStream.singleNodeIterator(nodeToParse, type, requiredList, new ArrayList<Node>());
        if (!requiredList.isEmpty()) {
            return requiredList.get(0);
        }
        return null;
    }

    private static void singleNodeIterator(Node nodeToParse, int type, ArrayList<Node> requiredList, ArrayList<Node> tempList) {
        if (!requiredList.isEmpty()) {
            return;
        }
        if (nodeToParse.getNodeName().hashCode() == type) {
            requiredList.add(nodeToParse);
        }
        tempList.add(nodeToParse);
        NodeList setOfNodes = nodeToParse.getChildNodes();
        for (int i2 = 0; i2 < setOfNodes.getLength(); ++i2) {
            XFAFormStream.nodePicker(setOfNodes.item(i2), type, requiredList, tempList, 0);
        }
    }

    private static double[] getFullPageCoords(Node pageAreaNode) {
        double longVal = 0.0;
        double shortVal = 0.0;
        boolean isLandscape = false;
        double[] temp = new double[4];
        NodeList pgList = pageAreaNode.getChildNodes();
        block9: for (int z2 = 0; z2 < pgList.getLength(); ++z2) {
            String str = pgList.item(z2).getNodeName();
            switch (str.hashCode()) {
                case -389704538: {
                    temp = XFAFormStream.getCoordsXYWH(pgList.item(z2));
                    continue block9;
                }
                case -1078030475: {
                    NamedNodeMap nm = pgList.item(z2).getAttributes();
                    block10: for (int q2 = 0; q2 < nm.getLength(); ++q2) {
                        String value = nm.item(q2).getNodeValue();
                        switch (nm.item(q2).getNodeName().hashCode()) {
                            case 3327612: {
                                longVal = XFAUtils.convertToPoints(value);
                                continue block10;
                            }
                            case 109413500: {
                                shortVal = XFAUtils.convertToPoints(value);
                                continue block10;
                            }
                            case -1439500848: {
                                if (value.hashCode() != 1430647483) continue block10;
                                isLandscape = true;
                            }
                        }
                    }
                    continue block9;
                }
            }
        }
        temp[2] = temp[0] + temp[2];
        temp[3] = temp[1] + temp[3];
        if (longVal > 0.0) {
            temp[3] = Math.max(longVal, temp[3]);
            temp[2] = Math.max(shortVal, temp[2]);
        }
        if (isLandscape) {
            temp[2] = longVal > 0.0 ? longVal : temp[2];
            temp[3] = shortVal > 0.0 ? shortVal : temp[3];
        }
        return temp;
    }

    private static double[] getPageCoordsXYWH(int pageNumber, HashMap<Integer, XFAPageContent> pgMap) {
        double[] coords = new double[4];
        if (pgMap.get(1) != null) {
            Node pgNode1 = pgMap.get(1).getPageAreaNode();
            if (pageNumber > 1) {
                Node pgNode = null;
                if (pgMap.containsKey(pageNumber)) {
                    pgNode = pgMap.get(pageNumber).getPageAreaNode();
                }
                if (pgNode != null) {
                    pgNode1 = pgNode;
                }
            }
            coords = XFAFormStream.getFullPageCoords(pgNode1);
        }
        return coords;
    }

    private static void fillWidgetHeight(Document template) {
        List<Node> list = XQuery.findAllFieldsAndDraws(template);
        for (Node parse : list) {
            int nameHash = parse.getNodeName().hashCode();
            boolean inserted = false;
            XBox box = new XBox(parse);
            if (nameHash == 97427706 && box.isContainMultiline()) {
                Node valueChild;
                String data = XBox.getCustomData(parse);
                if (data == null && (valueChild = XFAFormStream.lookForChild(parse, 111972721)) != null) {
                    data = valueChild.getTextContent();
                }
                if (data != null && box.hasMinH) {
                    double lineHeight = XFAFormStream.getJavaLineHeight(box.getFormFontInfo(), data);
                    double availableWidth = box.getW() - box.getMarginLeft() - box.getMarginRight();
                    HashMap<Integer, String> lineMap = XFAFormStream.getTotalLinesMap(availableWidth, data, box.getFormFontInfo());
                    int size = lineMap.size();
                    double dataHeight = (double)size * lineHeight;
                    if (dataHeight > box.getH()) {
                        XBox.addCustomGlobalHeight(parse, dataHeight);
                        inserted = true;
                    }
                }
            }
            if (inserted) continue;
            XBox.addCustomGlobalHeight(parse, box.getH());
        }
    }

    public static double[] getDynamicCoordsBottom(Node node, Node pageAreaNode) {
        XPageArea xPageArea = new XPageArea(pageAreaNode);
        XBox box = new XBox(node);
        double[] pgCoords = xPageArea.getContentAreaCoords();
        double[] fullCoords = xPageArea.getFullPageCoords();
        double[] temp = box.getXYWH();
        if (XBox.isPageAreaFamily(node)) {
            XRect rect = XBox.getCustomGlobalPosition(node);
            if (rect != null) {
                temp = new double[]{rect.getX(), rect.getY(), temp[2], temp[3]};
            }
            temp[1] = fullCoords[3] - temp[1] - temp[3];
            return temp;
        }
        double[] coords = XBox.getCustomCoords(node);
        coords[0] = pgCoords[0] + coords[0];
        coords[1] = pgCoords[1] + coords[1];
        coords[1] = fullCoords[3] - coords[1] - coords[3];
        return coords;
    }

    private static Node getSpecificPageArea(String id2, ArrayList<Node> pageAreaNodeList) {
        if (id2 != null && id2.contains("#")) {
            id2 = id2.substring(1);
        }
        for (Node node : pageAreaNodeList) {
            XPageArea pageArea = new XPageArea(node);
            if (pageArea.getId() == null || !pageArea.getId().equals(id2)) continue;
            return node;
        }
        return null;
    }

    private static Node getSpecificPageArea(String id2, ArrayList<Node> pageAreaNodeList, int targetType) {
        String pid = null;
        if (id2 != null) {
            String string = pid = id2.contains("#") ? id2.substring(1) : id2;
            if (pid.contains(".")) {
                String[] spl = pid.split("\\.");
                pid = spl[0];
                targetType = 858900412;
            }
        }
        switch (targetType) {
            case 858900412: {
                for (Node node : pageAreaNodeList) {
                    XPageArea pageArea = new XPageArea(node);
                    if ((pageArea.getId() == null || !pageArea.getId().equals(pid)) && (pageArea.getName() == null || !pageArea.getName().equals(pid))) continue;
                    return node;
                }
                break;
            }
            case -389704538: {
                for (Node node : pageAreaNodeList) {
                    XPageArea pageArea = new XPageArea(node);
                    if ((pageArea.getContentAreaId() == null || !pageArea.getContentAreaId().equals(pid)) && (pageArea.getContentAreaName() == null || !pageArea.getContentAreaName().equals(pid))) continue;
                    return node;
                }
                break;
            }
        }
        return null;
    }

    private static boolean isContainer(Node node) {
        boolean isContainer = false;
        int type = node.getNodeName().hashCode();
        if (type == 1644111747 || type == -1867994364 || type == 471239358 || type == 3002509) {
            isContainer = true;
        }
        return isContainer;
    }

    private static boolean isFormContainer(Node node) {
        int type = node.getNodeName().hashCode();
        return type == -1867994364 || type == 471239358;
    }

    private static boolean isWidget(Node node) {
        boolean isWidget = false;
        int type = node.getNodeName().hashCode();
        if (type == 3091780 || type == 97427706) {
            isWidget = true;
        }
        return isWidget;
    }

    public static boolean isField(Node node) {
        boolean isWidget = false;
        int type = node.getNodeName().hashCode();
        if (type == 97427706) {
            isWidget = true;
        }
        return isWidget;
    }

    public static boolean isDraw(Node node) {
        boolean isWidget = false;
        int type = node.getNodeName().hashCode();
        if (type == 3091780) {
            isWidget = true;
        }
        return isWidget;
    }

    private static boolean isExclGroup(Node node) {
        boolean isWidget = false;
        int type = node.getNodeName().hashCode();
        if (type == 1644111747) {
            isWidget = true;
        }
        return isWidget;
    }

    public static Node lookForChild(Node node, int nodeType) {
        for (int z2 = 0; z2 < node.getChildNodes().getLength(); ++z2) {
            String cName = node.getChildNodes().item(z2).getNodeName();
            if (cName.hashCode() != nodeType) continue;
            return node.getChildNodes().item(z2);
        }
        return null;
    }

    private static double[] getCoordsXYWH(Node node) {
        return new XBox(node).getXYWH();
    }

    public HashMap<Integer, XFAPageContent> getPageMapXFA() {
        return this.pageMapXFA;
    }

    public void updatePageData(PdfPageData pageData) {
        for (int z2 = 0; z2 < this.pageMapXFA.size(); ++z2) {
            double[] coords = XFAFormStream.getPageCoordsXYWH(z2 + 1, this.pageMapXFA);
            pageData.setMediaBox(new float[]{0.0f, (float)coords[3], (float)coords[2], 0.0f});
            pageData.setCropBox(new float[]{0.0f, (float)coords[3], (float)coords[2], 0.0f});
            pageData.setPageRotation(0, 1);
            pageData.checkSizeSet(z2 + 1);
        }
    }

    private void parseConfig(Node config) {
        NodeList setOfNodes = config.getChildNodes();
        for (int i2 = 0; i2 < setOfNodes.getLength(); ++i2) {
            Node childNode = setOfNodes.item(i2);
            String name = childNode.getNodeName();
            if (childNode.hasChildNodes()) {
                this.parseConfig(setOfNodes.item(i2));
            }
            if (!"dynamicRender".equals(name)) continue;
            this.dynamicRender = childNode.getTextContent();
        }
    }

    private static void generateCarpet(Node root, HashMap<Integer, XFAPageContent> pageMapXFA) {
        Node pageSet = XFAFormStream.singleNodePicker(root, -803560621);
        if (pageSet != null) {
            ArrayList<Node> pageAreaList = new ArrayList<Node>();
            for (int z2 = 0; z2 < pageSet.getChildNodes().getLength(); ++z2) {
                Node pageSetChild = pageSet.getChildNodes().item(z2);
                if (pageSetChild.getNodeName().hashCode() != 858900412) continue;
                pageAreaList.add(pageSetChild);
            }
            TreeMap<Integer, Node> breakMap = new TreeMap<Integer, Node>();
            if (!pageAreaList.isEmpty()) {
                Node firstPageArea = (Node)pageAreaList.get(0);
                breakMap.put(0, firstPageArea);
                XFAFormStream.fillPageBreakPointsNew(root, pageAreaList, breakMap, new ArrayList<Integer>());
                XFAFormStream.fillPageMap(root, breakMap, pageMapXFA);
            }
        }
    }

    private static void fillPageMap(Node parse, TreeMap<Integer, Node> breakMap, HashMap<Integer, XFAPageContent> pageMapXFA) {
        XBox parseBox = new XBox(parse);
        if ((XFAFormStream.isWidget(parse) || XFAFormStream.isExclGroup(parse)) && !XBox.hiddenOrInactive(parse)) {
            XRect parseRect;
            if (XBox.isPageAreaFamily(parse)) {
                parseRect = XBox.getCustomGlobalPosition(parse);
                if (parseRect != null) {
                    XBox.addCustomCoords(parse, new double[]{parseRect.getX(), parseRect.getY(), 0.0, 0.0});
                }
            } else {
                parseRect = XBox.getCustomGlobalPosition(parse);
                XRect marginRect = XBox.getHierachyMarginRect(parse);
                if (parseRect != null) {
                    parseRect.moveFromX(marginRect.getX());
                    parseRect.moveFromY(marginRect.getY());
                    int count = 0;
                    Node pgAreaNode = breakMap.firstEntry().getValue();
                    int lastKey = 0;
                    Object[] keys = breakMap.keySet().toArray();
                    for (int z2 = 0; z2 < keys.length; ++z2) {
                        int nextKey;
                        ++count;
                        int key = (Integer)keys[z2];
                        lastKey = (Integer)keys[z2];
                        pgAreaNode = breakMap.get(key);
                        int n2 = nextKey = z2 < keys.length - 1 ? (Integer)keys[z2 + 1] : Integer.MAX_VALUE;
                        if (parseRect.getY() >= (double)key && parseRect.getY() < (double)nextKey) break;
                    }
                    XBox.addCustomCoords(parse, new double[]{parseRect.getX(), parseRect.getY() - (double)lastKey, parseBox.getW(), parseBox.getCalculatedHeight()});
                    if (parseBox.canDisplayWidget(parse)) {
                        XFAPageContent xpc;
                        if (pageMapXFA.containsKey(count)) {
                            xpc = pageMapXFA.get(count);
                        } else {
                            xpc = new XFAPageContent();
                            xpc.setPageAreaNode(pgAreaNode);
                        }
                        xpc.getNodeList().add(parse);
                        pageMapXFA.put(count, xpc);
                    }
                }
            }
        }
        NodeList setOfNodes = parse.getChildNodes();
        for (int i2 = 0; i2 < setOfNodes.getLength(); ++i2) {
            XFAFormStream.fillPageMap(setOfNodes.item(i2), breakMap, pageMapXFA);
        }
    }

    private static void fillPageBreakPointsNew(Node parse, ArrayList<Node> pageAreaList, TreeMap<Integer, Node> breakMap, ArrayList<Integer> subformCount) {
        if (XFAFormStream.isFormContainer(parse)) {
            subformCount.add(1);
            XSubForm xForm = new XSubForm(parse);
            if (subformCount.size() == 1 || subformCount.size() == 2) {
                Node firstPageArea;
                if ((xForm.hasBreak_BreakBefore || xForm.hasBreakBefore) && xForm.beforeTargetStr != null && (firstPageArea = XFAFormStream.getSpecificPageArea(xForm.beforeTargetStr, pageAreaList)) != null) {
                    breakMap.put(0, firstPageArea);
                    XPageArea.addOccurConsume(firstPageArea);
                }
            } else {
                Node tempArea;
                XRect formRect = XBox.getCustomGlobalPosition(parse);
                double formHeight = xForm.getCalculatedHeight();
                double hierTop = XBox.getHeirachyMarginTop(parse);
                Node lastAreaNode = breakMap.get(breakMap.lastEntry().getKey());
                if (xForm.hasBreakBefore && formRect != null) {
                    XPageArea lastPageArea = new XPageArea(lastAreaNode);
                    double contentEnd = lastPageArea.getContentEndPlace();
                    int lastContentEnd = (int)((double)breakMap.lastEntry().getKey().intValue() + contentEnd);
                    int formEndPoint = (int)(formRect.getY() + hierTop + formHeight);
                    boolean canDisplayNext = true;
                    if (xForm.keepNext == -389704538) {
                        for (Node iter = parse.getNextSibling(); iter != null; iter = iter.getNextSibling()) {
                            XBox iterBox = new XBox(iter);
                            if (iterBox.keepNext == -389704538 || !XFAFormStream.isFormContainer(iter) && !XFAFormStream.isWidget(iter)) continue;
                            int areaEnd = (int)((double)lastContentEnd - lastPageArea.getContentAreaRect().getY());
                            XRect iterRect = XBox.getCustomGlobalPosition(iter);
                            if (iterRect == null) continue;
                            double iterH = iterBox.getCalculatedHeight();
                            double iterTop = XBox.getHeirachyMarginTop(iter);
                            double iterBot = XBox.getHeirachyMarginBottom(iter);
                            double iterEnd = iterRect.getY() + iterH + iterTop + iterBot + 1.0;
                            canDisplayNext = iterEnd < (double)areaEnd;
                            break;
                        }
                    }
                    if (xForm.startNew != null || formEndPoint > lastContentEnd || xForm.keepNext == -389704538 && !canDisplayNext || "pageArea".equals(xForm.targetType)) {
                        XFAFormStream.fillStartNewBreak(xForm, lastPageArea, lastAreaNode, hierTop, formRect, pageAreaList, breakMap);
                    }
                } else if (xForm.hasBreak_BreakBefore && formRect != null) {
                    XFAFormStream.fillBreakBreakBefore(xForm, lastAreaNode, hierTop, formRect, pageAreaList, breakMap);
                }
                if (xForm.hasBreakAfter && formRect != null) {
                    tempArea = xForm.targetType != null ? XFAFormStream.getSpecificPageArea(xForm.afterTargetStr, pageAreaList, xForm.targetType.hashCode()) : XFAFormStream.getSpecificPageArea(xForm.afterTargetStr, pageAreaList);
                    if (tempArea == null) {
                        tempArea = breakMap.get(breakMap.lastEntry().getKey());
                    }
                    breakMap.put((int)(formRect.getY() + hierTop + formHeight), tempArea);
                } else if (xForm.hasBreak_BreakAfter && formRect != null) {
                    tempArea = XFAFormStream.getSpecificPageArea(xForm.afterTargetStr, pageAreaList);
                    if (tempArea == null) {
                        tempArea = breakMap.get(breakMap.lastEntry().getKey());
                    }
                    breakMap.put((int)(formRect.getY() + hierTop + formHeight), tempArea);
                }
            }
        }
        if (XFAFormStream.isExclGroup(parse) || XFAFormStream.isWidget(parse)) {
            XFAFormStream.fillPointsInExclOrWidget(parse, breakMap);
        }
        NodeList setOfNodes = parse.getChildNodes();
        for (int i2 = 0; i2 < setOfNodes.getLength(); ++i2) {
            XFAFormStream.fillPageBreakPointsNew(setOfNodes.item(i2), pageAreaList, breakMap, subformCount);
        }
    }

    private static void fillStartNewBreak(XSubForm xForm, XPageArea lastPageArea, Node lastAreaNode, double hierTop, XRect formRect, ArrayList<Node> pageAreaList, TreeMap<Integer, Node> breakMap) {
        Node tempArea = xForm.targetType != null ? XFAFormStream.getSpecificPageArea(xForm.beforeTargetStr, pageAreaList, xForm.targetType.hashCode()) : XFAFormStream.getSpecificPageArea(xForm.beforeTargetStr, pageAreaList);
        if (tempArea == null) {
            int maxOccur = lastPageArea.getMaxOccur();
            int consumeMax = XPageArea.getOccurConsume(lastAreaNode);
            if (xForm.startNew != null && xForm.beforeTargetStr == null && consumeMax < maxOccur) {
                tempArea = lastAreaNode;
            } else {
                int pos = 0;
                for (int z2 = 0; z2 < pageAreaList.size(); ++z2) {
                    if (!lastAreaNode.isSameNode(pageAreaList.get(z2))) continue;
                    pos = z2;
                    break;
                }
                tempArea = pageAreaList.size() > pos + 1 ? pageAreaList.get(pos + 1) : lastAreaNode;
            }
        }
        breakMap.put((int)(formRect.getY() + hierTop), tempArea);
        XPageArea.addOccurConsume(tempArea);
    }

    private static void fillBreakBreakBefore(XSubForm xForm, Node lastAreaNode, double hierTop, XRect formRect, ArrayList<Node> pageAreaList, TreeMap<Integer, Node> breakMap) {
        Node tempArea = XFAFormStream.getSpecificPageArea(xForm.beforeTargetStr, pageAreaList);
        if (tempArea == null) {
            int pos = 0;
            for (int z2 = 0; z2 < pageAreaList.size(); ++z2) {
                if (!lastAreaNode.isSameNode(pageAreaList.get(z2))) continue;
                pos = z2;
                break;
            }
            tempArea = pageAreaList.size() > pos + 1 ? pageAreaList.get(pos + 1) : lastAreaNode;
        }
        breakMap.put((int)(formRect.getY() + hierTop), tempArea);
    }

    private static void fillPointsInExclOrWidget(Node parse, TreeMap<Integer, Node> breakMap) {
        Node tempArea = breakMap.get(breakMap.lastEntry().getKey());
        XRect lastRect = new XPageArea(tempArea).getContentAreaRect();
        int key = breakMap.lastEntry().getKey();
        XBox parseBox = new XBox(parse);
        if (!XBox.isPageAreaFamily(parse) && !XBox.hiddenOrInactive(parse)) {
            XRect parseRect = XBox.getCustomGlobalPosition(parse);
            double hierTop = XBox.getHeirachyMarginTop(parse);
            if (parseRect != null) {
                parseRect.moveFromY(hierTop);
                double currentWidEnd = (int)(parseRect.getY() + parseBox.getCalculatedHeight());
                if (currentWidEnd > (double)key + lastRect.getH()) {
                    String data = XBox.getCustomData(parse);
                    if (parseBox.isContainMultiline() && data != null) {
                        double lineHeight = XFAFormStream.getJavaLineHeight(parseBox.getFormFontInfo(), data);
                        double availableWidth = parseBox.getW() - parseBox.getMarginLeft() - parseBox.getMarginRight();
                        HashMap<Integer, String> lineMap = XFAFormStream.getTotalLinesMap(availableWidth, data, parseBox.getFormFontInfo());
                        double overFlow = currentWidEnd - ((double)key + lastRect.getH());
                        int curDraw = (int)((parseBox.getCalculatedHeight() - overFlow) / lineHeight);
                        StringBuilder curData = new StringBuilder();
                        StringBuilder nextData = new StringBuilder();
                        for (int z2 = 1; z2 <= lineMap.size(); ++z2) {
                            String str = lineMap.get(z2);
                            if (z2 <= curDraw) {
                                curData.append(str).append('\n');
                                continue;
                            }
                            nextData.append(str).append('\n');
                        }
                        Node clone = parse.cloneNode(true);
                        XFAFormStream.insertAfterCurrent(clone, parse);
                        XBox.addCustomData(clone, nextData.toString());
                        XBox.addCustomGlobalHeight(clone, parseBox.getCalculatedHeight() - (double)curDraw * lineHeight);
                        XBox.addGivenCoords(clone, "y", 0.0);
                        XRect rect = XBox.getCustomGlobalPosition(parse);
                        if (rect != null) {
                            XBox.addCustomGlobalPosition(clone, rect.getX(), (double)key + lastRect.getH() + 1.0);
                            XBox.addCustomName(clone, XBox.getCustomName(parse) + "[stub]" + key + lastRect.getH());
                            XBox.addCustomGlobalHeight(parse, (double)curDraw * lineHeight);
                            XBox.addCustomData(parse, curData.toString());
                            breakMap.put((int)((double)key + lastRect.getH()), tempArea);
                        }
                    } else if (parseRect.getY() < (double)key + lastRect.getH()) {
                        breakMap.put((int)parseRect.getY(), tempArea);
                    } else {
                        breakMap.put((int)((double)key + lastRect.getH()), tempArea);
                    }
                }
            }
        }
    }

    private static void fillGlobalPosition(Node parse) {
        XRect relativeRect;
        if (XBox.getCustomGlobalPosition(parse) == null && !XBox.isPageAreaFamily(parse) && (XFAFormStream.isContainer(parse) || XFAFormStream.isWidget(parse))) {
            relativeRect = XFAFormStream.findRelativePosition(parse);
            if (relativeRect != null) {
                XBox.addCustomGlobalPosition(parse, relativeRect.getX(), relativeRect.getY());
            }
        } else if (XBox.isPageAreaFamily(parse) && (XFAFormStream.isContainer(parse) || XFAFormStream.isWidget(parse)) && (relativeRect = XFAFormStream.findPageAreaFamilyRelativePosition(parse)) != null) {
            XBox.addCustomGlobalPosition(parse, relativeRect.getX(), relativeRect.getY());
        }
        NodeList setOfNodes = parse.getChildNodes();
        for (int i2 = 0; i2 < setOfNodes.getLength(); ++i2) {
            XFAFormStream.fillGlobalPosition(setOfNodes.item(i2));
        }
    }

    private static XRect findPageAreaFamilyRelativePosition(Node node) {
        if (XBox.isPageSetBeforeParent(node)) {
            XBox box = new XBox(node);
            return new XRect(box.getX(), box.getY());
        }
        return XFAFormStream.findRelativePosition(node);
    }

    private static XRect findRelativePosition(Node node) {
        XRect boxRect;
        XRect formRect;
        Node parentForm = XBox.getVisibleParentForm(node);
        if (parentForm == null) {
            XBox box = new XBox(node);
            return new XRect(box.getX(), box.getY());
        }
        if (XBox.hiddenOrInactive(parentForm)) {
            return null;
        }
        XBox.XLayout layout = XBox.findLayout(parentForm);
        if (XFAFormStream.isExclGroup(node.getParentNode())) {
            Node exclNode = node.getParentNode();
            formRect = XBox.getCustomGlobalPosition(exclNode);
            if (formRect == null) {
                return null;
            }
            if (XBox.findLayout(exclNode) == XBox.XLayout.LEFTRIGHTTB) {
                NodeList pChild = exclNode.getChildNodes();
                for (int z2 = 0; z2 < pChild.getLength(); ++z2) {
                    Node current = pChild.item(z2);
                    if (!XFAFormStream.isWidget(current)) continue;
                    if (!node.isSameNode(current)) {
                        XBox temp = new XBox(current);
                        formRect.moveFromX(temp.getW());
                        continue;
                    }
                    break;
                }
            }
        } else if (node.getParentNode().getNodeName().hashCode() == 3002509) {
            formRect = XBox.getCustomGlobalPosition(node.getParentNode());
            layout = XBox.findLayout(node.getParentNode());
        } else {
            formRect = XBox.getCustomGlobalPosition(parentForm);
        }
        switch (layout) {
            case LEFTRIGHTTB: {
                boxRect = XFAFormStream.findLocationLeftToRight(node);
                break;
            }
            case RIGHTLEFTTB: {
                boxRect = XFAFormStream.findLocationRightToLeft(node);
                break;
            }
            case TB: {
                boxRect = XFAFormStream.findLocationTB(node);
                break;
            }
            case POSITION: {
                boxRect = XFAFormStream.findLocationPosition(node);
                break;
            }
            case TABLE: {
                boxRect = XFAFormStream.findLocationTable(node);
                break;
            }
            case ROW: {
                boxRect = XFAFormStream.findLocationRow(node);
                break;
            }
            default: {
                boxRect = new XRect();
            }
        }
        if (formRect != null && boxRect != null) {
            boxRect.moveFromX(formRect.getX());
            boxRect.moveFromY(formRect.getY());
        }
        return boxRect;
    }

    private static XRect findLocationTB(Node node) {
        Node parentFormNode = XBox.getVisibleParentForm(node);
        XRect rect = new XRect();
        if (parentFormNode != null) {
            for (int z2 = 0; z2 < parentFormNode.getChildNodes().getLength(); ++z2) {
                Node iter = parentFormNode.getChildNodes().item(z2);
                XBox iterBox = new XBox(iter);
                if (iter.isSameNode(node)) {
                    return rect;
                }
                if (XFAFormStream.isFormContainer(iter)) {
                    rect.moveFromY(XBox.getCustomGlobalHeight(iter));
                    continue;
                }
                rect.moveFromY(iterBox.getCalculatedHeight());
            }
        }
        return rect;
    }

    private static XRect findLocationLeftToRight(Node node) {
        Node parentFormNode = XBox.getVisibleParentForm(node);
        if (parentFormNode == null) {
            return null;
        }
        XBox xForm = new XBox(parentFormNode);
        if (parentFormNode.getFirstChild().getNodeName().hashCode() == -803560621 && XBox.getVisibleParentForm(parentFormNode) == null && !xForm.hasW) {
            return XFAFormStream.findLocationTB(node);
        }
        double allowW = xForm.getW() - xForm.getMarginLeft() - xForm.getMarginRight();
        XRect rect = new XRect();
        XRect prev = new XRect();
        for (int z2 = 0; z2 < parentFormNode.getChildNodes().getLength(); ++z2) {
            Node iter = parentFormNode.getChildNodes().item(z2);
            if (!XFAFormStream.isContainer(iter) && !XFAFormStream.isWidget(iter)) continue;
            XBox iterBox = new XBox(iter);
            double w2 = 0.0;
            double h2 = 0.0;
            int code = iter.getNodeName().hashCode();
            switch (code) {
                case -1867994364: 
                case 471239358: {
                    w2 = XFAFormStream.findFormWidth(iter);
                    h2 = XFAFormStream.findFormHeight(iter);
                    break;
                }
                case 1644111747: {
                    XBox exChild;
                    int i2;
                    if (iterBox.getW() == 0.0) {
                        for (i2 = 0; i2 < iter.getChildNodes().getLength(); ++i2) {
                            exChild = new XBox(iter.getChildNodes().item(i2));
                            w2 += exChild.getW();
                        }
                    } else {
                        w2 = iterBox.getW();
                    }
                    if (iterBox.getH() == 0.0) {
                        for (i2 = 0; i2 < iter.getChildNodes().getLength(); ++i2) {
                            exChild = new XBox(iter.getChildNodes().item(i2));
                            h2 = Math.max(h2, exChild.getCalculatedHeight());
                        }
                        break;
                    }
                    h2 = iterBox.getH();
                    break;
                }
                default: {
                    w2 = iterBox.isHidden || iterBox.isInactive ? 0.0 : iterBox.getW();
                    double d2 = h2 = iterBox.isHidden || iterBox.isInactive ? 0.0 : iterBox.getCalculatedHeight();
                }
            }
            if (iter.isSameNode(node)) {
                if ((double)((int)(prev.getX() + w2)) > allowW && allowW != 0.0) {
                    rect.moveFromY(prev.getY() + prev.getH());
                } else {
                    rect.moveFromX(prev.getX());
                    rect.moveFromY(prev.getY());
                }
                return rect;
            }
            if ((double)((int)(prev.getX() + w2)) > allowW && allowW != 0.0) {
                prev.moveFromY(prev.getH());
                prev.setH(h2);
                prev.setX(w2);
                continue;
            }
            prev.moveFromX(w2);
            prev.setH(Math.max(h2, prev.getH()));
        }
        return rect;
    }

    private static XRect findLocationRightToLeft(Node node) {
        Node parentFormNode = XBox.getVisibleParentForm(node);
        if (parentFormNode == null) {
            return null;
        }
        XBox xForm = new XBox(parentFormNode);
        double allowW = xForm.getW() - xForm.getMarginLeft() - xForm.getMarginRight();
        XRect rect = new XRect();
        XRect prev = new XRect();
        for (int z2 = 0; z2 < parentFormNode.getChildNodes().getLength(); ++z2) {
            Node iter = parentFormNode.getChildNodes().item(z2);
            if (!XFAFormStream.isContainer(iter) && !XFAFormStream.isWidget(iter)) continue;
            XBox iterBox = new XBox(iter);
            double w2 = 0.0;
            double h2 = 0.0;
            int code = iter.getNodeName().hashCode();
            switch (code) {
                case -1867994364: 
                case 471239358: {
                    w2 = XFAFormStream.findFormWidth(iter);
                    h2 = XFAFormStream.findFormHeight(iter);
                    break;
                }
                case 1644111747: {
                    XBox exChild;
                    int i2;
                    if (iterBox.getW() == 0.0) {
                        for (i2 = 0; i2 < iter.getChildNodes().getLength(); ++i2) {
                            exChild = new XBox(iter.getChildNodes().item(i2));
                            w2 += exChild.getW();
                        }
                    } else {
                        w2 = iterBox.getW();
                    }
                    if (iterBox.getH() == 0.0) {
                        for (i2 = 0; i2 < iter.getChildNodes().getLength(); ++i2) {
                            exChild = new XBox(iter.getChildNodes().item(i2));
                            h2 = Math.max(h2, exChild.getH());
                        }
                        break;
                    }
                    h2 = iterBox.getH();
                    break;
                }
                default: {
                    w2 = iterBox.getW();
                    h2 = iterBox.getCalculatedHeight();
                }
            }
            if (iter.isSameNode(node)) {
                if ((double)((int)(prev.getX() + w2)) > allowW && allowW != 0.0) {
                    rect.moveFromY(prev.getY() + prev.getH());
                } else {
                    XBox box = new XBox(node);
                    rect.moveFromX(prev.getX() + box.getX());
                    rect.moveFromY(prev.getY());
                }
                return rect;
            }
            if ((double)((int)(prev.getX() + w2)) > allowW && allowW != 0.0) {
                prev.moveFromY(prev.getH());
                prev.setH(h2);
                prev.setX(w2);
                continue;
            }
            prev.moveFromX(w2);
            prev.setH(Math.max(h2, prev.getH()));
        }
        return rect;
    }

    private static XRect findLocationTable(Node node) {
        XRect rect = new XRect();
        if (XFAFormStream.isFormContainer(node)) {
            Node parentNode = node.getParentNode();
            for (int z2 = 0; z2 < parentNode.getChildNodes().getLength(); ++z2) {
                Node child = parentNode.getChildNodes().item(z2);
                if (child.isSameNode(node)) {
                    return rect;
                }
                if (!XFAFormStream.isFormContainer(child)) continue;
                XBox childBox = new XBox(child);
                rect.moveFromY(XFAFormStream.findFormHeight(child) + childBox.getMarginTop());
            }
        }
        return rect;
    }

    private static XRect findLocationPosition(Node node) {
        double y2 = 0.0;
        double x2 = 0.0;
        if (node.hasAttributes()) {
            block4: for (int z2 = 0; z2 < node.getAttributes().getLength(); ++z2) {
                Node attr = node.getAttributes().item(z2);
                switch (attr.getNodeName().hashCode()) {
                    case 120: {
                        x2 = XFAUtils.convertToPoints(attr.getNodeValue());
                        continue block4;
                    }
                    case 121: {
                        y2 = XFAUtils.convertToPoints(attr.getNodeValue());
                    }
                }
            }
        }
        return new XRect(x2, y2);
    }

    private static XRect findLocationRow(Node node) {
        XRect rect = new XRect();
        if (!XFAFormStream.isContainer(node) && !XFAFormStream.isWidget(node)) {
            return rect;
        }
        Node parentFormNode = XBox.getVisibleParentForm(node);
        if (parentFormNode == null) {
            return null;
        }
        XBox parentForm = new XBox(parentFormNode);
        rect.moveFromY(parentForm.getMarginTop());
        double height = XFAFormStream.findFormHeight(parentFormNode);
        Element ele = (Element)node;
        ele.setAttribute("h", height + "pt");
        ele.setAttribute("minH", height + "pt");
        Node gParentNode = XBox.getVisibleParentForm(parentFormNode);
        if (gParentNode == null) {
            return rect;
        }
        Node nodeW = gParentNode.getAttributes().getNamedItem("columnWidths");
        if (nodeW != null) {
            String[] colWidthStr = nodeW.getNodeValue().split(" ");
            double[] colWidths = new double[colWidthStr.length];
            for (int z2 = 0; z2 < colWidthStr.length; ++z2) {
                colWidths[z2] = XFAUtils.convertToPoints(colWidthStr[z2]);
            }
            ArrayList<Node> widgetList = new ArrayList<Node>();
            for (int z3 = 0; z3 < parentFormNode.getChildNodes().getLength(); ++z3) {
                Node child = parentFormNode.getChildNodes().item(z3);
                if (!XFAFormStream.isWidget(child) && !XFAFormStream.isFormContainer(child)) continue;
                widgetList.add(child);
            }
            int spanCounter = 0;
            for (int z4 = 0; z4 < colWidths.length; ++z4) {
                int i2;
                if (widgetList.size() <= z4) continue;
                Node iter = (Node)widgetList.get(z4);
                int colSpan = 1;
                for (int c2 = 0; c2 < iter.getAttributes().getLength(); ++c2) {
                    if (iter.getAttributes().item(c2).getNodeName().hashCode() != 948710634) continue;
                    String colSpanStr = iter.getAttributes().item(c2).getNodeValue();
                    colSpan = Integer.parseInt(colSpanStr);
                }
                double totalWidth = 0.0;
                if (colSpan == -1) {
                    for (i2 = z4; i2 < colWidths.length; ++i2) {
                        totalWidth += colWidths[i2];
                    }
                } else if (colSpan == 1) {
                    totalWidth = colWidths[spanCounter];
                } else if (colSpan > 1) {
                    for (i2 = spanCounter; i2 < spanCounter + colSpan && i2 < colWidths.length; ++i2) {
                        totalWidth += colWidths[i2];
                    }
                    spanCounter += colSpan - 1;
                }
                if (iter.isSameNode(node)) {
                    Element element = (Element)iter;
                    element.setAttribute("w", totalWidth + "pt");
                    return rect;
                }
                rect.moveFromX(totalWidth);
                ++spanCounter;
            }
        }
        return rect;
    }

    private static void fillDynamicFormHeight(Node parse) {
        int nameHash = parse.getNodeName().hashCode();
        if (nameHash == -1867994364 || nameHash == 471239358 || nameHash == 3002509) {
            double cusHeight = XFAFormStream.findFormHeight(parse);
            XBox.addCustomGlobalHeight(parse, cusHeight);
        }
        NodeList setOfNodes = parse.getChildNodes();
        for (int i2 = 0; i2 < setOfNodes.getLength(); ++i2) {
            XFAFormStream.fillDynamicFormHeight(setOfNodes.item(i2));
        }
    }

    private static double findFormWidth(Node node) {
        double width = 0.0;
        if (XBox.hiddenOrInactive(node)) {
            return 0.0;
        }
        XBox xForm = new XBox(node);
        if (xForm.getW() > 0.0) {
            width = xForm.getW();
        } else {
            switch (XBox.findLayout(node)) {
                case LEFTRIGHTTB: 
                case RIGHTLEFTTB: {
                    width = xForm.getW();
                    break;
                }
                case TB: {
                    width = XFAFormStream.getWidth(node, width);
                    break;
                }
                case POSITION: {
                    width = xForm.getW();
                    if (width != 0.0) break;
                    width = XFAFormStream.getWidth(node, width);
                    width = width + xForm.getMarginRight() + xForm.getMarginLeft();
                    break;
                }
                case TABLE: {
                    width = XFAFormStream.getWidth(node, xForm);
                    break;
                }
                case ROW: {
                    width = XFAFormStream.getWidth(node.getParentNode(), xForm);
                }
            }
        }
        return width;
    }

    private static double getWidth(Node node, XBox xForm) {
        double width;
        Node nodeW = node.getAttributes().getNamedItem("columnWidths");
        if (nodeW != null) {
            String[] colWidths = nodeW.getNodeValue().split(" ");
            double totalWidth = 0.0;
            for (String str : colWidths) {
                totalWidth += XFAUtils.convertToPoints(str);
            }
            width = totalWidth;
        } else {
            width = xForm.getW();
        }
        return width;
    }

    private static double getWidth(Node node, double width) {
        for (int z2 = 0; z2 < node.getChildNodes().getLength(); ++z2) {
            Node cNode = node.getChildNodes().item(z2);
            XBox cBox = new XBox(cNode);
            double temp = XFAFormStream.isFormContainer(cNode) ? XFAFormStream.findFormWidth(cNode) : cBox.getW();
            width = Math.max(temp, width);
        }
        return width;
    }

    private static double findFormHeight(Node formNode) {
        double height = 0.0;
        XBox xBox = new XBox(formNode);
        if (!xBox.canDisplayWidget(formNode)) {
            return 0.0;
        }
        XBox.XLayout layout = XBox.findLayout(formNode);
        switch (layout) {
            case LEFTRIGHTTB: {
                height = XFAFormStream.findFormHeightLeftToRight(formNode);
                break;
            }
            case RIGHTLEFTTB: {
                height = XFAFormStream.findFormHeightRightToLeft(formNode);
                break;
            }
            case TB: {
                height = XFAFormStream.findFormHeightTB(formNode);
                break;
            }
            case POSITION: {
                height = XFAFormStream.findFormHeightPosition(formNode);
                break;
            }
            case TABLE: {
                height = XFAFormStream.findFormHeightTable(formNode);
                break;
            }
            case ROW: {
                height = XFAFormStream.findFormHeightRow(formNode);
            }
        }
        return height;
    }

    private static double findFormHeightTable(Node node) {
        XBox xBox = new XBox(node);
        if (xBox.hasH) {
            return xBox.getH();
        }
        double totalHeight = 0.0;
        for (int z2 = 0; z2 < node.getChildNodes().getLength(); ++z2) {
            Node child = node.getChildNodes().item(z2);
            if (!XFAFormStream.isFormContainer(child)) continue;
            XBox childBox = new XBox(child);
            totalHeight = totalHeight + XFAFormStream.findFormHeight(child) + childBox.getMarginBottom() + childBox.getMarginTop();
        }
        return totalHeight;
    }

    private static double findFormHeightRow(Node node) {
        XBox xBox = new XBox(node);
        if (xBox.hasH) {
            return xBox.getH();
        }
        double maxHeight = 0.0;
        for (int z2 = 0; z2 < node.getChildNodes().getLength(); ++z2) {
            double currentHeight;
            Node child = node.getChildNodes().item(z2);
            if (XFAFormStream.isFormContainer(child)) {
                currentHeight = XFAFormStream.findFormHeight(child);
            } else {
                XBox tempBox = new XBox(child);
                currentHeight = tempBox.getCalculatedHeight();
            }
            maxHeight = Math.max(currentHeight, maxHeight);
        }
        return maxHeight;
    }

    private static double findFormHeightTB(Node node) {
        XBox xBox = new XBox(node);
        if (xBox.hasH && !node.getNodeName().equals("subform")) {
            return xBox.getH();
        }
        double maxHeight = 0.0;
        for (int z2 = 0; z2 < node.getChildNodes().getLength(); ++z2) {
            XBox tempBox;
            Node child = node.getChildNodes().item(z2);
            if (XFAFormStream.isFormContainer(child) || "area".equals(child.getNodeName())) {
                XBox childForm = new XBox(child);
                if (!childForm.canDisplayWidget(child)) continue;
                maxHeight += XFAFormStream.findFormHeight(child);
                continue;
            }
            if (!XFAFormStream.isWidget(child) || !(tempBox = new XBox(child)).canDisplayWidget(child)) continue;
            double[] temp = tempBox.getXYWH();
            maxHeight = maxHeight + temp[1] + temp[3];
        }
        maxHeight = maxHeight + xBox.getMarginTop() + xBox.getMarginBottom();
        return maxHeight;
    }

    private static double findFormHeightLeftToRight(Node node) {
        XBox xBox = new XBox(node);
        if (xBox.hasH) {
            return xBox.getH();
        }
        double allowedW = xBox.getW() - xBox.getMarginLeft() - xBox.getMarginRight();
        if (!xBox.hasW) {
            allowedW = 0.0;
        }
        double maxHeight = 0.0;
        double prevLength = 0.0;
        double prevHeight = 0.0;
        for (int z2 = 0; z2 < node.getChildNodes().getLength(); ++z2) {
            Node child = node.getChildNodes().item(z2);
            if (!XFAFormStream.isContainer(child) && !XFAFormStream.isWidget(child)) continue;
            double tempH = 0.0;
            double tempW = 0.0;
            if (XFAFormStream.isFormContainer(child)) {
                XBox childForm = new XBox(child);
                if (childForm.canDisplayWidget(child)) {
                    tempH = XFAFormStream.findFormHeight(child);
                    tempW = XFAFormStream.findFormWidth(child);
                }
            } else {
                XBox childBox = new XBox(child);
                if (childBox.canDisplayWidget(child)) {
                    tempH = childBox.getCalculatedHeight();
                    tempW = childBox.getW();
                }
            }
            if (maxHeight == 0.0) {
                maxHeight = tempH;
                prevHeight = tempH;
                prevLength = tempW;
                continue;
            }
            if ((double)((int)(prevLength + tempW)) > allowedW && allowedW != 0.0) {
                maxHeight += tempH;
                prevLength = tempW;
                prevHeight = tempH;
                continue;
            }
            prevLength += tempW;
            if (!(tempH > prevHeight)) continue;
            maxHeight += tempH - prevHeight;
            prevHeight = tempH;
        }
        maxHeight = maxHeight + xBox.getMarginBottom() + xBox.getMarginTop();
        return maxHeight;
    }

    private static double findFormHeightRightToLeft(Node node) {
        return XFAFormStream.findFormHeightLeftToRight(node);
    }

    private static double findFormHeightPosition(Node node) {
        XBox xBox = new XBox(node);
        if (xBox.hasH) {
            return xBox.getH();
        }
        double maxHeight = 0.0;
        for (int z2 = 0; z2 < node.getChildNodes().getLength(); ++z2) {
            XBox tempBox;
            Node child = node.getChildNodes().item(z2);
            if (XFAFormStream.isFormContainer(child)) {
                tempBox = new XBox(child);
                double formHeight = XFAFormStream.findFormHeight(child);
                formHeight = tempBox.getY() + formHeight;
                maxHeight = Math.max(formHeight, maxHeight);
                continue;
            }
            tempBox = new XBox(child);
            double[] temp = tempBox.getXYWHwithMargin();
            maxHeight = Math.max(maxHeight, temp[1] + temp[3]);
        }
        maxHeight = maxHeight + xBox.getMarginTop() + xBox.getMarginBottom();
        return maxHeight;
    }

    public static void insertAfterCurrent(Node newNode, Node current) {
        if (current.getNextSibling() == null) {
            current.getParentNode().appendChild(newNode);
        } else {
            current.getParentNode().insertBefore(newNode, current.getNextSibling());
        }
    }

    private static double getJavaLineHeight(XFontInfo xFontInfo, String data) {
        Font font = new Font(xFontInfo.getTypeFace(), xFontInfo.getWeight(), xFontInfo.getSize());
        AffineTransform af2 = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(af2, false, false);
        LineMetrics fontMetrics = font.getLineMetrics(data, frc);
        return fontMetrics.getHeight();
    }

    private static double getJavaFontTotalWidth(XFontInfo fontInfo, String data) {
        Font tempFont = new Font(fontInfo.getTypeFace(), fontInfo.getWeight(), fontInfo.getSize());
        AffineTransform af2 = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(af2, false, false);
        return tempFont.getStringBounds(data, frc).getWidth();
    }

    private static HashMap<Integer, String> getTotalLinesMap(double maxWidth, String data, XFontInfo fontInfo) {
        HashMap<Integer, String> lineMap = new HashMap<Integer, String>();
        ArrayList<String> lineData = new ArrayList<String>();
        try (Scanner scan = new Scanner(data);){
            while (scan.hasNext()) {
                lineData.add(scan.nextLine());
            }
        }
        for (String str : lineData) {
            double dataW = XFAFormStream.getJavaFontTotalWidth(fontInfo, str);
            if (maxWidth > dataW || maxWidth < 1.0) {
                lineMap.put(lineMap.size() + 1, str);
                continue;
            }
            String sb = "";
            double lineLength = 0.0;
            for (int z2 = 0; z2 < str.length(); ++z2) {
                if (lineLength >= maxWidth) {
                    if ((sb = sb + str.charAt(z2)).endsWith(" ") || sb.endsWith(".") || z2 + 1 == str.length() || sb.indexOf(32) == -1) {
                        lineMap.put(lineMap.size() + 1, sb);
                        sb = "";
                        lineLength = 0.0;
                        continue;
                    }
                    String toMap = sb.substring(0, sb.lastIndexOf(32));
                    lineMap.put(lineMap.size() + 1, toMap);
                    sb = sb.substring(sb.lastIndexOf(32) + 1);
                    lineLength = XFAFormStream.getJavaFontTotalWidth(fontInfo, sb);
                    continue;
                }
                sb = sb + str.charAt(z2);
                lineLength += XFAFormStream.getJavaFontTotalWidth(fontInfo, String.valueOf(str.charAt(z2)).intern());
            }
            if (!(lineLength > 1.0)) continue;
            lineMap.put(lineMap.size() + 1, sb);
        }
        return lineMap;
    }

    public static PdfFont resolveFont(XFontInfo fontInfo, PdfStreamDecoder decoder, Map<String, PdfFont> fontCache, PdfFontFactory pdfFontFactory, ObjectStore objectStore) {
        String fontName = XFAFormStream.getEmbeddedFontNameXFA(fontInfo.getTypeFace(), fontInfo.getWeight(), fontInfo.getPosture(), decoder);
        PdfFont currentFont = null;
        if (decoder != null) {
            currentFont = FontResolver.resolveFont(null, decoder, fontName, pdfFontFactory, decoder.getObjectCache());
        }
        if (currentFont == null) {
            currentFont = fontCache.get(fontName);
        }
        if (currentFont == null) {
            currentFont = XFAFormStream.getFont(fontName, pdfFontFactory, objectStore);
            if (currentFont == null || !currentFont.isFontSubstituted()) {
                currentFont = XFAFormStream.getFont("Arial", pdfFontFactory, objectStore);
            }
            fontCache.put(fontName, currentFont);
        }
        return currentFont;
    }

    public static double getPdfFontTotalWidth(XFontInfo fontInfo, String data, PdfStreamDecoder decoder, Map<String, PdfFont> fontCache, PdfFontFactory pdfFontFactory, ObjectStore objectStore) {
        PdfFont pf = XFAFormStream.resolveFont(fontInfo, decoder, fontCache, pdfFontFactory, objectStore);
        double w2 = 0.0;
        for (int z2 = 0; z2 < data.length(); ++z2) {
            char c2 = data.charAt(z2);
            String glyfName = c2 > '\u00ff' ? String.valueOf(c2).intern() : StandardFonts.getUnicodeChar(2, c2);
            w2 += (double)(pf.getGlyphWidth(glyfName, c2) * (float)fontInfo.getSize());
        }
        return w2;
    }

    private static PdfFont getFont(String fontName, PdfFontFactory pdfFontFactory, ObjectStore objectStore) {
        PdfFont currentFont = null;
        FontObject newFont = new FontObject("1 0 R");
        newFont.setConstant(1147962727, 1228944677);
        try {
            currentFont = pdfFontFactory.createFont(newFont, fontName, objectStore, true, null, false);
            if (StandardFonts.isStandardFont(fontName, true)) {
                currentFont.putFontEncoding(2);
            }
        }
        catch (PdfException e2) {
            LogWriter.writeLog(e2);
        }
        return currentFont;
    }

    private static String getEmbeddedFontNameXFA(String fontTypeFace, int fontWeight, int posture, PdfStreamDecoder decoder) {
        if ("Myriad Pro".equals(fontTypeFace)) {
            if (fontWeight == 1) {
                if (posture == 2) {
                    return "MyriadPro-BoldIt";
                }
                return "MyriadPro-Bold";
            }
            if (posture == 2) {
                return "MyriadPro-It";
            }
            return "MyriadPro-Regular";
        }
        if ("Myriad Pro Black".equals(fontTypeFace)) {
            if (posture == 2) {
                return "MyriadPro-BlackIt";
            }
            return "MyriadPro-Black";
        }
        if ("Myriad Pro Light".equals(fontTypeFace)) {
            if (posture == 2) {
                return "MyriadPro-LightIt";
            }
            return "MyriadPro-Light";
        }
        if ("Myriad Pro SmBd".equals(fontTypeFace)) {
            if (posture == 2) {
                return "MyriadPro-SemiboldIt";
            }
            return "MyriadPro-Semibold";
        }
        if ("Minion Pro".equals(fontTypeFace)) {
            if (fontWeight == 1) {
                if (posture == 2) {
                    return "MinionPro-BoldIt";
                }
                return "MinionPro-Bold";
            }
            if (posture == 2) {
                return "MinionPro-It";
            }
            return "MinionPro-Regular";
        }
        if ("Minion Pro SmBd".equals(fontTypeFace)) {
            if (posture == 2) {
                return "MinionPro-SemiboldIt";
            }
            return "MinionPro-Semibold";
        }
        if (fontTypeFace.contains("Times New Roman")) {
            switch (fontWeight) {
                case 0: {
                    return "TimesNewRomanPSMT";
                }
                case 2: {
                    return "TimesNewRomanPS-ItalicMT";
                }
                case 1: {
                    return "TimesNewRomanPS-BoldMT";
                }
            }
        }
        String fontName = fontTypeFace.replace(" ", "");
        String style = XFAFormStream.getStyle(fontWeight);
        String fullName = fontName + '-' + style;
        fontName = decoder != null ? (decoder.getObjectCache().resolvedFonts.containsKey(fullName) || decoder.getObjectCache().unresolvedFonts.containsKey(fullName) ? fullName : XFAFormStream.getFontName(decoder, fontName, style)) : "Arial";
        return fontName;
    }

    private static String getStyle(int fontWeight) {
        String style = "";
        switch (fontWeight) {
            case 0: {
                style = "Regular";
                break;
            }
            case 1: {
                style = "Bold";
                break;
            }
            case 2: {
                style = "It";
                break;
            }
        }
        return style;
    }

    private static String getFontName(PdfStreamDecoder decoder, String fontName, String style) {
        for (Object object : decoder.getObjectCache().unresolvedFonts.keySet()) {
            String k2 = (String)object;
            if (!k2.startsWith((String)fontName) || !k2.contains(style)) continue;
            fontName = k2;
        }
        for (String string : decoder.getObjectCache().resolvedFonts.keySet()) {
            String k2 = string;
            if (!k2.startsWith((String)fontName) || !k2.contains(style)) continue;
            fontName = k2;
        }
        return fontName;
    }

    public static double getTempTotalWidth(XFontInfo fontInfo, String data, PdfStreamDecoder decoder, Map<String, PdfFont> fontCache, PdfFontFactory pdfFontFactory, ObjectStore objectStore) {
        double temp = 0.0;
        PdfFont currentFont = XFAFormStream.resolveFont(fontInfo, decoder, fontCache, pdfFontFactory, objectStore);
        char[] chars = data.toCharArray();
        for (int a10 = 0; a10 < chars.length; ++a10) {
            try {
                temp += (double)(currentFont.getWidth(data.charAt(a10)) * (float)fontInfo.getSize());
                continue;
            }
            catch (Exception e2) {
                LogWriter.writeLog("XFAFormStream : Font width calculation error " + e2);
            }
        }
        if (temp == 0.0) {
            Font tempFont = new Font(fontInfo.getTypeFace(), fontInfo.getWeight(), fontInfo.getSize());
            AffineTransform af2 = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(af2, false, false);
            temp = tempFont.getStringBounds(data, frc).getWidth();
        }
        return temp;
    }

    public static HashMap<Integer, String> getTotalLines(double maxWidth, String data, XFontInfo fontInfo, PdfStreamDecoder decoder, Map<String, PdfFont> fontCache, PdfFontFactory pdfFontFactory, ObjectStore objectStore) {
        String[] outputs;
        HashMap<Integer, String> lineMap = new HashMap<Integer, String>();
        double curW = 0.0;
        StringBuilder curLine = new StringBuilder();
        StringBuilder curWord = new StringBuilder();
        StringBuilder output = new StringBuilder();
        if (maxWidth < 1.0) {
            lineMap.put(lineMap.size() + 1, data);
            return lineMap;
        }
        byte[] dataBytes = data.getBytes();
        int ii = data.length();
        block4: for (int i2 = 0; i2 < ii; ++i2) {
            int cc = dataBytes[i2] & 0xFF;
            String cs = String.valueOf(data.charAt(i2)).intern();
            double cw = XFAFormStream.getTempTotalWidth(fontInfo, cs, decoder, fontCache, pdfFontFactory, objectStore);
            if (curW + cw > maxWidth + 0.5) {
                if (curWord.toString().equals(curLine.toString())) {
                    output.append((CharSequence)curWord);
                    output.append('\n');
                    curWord = new StringBuilder();
                    curLine = new StringBuilder();
                    curW = 0.0;
                } else {
                    output.append('\n');
                    curW = XFAFormStream.getTempTotalWidth(fontInfo, curWord.toString(), decoder, fontCache, pdfFontFactory, objectStore);
                    curLine = new StringBuilder(curWord.toString());
                }
            }
            curW += cw;
            switch (cc) {
                case 10: {
                    output.append((CharSequence)curWord);
                    output.append('\n');
                    curWord = new StringBuilder();
                    curLine = new StringBuilder();
                    curW = 0.0;
                    continue block4;
                }
                case 0: 
                case 9: 
                case 12: 
                case 13: 
                case 32: {
                    output.append((CharSequence)curWord);
                    output.append(' ');
                    curWord = new StringBuilder();
                    curLine.append(' ');
                    continue block4;
                }
                default: {
                    curWord.append(cs);
                    curLine.append(cs);
                }
            }
        }
        if (curWord.length() > 0) {
            output.append((CharSequence)curWord);
        }
        for (String out : outputs = output.toString().split("\n")) {
            lineMap.put(lineMap.size() + 1, out);
        }
        return lineMap;
    }
}

