/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.objects.XFAField;
import java.awt.Rectangle;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class XFAFormObject
extends FormObject {
    private XFAField.XFARawDataType xfaRawDataType = XFAField.XFARawDataType.TEXTEDIT;
    private int layout;
    private String script;
    private String scriptType;
    private int heightOfCaption;
    private int widthOfCaption;
    private int captionPosition;
    private int outline;
    private int choiceShown;
    private int borderStroke;
    private int activity = -1;
    private String typeface;
    private int numericValue;
    private boolean editable;
    private int marginBottomInset;
    private int marginTopInset;
    private int marginLeftInset;
    private int marginRightInset;
    private int submitDataFormat;
    private String submitURL;
    private int submitTextEncode;
    private int longMedium;
    private int shortMedium;
    private String stdPaperName;
    private float verticalAlign;

    protected XFAFormObject() {
        this.isXFAObject = true;
        this.F = 4;
    }

    @Override
    public PdfObject duplicate() {
        XFAFormObject newObject = (XFAFormObject)super.duplicate();
        newObject.activity = this.activity;
        newObject.borderStroke = this.borderStroke;
        newObject.captionPosition = this.captionPosition;
        newObject.choiceShown = this.choiceShown;
        newObject.heightOfCaption = this.heightOfCaption;
        newObject.layout = this.layout;
        newObject.longMedium = this.longMedium;
        newObject.numericValue = this.numericValue;
        newObject.marginBottomInset = this.marginBottomInset;
        newObject.marginTopInset = this.marginTopInset;
        newObject.marginLeftInset = this.marginLeftInset;
        newObject.marginRightInset = this.marginRightInset;
        newObject.outline = this.outline;
        newObject.shortMedium = this.shortMedium;
        newObject.submitDataFormat = this.submitDataFormat;
        newObject.submitTextEncode = this.submitTextEncode;
        newObject.widthOfCaption = this.widthOfCaption;
        newObject.script = this.script;
        newObject.scriptType = this.scriptType;
        newObject.stdPaperName = this.stdPaperName;
        newObject.submitURL = this.submitURL;
        newObject.typeface = this.typeface;
        newObject.editable = this.editable;
        newObject.verticalAlign = this.verticalAlign;
        return newObject;
    }

    public String toString() {
        String buf = "\n  layout=" + this.layout + "\n  scriptname=" + this.script + "\n  heightofcaption=" + this.heightOfCaption + "\n  widthofcaption=" + this.widthOfCaption + "\n  captionposition=" + this.captionPosition + "\n  outline=" + this.outline + "\n  choiceshown=" + this.choiceShown + "\n  borderstroke=" + this.borderStroke + "\n  activity=" + this.activity + "\n  typeface=" + this.typeface + "\n  numericvalue=" + this.numericValue + "\n  editable=" + this.editable + "\n  maginbottom=" + this.marginBottomInset + "\n  margintop=" + this.marginTopInset + "\n  marginleft=" + this.marginLeftInset + "\n  marginright=" + this.marginRightInset + "\n  submitdataformat=" + this.submitDataFormat + "\n  submiturl=" + this.submitURL + "\n  submittextencoding=" + this.submitTextEncode + "\n  longmedium=" + this.longMedium + "\n  shortmedium=" + this.shortMedium + "\n  stdpapername=" + this.stdPaperName + "\n  verticalalign=" + this.verticalAlign;
        return super.toString() + buf;
    }

    public int getBorderStroke() {
        return this.borderStroke;
    }

    protected void setBorderStroke(String attValue) {
        if (this.BS == null) {
            this.BS = new FormObject();
        }
        switch (attValue) {
            case "solid": {
                this.borderStroke = 5;
                break;
            }
            case "dashed": {
                this.borderStroke = 1;
                break;
            }
            case "dotted": {
                this.borderStroke = 2;
                break;
            }
            case "dashDot": {
                this.borderStroke = 3;
                break;
            }
            case "dashDotDot": {
                this.borderStroke = 4;
                break;
            }
            case "lowered": {
                this.borderStroke = 6;
                this.BS.setName(35, "I".getBytes());
                break;
            }
            case "raised": {
                this.borderStroke = 7;
                this.BS.setName(35, "B".getBytes());
                break;
            }
            case "etched": {
                this.borderStroke = 8;
                break;
            }
            case "embossed": {
                this.borderStroke = 9;
                this.BS.setName(35, "B".getBytes());
                break;
            }
            default: {
                LogWriter.writeLog("[forms] XFAFormObject.setBorderStroke not taking " + attValue);
            }
        }
    }

    protected void setXYWH(double[] coords) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.x = (int)coords[0];
        this.BBox.y = (int)coords[1];
        this.BBox.width = (int)coords[2];
        this.BBox.height = (int)coords[3];
    }

    public XFAField.XFARawDataType getXFARawDataType() {
        return this.xfaRawDataType;
    }

    protected void setXFARawDataType(XFAField.XFARawDataType type) {
        this.xfaRawDataType = type;
    }
}

