/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.VarianceFNs;
import com.idrsolutions.image.webp.enc.VarianceResults;

final class Variance {
    static final VarianceFNs.VF vpx_variance16x16 = (src_ptr, src_stride, ref_ptr, ref_stride, sse) -> Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 16, 16);
    static final VarianceFNs.VF vpx_variance16x8 = (src_ptr, src_stride, ref_ptr, ref_stride, sse) -> Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 16, 8);
    static final VarianceFNs.VF vpx_variance8x16 = (src_ptr, src_stride, ref_ptr, ref_stride, sse) -> Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 8, 16);
    static final VarianceFNs.VF vpx_variance8x8 = (src_ptr, src_stride, ref_ptr, ref_stride, sse) -> Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 8, 8);
    static final VarianceFNs.VF vpx_variance4x4 = (src_ptr, src_stride, ref_ptr, ref_stride, sse) -> Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 4, 4);
    static final VarianceFNs.VF vpx_mse16x16 = new VarianceFNs.VF(){

        @Override
        public void call(GetSetPointer src_ptr, int src_stride, GetSetPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 16, 16, skipVar);
        }
    };
    private static final VarCalc calcVar = (ret, w2, h2, sum) -> {
        ret.variance = (long)ret.sse - sum * sum / ((long)w2 * (long)h2);
    };
    private static final VarCalc skipVar = (ret, w2, h2, sum) -> {
        ret.variance = Long.MAX_VALUE;
    };

    private Variance() {
    }

    static int vpx_get4x4sse_cs(GetSetPointer src_ptr, int src_stride, GetSetPointer ref_ptr) {
        VarianceResults sse = new VarianceResults();
        Variance.variance(src_ptr, src_stride, ref_ptr, 16, sse, 4, 4, skipVar);
        return sse.sse;
    }

    static void variance(GetSetPointer src_ptr, int src_stride, GetSetPointer ref_ptr, int ref_stride, VarianceResults ret, int w2, int h2) {
        Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, ret, w2, h2, calcVar);
    }

    private static void variance(GetSetPointer src_ptr, int src_stride, GetSetPointer ref_ptr, int ref_stride, VarianceResults ret, int w2, int h2, VarCalc varcalc) {
        long sum = 0L;
        ret.sse = 0;
        for (int i2 = 0; i2 < h2; ++i2) {
            int baseSrc = i2 * src_stride;
            int baseRef = i2 * ref_stride;
            for (int j2 = 0; j2 < w2; ++j2) {
                int diff = src_ptr.getRel(baseSrc + j2) - ref_ptr.getRel(baseRef + j2);
                sum += (long)diff;
                ret.sse += diff * diff;
            }
        }
        varcalc.call(ret, w2, h2, sum);
    }

    static interface VarCalc {
        public void call(VarianceResults var1, int var2, int var3, long var4);
    }
}

