/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import com.idrsolutions.image.utility.WriterByteLittle;
import com.idrsolutions.image.webp.enc.AlgoFlags;
import com.idrsolutions.image.webp.enc.CXInterface;
import com.idrsolutions.image.webp.enc.CodecAlgPRiv;
import com.idrsolutions.image.webp.enc.CodecEncCfg;
import com.idrsolutions.image.webp.enc.CodecPkt;
import com.idrsolutions.image.webp.enc.ExtraCFG;
import com.idrsolutions.image.webp.enc.Picture;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Iterator;

public final class VP8Encoder {
    static final short INT_TO_BYTE_OFFSET = 128;
    final CodecEncCfg cfg = new CodecEncCfg();
    final ExtraCFG vp8Cfg = new ExtraCFG();
    CodecAlgPRiv ctx;
    int pts;

    public static void encodeWEBP(BufferedImage bImg, OutputStream out, int qp) throws IOException {
        VP8Encoder enc = new VP8Encoder((short)qp);
        Picture pic = VP8Encoder.getPictureFromBuffer(bImg);
        byte[] bufData = enc.encodeFrame(pic);
        int frameSize = bufData.length;
        int frameAdd = frameSize % 2 != 0 ? frameSize + 1 : frameSize;
        byte[] temp = new byte[frameAdd];
        System.arraycopy(bufData, 0, temp, 0, frameSize);
        int dataLen = 20 + frameAdd;
        byte[] data = new byte[dataLen];
        WriterByteLittle endian = new WriterByteLittle(data);
        endian.write("RIFF".getBytes());
        endian.putU32(data.length - 8);
        endian.write("WEBP".getBytes());
        endian.write("VP8 ".getBytes());
        endian.putU32(frameAdd);
        endian.write(temp);
        out.write(data);
    }

    private static Picture getPictureFromBuffer(BufferedImage img) {
        int b2;
        int g2;
        int r2;
        int p2;
        int x2;
        int y2;
        int w2 = img.getWidth();
        int h2 = img.getHeight();
        int dim = w2 * h2;
        int strideC = w2 / 2;
        int cw = (w2 + 1) / 2;
        int ch = (h2 + 1) / 2;
        byte[][] data = new byte[][]{new byte[dim], new byte[ch * cw], new byte[ch * cw]};
        PixGet pg = Access.getPixGet(img);
        for (y2 = 0; y2 < h2; ++y2) {
            for (x2 = 0; x2 < w2; ++x2) {
                p2 = pg.getRGB(x2, y2);
                r2 = p2 >> 16 & 0xFF;
                g2 = p2 >> 8 & 0xFF;
                b2 = p2 & 0xFF;
                data[0][y2 * w2 + x2] = (byte)((128 + 66 * r2 + 129 * g2 + 25 * b2 >> 8) - 112);
            }
        }
        for (y2 = 0; y2 < h2; y2 += 2) {
            for (x2 = 0; x2 < w2; x2 += 2) {
                p2 = pg.getRGB(x2, y2);
                r2 = p2 >> 16 & 0xFF;
                g2 = p2 >> 8 & 0xFF;
                b2 = p2 & 0xFF;
                p2 = y2 / 2 * strideC + x2 / 2;
                data[1][p2] = (byte)(128 - 38 * r2 - 74 * g2 + 112 * b2 >> 8);
                data[2][p2] = (byte)(128 + 112 * r2 - 94 * g2 - 18 * b2 >> 8);
            }
        }
        return Picture.createPicture(img.getWidth(), img.getHeight(), data);
    }

    private VP8Encoder(short qp) {
        if (qp >= 0) {
            this.cfg.setRc_max_quantizer(qp);
        }
    }

    private byte[] encodeFrame(Picture pic) {
        if (this.ctx == null) {
            this.cfg.setG_w(pic.getWidth());
            this.cfg.setG_h(pic.getHeight());
            this.ctx = new CodecAlgPRiv(this.cfg, this.vp8Cfg);
        }
        CXInterface.vp8e_encode(this.ctx, pic, this.pts++, EnumSet.noneOf(AlgoFlags.class));
        CodecPkt ret = CodecAlgPRiv.vpx_codec_get_cx_data(this.ctx.base, new Iterator[1]);
        CodecPkt.FramePacket fp = (CodecPkt.FramePacket)ret.packet;
        byte[] temp = new byte[fp.sz];
        for (int i2 = 0; i2 < fp.sz; ++i2) {
            temp[i2] = (byte)fp.buf.getRel(i2);
        }
        return temp;
    }
}

