/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.BitEncoder;
import com.idrsolutions.image.webp.enc.Entropy;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.Token;

final class TreeWriter {
    private TreeWriter() {
    }

    static int vp8_cost_zero(int p2) {
        return BitEncoder.vp8_prob_cost[p2];
    }

    static int vp8_cost_one(int p2) {
        return TreeWriter.vp8_cost_zero(TreeWriter.vp8_complement(p2));
    }

    static int vp8_cost_bit(int x2, int b2) {
        return TreeWriter.vp8_cost_zero(b2 != 0 ? TreeWriter.vp8_complement(x2) : x2);
    }

    static int vp8_cost_branch(int[] ct, int p2) {
        return (int)((long)ct[0] * (long)TreeWriter.vp8_cost_zero(p2) + (long)ct[1] * (long)TreeWriter.vp8_cost_one(p2) >> 8);
    }

    static void vp8_write_literal(BitEncoder bc2, int data, int bits) {
        bc2.vp8_encode_value(data, bits);
    }

    static void vp8_treed_write(BitEncoder w2, GetPointer t2, GetPointer p2, int v2, int n2) {
        int i2 = 0;
        do {
            int b2;
            w2.vp8_encode_bool((b2 = v2 >> --n2 & 1) == 1, p2.getRel(i2 >> 1));
            i2 = t2.getRel(i2 + b2);
        } while (n2 != 0);
    }

    static void vp8_write_token(BitEncoder w2, GetPointer t2, GetPointer p2, Token x2) {
        TreeWriter.vp8_treed_write(w2, t2, p2, x2.value, x2.len);
    }

    static int vp8_treed_cost(GetPointer t2, GetPointer p2, int v2, int n2) {
        int c2 = 0;
        int i2 = 0;
        do {
            int b2 = v2 >> --n2 & 1;
            c2 += TreeWriter.vp8_cost_bit(p2.getRel(i2 >> 1), b2);
            i2 = t2.getRel(i2 + b2);
        } while (n2 != 0);
        return c2;
    }

    static int vp8_treed_cost_short(short[] t2, short[] p2, int v2, int n2) {
        int c2 = 0;
        int i2 = 0;
        do {
            int b2 = v2 >> --n2 & 1;
            c2 += TreeWriter.vp8_cost_bit(p2[i2 >> 1], b2);
            i2 = t2[i2 + b2];
        } while (n2 != 0);
        return c2;
    }

    static void cost(int[] C2, GetPointer T2, GetPointer P2, int i2, int c2) {
        short p2 = P2.getRel(i2 >> 1);
        do {
            short j2 = T2.getRel(i2);
            int d2 = c2 + TreeWriter.vp8_cost_bit(p2, i2 & 1);
            if (j2 <= 0) {
                C2[-j2] = d2;
                continue;
            }
            TreeWriter.cost(C2, T2, P2, j2, d2);
        } while ((++i2 & 1) != 0);
    }

    static void vp8_cost_tokens(int[] c2, GetPointer p2, GetPointer t2) {
        TreeWriter.cost(c2, t2, p2, 0, 0);
    }

    static void vp8_cost_tokens2(int[] c2, GetPointer p2) {
        TreeWriter.cost(c2, Entropy.vp8_coef_tree, p2, 2, 0);
    }

    static int vp8_complement(int p2) {
        return 255 - p2;
    }
}

