/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.BlockD;
import com.idrsolutions.image.webp.enc.Compressor;
import com.idrsolutions.image.webp.enc.DCTValueConstants;
import com.idrsolutions.image.webp.enc.EntropyPlanes;
import com.idrsolutions.image.webp.enc.FullGenArrPointer;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.Macroblock;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.PlaneType;
import com.idrsolutions.image.webp.enc.TokenAlphabet;
import com.idrsolutions.image.webp.enc.TokenExtra;
import com.idrsolutions.image.webp.enc.TokenValue;
import com.idrsolutions.image.webp.enc.VP8Util;
import com.idrsolutions.image.webp.enc.WebpConst;

final class Tokenize {
    private Tokenize() {
    }

    private static TokenExtra configureToken(FullGenArrPointer<TokenExtra> tp, TokenAlphabet tok, Compressor cpi, PlaneType type, int band, int pt, boolean skip) {
        int typ = type.ordinal();
        TokenExtra t2 = tp.get();
        if (t2 == null) {
            t2 = new TokenExtra();
            tp.setAndInc(t2);
        } else {
            tp.inc();
        }
        t2.Token = tok;
        t2.context_tree = cpi.common.fc.coef_probs[typ][band][pt];
        t2.skip_eob_node = skip;
        int[] nArray = cpi.mb.coef_counts[typ][band][pt];
        int n2 = tok.ordinal();
        nArray[n2] = nArray[n2] + 1;
        return t2;
    }

    private static void configureAsEob(FullGenArrPointer<TokenExtra> tp, Compressor cpi, PlaneType type, int band, int pt) {
        Tokenize.configureToken(tp, TokenAlphabet.DCT_EOB_TOKEN, cpi, type, band, pt, false);
    }

    private static int configureAsGeneric(FullGenArrPointer<TokenExtra> tp, Compressor cpi, int v2, PlaneType type, int band, int pt, boolean skip) {
        TokenValue tv = DCTValueConstants.getTokenValue(v2);
        TokenAlphabet token = tv.token;
        TokenExtra t2 = Tokenize.configureToken(tp, token, cpi, type, band, pt, skip);
        t2.Extra = tv.extra;
        return token.previousTokenClass;
    }

    static void tokenize2nd_order_b(Macroblock x2, FullGenArrPointer<TokenExtra> tp, Compressor cpi) {
        MacroblockD xd = x2.e_mbd;
        Tokenize.singleBlockfinalizeTokenize(PlaneType.Y2, tp, cpi, 24, xd.above_context.get().panes, xd.left_context.panes);
    }

    static void tokenize1st_order_b(Macroblock x2, FullGenArrPointer<TokenExtra> tp, PlaneType type, Compressor cpi) {
        int block;
        MacroblockD xd = x2.e_mbd;
        FullGetSetPointer a10 = xd.above_context.get().panes;
        FullGetSetPointer l2 = xd.left_context.panes;
        for (block = 0; block < 16; ++block) {
            Tokenize.singleBlockfinalizeTokenize(type, tp, cpi, block, a10, l2);
        }
        for (block = 16; block < 24; ++block) {
            Tokenize.singleBlockfinalizeTokenize(PlaneType.UV, tp, cpi, block, a10, l2);
        }
    }

    private static void singleBlockfinalizeTokenize(PlaneType type, FullGenArrPointer<TokenExtra> tp, Compressor cpi, int block, FullGetSetPointer a10, FullGetSetPointer l2) {
        BlockD bd2 = cpi.mb.e_mbd.block.getRel(block);
        short eob = bd2.eob.get();
        FullGetSetPointer qcoeff_ptr = bd2.qcoeff;
        int aPos = BlockD.vp8_block2above[block];
        int lPos = BlockD.vp8_block2left[block];
        int pt = a10.getRel(aPos) + l2.getRel(lPos);
        int c2 = type.start_coeff;
        if (c2 >= eob) {
            Tokenize.configureAsEob(tp, cpi, type, c2, pt);
            a10.setRel(aPos, l2.setRel(lPos, (short)0));
            return;
        }
        short v2 = qcoeff_ptr.getRel(c2);
        pt = Tokenize.configureAsGeneric(tp, cpi, v2, type, c2, pt, false);
        ++c2;
        assert (eob <= 16);
        while (c2 < eob) {
            int rc = WebpConst.zigzag[c2];
            v2 = qcoeff_ptr.getRel(rc);
            pt = Tokenize.configureAsGeneric(tp, cpi, v2, type, VP8Util.SubblockKeys.vp8CoefBands[c2], pt, pt == 0);
            ++c2;
        }
        if (c2 < 16) {
            Tokenize.configureAsEob(tp, cpi, type, VP8Util.SubblockKeys.vp8CoefBands[c2], pt);
        }
        a10.setRel(aPos, l2.setRel(lPos, (short)1));
    }

    private static void stuffOrderHelper(FullGenArrPointer<TokenExtra> tp, FullGetSetPointer a10, FullGetSetPointer l2, Compressor cpi, PlaneType plane, int band) {
        int pt = a10.get() + l2.get();
        Tokenize.configureAsEob(tp, cpi, plane, band, pt);
        a10.set(l2.set((short)0));
    }

    static void stuff2nd_order_b(FullGenArrPointer<TokenExtra> tp, FullGetSetPointer a10, FullGetSetPointer l2, Compressor cpi) {
        Tokenize.stuffOrderHelper(tp, a10, l2, cpi, PlaneType.Y2, 0);
    }

    static void stuff1st_order_b(FullGenArrPointer<TokenExtra> tp, FullGetSetPointer a10, FullGetSetPointer l2, PlaneType type, Compressor cpi) {
        Tokenize.stuffOrderHelper(tp, a10, l2, cpi, type, type == PlaneType.Y_NO_DC ? 0 : 1);
    }

    static void stuff1st_order_buv(FullGenArrPointer<TokenExtra> tp, FullGetSetPointer a10, FullGetSetPointer l2, Compressor cpi) {
        Tokenize.stuffOrderHelper(tp, a10, l2, cpi, PlaneType.UV, 0);
    }

    static void vp8_stuff_mb(Compressor cpi, Macroblock x2, FullGenArrPointer<TokenExtra> t2) {
        int b2;
        MacroblockD xd = x2.e_mbd;
        EntropyPlanes A2 = xd.above_context.get();
        EntropyPlanes L2 = xd.left_context;
        PlaneType plane_type = PlaneType.Y_WITH_DC;
        if (xd.hasSecondOrder()) {
            Tokenize.stuff2nd_order_b(t2, A2.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[24]), L2.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[24]), cpi);
            plane_type = PlaneType.Y_NO_DC;
        }
        for (b2 = 0; b2 < 16; ++b2) {
            Tokenize.stuff1st_order_b(t2, A2.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b2]), L2.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b2]), plane_type, cpi);
        }
        for (b2 = 16; b2 < 24; ++b2) {
            Tokenize.stuff1st_order_buv(t2, A2.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b2]), L2.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b2]), cpi);
        }
    }

    static boolean mb_is_skippable(MacroblockD x2, boolean has_y2_block) {
        boolean skip = true;
        int i2 = 0;
        int imax = 24;
        if (has_y2_block) {
            ++imax;
            for (i2 = 0; i2 < 16 && skip; skip &= x2.eobs.getRel(i2) < 2, ++i2) {
            }
        }
        while (i2 < imax && skip) {
            skip &= x2.eobs.getRel(i2) == 0;
            ++i2;
        }
        return skip;
    }

    static void vp8_fix_contexts(MacroblockD x2) {
        if (x2.hasSecondOrder()) {
            x2.above_context.get().panes.memset(0, (short)0, x2.above_context.get().panes.size());
            x2.left_context.panes.memset(0, (short)0, x2.left_context.panes.size());
        } else {
            x2.above_context.get().panes.memset(0, (short)0, x2.above_context.get().panes.size() - 1);
            x2.left_context.panes.memset(0, (short)0, x2.left_context.panes.size() - 1);
        }
    }

    static void vp8_tokenize_mb(Compressor cpi, Macroblock x2, FullGenArrPointer<TokenExtra> t2) {
        boolean hasSkip;
        MacroblockD xd = x2.e_mbd;
        boolean has_y2_block = xd.hasSecondOrder();
        xd.mode_info_context.get().mbmi.mb_skip_coeff = hasSkip = Tokenize.mb_is_skippable(xd, has_y2_block);
        if (hasSkip) {
            if (!cpi.common.mb_no_coeff_skip) {
                Tokenize.vp8_stuff_mb(cpi, x2, t2);
            } else {
                Tokenize.vp8_fix_contexts(xd);
                ++x2.skip_true_count;
            }
            return;
        }
        PlaneType plane_type = PlaneType.Y_WITH_DC;
        if (has_y2_block) {
            Tokenize.tokenize2nd_order_b(x2, t2, cpi);
            plane_type = PlaneType.Y_NO_DC;
        }
        Tokenize.tokenize1st_order_b(x2, t2, plane_type, cpi);
    }
}

