/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.Block;
import com.idrsolutions.image.webp.enc.BlockD;
import com.idrsolutions.image.webp.enc.BlockEnum;
import com.idrsolutions.image.webp.enc.CUtils;
import com.idrsolutions.image.webp.enc.Compressor;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.LookaheadEntry;
import com.idrsolutions.image.webp.enc.MV;
import com.idrsolutions.image.webp.enc.Macroblock;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.VarianceResults;
import com.idrsolutions.image.webp.enc.YV12buffer;

final class TemporalFilter {
    private static final int THRESH_LOW = 10000;
    private static final int THRESH_HIGH = 20000;

    private TemporalFilter() {
    }

    static void vp8_temporal_filter_predictors_mb(MacroblockD x2, FullGetSetPointer y_mb_ptr, FullGetSetPointer u_mb_ptr, FullGetSetPointer v_mb_ptr, int stride, int mv_row, int mv_col, FullGetSetPointer pred) {
        FullGetSetPointer yptr = y_mb_ptr.shallowCopyWithPosInc((mv_row >> 3) * stride + (mv_col >> 3));
        if (((mv_row | mv_col) & 7) != 0) {
            x2.subpixel_predict16x16.call(yptr, stride, mv_col & 7, mv_row & 7, pred, 16);
        } else {
            CUtils.vp8_copy_mem16x16(yptr, stride, pred, 16);
        }
        stride = stride + 1 >> 1;
        int offset = ((mv_row >>= 1) >> 3) * stride + ((mv_col >>= 1) >> 3);
        FullGetSetPointer uptr = u_mb_ptr.shallowCopyWithPosInc(offset);
        FullGetSetPointer vptr = v_mb_ptr.shallowCopyWithPosInc(offset);
        if (((mv_row | mv_col) & 7) != 0) {
            x2.subpixel_predict8x8.call(uptr, stride, mv_col & 7, mv_row & 7, pred.shallowCopyWithPosInc(256), 8);
            x2.subpixel_predict8x8.call(vptr, stride, mv_col & 7, mv_row & 7, pred.shallowCopyWithPosInc(320), 8);
        } else {
            CUtils.vp8_copy_mem8x8(uptr, stride, pred.shallowCopyWithPosInc(256));
            CUtils.vp8_copy_mem8x8(vptr, stride, pred.shallowCopyWithPosInc(320));
        }
    }

    static void vp8_temporal_filter_apply(FullGetSetPointer frame1, int stride, FullGetSetPointer frame2, int block_size, int strength, int filter_weight, FullGetSetPointer accumulator, FullGetSetPointer count) {
        int byt = 0;
        frame2 = frame2.shallowCopy();
        int rounding = strength > 0 ? 1 << strength - 1 : 0;
        int k2 = 0;
        for (int i2 = 0; i2 < block_size; ++i2) {
            int j2 = 0;
            while (j2 < block_size) {
                short src_byte = frame1.getRel(byt);
                short pixel_value = frame2.getAndInc();
                int modifier = src_byte - pixel_value;
                modifier *= modifier;
                modifier *= 3;
                modifier += rounding;
                if ((modifier >>= strength) > 16) {
                    modifier = 16;
                }
                modifier = 16 - modifier;
                count.setRel(k2, (short)(count.getRel(k2) + (modifier *= filter_weight)));
                accumulator.setRel(k2, (short)(accumulator.getRel(k2) + modifier * pixel_value));
                ++byt;
                ++j2;
                ++k2;
            }
            byt += stride - block_size;
        }
    }

    static long vp8_temporal_filter_find_matching_mb(Compressor cpi, YV12buffer arf_frame, YV12buffer frame_ptr, int mb_offset) {
        Macroblock x2 = cpi.mb;
        Block b2 = x2.block.get();
        BlockD d2 = x2.e_mbd.block.get();
        MV best_ref_mv1 = new MV();
        FullGetSetPointer base_src = b2.base_src;
        int src = b2.src;
        int src_stride = b2.src_stride;
        FullGetSetPointer base_pre = x2.e_mbd.pre.y_buffer.shallowCopy();
        int pre = d2.getOffset();
        int pre_stride = x2.e_mbd.pre.y_stride;
        b2.base_src = arf_frame.y_buffer.shallowCopy();
        b2.src_stride = arf_frame.y_stride;
        b2.src = mb_offset;
        x2.e_mbd.pre.y_buffer = frame_ptr.y_buffer.shallowCopy();
        x2.e_mbd.pre.y_stride = frame_ptr.y_stride;
        d2.setOffset(mb_offset);
        VarianceResults res = new VarianceResults();
        long bestsme = cpi.find_fractional_mv_step.call(x2, b2, d2, d2.bmi.mv, best_ref_mv1, x2.errorperbit, cpi.fn_ptr.get((Object)BlockEnum.BLOCK_16X16), null, res);
        b2.base_src = base_src;
        b2.src = src;
        b2.src_stride = src_stride;
        x2.e_mbd.pre.y_buffer = base_pre;
        d2.setOffset(pre);
        x2.e_mbd.pre.y_stride = pre_stride;
        return bestsme;
    }

    static void vp8_temporal_filter_iterate(Compressor cpi, int frame_count, int alt_ref_index, int strength) {
        int mb_cols = cpi.common.mb_cols;
        int mb_rows = cpi.common.mb_rows;
        int mb_y_offset = 0;
        int mb_uv_offset = 0;
        FullGetSetPointer accumulator = new FullGetSetPointer(384);
        FullGetSetPointer count = new FullGetSetPointer(384);
        MacroblockD mbd = cpi.mb.e_mbd;
        YV12buffer f2 = cpi.frames[alt_ref_index];
        FullGetSetPointer predictor = new FullGetSetPointer(384);
        FullGetSetPointer y_buffer = mbd.pre.y_buffer.shallowCopy();
        FullGetSetPointer u_buffer = mbd.pre.u_buffer.shallowCopy();
        FullGetSetPointer v_buffer = mbd.pre.v_buffer.shallowCopy();
        for (int mb_row = 0; mb_row < mb_rows; ++mb_row) {
            cpi.mb.mv_row_min = (short)(-(mb_row * 16 + 11));
            cpi.mb.mv_row_max = (short)((cpi.common.mb_rows - 1 - mb_row) * 16 + 11);
            for (int mb_col = 0; mb_col < mb_cols; ++mb_col) {
                int j2;
                int i2;
                CUtils.vp8_zero(accumulator);
                CUtils.vp8_zero(count);
                cpi.mb.mv_col_min = (short)(-(mb_col * 16 + 11));
                cpi.mb.mv_col_max = (short)((cpi.common.mb_cols - 1 - mb_col) * 16 + 11);
                for (int frame = 0; frame < frame_count; ++frame) {
                    int filter_weight;
                    if (cpi.frames[frame] == null) continue;
                    mbd.block.get().bmi.mv.setZero();
                    if (frame == alt_ref_index) {
                        filter_weight = 2;
                    } else {
                        long err = TemporalFilter.vp8_temporal_filter_find_matching_mb(cpi, cpi.frames[alt_ref_index], cpi.frames[frame], mb_y_offset);
                        int n2 = err < 10000L ? 2 : (filter_weight = err < 20000L ? 1 : 0);
                    }
                    if (filter_weight == 0) continue;
                    TemporalFilter.vp8_temporal_filter_predictors_mb(mbd, cpi.frames[frame].y_buffer.shallowCopyWithPosInc(mb_y_offset), cpi.frames[frame].u_buffer.shallowCopyWithPosInc(mb_uv_offset), cpi.frames[frame].v_buffer.shallowCopyWithPosInc(mb_uv_offset), cpi.frames[frame].y_stride, mbd.block.get().bmi.mv.row, mbd.block.get().bmi.mv.col, predictor);
                    TemporalFilter.vp8_temporal_filter_apply(f2.y_buffer.shallowCopyWithPosInc(mb_y_offset), f2.y_stride, predictor, 16, strength, filter_weight, accumulator, count);
                    TemporalFilter.vp8_temporal_filter_apply(f2.u_buffer.shallowCopyWithPosInc(mb_uv_offset), f2.uv_stride, predictor.shallowCopyWithPosInc(256), 8, strength, filter_weight, accumulator.shallowCopyWithPosInc(256), count.shallowCopyWithPosInc(256));
                    TemporalFilter.vp8_temporal_filter_apply(f2.v_buffer.shallowCopyWithPosInc(mb_uv_offset), f2.uv_stride, predictor.shallowCopyWithPosInc(320), 8, strength, filter_weight, accumulator.shallowCopyWithPosInc(320), count.shallowCopyWithPosInc(320));
                }
                FullGetSetPointer dst1 = cpi.alt_ref_buffer.y_buffer;
                int stride = cpi.alt_ref_buffer.y_stride;
                int byt = mb_y_offset;
                int k2 = 0;
                for (i2 = 0; i2 < 16; ++i2) {
                    j2 = 0;
                    while (j2 < 16) {
                        int pval = accumulator.getRel(k2) + (count.getRel(k2) >> 1);
                        pval *= cpi.fixed_divide[count.getRel(k2)];
                        dst1.setRel(byt, (short)(pval >>= 19));
                        ++byt;
                        ++j2;
                        ++k2;
                    }
                    byt += stride - 16;
                }
                dst1 = cpi.alt_ref_buffer.u_buffer;
                FullGetSetPointer dst2 = cpi.alt_ref_buffer.v_buffer;
                stride = cpi.alt_ref_buffer.uv_stride;
                byt = mb_uv_offset;
                k2 = 256;
                for (i2 = 0; i2 < 8; ++i2) {
                    j2 = 0;
                    while (j2 < 8) {
                        int m2 = k2 + 64;
                        int pval = accumulator.getRel(k2) + (count.getRel(k2) >> 1);
                        pval *= cpi.fixed_divide[count.getRel(k2)];
                        dst1.setRel(byt, (short)(pval >>= 19));
                        pval = accumulator.getRel(m2) + (count.getRel(m2) >> 1);
                        pval *= cpi.fixed_divide[count.getRel(m2)];
                        dst2.setRel(byt, (short)(pval >>= 19));
                        ++byt;
                        ++j2;
                        ++k2;
                    }
                    byt += stride - 8;
                }
                mb_y_offset += 16;
                mb_uv_offset += 8;
            }
            mb_y_offset += 16 * (f2.y_stride - mb_cols);
            mb_uv_offset += 8 * (f2.uv_stride - mb_cols);
        }
        mbd.pre.y_buffer = y_buffer;
        mbd.pre.u_buffer = u_buffer;
        mbd.pre.v_buffer = v_buffer;
    }

    static void vp8_temporal_filter_prepare(Compressor cpi, int distance) {
        int frames_to_blur;
        int frames_to_blur_backward = 0;
        int frames_to_blur_forward = 0;
        int strength = cpi.oxcf.arnr_strength;
        int blur_type = cpi.oxcf.arnr_type;
        boolean max_frames = false;
        int num_frames_forward = cpi.lookahead.vp8_lookahead_depth() - (distance + 1);
        switch (blur_type) {
            case 1: {
                frames_to_blur_backward = distance;
                if (frames_to_blur_backward >= 0) {
                    frames_to_blur_backward = -1;
                }
                frames_to_blur = frames_to_blur_backward + 1;
                break;
            }
            case 2: {
                frames_to_blur_forward = num_frames_forward;
                if (frames_to_blur_forward >= 0) {
                    frames_to_blur_forward = -1;
                }
                frames_to_blur = frames_to_blur_forward + 1;
                break;
            }
            default: {
                frames_to_blur_forward = num_frames_forward;
                frames_to_blur_backward = distance;
                if (frames_to_blur_forward > frames_to_blur_backward) {
                    frames_to_blur_forward = frames_to_blur_backward;
                }
                if (frames_to_blur_backward > frames_to_blur_forward) {
                    frames_to_blur_backward = frames_to_blur_forward;
                }
                if (frames_to_blur_forward > 0) {
                    frames_to_blur_forward = 0;
                }
                if (frames_to_blur_backward > 0) {
                    frames_to_blur_backward = 0;
                }
                frames_to_blur = frames_to_blur_backward + frames_to_blur_forward + 1;
            }
        }
        int start_frame = distance + frames_to_blur_forward;
        for (int frame = 0; frame < frames_to_blur; ++frame) {
            int which_buffer = start_frame - frame;
            LookaheadEntry buf = cpi.lookahead.vp8_lookahead_peek(which_buffer, 1);
            cpi.frames[frames_to_blur - 1 - frame] = buf.img;
        }
        TemporalFilter.vp8_temporal_filter_iterate(cpi, frames_to_blur, frames_to_blur_backward, strength);
    }
}

