/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.BilinearPredict;
import com.idrsolutions.image.webp.enc.CUtils;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.Variance;
import com.idrsolutions.image.webp.enc.VarianceFNs;
import com.idrsolutions.image.webp.enc.VarianceResults;

class SubpixelVariance
implements VarianceFNs.SVF {
    static final int FILTER_BITS = 7;
    private final int w;
    private final int h;
    private final FullGetSetPointer biliX;
    private final FullGetSetPointer biliY;

    static void var_filter_block2d_bil(GetSetPointer src_ptr, FullGetSetPointer ref_ptr, int src_pixels_per_line, int pixel_step, int output_height, int output_width, int[] filter) {
        int baseSrc = 0;
        int baseRef = 0;
        for (int i2 = 0; i2 < output_height; ++i2) {
            int basePS = baseSrc + pixel_step;
            for (int j2 = 0; j2 < output_width; ++j2) {
                ref_ptr.setRel(baseRef + j2, (short)CUtils.roundPowerOfTwo(src_ptr.getRel(baseSrc + j2) * filter[0] + src_ptr.getRel(basePS + j2) * filter[1], 7));
            }
            baseSrc += src_pixels_per_line;
            baseRef += output_width;
        }
    }

    public SubpixelVariance(int w2, int h2) {
        this.w = w2;
        this.h = h2;
        this.biliX = new FullGetSetPointer((h2 + 1) * w2);
        this.biliY = new FullGetSetPointer(h2 * w2);
    }

    @Override
    public void call(GetSetPointer src_ptr, int src_stride, int xoff, int yoff, GetSetPointer ref_ptr, int ref_stride, VarianceResults sse) {
        SubpixelVariance.var_filter_block2d_bil(src_ptr, this.biliX, src_stride, 1, this.h + 1, this.w, BilinearPredict.vp8_bilinear_filters[xoff]);
        SubpixelVariance.var_filter_block2d_bil(this.biliX, this.biliY, this.w, this.w, this.h, this.w, BilinearPredict.vp8_bilinear_filters[yoff]);
        Variance.variance(this.biliY, this.w, ref_ptr, ref_stride, sse, this.w, this.h);
    }
}

