/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.BPredictionMode;
import com.idrsolutions.image.webp.enc.Block;
import com.idrsolutions.image.webp.enc.BlockD;
import com.idrsolutions.image.webp.enc.Compressor;
import com.idrsolutions.image.webp.enc.DCTValueConstants;
import com.idrsolutions.image.webp.enc.EncodeMB;
import com.idrsolutions.image.webp.enc.Entropy;
import com.idrsolutions.image.webp.enc.EntropyPlanes;
import com.idrsolutions.image.webp.enc.FindNearMV;
import com.idrsolutions.image.webp.enc.FrameContext;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.IDCTllm;
import com.idrsolutions.image.webp.enc.MBPredictionMode;
import com.idrsolutions.image.webp.enc.MVReferenceFrame;
import com.idrsolutions.image.webp.enc.Macroblock;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.ModeInfo;
import com.idrsolutions.image.webp.enc.OnyxIf;
import com.idrsolutions.image.webp.enc.PlaneType;
import com.idrsolutions.image.webp.enc.QualityMetrics;
import com.idrsolutions.image.webp.enc.Quantize;
import com.idrsolutions.image.webp.enc.ReconIntra;
import com.idrsolutions.image.webp.enc.TokenAlphabet;
import com.idrsolutions.image.webp.enc.TreeWriter;
import com.idrsolutions.image.webp.enc.VP8Util;
import com.idrsolutions.image.webp.enc.WebpConst;
import java.util.HashMap;
import java.util.Iterator;

final class RDOpt {
    static final int[] auto_speed_thresh = new int[]{1000, 200, 150, 130, 150, 125, 120, 115, 115, 115, 115, 115, 115, 115, 115, 115, 105};

    private RDOpt() {
    }

    static long RDCOST(int RM, int DM, int R2, long D2) {
        return (128L + (long)R2 * (long)RM >> 8) + (long)DM * D2;
    }

    static int rd_cost_mbuv(Macroblock mb) {
        int cost = 0;
        MacroblockD x2 = mb.e_mbd;
        EntropyPlanes t_above = new EntropyPlanes(x2.above_context.get());
        EntropyPlanes t_left = new EntropyPlanes(x2.left_context);
        for (int b2 = 16; b2 < 24; ++b2) {
            cost += RDOpt.cost_coeffs(mb, x2.block.getRel(b2), PlaneType.UV, t_above.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b2]), t_left.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b2]));
        }
        return cost;
    }

    static int vp8_rdcost_mby(Macroblock mb) {
        int cost = 0;
        MacroblockD x2 = mb.e_mbd;
        EntropyPlanes t_above = new EntropyPlanes(mb.e_mbd.above_context.get());
        EntropyPlanes t_left = new EntropyPlanes(mb.e_mbd.left_context);
        for (int b2 = 0; b2 < 16; ++b2) {
            cost += RDOpt.cost_coeffs(mb, x2.block.getRel(b2), PlaneType.Y_NO_DC, t_above.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[b2]), t_left.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[b2]));
        }
        return cost += RDOpt.cost_coeffs(mb, x2.block.getRel(24), PlaneType.Y2, t_above.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[24]), t_left.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[24]));
    }

    static int cost_coeffs(Macroblock mb, BlockD b2, PlaneType type, FullGetSetPointer a10, FullGetSetPointer l2) {
        int c2;
        int corig = c2 = type.start_coeff;
        short eob = b2.eob.get();
        int cost = 0;
        FullGetSetPointer qcoeff_ptr = b2.qcoeff;
        short pt = (short)(a10.get() + l2.get());
        assert (eob <= 16);
        while (c2 < eob) {
            short v2 = ((GetPointer)qcoeff_ptr).getRel(WebpConst.zigzag[c2]);
            TokenAlphabet t2 = DCTValueConstants.getTokenValue((int)v2).token;
            cost += mb.token_costs[type.ordinal()][VP8Util.SubblockKeys.vp8CoefBands[c2]][pt][t2.ordinal()];
            cost += DCTValueConstants.getValueCost(v2);
            pt = t2.previousTokenClass;
            ++c2;
        }
        if (c2 < 16) {
            cost += mb.token_costs[type.ordinal()][VP8Util.SubblockKeys.vp8CoefBands[c2]][pt][TokenAlphabet.DCT_EOB_TOKEN.ordinal()];
        }
        pt = (short)(c2 != corig ? 1 : 0);
        a10.set(l2.set(pt));
        return cost;
    }

    static int vp8_block_error(GetPointer coeff, GetPointer dqcoeff) {
        int error = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            int this_diff = coeff.getRel(i2) - dqcoeff.getRel(i2);
            error += this_diff * this_diff;
        }
        return error;
    }

    static int vp8_mbuverror(Macroblock mb) {
        int error = 0;
        for (int i2 = 16; i2 < 24; ++i2) {
            Block be2 = mb.block.getRel(i2);
            BlockD bd2 = mb.e_mbd.block.getRel(i2);
            error += RDOpt.vp8_block_error(be2.coeff, bd2.dqcoeff);
        }
        return error;
    }

    static void rd_pick_intra_mbuv_mode(Macroblock x2, QualityMetrics rd) {
        MBPredictionMode mode_selected = null;
        rd.error = Long.MAX_VALUE;
        MacroblockD xd = x2.e_mbd;
        FullGetSetPointer vpred_ptr = xd.getFreshVPredPtr();
        FullGetSetPointer upred_ptr = xd.getFreshUPredPtr();
        FullGetSetPointer uabove = xd.dst.u_buffer.shallowCopyWithPosInc(-xd.dst.uv_stride);
        FullGetSetPointer vabove = xd.dst.v_buffer.shallowCopyWithPosInc(-xd.dst.uv_stride);
        FullGetSetPointer uleft = xd.dst.u_buffer.shallowCopyWithPosInc(-1);
        FullGetSetPointer vleft = xd.dst.v_buffer.shallowCopyWithPosInc(-1);
        ModeInfo mi = xd.mode_info_context.get();
        Iterator iterator = MBPredictionMode.nonBlockPred.iterator();
        while (iterator.hasNext()) {
            int this_distortion;
            MBPredictionMode mode;
            mi.mbmi.uv_mode = mode = (MBPredictionMode)((Object)iterator.next());
            x2.recon.vp8_build_intra_predictors_mbuv_s(xd, uabove, vabove, uleft, vleft, xd.dst.uv_stride, upred_ptr, vpred_ptr, 8);
            EncodeMB.vp8_subtract_mbuv(x2.src_diff, x2.src.u_buffer, x2.src.v_buffer, x2.src.uv_stride, upred_ptr, vpred_ptr, 8);
            EncodeMB.vp8_transform_mbuv(x2);
            Quantize.vp8_quantize_mbuv(x2);
            int rate_to = RDOpt.rd_cost_mbuv(x2);
            int this_rate = rate_to + x2.intra_uv_mode_cost[xd.frame_type][mi.mbmi.uv_mode.ordinal()];
            long this_rd = RDOpt.RDCOST(x2.rdmult, x2.rddiv, this_rate, this_distortion = RDOpt.vp8_mbuverror(x2) / 4);
            if (this_rd >= rd.error) continue;
            rd.error = this_rd;
            rd.distortion = this_distortion;
            rd.rateComp = this_rate;
            rd.rateBase = rate_to;
            mode_selected = mode;
        }
        assert (mode_selected != null);
        mi.mbmi.uv_mode = mode_selected;
    }

    static int vp8_mbblock_error(Macroblock mb, int dc) {
        int error = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            Block be2 = mb.block.getRel(i2);
            BlockD bd2 = mb.e_mbd.block.getRel(i2);
            int berror = 0;
            for (int j2 = dc; j2 < 16; ++j2) {
                int this_diff = be2.coeff.getRel(j2) - bd2.dqcoeff.getRel(j2);
                berror += this_diff * this_diff;
            }
            error += berror;
        }
        return error;
    }

    static void macro_block_yrd(Macroblock mb, QualityMetrics best) {
        MacroblockD x2 = mb.e_mbd;
        Block mb_y2 = mb.block.getRel(24);
        BlockD x_y2 = x2.block.getRel(24);
        FullGetSetPointer Y2DCPtr = mb_y2.src_diff.shallowCopy();
        EncodeMB.vp8_subtract_mby(mb.src_diff, mb.block.get().base_src, mb.block.get().src_stride, mb.e_mbd.predictor, 16);
        for (int bi2 = 0; bi2 < 16; bi2 += 2) {
            mb.short_fdct8x4.call(mb.block.getRel((int)bi2).src_diff, mb.block.getRel((int)bi2).coeff, 32);
            Y2DCPtr.setAndInc(mb.block.getRel((int)bi2).coeff.get());
            Y2DCPtr.setAndInc(mb.block.getRel((int)bi2).coeff.getRel(16));
        }
        mb.short_walsh4x4.call(mb_y2.src_diff, mb_y2.coeff, 8);
        for (int b2 = 0; b2 < 16; ++b2) {
            mb.quantize_b.call(mb.block.getRel(b2), mb.e_mbd.block.getRel(b2));
        }
        mb.quantize_b.call(mb_y2, x_y2);
        int d2 = RDOpt.vp8_mbblock_error(mb, 1) << 2;
        best.distortion = (d2 += RDOpt.vp8_block_error(mb_y2.coeff, x_y2.dqcoeff)) >> 4;
        best.rateBase = RDOpt.vp8_rdcost_mby(mb);
    }

    static void rd_pick_intra16x16mby_mode(Macroblock x2, QualityMetrics rd) {
        MBPredictionMode mode_selected = null;
        MacroblockD xd = x2.e_mbd;
        QualityMetrics curr = new QualityMetrics();
        rd.error = Long.MAX_VALUE;
        ModeInfo mi = xd.mode_info_context.get();
        Iterator iterator = MBPredictionMode.nonBlockPred.iterator();
        while (iterator.hasNext()) {
            MBPredictionMode mode;
            mi.mbmi.mode = mode = (MBPredictionMode)((Object)iterator.next());
            x2.recon.vp8_build_intra_predictors_mby_s(xd, xd.dst.y_buffer.shallowCopyWithPosInc(-xd.dst.y_stride), xd.dst.y_buffer.shallowCopyWithPosInc(-1), xd.dst.y_stride, xd.predictor, 16);
            RDOpt.macro_block_yrd(x2, curr);
            int temp = curr.rateBase + x2.mbmode_cost.get(xd.frame_type).get((Object)mi.mbmi.mode);
            long this_rd = RDOpt.RDCOST(x2.rdmult, x2.rddiv, temp, curr.distortion);
            if (this_rd >= rd.error) continue;
            mode_selected = mode;
            rd.error = this_rd;
            rd.rateBase = temp;
            rd.rateComp = curr.rateComp;
            rd.distortion = curr.distortion;
        }
        assert (mode_selected != null);
        mi.mbmi.mode = mode_selected;
    }

    static void copy_predictor(FullGetSetPointer dst, GetPointer predictor) {
        for (int i2 = 0; i2 < 13; i2 += 4) {
            dst.setRel(i2, predictor.getRel(i2));
        }
    }

    static void rd_pick_intra4x4block(Macroblock x2, Block be2, BlockD b2, int[] bestmode, HashMap<Integer, Integer> bmode_costs, FullGetSetPointer a10, FullGetSetPointer l2, QualityMetrics best) {
        best.error = Long.MAX_VALUE;
        FullGetSetPointer best_predictor = new FullGetSetPointer(64);
        FullGetSetPointer best_dqcoeff = new FullGetSetPointer(16);
        int dst_stride = x2.e_mbd.dst.y_stride;
        FullGetSetPointer dst = b2.getOffsetPointer(x2.e_mbd.dst.y_buffer);
        FullGetSetPointer Above = dst.shallowCopyWithPosInc(-dst_stride);
        FullGetSetPointer yleft = dst.shallowCopyWithPosInc(-1);
        short top_left = Above.getRel(-1);
        for (int mode : BPredictionMode.bintramodes) {
            int rate = bmode_costs.get(mode);
            x2.recon.vp8_intra4x4_predict(Above, yleft, dst_stride, mode, b2.predictor, 16, top_left);
            EncodeMB.vp8_subtract_b(be2, b2);
            x2.short_fdct4x4.call(be2.src_diff, be2.coeff, 32);
            x2.quantize_b.call(be2, b2);
            FullGetSetPointer tempa = a10.shallowCopy();
            FullGetSetPointer templ = l2.shallowCopy();
            int ratey = RDOpt.cost_coeffs(x2, b2, PlaneType.Y_WITH_DC, tempa, templ);
            int distortion = RDOpt.vp8_block_error(be2.coeff, b2.dqcoeff) >> 2;
            long this_rd = RDOpt.RDCOST(x2.rdmult, x2.rddiv, rate += ratey, distortion);
            if (this_rd >= best.error) continue;
            best.rateBase = rate;
            best.rateComp = ratey;
            best.distortion = distortion;
            best.error = this_rd;
            bestmode[0] = mode;
            a10.set(tempa.get());
            l2.set(templ.get());
            RDOpt.copy_predictor(best_predictor, b2.predictor);
            best_dqcoeff.memcopyin(0, b2.dqcoeff, 0, 16);
        }
        b2.bmi.as_mode(bestmode[0]);
        IDCTllm.vp8_short_idct4x4llm(best_dqcoeff, best_predictor, 16, dst, dst_stride);
    }

    static void rd_pick_intra4x4mby_modes(Macroblock mb, QualityMetrics best) {
        MacroblockD xd = mb.e_mbd;
        int cost = mb.mbmode_cost.get(xd.frame_type).get((Object)MBPredictionMode.B_PRED);
        int distortion = 0;
        int tot_rate_y = 0;
        long total_rd = 0L;
        EntropyPlanes t_above = new EntropyPlanes(mb.e_mbd.above_context.get());
        EntropyPlanes t_left = new EntropyPlanes(mb.e_mbd.left_context);
        ReconIntra.intra_prediction_down_copy(xd);
        HashMap<Integer, Integer> bmode_costs = mb.inter_bmode_costs;
        QualityMetrics rdTemp = new QualityMetrics();
        ModeInfo mi = xd.mode_info_context.get();
        for (int i2 = 0; i2 < 16; ++i2) {
            int mis = xd.mode_info_stride;
            int[] best_mode = new int[]{-1};
            if (mb.e_mbd.frame_type == 0) {
                int A2 = FindNearMV.above_block_mode(xd.mode_info_context, i2, mis);
                int L2 = FindNearMV.left_block_mode(xd.mode_info_context, i2);
                bmode_costs = mb.bmode_costs.get(A2).get(L2);
            }
            RDOpt.rd_pick_intra4x4block(mb, mb.block.getRel(i2), xd.block.getRel(i2), best_mode, bmode_costs, t_above.panes.shallowCopyWithPosInc(BlockD.vp8_block2above[i2]), t_left.panes.shallowCopyWithPosInc(BlockD.vp8_block2left[i2]), rdTemp);
            total_rd += rdTemp.error;
            cost += rdTemp.rateBase;
            distortion = (int)((long)distortion + rdTemp.distortion);
            tot_rate_y += rdTemp.rateComp;
            assert (best_mode[0] != -1);
            mi.bmi[i2].as_mode(best_mode[0]);
            if (total_rd >= best.error) break;
        }
        if (total_rd >= best.error) {
            best.error = Integer.MAX_VALUE;
            return;
        }
        best.rateBase = cost;
        best.rateComp = tot_rate_y;
        best.distortion = distortion;
        best.error = RDOpt.RDCOST(mb.rdmult, mb.rddiv, cost, distortion);
    }

    static long vp8_rd_pick_intra_mode(Macroblock x2) {
        ModeInfo mi = x2.e_mbd.mode_info_context.get();
        mi.mbmi.ref_frame = MVReferenceFrame.INTRA_FRAME;
        QualityMetrics resUV = new QualityMetrics();
        RDOpt.rd_pick_intra_mbuv_mode(x2, resUV);
        QualityMetrics res16 = new QualityMetrics();
        RDOpt.rd_pick_intra16x16mby_mode(x2, res16);
        QualityMetrics res4 = new QualityMetrics();
        res4.error = res16.error;
        RDOpt.rd_pick_intra4x4mby_modes(x2, res4);
        if (res4.error < res16.error) {
            mi.mbmi.mode = MBPredictionMode.B_PRED;
            res16.rateComp = res4.rateComp;
        }
        return resUV.rateComp + res16.rateComp;
    }

    static void vp8_auto_select_speed(Compressor cpi) {
        int milliseconds_for_compress = (int)(1000000.0 / cpi.framerate);
        if (cpi.avg_pick_mode_time < (milliseconds_for_compress = milliseconds_for_compress * (16 - cpi.oxcf.getCpu_used()) / 16) && cpi.avg_encode_time - cpi.avg_pick_mode_time < milliseconds_for_compress) {
            if (cpi.avg_pick_mode_time == 0) {
                cpi.Speed = 4;
            } else {
                if (milliseconds_for_compress * 100 < cpi.avg_encode_time * 95) {
                    cpi.Speed += 2;
                    cpi.avg_pick_mode_time = 0;
                    cpi.avg_encode_time = 0;
                    if (cpi.Speed > 16) {
                        cpi.Speed = 16;
                    }
                }
                if (milliseconds_for_compress * 100 > cpi.avg_encode_time * auto_speed_thresh[cpi.Speed]) {
                    --cpi.Speed;
                    cpi.avg_pick_mode_time = 0;
                    cpi.avg_encode_time = 0;
                    if (cpi.Speed < 4) {
                        cpi.Speed = 4;
                    }
                }
            }
        } else {
            cpi.Speed += 4;
            if (cpi.Speed > 16) {
                cpi.Speed = 16;
            }
            cpi.avg_pick_mode_time = 0;
            cpi.avg_encode_time = 0;
        }
    }

    static void fill_token_costs(int[][][][] c2, short[][][][] p2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 8; ++j2) {
                for (int k2 = 0; k2 < 3; ++k2) {
                    if (k2 == 0 && j2 > (i2 == 0 ? 1 : 0)) {
                        TreeWriter.vp8_cost_tokens2(c2[i2][j2][0], new GetPointer(p2[i2][j2][k2], 0));
                        continue;
                    }
                    TreeWriter.vp8_cost_tokens(c2[i2][j2][k2], new GetPointer(p2[i2][j2][k2], 0), Entropy.vp8_coef_tree);
                }
            }
        }
    }

    static void vp8_initialize_rd_consts(Compressor cpi, Macroblock x2, int Qvalue) {
        int i2;
        double capped_q = Qvalue < 160 ? (double)Qvalue : 160.0;
        double rdconst = 2.8;
        cpi.RDMULT = (int)(2.8 * (capped_q * capped_q));
        if (cpi.mb.zbin_over_quant > 0) {
            double oq_factor = 1.0 + 0.0015625 * (double)cpi.mb.zbin_over_quant;
            double modq = (int)(capped_q * oq_factor);
            cpi.RDMULT = (int)(2.8 * (modq * modq));
        }
        cpi.mb.errorperbit = Math.max(cpi.RDMULT / 110, 1);
        OnyxIf.vp8_set_speed_features(cpi);
        for (i2 = 0; i2 < 20; ++i2) {
            x2.mode_test_hit_counts[i2] = 0;
        }
        int q2 = (int)Math.pow(Qvalue, 1.25);
        if (q2 < 8) {
            q2 = 8;
        }
        if (cpi.RDMULT > 1000) {
            cpi.RDDIV = 1;
            cpi.RDMULT /= 100;
            for (i2 = 0; i2 < 20; ++i2) {
                x2.rd_threshes[i2] = cpi.sf.thresh_mult[i2] < Integer.MAX_VALUE ? cpi.sf.thresh_mult[i2] * q2 / 100 : Integer.MAX_VALUE;
                cpi.rd_baseline_thresh[i2] = x2.rd_threshes[i2];
            }
        } else {
            cpi.RDDIV = 100;
            for (i2 = 0; i2 < 20; ++i2) {
                x2.rd_threshes[i2] = cpi.sf.thresh_mult[i2] < Integer.MAX_VALUE / q2 ? cpi.sf.thresh_mult[i2] * q2 : Integer.MAX_VALUE;
                cpi.rd_baseline_thresh[i2] = x2.rd_threshes[i2];
            }
        }
        FrameContext l2 = cpi.lfc_n;
        if (cpi.common.refresh_alt_ref_frame) {
            l2 = cpi.lfc_a;
        } else if (cpi.common.refresh_golden_frame) {
            l2 = cpi.lfc_g;
        }
        RDOpt.fill_token_costs(cpi.mb.token_costs, l2.coef_probs);
        cpi.rd_costs.vp8_init_mode_costs(cpi);
    }
}

