/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.Block;
import com.idrsolutions.image.webp.enc.BlockD;
import com.idrsolutions.image.webp.enc.CUtils;
import com.idrsolutions.image.webp.enc.CommonData;
import com.idrsolutions.image.webp.enc.Compressor;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.MBLvlFeatures;
import com.idrsolutions.image.webp.enc.Macroblock;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.ModeInfo;
import com.idrsolutions.image.webp.enc.QuantCommon;
import com.idrsolutions.image.webp.enc.QuantDetails;
import com.idrsolutions.image.webp.enc.WebpConst;
import java.util.EnumMap;

final class Quantize {
    static final Quant fastQuant = Quantize::vp8_fast_quantize_b;
    static final Quant regularQuant = Quantize::vp8_regular_quantize_b;
    static final int qrounding_factor = 48;
    static final EnumMap<CommonData.Quant, int[]> qzbin_factors = new EnumMap(CommonData.Quant.class);

    private Quantize() {
    }

    static void vp8_quantize_mby(Macroblock x2) {
        Quantize.quantizeblockRange(x2, 0, 16);
        if (x2.e_mbd.hasSecondOrder()) {
            Quantize.quantizeblockRange(x2, 24, 25);
        }
    }

    static void vp8_quantize_mbuv(Macroblock x2) {
        Quantize.quantizeblockRange(x2, 16, 24);
    }

    private static void quantizeblockRange(Macroblock x2, int st, int stop) {
        for (int i2 = st; i2 < stop; ++i2) {
            x2.quantize_b.call(x2.block.getRel(i2), x2.e_mbd.block.getRel(i2));
        }
    }

    static void vp8cx_mb_init_quantizer(Compressor cpi, Macroblock x2, boolean ok_to_skip) {
        short QIndex;
        MacroblockD xd = x2.e_mbd;
        ModeInfo mi = x2.e_mbd.mode_info_context.get();
        if (xd.segmentation_enabled != 0) {
            if (xd.mb_segement_abs_delta) {
                QIndex = xd.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][mi.mbmi.segment_id];
            } else {
                QIndex = (short)(cpi.common.base_qindex + xd.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][mi.mbmi.segment_id]);
                QIndex = CUtils.clamp(QIndex, (short)0, (short)127);
            }
        } else {
            QIndex = cpi.common.base_qindex;
        }
        if (!ok_to_skip || QIndex != x2.q_index) {
            int i2;
            xd.dequant_y1_dc.set((short)1);
            xd.dequant_y1.set(cpi.common.dequant.get((Object)CommonData.Quant.Y1)[QIndex].get());
            xd.dequant_y2.set(cpi.common.dequant.get((Object)CommonData.Quant.Y2)[QIndex].get());
            xd.dequant_uv.set(cpi.common.dequant.get((Object)CommonData.Quant.UV)[QIndex].get());
            for (i2 = 1; i2 < 16; ++i2) {
                xd.dequant_y1_dc.setRel(i2, xd.dequant_y1.setRel(i2, cpi.common.dequant.get((Object)CommonData.Quant.Y1)[QIndex].getRel(1)));
                xd.dequant_y2.setRel(i2, cpi.common.dequant.get((Object)CommonData.Quant.Y2)[QIndex].getRel(1));
                xd.dequant_uv.setRel(i2, cpi.common.dequant.get((Object)CommonData.Quant.UV)[QIndex].getRel(1));
            }
            for (i2 = 0; i2 < 16; ++i2) {
                x2.e_mbd.block.getRel((int)i2).dequant = xd.dequant_y1;
            }
            for (i2 = 16; i2 < 24; ++i2) {
                x2.e_mbd.block.getRel((int)i2).dequant = xd.dequant_uv;
            }
            x2.e_mbd.block.getRel((int)24).dequant = xd.dequant_y2;
            Quantize.vp8_update_zbin_extra(cpi, x2);
            for (i2 = 0; i2 < 16; ++i2) {
                cpi.q.get((Object)CommonData.Quant.Y1).shallowCopyTo(x2.block.getRel(i2), QIndex);
            }
            while (i2 < 24) {
                cpi.q.get((Object)CommonData.Quant.UV).shallowCopyTo(x2.block.getRel(i2), QIndex);
                ++i2;
            }
            cpi.q.get((Object)CommonData.Quant.Y2).shallowCopyTo(x2.block.getRel(i2), QIndex);
            x2.q_index = QIndex;
            x2.last_zbin_over_quant = x2.zbin_over_quant;
            x2.last_zbin_mode_boost = x2.zbin_mode_boost;
            x2.last_act_zbin_adj = x2.act_zbin_adj;
        } else if (x2.last_zbin_over_quant != x2.zbin_over_quant || x2.last_zbin_mode_boost != x2.zbin_mode_boost || x2.last_act_zbin_adj != x2.act_zbin_adj) {
            Quantize.vp8_update_zbin_extra(cpi, x2);
            x2.last_zbin_over_quant = x2.zbin_over_quant;
            x2.last_zbin_mode_boost = x2.zbin_mode_boost;
            x2.last_act_zbin_adj = x2.act_zbin_adj;
        }
    }

    static void vp8_update_zbin_extra(Compressor cpi, Macroblock x2) {
        int i2;
        int QIndex = x2.q_index;
        int zbin_extra = cpi.common.dequant.get((Object)CommonData.Quant.Y1)[QIndex].getRel(1) * (x2.zbin_over_quant + x2.zbin_mode_boost + x2.act_zbin_adj) >> 7;
        for (i2 = 0; i2 < 16; ++i2) {
            x2.block.getRel((int)i2).zbin_extra = zbin_extra;
        }
        zbin_extra = cpi.common.dequant.get((Object)CommonData.Quant.UV)[QIndex].getRel(1) * (x2.zbin_over_quant + x2.zbin_mode_boost + x2.act_zbin_adj) >> 7;
        while (i2 < 24) {
            x2.block.getRel((int)i2).zbin_extra = zbin_extra;
            ++i2;
        }
        x2.block.getRel((int)i2).zbin_extra = zbin_extra = cpi.common.dequant.get((Object)CommonData.Quant.Y2)[QIndex].getRel(1) * (x2.zbin_over_quant / 2 + x2.zbin_mode_boost + x2.act_zbin_adj) >> 7;
    }

    static void vp8_fast_quantize_b(Block b2, BlockD d2) {
        FullGetSetPointer coeff_ptr = b2.coeff;
        FullGetSetPointer round_ptr = b2.round;
        FullGetSetPointer quant_ptr = b2.quant_fast;
        FullGetSetPointer qcoeff_ptr = d2.qcoeff;
        FullGetSetPointer dqcoeff_ptr = d2.dqcoeff;
        FullGetSetPointer dequant_ptr = d2.dequant;
        int eob = -1;
        for (int i2 = 0; i2 < 16; ++i2) {
            int rc = WebpConst.zigzag[i2];
            short z2 = ((GetPointer)coeff_ptr).getRel(rc);
            int sz = z2 >> 31;
            int x2 = (z2 ^ sz) - sz;
            int y2 = (x2 + ((GetPointer)round_ptr).getRel(rc)) * ((GetPointer)quant_ptr).getRel(rc) >> 16;
            x2 = (y2 ^ sz) - sz;
            qcoeff_ptr.setRel(rc, (short)x2);
            dqcoeff_ptr.setRel(rc, (short)(x2 * ((GetPointer)dequant_ptr).getRel(rc)));
            if (y2 == 0) continue;
            eob = i2;
        }
        d2.eob.set((short)(eob + 1));
    }

    static void vp8_regular_quantize_b(Block b2, BlockD d2) {
        GetSetPointer zbin_boost_ptr = b2.zrun_zbin_boost.positionableOnly();
        FullGetSetPointer coeff_ptr = b2.coeff;
        FullGetSetPointer zbin_ptr = b2.zbin;
        FullGetSetPointer round_ptr = b2.round;
        FullGetSetPointer quant_ptr = b2.quant_fast;
        FullGetSetPointer qcoeff_ptr = d2.qcoeff;
        FullGetSetPointer dqcoeff_ptr = d2.dqcoeff;
        FullGetSetPointer dequant_ptr = d2.dequant;
        FullGetSetPointer quant_shift_ptr = b2.quant_shift;
        int zbin_oq_value = b2.zbin_extra;
        qcoeff_ptr.memset(0, (short)0, 16);
        dqcoeff_ptr.memset(0, (short)0, 16);
        int eob = -1;
        for (int i2 = 0; i2 < 16; ++i2) {
            int rc = WebpConst.zigzag[i2];
            short z2 = ((GetPointer)coeff_ptr).getRel(rc);
            int zbin = ((GetPointer)zbin_ptr).getRel(rc) + zbin_boost_ptr.get() + zbin_oq_value;
            zbin_boost_ptr.inc();
            int sz = z2 >> 31;
            int x2 = (z2 ^ sz) - sz;
            if (x2 < zbin) continue;
            int y2 = (((x2 += ((GetPointer)round_ptr).getRel(rc)) * ((GetPointer)quant_ptr).getRel(rc) >> 16) + x2) * ((GetPointer)quant_shift_ptr).getRel(rc) >> 16;
            x2 = (y2 ^ sz) - sz;
            qcoeff_ptr.setRel(rc, (short)x2);
            dqcoeff_ptr.setRel(rc, (short)(x2 * ((GetPointer)dequant_ptr).getRel(rc)));
            if (y2 == 0) continue;
            eob = i2;
            zbin_boost_ptr.rewindToSaved();
        }
        d2.eob.set((short)(eob + 1));
    }

    static void vp8cx_frame_init_quantizer(Compressor cpi) {
        cpi.mb.zbin_mode_boost = 0;
        Quantize.vp8cx_mb_init_quantizer(cpi, cpi.mb, false);
    }

    static void invert_quant(boolean improved_quant, FullGetSetPointer quant, FullGetSetPointer shift, int d2) {
        if (improved_quant) {
            int l2 = 32 - Integer.numberOfLeadingZeros(d2);
            int m2 = 1 + (1 << 16 + l2) / d2;
            quant.set((short)(m2 - 65536 & 0xFFFF));
            shift.set((short)l2);
            shift.set((short)(1 << 16 - shift.get()));
        } else {
            quant.set((short)(65536 / d2));
            shift.set((short)0);
        }
    }

    static void vp8cx_init_quantizer(Compressor cpi) {
        short[] zbin_boost = new short[]{0, 0, 8, 10, 12, 14, 16, 20, 24, 28, 32, 36, 40, 44, 44, 44};
        for (short Q2 = 0; Q2 < 128; Q2 = (short)((short)(Q2 + 1))) {
            for (CommonData.Quant qenum : CommonData.Quant.values()) {
                QuantDetails q2 = cpi.q.get((Object)qenum);
                for (CommonData.Comp comp : CommonData.Comp.values()) {
                    short quant_val = QuantCommon.lookup.get((Object)qenum).get((Object)comp).call(Q2, cpi.common.delta_q.get((Object)qenum).get((Object)comp));
                    q2.quant_fast[Q2].setRel(comp.baseIndex, (short)(65536 / quant_val));
                    Quantize.invert_quant(cpi.sf.improved_quant, q2.quant[Q2].shallowCopyWithPosInc(comp.baseIndex), q2.quant_shift[Q2].shallowCopyWithPosInc(comp.baseIndex), quant_val);
                    q2.zbin[Q2].setRel(comp.baseIndex, (short)(qzbin_factors.get((Object)qenum)[Q2] * quant_val + 64 >> 7));
                    q2.round[Q2].setRel(comp.baseIndex, (short)(48 * quant_val >> 7));
                    cpi.common.dequant.get((Object)qenum)[Q2].setRel(comp.baseIndex, quant_val);
                    q2.zrun_zbin_boost[Q2].setRel(comp.baseIndex, (short)(quant_val * zbin_boost[comp.baseIndex] >> 7));
                }
                q2.quant_fast[Q2].memset(2, q2.quant_fast[Q2].getRel(1), 14);
                q2.quant[Q2].memset(2, q2.quant[Q2].getRel(1), 14);
                q2.quant_shift[Q2].memset(2, q2.quant_shift[Q2].getRel(1), 14);
                q2.zbin[Q2].memset(2, q2.zbin[Q2].getRel(1), 14);
                q2.round[Q2].memset(2, q2.round[Q2].getRel(1), 14);
                for (int j2 = 2; j2 < q2.zrun_zbin_boost[Q2].size(); ++j2) {
                    q2.zrun_zbin_boost[Q2].setRel(j2, (short)(cpi.common.dequant.get((Object)qenum)[Q2].getRel(1) * zbin_boost[j2] >> 7));
                }
            }
        }
    }

    static void vp8_set_quantizer(Compressor cpi, short Q2) {
        CommonData cm = cpi.common;
        MacroblockD mbd = cpi.mb.e_mbd;
        boolean update = false;
        cm.base_qindex = Q2;
        cm.delta_q.get((Object)CommonData.Quant.Y1).put(CommonData.Comp.DC, (short)0);
        cm.delta_q.get((Object)CommonData.Quant.Y2).put(CommonData.Comp.AC, (short)0);
        short new_delta_q = Q2 < 4 ? (short)(4 - Q2) : (short)0;
        update |= cm.delta_q.get((Object)CommonData.Quant.Y2).get((Object)CommonData.Comp.DC) != new_delta_q;
        cm.delta_q.get((Object)CommonData.Quant.Y2).put(CommonData.Comp.DC, new_delta_q);
        short new_uv_delta_q = 0;
        if (cpi.oxcf.screen_content_mode != 0 && Q2 > 40 && (new_uv_delta_q = (short)(-0.15 * (double)Q2)) < -15) {
            new_uv_delta_q = (short)-15;
        }
        update |= cm.delta_q.get((Object)CommonData.Quant.UV).get((Object)CommonData.Comp.DC) != new_uv_delta_q;
        cm.delta_q.get((Object)CommonData.Quant.UV).put(CommonData.Comp.DC, new_uv_delta_q);
        cm.delta_q.get((Object)CommonData.Quant.UV).put(CommonData.Comp.AC, new_uv_delta_q);
        mbd.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][0] = cpi.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][0];
        mbd.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][1] = cpi.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][1];
        mbd.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][2] = cpi.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][2];
        mbd.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][3] = cpi.segment_feature_data[MBLvlFeatures.ALT_Q.ordinal()][3];
        if (update) {
            Quantize.vp8cx_init_quantizer(cpi);
        }
    }

    static {
        int[] factors = new int[129];
        for (int i2 = 0; i2 < 129; ++i2) {
            factors[i2] = i2 < 48 ? 84 : 80;
        }
        qzbin_factors.put(CommonData.Quant.Y1, factors);
        qzbin_factors.put(CommonData.Quant.Y2, factors);
        qzbin_factors.put(CommonData.Quant.UV, factors);
    }

    static interface Quant {
        public void call(Block var1, BlockD var2);
    }
}

