/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.CUtils;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.LoopFilterInfo;

final class LFFilters {
    private LFFilters() {
    }

    static int vp8_filter_mask(int limit, int blimit, int p3, int p2, int p1, int p0, int q0, int q1, int q2, int q3) {
        boolean mask = false;
        mask |= Math.abs(p3 - p2) > limit;
        mask |= Math.abs(p2 - p1) > limit;
        mask |= Math.abs(p1 - p0) > limit;
        mask |= Math.abs(q1 - q0) > limit;
        mask |= Math.abs(q2 - q1) > limit;
        mask |= Math.abs(q3 - q2) > limit;
        return (mask |= LFFilters.filtermaskcore(p1, p0, q0, q1) > blimit) ? 0 : -1;
    }

    static int vp8_hevmask(int thresh, int p1, int p0, int q0, int q1) {
        int hev = 0;
        hev |= Math.abs(p1 - p0) > thresh ? -1 : 0;
        return hev |= Math.abs(q1 - q0) > thresh ? -1 : 0;
    }

    private static short unsignedToSigned(short in) {
        return (short)(in - 128);
    }

    private static short signedToUnsigned(short in) {
        return (short)(in + 128);
    }

    static void vp8_filter(int mask, int hev, FullGetSetPointer ptr, int op1, int op0, int oq1) {
        short ps1 = LFFilters.unsignedToSigned(ptr.getRel(op1));
        short ps0 = LFFilters.unsignedToSigned(ptr.getRel(op0));
        short qs0 = LFFilters.unsignedToSigned(ptr.getRel(0));
        short qs1 = LFFilters.unsignedToSigned(ptr.getRel(oq1));
        int filter_value = CUtils.byteClamp((short)(ps1 - qs1));
        filter_value &= hev;
        filter_value = CUtils.byteClamp((short)(filter_value + 3 * (qs0 - ps0)));
        int Filter1 = CUtils.byteClamp((short)((filter_value &= mask) + 4));
        int Filter2 = CUtils.byteClamp((short)(filter_value + 3));
        short u2 = CUtils.byteClamp((short)(qs0 - (Filter1 >>= 3)));
        ptr.setRel(0, LFFilters.signedToUnsigned(u2));
        u2 = CUtils.byteClamp((short)(ps0 + (Filter2 >>= 3)));
        ptr.setRel(op0, LFFilters.signedToUnsigned(u2));
        filter_value = Filter1;
        ++filter_value;
        filter_value >>= 1;
        u2 = CUtils.byteClamp((short)(qs1 - (filter_value &= ~hev)));
        ptr.setRel(oq1, LFFilters.signedToUnsigned(u2));
        u2 = CUtils.byteClamp((short)(ps1 + filter_value));
        ptr.setRel(op1, LFFilters.signedToUnsigned(u2));
    }

    static void loop_filter_horizontal_edge(FullGetSetPointer s2, int p2, GetPointer blimit, GetPointer limit, GetPointer thresh, int count) {
        int i2 = 0;
        do {
            LFFilters.filterCore(s2, blimit, limit, thresh, p2);
            s2.inc();
        } while (++i2 < count * 8);
    }

    private static int getMask(GetPointer s2, GetPointer blimit, GetPointer limit, int p2) {
        return LFFilters.vp8_filter_mask(limit.get(), blimit.get(), s2.getRel(-4 * p2), s2.getRel(-3 * p2), s2.getRel(-2 * p2), s2.getRel(-1 * p2), s2.getRel(0), s2.getRel(p2), s2.getRel(2 * p2), s2.getRel(3 * p2));
    }

    private static int getHEV(FullGetSetPointer s2, GetPointer thresh, int p2) {
        return LFFilters.vp8_hevmask(thresh.get(), s2.getRel(-2 * p2), s2.getRel(-1 * p2), s2.getRel(0), s2.getRel(p2));
    }

    private static void filterCore(FullGetSetPointer s2, GetPointer blimit, GetPointer limit, GetPointer thresh, int p2) {
        int mask = LFFilters.getMask(s2, blimit, limit, p2);
        int hev = LFFilters.getHEV(s2, thresh, p2);
        LFFilters.vp8_filter(mask, hev, s2, -(p2 << 1), -p2, p2);
    }

    static void loop_filter_vertical_edge(FullGetSetPointer s2, int p2, GetPointer blimit, GetPointer limit, GetPointer thresh, int count) {
        int i2 = 0;
        do {
            LFFilters.filterCore(s2, blimit, limit, thresh, 1);
            s2.incBy(p2);
        } while (++i2 < count * 8);
    }

    static void vp8_mbfilter(int mask, int hev, FullGetSetPointer ptr, int op2, int op1, int op0, int oq1, int oq2) {
        short ps2 = LFFilters.unsignedToSigned(ptr.getRel(op2));
        short ps1 = LFFilters.unsignedToSigned(ptr.getRel(op1));
        short ps0 = LFFilters.unsignedToSigned(ptr.getRel(op0));
        short qs0 = LFFilters.unsignedToSigned(ptr.getRel(0));
        short qs1 = LFFilters.unsignedToSigned(ptr.getRel(oq1));
        short qs2 = LFFilters.unsignedToSigned(ptr.getRel(oq2));
        short filter_value = CUtils.byteClamp((short)(ps1 - qs1));
        filter_value = CUtils.byteClamp((short)(filter_value + 3 * (qs0 - ps0)));
        short Filter2 = filter_value = (short)(filter_value & mask);
        Filter2 = (short)(Filter2 & hev);
        short Filter1 = CUtils.byteClamp((short)(Filter2 + 4));
        Filter2 = CUtils.byteClamp((short)(Filter2 + 3));
        Filter1 = (short)(Filter1 >> 3);
        Filter2 = (short)(Filter2 >> 3);
        qs0 = CUtils.byteClamp((short)(qs0 - Filter1));
        ps0 = CUtils.byteClamp((short)(ps0 + Filter2));
        Filter2 = filter_value = (short)(filter_value & ~hev);
        short u2 = CUtils.byteClamp((short)(63 + Filter2 * 27 >> 7));
        short s2 = CUtils.byteClamp((short)(qs0 - u2));
        ptr.setRel(0, LFFilters.signedToUnsigned(s2));
        s2 = CUtils.byteClamp((short)(ps0 + u2));
        ptr.setRel(op0, LFFilters.signedToUnsigned(s2));
        u2 = CUtils.byteClamp((short)(63 + Filter2 * 18 >> 7));
        s2 = CUtils.byteClamp((short)(qs1 - u2));
        ptr.setRel(oq1, LFFilters.signedToUnsigned(s2));
        s2 = CUtils.byteClamp((short)(ps1 + u2));
        ptr.setRel(op1, LFFilters.signedToUnsigned(s2));
        u2 = CUtils.byteClamp((short)(63 + Filter2 * 9 >> 7));
        s2 = CUtils.byteClamp((short)(qs2 - u2));
        ptr.setRel(oq2, LFFilters.signedToUnsigned(s2));
        s2 = CUtils.byteClamp((short)(ps2 + u2));
        ptr.setRel(op2, LFFilters.signedToUnsigned(s2));
    }

    static void mbloop_filter_horizontal_edge(FullGetSetPointer s2, int p2, GetPointer blimit, GetPointer limit, GetPointer thresh, int count) {
        int i2 = 0;
        s2 = s2.shallowCopy();
        do {
            LFFilters.mbfiltercore(s2, blimit, limit, thresh, p2);
            s2.inc();
        } while (++i2 < count * 8);
    }

    private static void mbfiltercore(FullGetSetPointer s2, GetPointer blimit, GetPointer limit, GetPointer thresh, int p2) {
        int mask = LFFilters.getMask(s2, blimit, limit, p2);
        int hev = LFFilters.getHEV(s2, thresh, p2);
        LFFilters.vp8_mbfilter(mask, hev, s2, -3 * p2, -2 * p2, -p2, p2, 2 * p2);
    }

    static void mbloop_filter_vertical_edge(FullGetSetPointer s2, int p2, GetPointer blimit, GetPointer limit, GetPointer thresh, int count) {
        int i2 = 0;
        s2 = s2.shallowCopy();
        do {
            LFFilters.mbfiltercore(s2, blimit, limit, thresh, 1);
            s2.incBy(p2);
        } while (++i2 < count * 8);
    }

    static int vp8_simple_filter_mask(int blimit, int p1, int p0, int q0, int q1) {
        return LFFilters.filtermaskcore(p1, p0, q0, q1) <= blimit ? -1 : 0;
    }

    private static int filtermaskcore(int p1, int p0, int q0, int q1) {
        return Math.abs(p0 - q0) * 2 + Math.abs(p1 - q1) / 2;
    }

    static void vp8_simple_filter(int mask, FullGetSetPointer ptr, int op1, int op0, int oq1) {
        short p1 = LFFilters.unsignedToSigned(ptr.getRel(op1));
        short p0 = LFFilters.unsignedToSigned(ptr.getRel(op0));
        short q0 = LFFilters.unsignedToSigned(ptr.getRel(0));
        short q1 = LFFilters.unsignedToSigned(ptr.getRel(oq1));
        int filter_value = CUtils.byteClamp((short)(p1 - q1));
        filter_value = CUtils.byteClamp((short)(filter_value + 3 * (q0 - p0)));
        int Filter1 = CUtils.byteClamp((short)((filter_value &= mask) + 4));
        short u2 = CUtils.byteClamp((short)(q0 - (Filter1 >>= 3)));
        ptr.setRel(0, LFFilters.signedToUnsigned(u2));
        int Filter2 = CUtils.byteClamp((short)(filter_value + 3));
        u2 = CUtils.byteClamp((short)(p0 + (Filter2 >>= 3)));
        ptr.setRel(op0, LFFilters.signedToUnsigned(u2));
    }

    static void vp8_loop_filter_simple_horizontal_edge(FullGetSetPointer y_ptr, int y_stride, GetPointer blimit) {
        int i2 = 0;
        y_ptr.savePos();
        do {
            int mask = LFFilters.vp8_simple_filter_mask(blimit.get(), y_ptr.getRel(-2 * y_stride), y_ptr.getRel(-1 * y_stride), y_ptr.getRel(0), y_ptr.getRel(y_stride));
            LFFilters.vp8_simple_filter(mask, y_ptr, -2 * y_stride, -y_stride, y_stride);
            y_ptr.inc();
        } while (++i2 < 16);
        y_ptr.rewindToSaved();
    }

    static void vp8_loop_filter_simple_vertical_edge(FullGetSetPointer y_ptr, int y_stride, GetPointer blimit) {
        int i2 = 0;
        y_ptr.savePos();
        do {
            int mask = LFFilters.vp8_simple_filter_mask(blimit.get(), y_ptr.getRel(-2), y_ptr.getRel(-1), y_ptr.get(), y_ptr.getRel(1));
            LFFilters.vp8_simple_filter(mask, y_ptr, -2, -1, 1);
            y_ptr.incBy(y_stride);
        } while (++i2 < 16);
        y_ptr.rewindToSaved();
    }

    static void vp8_loop_filter_mbh(FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr, int y_stride, int uv_stride, LoopFilterInfo lfi) {
        LFFilters.mbloop_filter_horizontal_edge(y_ptr, y_stride, lfi.mblim, lfi.lim, lfi.hev_thr, 2);
        if (u_ptr != null) {
            LFFilters.mbloop_filter_horizontal_edge(u_ptr, uv_stride, lfi.mblim, lfi.lim, lfi.hev_thr, 1);
        }
        if (v_ptr != null) {
            LFFilters.mbloop_filter_horizontal_edge(v_ptr, uv_stride, lfi.mblim, lfi.lim, lfi.hev_thr, 1);
        }
    }

    static void vp8_loop_filter_mbv(FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr, int y_stride, int uv_stride, LoopFilterInfo lfi) {
        LFFilters.mbloop_filter_vertical_edge(y_ptr, y_stride, lfi.mblim, lfi.lim, lfi.hev_thr, 2);
        if (u_ptr != null) {
            LFFilters.mbloop_filter_vertical_edge(u_ptr, uv_stride, lfi.mblim, lfi.lim, lfi.hev_thr, 1);
        }
        if (v_ptr != null) {
            LFFilters.mbloop_filter_vertical_edge(v_ptr, uv_stride, lfi.mblim, lfi.lim, lfi.hev_thr, 1);
        }
    }

    static void vp8_loop_filter_bh(FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr, int y_stride, int uv_stride, LoopFilterInfo lfi) {
        LFFilters.loop_filter_horizontal_edge(y_ptr.shallowCopyWithPosInc(y_stride << 2), y_stride, lfi.blim, lfi.lim, lfi.hev_thr, 2);
        LFFilters.loop_filter_horizontal_edge(y_ptr.shallowCopyWithPosInc(y_stride << 3), y_stride, lfi.blim, lfi.lim, lfi.hev_thr, 2);
        LFFilters.loop_filter_horizontal_edge(y_ptr.shallowCopyWithPosInc(12 * y_stride), y_stride, lfi.blim, lfi.lim, lfi.hev_thr, 2);
        if (u_ptr != null) {
            LFFilters.loop_filter_horizontal_edge(u_ptr.shallowCopyWithPosInc(uv_stride << 2), uv_stride, lfi.blim, lfi.lim, lfi.hev_thr, 1);
        }
        if (v_ptr != null) {
            LFFilters.loop_filter_horizontal_edge(v_ptr.shallowCopyWithPosInc(uv_stride << 2), uv_stride, lfi.blim, lfi.lim, lfi.hev_thr, 1);
        }
    }

    static void vp8_loop_filter_bhs(FullGetSetPointer y_ptr, int y_stride, GetPointer blimit) {
        LFFilters.vp8_loop_filter_simple_horizontal_edge(y_ptr.shallowCopyWithPosInc(y_stride << 2), y_stride, blimit);
        LFFilters.vp8_loop_filter_simple_horizontal_edge(y_ptr.shallowCopyWithPosInc(y_stride << 3), y_stride, blimit);
        LFFilters.vp8_loop_filter_simple_horizontal_edge(y_ptr.shallowCopyWithPosInc(12 * y_stride), y_stride, blimit);
    }

    static void vp8_loop_filter_bv(FullGetSetPointer y_ptr, FullGetSetPointer u_ptr, FullGetSetPointer v_ptr, int y_stride, int uv_stride, LoopFilterInfo lfi) {
        LFFilters.loop_filter_vertical_edge(y_ptr.shallowCopyWithPosInc(4), y_stride, lfi.blim, lfi.lim, lfi.hev_thr, 2);
        LFFilters.loop_filter_vertical_edge(y_ptr.shallowCopyWithPosInc(8), y_stride, lfi.blim, lfi.lim, lfi.hev_thr, 2);
        LFFilters.loop_filter_vertical_edge(y_ptr.shallowCopyWithPosInc(12), y_stride, lfi.blim, lfi.lim, lfi.hev_thr, 2);
        if (u_ptr != null) {
            LFFilters.loop_filter_vertical_edge(u_ptr.shallowCopyWithPosInc(4), uv_stride, lfi.blim, lfi.lim, lfi.hev_thr, 1);
        }
        if (v_ptr != null) {
            LFFilters.loop_filter_vertical_edge(v_ptr.shallowCopyWithPosInc(4), uv_stride, lfi.blim, lfi.lim, lfi.hev_thr, 1);
        }
    }

    static void vp8_loop_filter_bvs(FullGetSetPointer y_ptr, int y_stride, GetPointer blimit) {
        LFFilters.vp8_loop_filter_simple_vertical_edge(y_ptr.shallowCopyWithPosInc(4), y_stride, blimit);
        LFFilters.vp8_loop_filter_simple_vertical_edge(y_ptr.shallowCopyWithPosInc(8), y_stride, blimit);
        LFFilters.vp8_loop_filter_simple_vertical_edge(y_ptr.shallowCopyWithPosInc(12), y_stride, blimit);
    }
}

