/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.CUtils;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;

final class IDCTllm {
    private static final int cospi8sqrt2minus1 = 20091;
    private static final int sinpi8sqrt2 = 35468;

    private IDCTllm() {
    }

    static void vp8_short_idct4x4llm(GetSetPointer ip, GetSetPointer pred_ptr, int pred_stride, FullGetSetPointer dst_ptr, int dst_stride) {
        FullGetSetPointer op = IDCTllm.vp8_short_idct4x4NoAdd(ip);
        for (int r2 = 0; r2 < 4; ++r2) {
            int basePred = r2 * pred_stride;
            int baseDst = r2 * dst_stride;
            for (int c2 = 0; c2 < 4; ++c2) {
                dst_ptr.setRel(baseDst + c2, CUtils.clipPixel((short)(op.getRel(c2) + pred_ptr.getRel(basePred + c2))));
            }
            op.incBy(4);
        }
    }

    static FullGetSetPointer vp8_short_idct4x4NoAdd(GetSetPointer ip) {
        int d1;
        int c1;
        int temp2;
        int temp1;
        int b1;
        int a12;
        int i2;
        int inPos = ip.getPos();
        FullGetSetPointer op = new FullGetSetPointer(16);
        int shortpitch = 4;
        for (i2 = 0; i2 < 4; ++i2) {
            a12 = ip.get() + ip.getRel(8);
            b1 = ip.get() - ip.getRel(8);
            temp1 = ip.getRel(4) * 35468 >> 16;
            temp2 = ip.getRel(12) + (ip.getRel(12) * 20091 >> 16);
            c1 = temp1 - temp2;
            temp1 = ip.getRel(4) + (ip.getRel(4) * 20091 >> 16);
            temp2 = ip.getRel(12) * 35468 >> 16;
            d1 = temp1 + temp2;
            op.set((short)(a12 + d1));
            op.setRel(12, (short)(a12 - d1));
            op.setRel(4, (short)(b1 + c1));
            op.setRel(8, (short)(b1 - c1));
            ip.inc();
            op.inc();
        }
        ip.setPos(inPos);
        op.rewind();
        for (i2 = 0; i2 < 4; ++i2) {
            a12 = op.get() + op.getRel(2);
            b1 = op.get() - op.getRel(2);
            temp1 = op.getRel(1) * 35468 >> 16;
            temp2 = op.getRel(3) + (op.getRel(3) * 20091 >> 16);
            c1 = temp1 - temp2;
            temp1 = op.getRel(1) + (op.getRel(1) * 20091 >> 16);
            temp2 = op.getRel(3) * 35468 >> 16;
            d1 = temp1 + temp2;
            op.set((short)(a12 + d1 + 4 >> 3));
            op.setRel(3, (short)(a12 - d1 + 4 >> 3));
            op.setRel(1, (short)(b1 + c1 + 4 >> 3));
            op.setRel(2, (short)(b1 - c1 + 4 >> 3));
            op.incBy(4);
        }
        op.rewind();
        return op;
    }

    static void vp8_dc_only_idct_add(int input_dc, GetSetPointer pred_ptr, int pred_stride, FullGetSetPointer dst_ptr, int dst_stride) {
        int a12 = input_dc + 4 >> 3;
        for (int r2 = 0; r2 < 4; ++r2) {
            int dstBase = r2 * dst_stride;
            int predBase = r2 * pred_stride;
            for (int c2 = 0; c2 < 4; ++c2) {
                dst_ptr.setRel(dstBase + c2, CUtils.clipPixel((short)(a12 + pred_ptr.getRel(predBase + c2))));
            }
        }
    }

    static void vp8_short_inv_walsh4x4(GetSetPointer ip, FullGetSetPointer mb_dqcoeff) {
        int d1;
        int c1;
        int b1;
        int a12;
        int i2;
        int inPos = ip.getPos();
        FullGetSetPointer op = new FullGetSetPointer(16);
        for (i2 = 0; i2 < 4; ++i2) {
            a12 = ip.get() + ip.getRel(12);
            b1 = ip.getRel(4) + ip.getRel(8);
            c1 = ip.getRel(4) - ip.getRel(8);
            d1 = ip.get() - ip.getRel(12);
            op.set((short)(a12 + b1));
            op.setRel(4, (short)(c1 + d1));
            op.setRel(8, (short)(a12 - b1));
            op.setRel(12, (short)(d1 - c1));
            ip.inc();
            op.inc();
        }
        op.rewind();
        ip.setPos(inPos);
        for (i2 = 0; i2 < 4; ++i2) {
            a12 = op.get() + op.getRel(3);
            b1 = op.getRel(1) + op.getRel(2);
            c1 = op.getRel(1) - op.getRel(2);
            d1 = op.get() - op.getRel(3);
            int a22 = a12 + b1;
            int b2 = c1 + d1;
            int c2 = a12 - b1;
            int d2 = d1 - c1;
            op.setAndInc((short)(a22 + 3 >> 3));
            op.setAndInc((short)(b2 + 3 >> 3));
            op.setAndInc((short)(c2 + 3 >> 3));
            op.setAndInc((short)(d2 + 3 >> 3));
        }
        op.rewind();
        for (i2 = 0; i2 < 16; ++i2) {
            mb_dqcoeff.setRel(i2 << 4, op.getRel(i2));
        }
    }

    static void vp8_short_inv_walsh4x4_1(GetPointer input, FullGetSetPointer mb_dqcoeff) {
        int a12 = input.get() + 3 >> 3;
        for (int i2 = 0; i2 < 16; ++i2) {
            mb_dqcoeff.setRel(i2 << 4, (short)a12);
        }
    }
}

