/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.IDCTllm;

final class IDCTBlk {
    private IDCTBlk() {
    }

    static void vp8_dequant_idct_add(FullGetSetPointer input, GetPointer dq, FullGetSetPointer dest, int stride) {
        for (int i2 = 0; i2 < 16; ++i2) {
            input.setRel(i2, (short)(dq.getRel(i2) * input.getRel(i2)));
        }
        IDCTllm.vp8_short_idct4x4llm(input, dest, stride, dest, stride);
        input.memset(0, (short)0, 16);
    }

    static void vp8_dequant_idct_add_core(int imax, int jmax, GetSetPointer eobs, FullGetSetPointer q2, GetPointer dq, FullGetSetPointer dst, int stride) {
        int dstinc = stride - jmax << 2;
        for (int i2 = 0; i2 < imax; ++i2) {
            for (int j2 = 0; j2 < jmax; ++j2) {
                if (eobs.get() > 1) {
                    IDCTBlk.vp8_dequant_idct_add(q2, dq, dst, stride);
                } else {
                    IDCTllm.vp8_dc_only_idct_add(q2.get() * dq.get(), dst, stride, dst, stride);
                    q2.memset(0, (short)0, 2);
                }
                eobs.inc();
                q2.incBy(16);
                dst.incBy(4);
            }
            dst.incBy(dstinc);
        }
    }

    static void vp8_dequant_idct_add_y_block(FullGetSetPointer q2, GetPointer dq, FullGetSetPointer dst, int stride, GetSetPointer eobs) {
        int ep = eobs.getPos();
        int qp = q2.getPos();
        int dp = dst.getPos();
        IDCTBlk.vp8_dequant_idct_add_core(4, 4, eobs, q2, dq, dst, stride);
        eobs.setPos(ep);
        q2.setPos(qp);
        dst.setPos(dp);
    }

    static void vp8_dequant_idct_add_uv_block(FullGetSetPointer q2, GetPointer dq, FullGetSetPointer dst_u, FullGetSetPointer dst_v, int stride, GetSetPointer eobs) {
        int ep = eobs.getPos();
        int qp = q2.getPos();
        int dup = dst_u.getPos();
        int dvp = dst_v.getPos();
        IDCTBlk.vp8_dequant_idct_add_core(2, 2, eobs, q2, dq, dst_u, stride);
        IDCTBlk.vp8_dequant_idct_add_core(2, 2, eobs, q2, dq, dst_v, stride);
        eobs.setPos(ep);
        q2.setPos(qp);
        dst_u.setPos(dup);
        dst_v.setPos(dvp);
    }
}

