/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.EntropyMode;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.MVContext;
import com.idrsolutions.image.webp.enc.TreeWriter;

final class EncodeMV {
    private EncodeMV() {
    }

    static int cost_mvcomponent(int v2, MVContext mvc) {
        int cost;
        GetSetPointer p2 = mvc.prob.positionableOnly();
        if (v2 < 8) {
            cost = TreeWriter.vp8_cost_zero(p2.getRel(0));
            p2.incBy(2);
            cost += TreeWriter.vp8_treed_cost(EntropyMode.vp8_small_mvtree, p2, v2, 3);
            if (v2 == 0) {
                return cost;
            }
        } else {
            int i2 = 0;
            cost = TreeWriter.vp8_cost_one(p2.getRel(0));
            p2.incBy(9);
            do {
                cost += TreeWriter.vp8_cost_bit(p2.getRel(i2), v2 >> i2 & 1);
            } while (++i2 < 3);
            i2 = 9;
            do {
                cost += TreeWriter.vp8_cost_bit(p2.getRel(i2), v2 >> i2 & 1);
            } while (--i2 > 3);
            if ((v2 & 0xFFF0) != 0) {
                cost += TreeWriter.vp8_cost_bit(p2.getRel(3), v2 >> 3 & 1);
            }
        }
        return cost;
    }

    static void vp8_build_component_cost_table(FullGetSetPointer[] mvcost, MVContext[] mvc, boolean[] mvc_flag) {
        int i2 = 1;
        if (mvc_flag[0]) {
            mvcost[0].set((short)EncodeMV.cost_mvcomponent(0, mvc[0]));
            do {
                int cost0 = EncodeMV.cost_mvcomponent(i2, mvc[0]);
                mvcost[0].setRel(i2, (short)(cost0 + TreeWriter.vp8_cost_zero(mvc[0].prob.getRel(1))));
                mvcost[0].setRel(-i2, (short)(cost0 + TreeWriter.vp8_cost_one(mvc[0].prob.getRel(1))));
            } while (++i2 <= 1023);
        }
        i2 = 1;
        if (mvc_flag[1]) {
            mvcost[1].set((short)EncodeMV.cost_mvcomponent(0, mvc[1]));
            do {
                int cost1 = EncodeMV.cost_mvcomponent(i2, mvc[1]);
                mvcost[1].setRel(i2, (short)(cost1 + TreeWriter.vp8_cost_zero(mvc[1].prob.getRel(1))));
                mvcost[1].setRel(-i2, (short)(cost1 + TreeWriter.vp8_cost_one(mvc[1].prob.getRel(1))));
            } while (++i2 <= 1023);
        }
    }
}

