/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.Block;
import com.idrsolutions.image.webp.enc.BlockD;
import com.idrsolutions.image.webp.enc.DCTValueConstants;
import com.idrsolutions.image.webp.enc.EntropyPlanes;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.MVReferenceFrame;
import com.idrsolutions.image.webp.enc.Macroblock;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.PlaneType;
import com.idrsolutions.image.webp.enc.TokenAlphabet;
import com.idrsolutions.image.webp.enc.TokenState;
import com.idrsolutions.image.webp.enc.VP8Util;
import com.idrsolutions.image.webp.enc.WebpConst;

final class EncodeMB {
    private EncodeMB() {
    }

    static void vpx_subtract_block(int rows, int cols, FullGetSetPointer diff_ptr, int diff_stride, GetPointer src_ptr, int src_stride, GetPointer pred_ptr, int pred_stride) {
        for (int r2 = 0; r2 < rows; ++r2) {
            int c2 = 0;
            int diff = r2 * diff_stride;
            int src = r2 * src_stride;
            int pred = r2 * pred_stride;
            while (c2 < cols) {
                diff_ptr.setRel(diff, (short)(src_ptr.getRel(src) - pred_ptr.getRel(pred)));
                ++c2;
                ++diff;
                ++src;
                ++pred;
            }
        }
    }

    static void vp8_subtract_b(Block be2, BlockD bd2) {
        EncodeMB.vpx_subtract_block(4, 4, be2.src_diff, 16, be2.getSrcPtr(), be2.src_stride, bd2.predictor, 16);
    }

    static void vp8_subtract_mby(FullGetSetPointer diff, GetPointer src, int src_stride, GetPointer pred, int pred_stride) {
        EncodeMB.vpx_subtract_block(16, 16, diff, 16, src, src_stride, pred, pred_stride);
    }

    static void build_dcblock(Macroblock x2) {
        int i2 = 0;
        int j2 = 384;
        while (i2 < 16) {
            x2.src_diff.setAbs(j2, x2.coeff.getRel(i2 << 4));
            ++i2;
            ++j2;
        }
    }

    static void vp8_transform_intra_mby(Macroblock x2) {
        for (int i2 = 0; i2 < 16; i2 += 2) {
            x2.short_fdct8x4.call(x2.block.getRel((int)i2).src_diff, x2.block.getRel((int)i2).coeff, 32);
        }
        EncodeMB.build_dcblock(x2);
        x2.short_walsh4x4.call(x2.block.getRel((int)24).src_diff, x2.block.getRel((int)24).coeff, 8);
    }

    static int RDCOST(int RM, int DM, int R2, int D2) {
        return (128 + R2 * RM >> 8) + DM * D2;
    }

    static int RDTRUNC(int RM, int R2) {
        return 128 + R2 * RM & 0xFF;
    }

    static void optimize_b(Macroblock mb, int ib, PlaneType type, FullGetSetPointer a10, FullGetSetPointer l2) {
        TokenState[][] tokens = new TokenState[17][2];
        int sz = 0;
        int err_mult = type.rd_mult;
        Block b2 = mb.block.getRel(ib);
        BlockD d2 = mb.e_mbd.block.getRel(ib);
        GetPointer dequant_ptr = d2.dequant.readOnly();
        FullGetSetPointer coeff_ptr = b2.coeff;
        FullGetSetPointer qcoeff_ptr = d2.qcoeff.shallowCopy();
        FullGetSetPointer dqcoeff_ptr = d2.dqcoeff.shallowCopy();
        int i0 = type.start_coeff;
        int eob = d2.eob.get();
        int rdmult = mb.rdmult * err_mult;
        if (mb.e_mbd.mode_info_context.get().mbmi.ref_frame == MVReferenceFrame.INTRA_FRAME) {
            rdmult = rdmult * 9 >> 4;
        }
        int rddiv = mb.rddiv;
        int[] best_mask = new int[]{0, 0};
        tokens[eob][0] = new TokenState(0, 0, 16, TokenAlphabet.DCT_EOB_TOKEN, 0);
        tokens[eob][1] = new TokenState(tokens[eob][0]);
        int next = eob;
        int i2 = eob;
        while (i2-- > i0) {
            int rc = WebpConst.zigzag[i2];
            int x2 = qcoeff_ptr.getRel(rc);
            if (x2 != 0) {
                TokenAlphabet t1;
                int rd_cost1;
                int rd_cost0;
                int band;
                boolean shortcut = false;
                int error0 = tokens[next][0].error;
                int error1 = tokens[next][1].error;
                int rate0 = tokens[next][0].rate;
                int rate1 = tokens[next][1].rate;
                TokenAlphabet t0 = DCTValueConstants.getTokenValue((int)x2).token;
                if (next < 16) {
                    band = VP8Util.SubblockKeys.vp8CoefBands[i2 + 1];
                    rate0 += mb.token_costs[type.ordinal()][band][t0.previousTokenClass][tokens[next][0].token.ordinal()];
                    rate1 += mb.token_costs[type.ordinal()][band][t0.previousTokenClass][tokens[next][1].token.ordinal()];
                }
                if ((rd_cost0 = EncodeMB.RDCOST(rdmult, rddiv, rate0, error0)) == (rd_cost1 = EncodeMB.RDCOST(rdmult, rddiv, rate1, error1))) {
                    rd_cost0 = EncodeMB.RDTRUNC(rdmult, rate0);
                    rd_cost1 = EncodeMB.RDTRUNC(rdmult, rate1);
                }
                int best = rd_cost1 < rd_cost0 ? 1 : 0;
                int base_bits = DCTValueConstants.getValueCost(x2);
                int dx = dqcoeff_ptr.getRel(rc) - ((GetPointer)coeff_ptr).getRel(rc);
                int d22 = dx * dx;
                tokens[i2][0] = new TokenState(base_bits + (best > 0 ? rate1 : rate0), d22 + (best > 0 ? error1 : error0), next, t0, x2);
                best_mask[0] = best_mask[0] | best << i2;
                rate0 = tokens[next][0].rate;
                rate1 = tokens[next][1].rate;
                if (Math.abs(x2) * dequant_ptr.getRel(rc) > Math.abs(((GetPointer)coeff_ptr).getRel(rc)) && Math.abs(x2) * dequant_ptr.getRel(rc) < Math.abs(((GetPointer)coeff_ptr).getRel(rc)) + dequant_ptr.getRel(rc)) {
                    sz = x2 < 0 ? -1 : 0;
                    x2 -= 2 * sz + 1;
                    shortcut = true;
                }
                if (x2 == 0) {
                    t0 = tokens[next][0].token == TokenAlphabet.DCT_EOB_TOKEN ? TokenAlphabet.DCT_EOB_TOKEN : TokenAlphabet.ZERO_TOKEN;
                    t1 = tokens[next][1].token == TokenAlphabet.DCT_EOB_TOKEN ? TokenAlphabet.DCT_EOB_TOKEN : TokenAlphabet.ZERO_TOKEN;
                } else {
                    t0 = t1 = DCTValueConstants.getTokenValue((int)x2).token;
                }
                if (next < 16) {
                    band = VP8Util.SubblockKeys.vp8CoefBands[i2 + 1];
                    if (t0 != TokenAlphabet.DCT_EOB_TOKEN) {
                        rate0 += mb.token_costs[type.ordinal()][band][t0.previousTokenClass][tokens[next][0].token.ordinal()];
                    }
                    if (t1 != TokenAlphabet.DCT_EOB_TOKEN) {
                        rate1 += mb.token_costs[type.ordinal()][band][t1.previousTokenClass][tokens[next][1].token.ordinal()];
                    }
                }
                if ((rd_cost0 = EncodeMB.RDCOST(rdmult, rddiv, rate0, error0)) == (rd_cost1 = EncodeMB.RDCOST(rdmult, rddiv, rate1, error1))) {
                    rd_cost0 = EncodeMB.RDTRUNC(rdmult, rate0);
                    rd_cost1 = EncodeMB.RDTRUNC(rdmult, rate1);
                }
                best = rd_cost1 < rd_cost0 ? 1 : 0;
                base_bits = DCTValueConstants.getValueCost(x2);
                if (shortcut) {
                    d22 = (dx -= dequant_ptr.getRel(rc) + sz ^ sz) * dx;
                }
                tokens[i2][1] = new TokenState(base_bits + (best > 0 ? rate1 : rate0), d22 + (best > 0 ? error1 : error0), next, best > 0 ? t1 : t0, x2);
                best_mask[1] = best_mask[1] | best << i2;
                next = i2;
                continue;
            }
            EncodeMB.nonZero(mb, type, tokens, next, i2);
        }
        EncodeMB.optimizeBsecond(mb, type, a10, l2, tokens, next, rdmult, i2, d2, dequant_ptr, qcoeff_ptr, dqcoeff_ptr, i0, eob, rddiv, best_mask);
    }

    private static void nonZero(Macroblock mb, PlaneType type, TokenState[][] tokens, int next, int i2) {
        int band = VP8Util.SubblockKeys.vp8CoefBands[i2 + 1];
        TokenAlphabet t0 = tokens[next][0].token;
        TokenAlphabet t1 = tokens[next][1].token;
        if (t0 != TokenAlphabet.DCT_EOB_TOKEN) {
            tokens[next][0].rate += mb.token_costs[type.ordinal()][band][0][t0.ordinal()];
            tokens[next][0].token = TokenAlphabet.ZERO_TOKEN;
        }
        if (t1 != TokenAlphabet.DCT_EOB_TOKEN) {
            tokens[next][1].rate += mb.token_costs[type.ordinal()][band][0][t1.ordinal()];
            tokens[next][1].token = TokenAlphabet.ZERO_TOKEN;
        }
    }

    private static void optimizeBsecond(Macroblock mb, PlaneType type, FullGetSetPointer a10, FullGetSetPointer l2, TokenState[][] tokens, int next, int rdmult, int i2, BlockD d2, GetPointer dequant_ptr, FullGetSetPointer qcoeff_ptr, FullGetSetPointer dqcoeff_ptr, int i0, int eob, int rddiv, int[] best_mask) {
        int rd_cost1;
        int band = VP8Util.SubblockKeys.vp8CoefBands[i2 + 1];
        int pt = a10.get() + l2.get();
        int rate0 = tokens[next][0].rate;
        int rate1 = tokens[next][1].rate;
        int error0 = tokens[next][0].error;
        int error1 = tokens[next][1].error;
        int rd_cost0 = EncodeMB.RDCOST(rdmult, rddiv, rate0 += mb.token_costs[type.ordinal()][band][pt][tokens[next][0].token.ordinal()], error0);
        if (rd_cost0 == (rd_cost1 = EncodeMB.RDCOST(rdmult, rddiv, rate1 += mb.token_costs[type.ordinal()][band][pt][tokens[next][1].token.ordinal()], error1))) {
            rd_cost0 = EncodeMB.RDTRUNC(rdmult, rate0);
            rd_cost1 = EncodeMB.RDTRUNC(rdmult, rate1);
        }
        int best = rd_cost1 < rd_cost0 ? 1 : 0;
        int final_eob = i0 - 1;
        i2 = next;
        while (i2 < eob) {
            int x2 = tokens[i2][best].qc;
            if (x2 != 0) {
                final_eob = i2;
            }
            int rc = WebpConst.zigzag[i2];
            qcoeff_ptr.setRel(rc, (short)x2);
            dqcoeff_ptr.setRel(rc, (short)(x2 * dequant_ptr.getRel(rc)));
            next = tokens[i2][best].next;
            best = best_mask[best] >> i2 & 1;
            i2 = next;
        }
        a10.set(l2.set((short)(++final_eob != type.start_coeff ? 1 : 0)));
        d2.eob.set((short)final_eob);
    }

    public static void check_reset_2nd_coeffs(MacroblockD x2, PlaneType type, FullGetSetPointer a10, FullGetSetPointer l2) {
        int i2;
        int sum = 0;
        BlockD bd2 = x2.block.getRel(24);
        if (bd2.dequant.get() >= 35 && bd2.dequant.get() >= 35) {
            return;
        }
        for (i2 = 0; i2 < bd2.eob.get(); ++i2) {
            short coef = bd2.dqcoeff.getRel(WebpConst.zigzag[i2]);
            if ((sum += coef >= 0 ? coef : -coef) < 35) continue;
            return;
        }
        for (i2 = 0; i2 < bd2.eob.get(); ++i2) {
            int rc = WebpConst.zigzag[i2];
            bd2.qcoeff.setRel(rc, (short)0);
            bd2.dqcoeff.setRel(rc, (short)0);
        }
        bd2.eob.set((short)0);
        a10.set(l2.set((short)(bd2.eob.get() != type.start_coeff ? 1 : 0)));
    }

    static void vp8_optimize_mby(Macroblock x2) {
        int b2;
        if (x2.e_mbd.above_context == null || x2.e_mbd.left_context == null) {
            return;
        }
        EntropyPlanes t_above = new EntropyPlanes(x2.e_mbd.above_context.get());
        EntropyPlanes t_left = new EntropyPlanes(x2.e_mbd.left_context);
        FullGetSetPointer ta = t_above.panes;
        FullGetSetPointer tl = t_left.panes;
        boolean has_2nd_order = x2.e_mbd.hasSecondOrder();
        PlaneType type = has_2nd_order ? PlaneType.Y_NO_DC : PlaneType.Y_WITH_DC;
        for (b2 = 0; b2 < 16; ++b2) {
            ta.setPos(BlockD.vp8_block2above[b2]);
            tl.setPos(BlockD.vp8_block2left[b2]);
            EncodeMB.optimize_b(x2, b2, type, ta, tl);
        }
        if (has_2nd_order) {
            b2 = 24;
            ta.setPos(BlockD.vp8_block2above[b2]);
            tl.setPos(BlockD.vp8_block2left[b2]);
            EncodeMB.optimize_b(x2, b2, PlaneType.Y2, ta, tl);
            EncodeMB.check_reset_2nd_coeffs(x2.e_mbd, PlaneType.Y2, ta, tl);
        }
    }

    static void vp8_subtract_mbuv(FullGetSetPointer diff, GetPointer usrc, GetPointer vsrc, int src_stride, GetPointer upred, GetPointer vpred, int pred_stride) {
        FullGetSetPointer udiff = diff.shallowCopyWithPosInc(256);
        FullGetSetPointer vdiff = diff.shallowCopyWithPosInc(320);
        EncodeMB.vpx_subtract_block(8, 8, udiff, 8, usrc, src_stride, upred, pred_stride);
        EncodeMB.vpx_subtract_block(8, 8, vdiff, 8, vsrc, src_stride, vpred, pred_stride);
    }

    static void vp8_transform_mbuv(Macroblock x2) {
        for (int i2 = 16; i2 < 24; i2 += 2) {
            x2.short_fdct8x4.call(x2.block.getRel((int)i2).src_diff, x2.block.getRel((int)i2).coeff, 16);
        }
    }

    static void vp8_optimize_mbuv(Macroblock x2) {
        if (x2.e_mbd.above_context.get() == null || x2.e_mbd.left_context == null) {
            return;
        }
        EntropyPlanes t_above = new EntropyPlanes(x2.e_mbd.above_context.get());
        EntropyPlanes t_left = new EntropyPlanes(x2.e_mbd.left_context);
        FullGetSetPointer ta = t_above.panes;
        FullGetSetPointer tl = t_left.panes;
        for (int b2 = 16; b2 < 24; ++b2) {
            ta.setPos(BlockD.vp8_block2above[b2]);
            tl.setPos(BlockD.vp8_block2left[b2]);
            EncodeMB.optimize_b(x2, b2, PlaneType.UV, ta, tl);
        }
    }
}

