/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.Block;
import com.idrsolutions.image.webp.enc.BlockD;
import com.idrsolutions.image.webp.enc.EncodeMB;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.IDCTllm;
import com.idrsolutions.image.webp.enc.Macroblock;
import com.idrsolutions.image.webp.enc.MacroblockD;
import com.idrsolutions.image.webp.enc.Quantize;
import com.idrsolutions.image.webp.enc.ReconIntra;

final class EncodeIntra {
    private EncodeIntra() {
    }

    static void vp8_encode_intra4x4block(Macroblock x2, int ib) {
        BlockD b2 = x2.e_mbd.block.getRel(ib);
        Block be2 = x2.block.getRel(ib);
        int dst_stride = x2.e_mbd.dst.y_stride;
        FullGetSetPointer dst = b2.getOffsetPointer(x2.e_mbd.dst.y_buffer);
        GetSetPointer Above = GetSetPointer.makePositionableAndInc(dst, -dst_stride);
        GetSetPointer yleft = GetSetPointer.makePositionableAndInc(dst, -1);
        short top_left = Above.getRel(-1);
        x2.recon.vp8_intra4x4_predict(Above, yleft, dst_stride, b2.bmi.as_mode(), b2.predictor, 16, top_left);
        EncodeMB.vp8_subtract_b(be2, b2);
        x2.short_fdct4x4.call(be2.src_diff, be2.coeff, 32);
        x2.quantize_b.call(be2, b2);
        if (b2.eob.get() > 1) {
            IDCTllm.vp8_short_idct4x4llm(b2.dqcoeff, b2.predictor, 16, dst, dst_stride);
        } else {
            IDCTllm.vp8_dc_only_idct_add(b2.dqcoeff.get(), b2.predictor, 16, dst, dst_stride);
        }
    }

    static void vp8_encode_intra4x4mby(Macroblock mb) {
        ReconIntra.intra_prediction_down_copy(mb.e_mbd);
        for (int i2 = 0; i2 < 16; ++i2) {
            EncodeIntra.vp8_encode_intra4x4block(mb, i2);
        }
    }

    static void vp8_encode_intra16x16mby(Macroblock x2) {
        Block b2 = x2.block.get();
        MacroblockD xd = x2.e_mbd;
        GetSetPointer above = GetSetPointer.makePositionableAndInc(xd.dst.y_buffer, -xd.dst.y_stride);
        GetSetPointer left = GetSetPointer.makePositionableAndInc(xd.dst.y_buffer, -1);
        x2.recon.vp8_build_intra_predictors_mby_s(xd, above, left, xd.dst.y_stride, xd.dst.y_buffer, xd.dst.y_stride);
        EncodeMB.vp8_subtract_mby(x2.src_diff, b2.base_src, b2.src_stride, xd.dst.y_buffer, xd.dst.y_stride);
        EncodeMB.vp8_transform_intra_mby(x2);
        Quantize.vp8_quantize_mby(x2);
        if (x2.optimize) {
            EncodeMB.vp8_optimize_mby(x2);
        }
    }

    static void vp8_encode_intra16x16mbuv(Macroblock x2) {
        MacroblockD xd = x2.e_mbd;
        GetSetPointer uab = GetSetPointer.makePositionableAndInc(xd.dst.u_buffer, -xd.dst.uv_stride);
        GetSetPointer vab = GetSetPointer.makePositionableAndInc(xd.dst.v_buffer, -xd.dst.uv_stride);
        GetSetPointer ulef = GetSetPointer.makePositionableAndInc(xd.dst.u_buffer, -1);
        GetSetPointer vlef = GetSetPointer.makePositionableAndInc(xd.dst.v_buffer, -1);
        x2.recon.vp8_build_intra_predictors_mbuv_s(xd, uab, vab, ulef, vlef, xd.dst.uv_stride, xd.dst.u_buffer, xd.dst.v_buffer, xd.dst.uv_stride);
        EncodeMB.vp8_subtract_mbuv(x2.src_diff, x2.src.u_buffer, x2.src.v_buffer, x2.src.uv_stride, xd.dst.u_buffer, xd.dst.v_buffer, xd.dst.uv_stride);
        EncodeMB.vp8_transform_mbuv(x2);
        Quantize.vp8_quantize_mbuv(x2);
        if (x2.optimize) {
            EncodeMB.vp8_optimize_mbuv(x2);
        }
    }
}

