/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.TokenAlphabet;
import com.idrsolutions.image.webp.enc.TokenValue;
import com.idrsolutions.image.webp.enc.TreeWriter;
import java.util.EnumSet;

final class DCTValueConstants {
    private static final int[] dct_value_cost = new int[4096];
    private static final TokenValue[] dct_value_tokens = new TokenValue[4096];

    private DCTValueConstants() {
    }

    static int getValueCost(int v2) {
        return dct_value_cost[2048 + v2];
    }

    static TokenValue getTokenValue(int v2) {
        return dct_value_tokens[2048 + v2];
    }

    static {
        int i2 = -2048;
        int sign = 1;
        do {
            int a10;
            if (i2 == 0) {
                sign = 0;
            }
            TokenAlphabet selected = null;
            int eb = sign;
            int n2 = a10 = sign != 0 ? -i2 : i2;
            if (a10 > 4) {
                for (TokenAlphabet ta : EnumSet.range(TokenAlphabet.DCT_VAL_CATEGORY1, TokenAlphabet.DCT_VAL_CATEGORY6)) {
                    if (ta.base_val > a10) break;
                    selected = ta;
                }
                if (selected != null) {
                    eb |= a10 - selected.base_val << 1;
                }
            } else {
                for (TokenAlphabet ta : EnumSet.range(TokenAlphabet.ZERO_TOKEN, TokenAlphabet.FOUR_TOKEN)) {
                    if (a10 == 0) {
                        selected = ta;
                    }
                    --a10;
                }
            }
            DCTValueConstants.dct_value_tokens[2048 + i2] = new TokenValue(selected, eb);
            int cost = 0;
            if (selected == null || selected.base_val == 0) continue;
            if (selected.len != 0) {
                cost += TreeWriter.vp8_treed_cost_short(selected.tree, selected.prob, eb >> 1, selected.len);
            }
            DCTValueConstants.dct_value_cost[2048 + i2] = cost += TreeWriter.vp8_cost_bit(128, eb & 1);
        } while (++i2 < 2048);
    }
}

