/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.IntraPredFN;
import com.idrsolutions.image.webp.enc.VP8Util;

class D45Predictor4x4Base
implements IntraPredFN {
    private final boolean avgCalc;

    D45Predictor4x4Base(boolean avgCalc) {
        this.avgCalc = avgCalc;
    }

    @Override
    public void call(FullGetSetPointer dst, int stride, GetPointer above, GetPointer left) {
        short A2 = above.getRel(0);
        short B2 = above.getRel(1);
        short C2 = above.getRel(2);
        short D2 = above.getRel(3);
        short E2 = above.getRel(4);
        short F2 = above.getRel(5);
        short G2 = above.getRel(6);
        short H2 = above.getRel(7);
        dst.set(VP8Util.avg3(A2, B2, C2));
        dst.setRel(1, dst.setRel(stride, VP8Util.avg3(B2, C2, D2)));
        dst.setRel(2, dst.setRel(1 + stride, dst.setRel(2 * stride, VP8Util.avg3(C2, D2, E2))));
        dst.setRel(3, dst.setRel(2 + stride, dst.setRel(1 + 2 * stride, dst.setRel(3 * stride, VP8Util.avg3(D2, E2, F2)))));
        dst.setRel(3 + stride, dst.setRel(2 + 2 * stride, dst.setRel(1 + 3 * stride, VP8Util.avg3(E2, F2, G2))));
        dst.setRel(3 + 2 * stride, dst.setRel(2 + 3 * stride, VP8Util.avg3(F2, G2, H2)));
        dst.setRel(3 + 3 * stride, this.avgCalc ? VP8Util.avg3(G2, H2, H2) : H2);
    }
}

