/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.GetPointer;
import com.idrsolutions.image.webp.enc.GetSetPointer;
import com.idrsolutions.image.webp.enc.IntraPredFN;
import com.idrsolutions.image.webp.enc.VP8Util;

class D135Predictor4x4
implements IntraPredFN {
    D135Predictor4x4() {
    }

    @Override
    public void call(FullGetSetPointer dst, int stride, GetPointer above, GetPointer left) {
        GetSetPointer pLeft = GetSetPointer.makePositionable(left);
        GetSetPointer pAbove = GetSetPointer.makePositionable(above);
        short I2 = pLeft.getAndInc();
        short J2 = pLeft.getAndInc();
        short K2 = pLeft.getAndInc();
        short L2 = pLeft.getAndInc();
        short X2 = pAbove.getRel(-1);
        short A2 = pAbove.getAndInc();
        short B2 = pAbove.getAndInc();
        short C2 = pAbove.getAndInc();
        short D2 = pAbove.getAndInc();
        dst.setRel(3 * stride, VP8Util.avg3(J2, K2, L2));
        dst.setRel(1 + 3 * stride, dst.setRel(2 * stride, VP8Util.avg3(I2, J2, K2)));
        dst.setRel(2 + 3 * stride, dst.setRel(1 + 2 * stride, dst.setRel(stride, VP8Util.avg3(X2, I2, J2))));
        dst.setRel(3 + 3 * stride, dst.setRel(2 + 2 * stride, dst.setRel(1 + stride, dst.set(VP8Util.avg3(A2, X2, I2)))));
        dst.setRel(3 + 2 * stride, dst.setRel(2 + stride, dst.setRel(1, VP8Util.avg3(B2, A2, X2))));
        dst.setRel(3 + stride, dst.setRel(2, VP8Util.avg3(C2, B2, A2)));
        dst.setRel(3, VP8Util.avg3(D2, C2, B2));
    }
}

