/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.CUtils;
import com.idrsolutions.image.webp.enc.CodecEncCfg;
import com.idrsolutions.image.webp.enc.CodecPkt;
import com.idrsolutions.image.webp.enc.CompressMode;
import com.idrsolutions.image.webp.enc.EndUsage;
import com.idrsolutions.image.webp.enc.ExtraCFG;
import com.idrsolutions.image.webp.enc.Rational;
import com.idrsolutions.image.webp.enc.TokenPartition;
import com.idrsolutions.image.webp.enc.Tuning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class Config {
    int Version;
    int Width;
    int Height;
    Rational timebase = Rational.ONE;
    int target_bandwidth;
    int noise_sensitivity;
    int Sharpness;
    private int cpu_used;
    int rc_max_intra_bitrate_pct;
    int gf_cbr_boost_pct;
    int screen_content_mode;
    CompressMode Mode = CompressMode.BESTQUALITY;
    boolean auto_key;
    int key_freq;
    int allow_lag;
    int lag_in_frames;
    EndUsage end_usage;
    int under_shoot_pct;
    int over_shoot_pct;
    long starting_buffer_level;
    long optimal_buffer_level;
    long maximum_buffer_size;
    long starting_buffer_level_in_ms;
    long optimal_buffer_level_in_ms;
    long maximum_buffer_size_in_ms;
    short fixed_q;
    short worst_allowed_q;
    short best_allowed_q;
    short cq_level;
    boolean allow_spatial_resampling;
    int resample_down_water_mark;
    int resample_up_water_mark;
    boolean allow_df;
    int drop_frames_water_mark;
    boolean play_alternate;
    int alt_freq;
    short alt_q;
    short key_q;
    short gold_q;
    TokenPartition token_partitions;
    int encode_breakout;
    boolean error_resilient_mode;
    int arnr_max_frames;
    int arnr_strength;
    int arnr_type;
    List<CodecPkt> output_pkt_list = new ArrayList<CodecPkt>();
    Tuning tuning;
    int number_of_layers;
    int[] target_bitrate = new int[16];
    int[] rate_decimator = new int[16];
    int periodicity;
    int[] layer_id = new int[16];

    private Config() {
    }

    Config(CodecEncCfg cfg, ExtraCFG vp8_cfg) {
        this.Version = cfg.getG_profile();
        this.Width = cfg.getG_w();
        this.Height = cfg.getG_h();
        this.timebase = cfg.getG_timebase();
        this.error_resilient_mode = cfg.isG_error_resilient();
        this.Mode = CompressMode.BESTQUALITY;
        this.allow_lag = 0;
        this.lag_in_frames = 0;
        this.allow_df = cfg.getRc_dropframe_thresh() > 0;
        this.drop_frames_water_mark = cfg.getRc_dropframe_thresh();
        this.allow_spatial_resampling = cfg.isRc_resize_allowed();
        this.resample_up_water_mark = cfg.getRc_resize_up_thresh();
        this.resample_down_water_mark = cfg.getRc_resize_down_thresh();
        switch (cfg.getRc_end_usage()) {
            case VPX_VBR: {
                this.end_usage = EndUsage.LOCAL_FILE_PLAYBACK;
                break;
            }
            case VPX_CBR: {
                this.end_usage = EndUsage.STREAM_FROM_SERVER;
                break;
            }
            case VPX_CQ: {
                this.end_usage = EndUsage.CONSTRAINED_QUALITY;
                break;
            }
            case VPX_Q: {
                this.end_usage = EndUsage.CONSTANT_QUALITY;
            }
        }
        this.target_bandwidth = cfg.getRc_target_bitrate();
        this.rc_max_intra_bitrate_pct = vp8_cfg.getRc_max_intra_bitrate_pct();
        this.gf_cbr_boost_pct = vp8_cfg.getGf_cbr_boost_pct();
        this.best_allowed_q = cfg.getRc_min_quantizer();
        this.worst_allowed_q = cfg.getRc_max_quantizer();
        this.cq_level = vp8_cfg.getCq_level();
        this.fixed_q = (short)-1;
        this.under_shoot_pct = cfg.getRc_undershoot_pct();
        this.over_shoot_pct = cfg.getRc_overshoot_pct();
        this.maximum_buffer_size_in_ms = cfg.getRc_buf_sz();
        this.starting_buffer_level_in_ms = cfg.getRc_buf_initial_sz();
        this.optimal_buffer_level_in_ms = cfg.getRc_buf_optimal_sz();
        this.maximum_buffer_size = cfg.getRc_buf_sz();
        this.starting_buffer_level = cfg.getRc_buf_initial_sz();
        this.optimal_buffer_level = cfg.getRc_buf_optimal_sz();
        this.auto_key = cfg.getKf_mode() == CodecEncCfg.vpx_kf_mode.VPX_KF_AUTO && cfg.getKf_min_dist() != cfg.getKf_max_dist();
        this.key_freq = cfg.getKf_max_dist();
        this.number_of_layers = cfg.getTs_number_layers();
        this.periodicity = cfg.getTs_periodicity();
        if (this.number_of_layers > 1) {
            CUtils.vp8_copy(cfg.getTs_target_bitrate(), this.target_bitrate);
            CUtils.vp8_copy(cfg.getTs_rate_decimator(), this.rate_decimator);
            CUtils.vp8_copy(cfg.getTs_layer_id(), this.layer_id);
        }
        this.encode_breakout = vp8_cfg.getStatic_thresh();
        this.play_alternate = vp8_cfg.isEnable_auto_alt_ref();
        this.noise_sensitivity = vp8_cfg.getNoise_sensitivity();
        this.Sharpness = vp8_cfg.getSharpness();
        this.token_partitions = vp8_cfg.getToken_partitions();
        this.output_pkt_list = vp8_cfg.getPkt_list();
        this.arnr_max_frames = vp8_cfg.getArnr_max_frames();
        this.arnr_strength = vp8_cfg.getArnr_strength();
        this.arnr_type = vp8_cfg.getArnr_type();
        this.tuning = vp8_cfg.getTuning();
        this.screen_content_mode = vp8_cfg.getScreen_content_mode();
        this.setCpu_used(vp8_cfg.getCpu_used());
    }

    Config copy() {
        Config n2 = new Config();
        n2.allow_df = this.allow_df;
        n2.allow_lag = this.allow_lag;
        n2.allow_spatial_resampling = this.allow_spatial_resampling;
        n2.alt_freq = this.alt_freq;
        n2.alt_q = this.alt_q;
        n2.arnr_max_frames = this.arnr_max_frames;
        n2.arnr_strength = this.arnr_strength;
        n2.arnr_type = this.arnr_type;
        n2.auto_key = this.auto_key;
        n2.best_allowed_q = this.best_allowed_q;
        n2.cpu_used = this.cpu_used;
        n2.cq_level = this.cq_level;
        n2.drop_frames_water_mark = this.drop_frames_water_mark;
        n2.encode_breakout = this.encode_breakout;
        n2.end_usage = this.end_usage;
        n2.error_resilient_mode = this.error_resilient_mode;
        n2.fixed_q = this.fixed_q;
        n2.gf_cbr_boost_pct = this.gf_cbr_boost_pct;
        n2.gold_q = this.gold_q;
        n2.Height = this.Height;
        n2.key_freq = this.key_freq;
        n2.key_q = this.key_q;
        n2.lag_in_frames = this.lag_in_frames;
        n2.layer_id = Arrays.copyOf(this.layer_id, this.layer_id.length);
        n2.maximum_buffer_size = this.maximum_buffer_size;
        n2.maximum_buffer_size_in_ms = this.maximum_buffer_size_in_ms;
        n2.Mode = this.Mode;
        n2.noise_sensitivity = this.noise_sensitivity;
        n2.number_of_layers = this.number_of_layers;
        n2.optimal_buffer_level = this.optimal_buffer_level;
        n2.optimal_buffer_level_in_ms = this.optimal_buffer_level_in_ms;
        n2.output_pkt_list = new ArrayList<CodecPkt>(this.output_pkt_list);
        n2.over_shoot_pct = this.over_shoot_pct;
        n2.periodicity = this.periodicity;
        n2.play_alternate = this.play_alternate;
        n2.rate_decimator = Arrays.copyOf(this.rate_decimator, this.rate_decimator.length);
        n2.rc_max_intra_bitrate_pct = this.rc_max_intra_bitrate_pct;
        n2.resample_down_water_mark = this.resample_down_water_mark;
        n2.resample_up_water_mark = this.resample_up_water_mark;
        n2.screen_content_mode = this.screen_content_mode;
        n2.Sharpness = this.Sharpness;
        n2.starting_buffer_level = this.starting_buffer_level;
        n2.starting_buffer_level_in_ms = this.starting_buffer_level_in_ms;
        n2.target_bandwidth = this.target_bandwidth;
        n2.target_bitrate = Arrays.copyOf(this.target_bitrate, this.target_bitrate.length);
        n2.timebase = this.timebase;
        n2.token_partitions = this.token_partitions;
        n2.tuning = this.tuning;
        n2.under_shoot_pct = this.under_shoot_pct;
        n2.Version = this.Version;
        n2.Width = this.Width;
        n2.worst_allowed_q = this.worst_allowed_q;
        return n2;
    }

    int getCpu_used() {
        return this.cpu_used;
    }

    void setCpu_used(short cpu_used) {
        short low = -16;
        short up = 16;
        if (this.Mode == CompressMode.GOODQUALITY) {
            low = -5;
            up = 5;
        }
        this.cpu_used = CUtils.clamp(cpu_used, low, up);
    }
}

