/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.enc;

import com.idrsolutions.image.webp.enc.EntropyPlanes;
import com.idrsolutions.image.webp.enc.FrameContext;
import com.idrsolutions.image.webp.enc.FrameFlags;
import com.idrsolutions.image.webp.enc.FullGenArrPointer;
import com.idrsolutions.image.webp.enc.FullGetSetPointer;
import com.idrsolutions.image.webp.enc.LoopFilterInfoN;
import com.idrsolutions.image.webp.enc.LoopFilterType;
import com.idrsolutions.image.webp.enc.MVReferenceFrame;
import com.idrsolutions.image.webp.enc.ModeInfo;
import com.idrsolutions.image.webp.enc.Scaling;
import com.idrsolutions.image.webp.enc.TokenPartition;
import com.idrsolutions.image.webp.enc.YV12buffer;
import java.util.EnumMap;
import java.util.EnumSet;

class CommonData {
    static final int NUM_YV12_BUFFERS = 4;
    final EnumMap<Quant, FullGetSetPointer[]> dequant = new EnumMap(Quant.class);
    int Width;
    int Height;
    static final Scaling horiz_scale = Scaling.NORMAL;
    static final Scaling vert_scale = Scaling.NORMAL;
    YV12buffer frame_to_show;
    final YV12buffer[] yv12_fb = new YV12buffer[4];
    final int[] fb_idx_ref_cnt = new int[4];
    final EnumMap<MVReferenceFrame, Integer> frameIdxs = new EnumMap(MVReferenceFrame.class);
    int new_fb_idx;
    int frame_type;
    boolean show_frame;
    EnumSet<FrameFlags> frame_flags;
    int MBs;
    int mb_rows;
    int mb_cols;
    int mode_info_stride;
    final boolean mb_no_coeff_skip;
    boolean no_lpf = false;
    boolean use_bilinear_mc_filter = false;
    boolean full_pixel = false;
    short base_qindex;
    final EnumMap<Quant, EnumMap<Comp, Short>> delta_q = new EnumMap(Quant.class);
    FullGenArrPointer<ModeInfo> mip;
    FullGenArrPointer<ModeInfo> mi;
    LoopFilterType filter_type;
    final LoopFilterInfoN lf_info;
    short filter_level;
    int last_sharpness_level;
    int sharpness_level;
    boolean refresh_last_frame = true;
    boolean refresh_golden_frame = false;
    boolean refresh_alt_ref_frame;
    int copy_buffer_to_gf = 0;
    int copy_buffer_to_arf = 0;
    boolean refresh_entropy_probs = true;
    final EnumMap<MVReferenceFrame, Boolean> ref_frame_sign_bias = new EnumMap(MVReferenceFrame.class);
    FullGenArrPointer<EntropyPlanes> above_context;
    final EntropyPlanes left_context = new EntropyPlanes();
    FrameContext lfc;
    FrameContext fc = new FrameContext();
    int current_video_frame;
    private byte version;
    TokenPartition multi_token_partition;

    CommonData() {
        this.mb_no_coeff_skip = true;
        this.filter_type = LoopFilterType.NORMAL;
        this.multi_token_partition = TokenPartition.ONE_PARTITION;
        this.lf_info = new LoopFilterInfoN(this);
        for (MVReferenceFrame rf : MVReferenceFrame.validFrames) {
            this.ref_frame_sign_bias.put(rf, false);
            this.frameIdxs.put(rf, 0);
        }
        for (Quant q2 : Quant.values()) {
            FullGetSetPointer[] temp = new FullGetSetPointer[128];
            for (int i2 = 0; i2 < temp.length; ++i2) {
                temp[i2] = new FullGetSetPointer(2);
            }
            this.dequant.put(q2, temp);
            EnumMap<Comp, Short> tempMap = new EnumMap<Comp, Short>(Comp.class);
            for (Comp c2 : Comp.values()) {
                tempMap.put(c2, (short)0);
            }
            this.delta_q.put(q2, tempMap);
        }
    }

    byte getVersion() {
        return this.version;
    }

    void setVersion(byte version) {
        this.version = version;
        this.vp8_setup_version();
    }

    void vp8_setup_version() {
        switch (this.version) {
            case 1: {
                this.no_lpf = false;
                this.filter_type = LoopFilterType.SIMPLE;
                this.use_bilinear_mc_filter = true;
                this.full_pixel = false;
                break;
            }
            case 2: {
                this.no_lpf = true;
                this.filter_type = LoopFilterType.NORMAL;
                this.use_bilinear_mc_filter = true;
                this.full_pixel = false;
                break;
            }
            case 3: {
                this.no_lpf = true;
                this.filter_type = LoopFilterType.SIMPLE;
                this.use_bilinear_mc_filter = true;
                this.full_pixel = true;
                break;
            }
            default: {
                this.no_lpf = false;
                this.filter_type = LoopFilterType.NORMAL;
                this.use_bilinear_mc_filter = false;
                this.full_pixel = false;
            }
        }
    }

    void vp8_alloc_frame_buffers(int width, int height) {
        int i2;
        this.vp8_de_alloc_frame_buffers();
        if ((width & 0xF) != 0) {
            width += 16 - (width & 0xF);
        }
        if ((height & 0xF) != 0) {
            height += 16 - (height & 0xF);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            this.fb_idx_ref_cnt[i2] = 0;
            this.yv12_fb[i2] = new YV12buffer(width, height);
            this.yv12_fb[i2].flags = EnumSet.noneOf(MVReferenceFrame.class);
        }
        this.new_fb_idx = 0;
        this.frameIdxs.clear();
        this.frameIdxs.put(MVReferenceFrame.LAST_FRAME, 1);
        this.frameIdxs.put(MVReferenceFrame.GOLDEN_FRAME, 2);
        this.frameIdxs.put(MVReferenceFrame.ALTREF_FRAME, 3);
        this.fb_idx_ref_cnt[0] = 1;
        this.fb_idx_ref_cnt[1] = 1;
        this.fb_idx_ref_cnt[2] = 1;
        this.fb_idx_ref_cnt[3] = 1;
        this.mb_rows = height >> 4;
        this.mb_cols = width >> 4;
        this.MBs = this.mb_rows * this.mb_cols;
        this.mode_info_stride = this.mb_cols + 1;
        this.mip = new FullGenArrPointer((this.mb_cols + 1) * (this.mb_rows + 1));
        for (i2 = 0; i2 < this.mip.size(); ++i2) {
            this.mip.setRel(i2, new ModeInfo());
        }
        this.mi = this.mip.shallowCopyWithPosInc(this.mode_info_stride + 1);
        this.above_context = new FullGenArrPointer(this.mb_cols);
        for (i2 = 0; i2 < this.mb_cols; ++i2) {
            this.above_context.setRel(i2, new EntropyPlanes());
        }
    }

    void vp8_de_alloc_frame_buffers() {
        this.above_context = null;
        this.mip = null;
    }

    static enum Comp {
        DC(0),
        AC(1);

        final int baseIndex;

        private Comp(int base) {
            this.baseIndex = base;
        }
    }

    static enum Quant {
        Y1,
        Y2,
        UV;

    }
}

