/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.data;

import com.idrsolutions.image.webp.data.WebpYUV;

class Picture {
    private final WebpYUV color;
    final int width;
    final int height;
    public final byte[][] data;
    private static final int MAX_PLANES = 3;

    Picture(int width, int height, byte[][] data, WebpYUV color) {
        this.width = width;
        this.height = height;
        this.data = data;
        this.color = color;
    }

    static Picture create() {
        WebpYUV colorSpace = WebpYUV.YUV420;
        int width = 16;
        int height = 16;
        int[] planeSizes = new int[3];
        for (int i2 = 0; i2 < colorSpace.nComp; ++i2) {
            int n2 = colorSpace.compPlane[i2];
            planeSizes[n2] = planeSizes[n2] + (16 >> colorSpace.compWidth[i2]) * (16 >> colorSpace.compHeight[i2]);
        }
        int nPlanes = 0;
        for (int i3 = 0; i3 < 3; ++i3) {
            nPlanes += planeSizes[i3] != 0 ? 1 : 0;
        }
        byte[][] data = new byte[nPlanes][];
        int plane = 0;
        for (int i4 = 0; i4 < 3; ++i4) {
            if (planeSizes[i4] == 0) continue;
            data[plane++] = new byte[planeSizes[i4]];
        }
        return new Picture(16, 16, data, colorSpace);
    }

    byte[] getPlaneData(int plane) {
        return this.data[plane];
    }

    final int getPlaneWidth(int plane) {
        return this.width >> this.color.compWidth[plane];
    }

    final int getPlaneHeight(int plane) {
        return this.height >> this.color.compHeight[plane];
    }
}

