/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.data;

import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.ByteWriter;
import com.idrsolutions.image.utility.DataWriter;
import com.idrsolutions.image.utility.PixGet;
import com.idrsolutions.image.utility.WriterByteLittle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jpedal.spotbugs.SuppressFBWarnings;
import org.jpedal.utils.LogWriter;

@SuppressFBWarnings
public final class EVP8L {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int ALPHA = 3;
    private static final int DELTA_RED = 4;
    private static final int DELTA_GREEN = 5;
    private static final int DELTA_BLUE = 6;
    private static final int DELTA_ALPHA = 7;
    private static final int RED_MINUS_GREEN = 8;
    private static final int BLUE_MINUS_GREEN = 9;
    private static final int DELTA_RED_MINUS_DELTA_GREEN = 10;
    private static final int DELTA_BLUE_MINUS_DELTA_GREEN = 11;
    private static final int PALETTE = 12;
    private static final int PREDICT_COUNT = 8;
    private static final int T_NOTHING = 0;
    private static final int T_PALETTE = 1;
    private static final int T_SUBGREEN = 2;
    private static final int T_PREDICT = 3;
    private static final int T_SUBGREEN_PREDICT = 4;
    private static final int T_COUNT = 5;
    private static final int[] DISTANCE_CODES = new int[]{96, 73, 55, 39, 23, 13, 5, 1, 255, 255, 255, 255, 255, 255, 255, 255, 101, 78, 58, 42, 26, 16, 8, 2, 0, 3, 9, 17, 27, 43, 59, 79, 102, 86, 62, 46, 32, 20, 10, 6, 4, 7, 11, 21, 33, 47, 63, 87, 105, 90, 70, 52, 37, 28, 18, 14, 12, 15, 19, 29, 38, 53, 71, 91, 110, 99, 82, 66, 48, 35, 30, 24, 22, 25, 31, 36, 49, 67, 83, 100, 115, 108, 94, 76, 64, 50, 44, 40, 34, 41, 45, 51, 65, 77, 95, 109, 118, 113, 103, 92, 80, 68, 60, 56, 54, 57, 61, 69, 81, 93, 104, 114, 119, 116, 111, 106, 97, 88, 84, 74, 72, 75, 85, 89, 98, 107, 112, 117};
    private static final int[] CODE_LENGTH_ORDER = new int[]{17, 18, 0, 1, 2, 3, 4, 5, 16, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int MAX_TRANSFORMBITS = 9;

    private EVP8L() {
    }

    public static void encode(BufferedImage image, OutputStream out) throws IOException {
        int[] pixels = EVP8L.getPixels(image);
        EBit b2 = new EBit();
        EVP8L.writeImageBitstream(b2, pixels, image.getWidth(), image.getHeight());
        b2.align();
        byte[] compressed = b2.byteBuffer.toArray();
        byte[] temp = new byte[compressed.length + 20];
        WriterByteLittle w2 = new WriterByteLittle(temp);
        EVP8L.writeContainer(w2, compressed);
        out.write(temp);
    }

    private static void writeImageBitstream(EBit b2, int[] image, int iw, int ih) {
        Analysis analysis = EVP8L.analyzeImage(image);
        EVP8L.writeHeader(b2, iw, ih, analysis.hasAlpha);
        if (analysis.paletteOrNull != null) {
            image = EVP8L.paletteTransform(b2, image, iw, ih, analysis.paletteOrNull);
        }
        if (analysis.useSubtractGreen) {
            image = EVP8L.subtractGreenTransform(b2, image);
        }
        if (analysis.usePredict) {
            image = EVP8L.predictTransform(b2, image, iw, ih);
        }
        b2.putBits(0, 1);
        EVP8L.writeImageData(b2, image, iw, ih, true, analysis.colorCacheBits);
    }

    private static void writeContainer(DataWriter w2, byte[] data) throws IOException {
        w2.write("RIFF".getBytes());
        w2.putU32(12 + data.length);
        w2.write("WEBP".getBytes());
        w2.write("VP8L".getBytes());
        w2.putU32(data.length);
        w2.write(data);
    }

    private static void writeHeader(EBit b2, int iw, int ih, boolean hasAlpha) {
        b2.putBits(47, 8);
        b2.putBits(iw - 1, 14);
        b2.putBits(ih - 1, 14);
        b2.putBits(hasAlpha ? 1 : 0, 1);
        b2.putBits(0, 3);
    }

    private static void writeImageData(EBit b2, int[] image, int iw, int ih, boolean isRecursive, int colCacheBits) {
        int i2;
        if (colCacheBits > 0) {
            if (colCacheBits > 11) {
                LogWriter.writeLog("color cache bits exceeds");
            }
            b2.putBits(1, 1);
            b2.putBits(colCacheBits, 4);
        } else {
            b2.putBits(0, 1);
        }
        if (isRecursive) {
            b2.putBits(0, 1);
        }
        int[] encodedLen = new int[]{0};
        int[] encoded = EVP8L.encodeImageData(image, iw, ih, colCacheBits, encodedLen);
        int eLen = encodedLen[0];
        int[][] histos = new int[][]{new int[280 + (colCacheBits > 0 ? 1 << colCacheBits : 0)], new int[256], new int[256], new int[256], new int[40]};
        for (int i3 = 0; i3 < eLen; ++i3) {
            int[] nArray = histos[0];
            int n2 = encoded[i3];
            nArray[n2] = nArray[n2] + 1;
            if (encoded[i3] < 256) {
                int[] nArray2 = histos[1];
                int n3 = encoded[i3 + 1];
                nArray2[n3] = nArray2[n3] + 1;
                int[] nArray3 = histos[2];
                int n4 = encoded[i3 + 2];
                nArray3[n4] = nArray3[n4] + 1;
                int[] nArray4 = histos[3];
                int n5 = encoded[i3 + 3];
                nArray4[n5] = nArray4[n5] + 1;
                i3 += 3;
                continue;
            }
            if (encoded[i3] >= 280) continue;
            int[] nArray5 = histos[4];
            int n6 = encoded[i3 + 2];
            nArray5[n6] = nArray5[n6] + 1;
            i3 += 3;
        }
        Code[][] codess = new Code[5][];
        for (i2 = 0; i2 < 5; ++i2) {
            Code[] codes = EVP8L.buildCodes(histos[i2], 16);
            EVP8L.writeCodeLengths(b2, codes);
            codess[i2] = codes;
        }
        for (i2 = 0; i2 < eLen; ++i2) {
            b2.putCode(codess[0][encoded[i2]]);
            if (encoded[i2] < 256) {
                b2.putCode(codess[1][encoded[i2 + 1]]);
                b2.putCode(codess[2][encoded[i2 + 2]]);
                b2.putCode(codess[3][encoded[i2 + 3]]);
                i2 += 3;
                continue;
            }
            if (encoded[i2] >= 280) continue;
            b2.putBits(encoded[i2 + 1], EVP8L.extraBits(encoded[i2] - 256));
            b2.putCode(codess[4][encoded[i2 + 2]]);
            b2.putBits(encoded[i2 + 3], EVP8L.extraBits(encoded[i2 + 2]));
            i2 += 3;
        }
    }

    private static int[] encodeImageData(int[] image, int iw, int ih, int colorCacheBits, int[] encodedLen) {
        ChainTable chainTable = new ChainTable();
        ColorCache colorCache = new ColorCache(colorCacheBits);
        int pixelCount = image.length;
        int maxLen = Math.min(4096, pixelCount);
        int[] encoded = new int[pixelCount * 4];
        int[] lengthExtra = new int[]{0};
        int[] distanceExtra = new int[]{0};
        int dim = iw * ih;
        int eLen = 0;
        for (int pix = 0; pix < pixelCount; ++pix) {
            int argb = image[pix];
            if (pix + 2 < pixelCount && dim == pixelCount) {
                Chain chain = chainTable.get(argb, image[pix + 1], image[pix + 2]);
                int longestIndex = 0;
                int longestLength = 0;
                for (int i2 = 0; i2 < 100 && chain != null && pix - chain.index <= 1048456; ++i2) {
                    int length = EVP8L.findMatchLen(image, pixelCount, pix, chain.index, maxLen);
                    if (length > longestLength) {
                        longestIndex = chain.index;
                        longestLength = length;
                    }
                    chain = chain.next;
                }
                if (longestLength > 2) {
                    int distanceCode = EVP8L.distanceCode(iw, pix - longestIndex);
                    int lengthSymbol = EVP8L.prefixCode(longestLength, lengthExtra);
                    int distanceSymbol = EVP8L.prefixCode(distanceCode, distanceExtra);
                    if (colorCache.isPresent) {
                        for (int i3 = 0; i3 < longestLength; ++i3) {
                            colorCache.insert(image[pix + i3]);
                        }
                    }
                    encoded[eLen++] = lengthSymbol + 256;
                    encoded[eLen++] = lengthExtra[0];
                    encoded[eLen++] = distanceSymbol;
                    encoded[eLen++] = distanceExtra[0];
                    pix += longestLength - 1;
                    continue;
                }
                chainTable.add(argb, image[pix + 1], image[pix + 2], pix);
            }
            int[] colorCacheIndex = new int[]{0};
            if (colorCache.isPresent && colorCache.lookup(argb, colorCacheIndex)) {
                encoded[eLen++] = colorCacheIndex[0] + 256 + 24;
                continue;
            }
            encoded[eLen++] = argb >> 8 & 0xFF;
            encoded[eLen++] = argb >> 16 & 0xFF;
            encoded[eLen++] = argb & 0xFF;
            encoded[eLen++] = argb >>> 24;
            if (!colorCache.isPresent) continue;
            colorCache.insert(argb);
        }
        encodedLen[0] = eLen;
        return encoded;
    }

    private static int findMatchLen(int[] image, int dim, int pix, int matchIndex, int maxLength) {
        int maxP;
        int i2;
        for (i2 = 0; pix + i2 < dim && i2 < maxLength && image[pix + i2] == image[maxP = matchIndex + i2]; ++i2) {
        }
        return i2;
    }

    private static int distanceCode(int iw, int dist) {
        int distY = dist / iw;
        int distX = dist - distY * iw;
        if (distX <= 8 && distY < 8) {
            return DISTANCE_CODES[distY * 16 + 8 - distX] + 1;
        }
        if (distX > iw - 8 && distY < 7) {
            return DISTANCE_CODES[(distY + 1) * 16 + 8 + (iw - distX)] + 1;
        }
        return dist + 120;
    }

    private static int prefixCode(int n2, int[] extra) {
        extra[0] = 0;
        if (n2 <= 5) {
            return n2 - 1;
        }
        int rem = n2 - 1;
        int shift = 0;
        while (rem > 3) {
            rem >>= 1;
            ++shift;
        }
        switch (rem) {
            case 2: {
                extra[0] = n2 - (2 << shift) - 1;
                return 2 + 2 * shift;
            }
            case 3: {
                extra[0] = n2 - (3 << shift) - 1;
                return 3 + 2 * shift;
            }
        }
        return 0;
    }

    private static int extraBits(int prefixCode) {
        return prefixCode < 4 ? 0 : prefixCode - 2 >> 1;
    }

    private static int[] getPixels(BufferedImage image) {
        PixGet pg = Access.getPixGet(image);
        int w2 = image.getWidth();
        int h2 = image.getHeight();
        int[] pixels = new int[w2 * h2];
        int p2 = 0;
        for (int y2 = 0; y2 < h2; ++y2) {
            for (int x2 = 0; x2 < w2; ++x2) {
                pixels[p2++] = pg.getARGB(x2, y2);
            }
        }
        return pixels;
    }

    private static void writeCodeLengths(EBit b2, Code[] codes) {
        ArrayList<Code> simpleCodes = new ArrayList<Code>();
        boolean allSimple = true;
        for (Code code : codes) {
            if (!code.present) continue;
            if (code.len > 1 || code.symbol > 255) {
                allSimple = false;
                break;
            }
            simpleCodes.add(code);
        }
        if (allSimple) {
            EVP8L.writeSimpleCodeLengths(b2, simpleCodes);
        } else {
            EVP8L.writeNormalCodeLengths(b2, codes);
        }
    }

    private static void writeSimpleCodeLengths(EBit b2, List<Code> codes) {
        b2.putBits(1, 1);
        if (codes.isEmpty()) {
            b2.putBits(0, 3);
            return;
        }
        b2.putBits(codes.size() - 1, 1);
        if (codes.get(0).symbol <= 1) {
            b2.putBits(0, 1);
            b2.putBits(codes.get(0).symbol, 1);
        } else {
            b2.putBits(1, 1);
            b2.putBits(codes.get(0).symbol, 8);
        }
        if (codes.size() > 1) {
            b2.putBits(codes.get(1).symbol, 8);
        }
    }

    private static void writeNormalCodeLengths(EBit b2, Code[] codes) {
        int i2;
        List<Integer> encodedLengths = EVP8L.encodeCodeLengths(codes);
        int[] lengthHisto = new int[19];
        for (int i3 = 0; i3 < encodedLengths.size(); ++i3) {
            int sym;
            int n2 = sym = encodedLengths.get(i3).intValue();
            lengthHisto[n2] = lengthHisto[n2] + 1;
            if (sym < 16) continue;
            ++i3;
        }
        Code[] lengthCodes = EVP8L.buildCodes(lengthHisto, 7);
        int lengthCodeCount = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            if (lengthHisto[CODE_LENGTH_ORDER[i2]] <= 0) continue;
            lengthCodeCount = i2 + 1;
        }
        if (lengthCodeCount < 4) {
            lengthCodeCount = 4;
        }
        b2.putBits(0, 1);
        b2.putBits(lengthCodeCount - 4, 4);
        for (i2 = 0; i2 < lengthCodeCount; ++i2) {
            b2.putBits(lengthCodes[CODE_LENGTH_ORDER[i2]].len, 3);
        }
        b2.putBits(0, 1);
        block8: for (int i4 = 0; i4 < encodedLengths.size(); ++i4) {
            int sym = encodedLengths.get(i4);
            b2.putCode(lengthCodes[sym]);
            switch (sym) {
                case 16: {
                    b2.putBits(encodedLengths.get(++i4), 2);
                    continue block8;
                }
                case 17: {
                    b2.putBits(encodedLengths.get(++i4), 3);
                    continue block8;
                }
                case 18: {
                    b2.putBits(encodedLengths.get(++i4), 7);
                    continue block8;
                }
            }
        }
    }

    private static List<Integer> encodeCodeLengths(Code[] codes) {
        ArrayList<Integer> lengthCodes = new ArrayList<Integer>();
        int lastLength = 8;
        for (int sym = 0; sym < codes.length; ++sym) {
            int streak;
            if (codes[sym].len == 0) {
                for (streak = 1; streak < 138 && sym + streak < codes.length && codes[sym + streak].len == 0; ++streak) {
                }
                if (streak >= 11) {
                    lengthCodes.add(18);
                    lengthCodes.add(streak - 11);
                    sym += streak - 1;
                    continue;
                }
                if (streak >= 3) {
                    lengthCodes.add(17);
                    lengthCodes.add(streak - 3);
                    sym += streak - 1;
                    continue;
                }
                lengthCodes.add(0);
                continue;
            }
            if (codes[sym].len == lastLength) {
                for (streak = 1; streak < 6 && sym + streak < codes.length && codes[sym + streak].len == lastLength; ++streak) {
                }
                if (streak >= 3) {
                    lengthCodes.add(16);
                    lengthCodes.add(streak - 3);
                    sym += streak - 1;
                    continue;
                }
            } else {
                lastLength = codes[sym].len;
            }
            lengthCodes.add(codes[sym].len);
        }
        return lengthCodes;
    }

    private static Code[] buildCodes(int[] histo, int maxLength) {
        Code[] codes = new Code[histo.length];
        for (int sym = 0; sym < histo.length; ++sym) {
            codes[sym] = new Code(sym);
        }
        Node tree = EVP8L.buildTree(histo, maxLength);
        if (!tree.isBranch) {
            int singletonSym = tree.leafSymbol;
            codes[singletonSym] = new Code(singletonSym, 0, 0);
            return codes;
        }
        EVP8L.assignCodeLengths(tree, 0, codes);
        Code[] sorted = new Code[codes.length];
        System.arraycopy(codes, 0, sorted, 0, sorted.length);
        Arrays.sort(sorted, new CodeComparer());
        int bits = 0;
        int length = 0;
        for (Code code : sorted) {
            if (!code.present) continue;
            length = code.len;
            codes[((Code)code).symbol] = new Code(code.symbol, bits <<= code.len - length, code.len);
            ++bits;
        }
        return codes;
    }

    private static Node buildTree(int[] histo, int maxLength) {
        int minWeight = EVP8L.sum(histo) >> maxLength - 2;
        EStack heap = new EStack(new NodeComparer());
        for (int sym = 0; sym < histo.length; ++sym) {
            int weight = histo[sym];
            if (weight == 0) continue;
            if (weight < minWeight) {
                weight = minWeight;
            }
            heap.add(new Node(sym, weight));
        }
        while (heap.arr.size() > 1) {
            Node n1 = heap.remove();
            Node n2 = heap.remove();
            heap.add(new Node(n1, n2));
        }
        if (!heap.arr.isEmpty()) {
            return heap.min();
        }
        return new Node(0, 0);
    }

    private static void assignCodeLengths(Node node, int depth, Code[] codes) {
        if (node.isBranch) {
            EVP8L.assignCodeLengths(node.left, depth + 1, codes);
            EVP8L.assignCodeLengths(node.right, depth + 1, codes);
        } else {
            codes[((Node)node).leafSymbol] = new Code(node.leafSymbol, 0, depth);
        }
    }

    private static Analysis analyzeImage(int[] pixels) {
        boolean[] hasAlpha = new boolean[]{false};
        Palette palette = EVP8L.createPalette(pixels);
        int[][] histos = EVP8L.computeHisto(pixels, palette, hasAlpha);
        double[] entropies = new double[histos.length];
        for (int i2 = 0; i2 < entropies.length; ++i2) {
            entropies[i2] = EVP8L.entropy(histos[i2]);
        }
        double[] transformEntropies = EVP8L.computeTransformEntropies(entropies);
        int best = 0;
        for (int i3 = 1; i3 < 5; ++i3) {
            if (i3 == 1 && palette == null || !(transformEntropies[i3] < transformEntropies[best])) continue;
            best = i3;
        }
        Analysis analysis = new Analysis();
        analysis.hasAlpha = hasAlpha[0];
        analysis.paletteOrNull = best == 1 ? palette : null;
        analysis.useSubtractGreen = best == 2 || best == 4;
        analysis.usePredict = best == 3 || best == 4;
        analysis.colorCacheBits = 0;
        return analysis;
    }

    private static int sum(int[] bins) {
        int sum = 0;
        for (int x2 : bins) {
            sum += x2;
        }
        return sum;
    }

    private static double entropy(int[] bins) {
        double sum = EVP8L.sum(bins);
        if (sum == 0.0) {
            return 0.0;
        }
        double logSum = Math.log(sum);
        double sumLogs = 0.0;
        for (int x2 : bins) {
            if (x2 == 0) continue;
            sumLogs += (double)x2 * (Math.log(x2) - logSum);
        }
        return -sumLogs / sum / Math.log(2.0);
    }

    private static int[][] computeHisto(int[] pixels, Palette palette, boolean[] hasAlpha) {
        int[][] histos = new int[13][256];
        long previous = -16777216L;
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int v2 = pixels[i2];
            int a10 = v2 >>> 24;
            int r2 = v2 >> 16 & 0xFF;
            int g2 = v2 >> 8 & 0xFF;
            int b2 = v2 & 0xFF;
            if (a10 != 255) {
                hasAlpha[0] = true;
            }
            long vl = (long)v2 & 0xFFFFFFFFL;
            int d2 = (int)(vl - previous);
            previous = vl;
            int[] nArray = histos[0];
            int n2 = r2;
            nArray[n2] = nArray[n2] + 1;
            int[] nArray2 = histos[1];
            int n3 = g2;
            nArray2[n3] = nArray2[n3] + 1;
            int[] nArray3 = histos[2];
            int n4 = b2;
            nArray3[n4] = nArray3[n4] + 1;
            int[] nArray4 = histos[3];
            int n5 = a10;
            nArray4[n5] = nArray4[n5] + 1;
            int da = d2 >>> 24;
            int dr = d2 >> 16 & 0xFF;
            int dg = d2 >> 8 & 0xFF;
            int db = d2 & 0xFF;
            int[] nArray5 = histos[4];
            int n6 = dr;
            nArray5[n6] = nArray5[n6] + 1;
            int[] nArray6 = histos[5];
            int n7 = dg;
            nArray6[n7] = nArray6[n7] + 1;
            int[] nArray7 = histos[6];
            int n8 = db;
            nArray7[n8] = nArray7[n8] + 1;
            int[] nArray8 = histos[7];
            int n9 = da;
            nArray8[n9] = nArray8[n9] + 1;
            int[] nArray9 = histos[8];
            int n10 = r2 - g2 & 0xFF;
            nArray9[n10] = nArray9[n10] + 1;
            int[] nArray10 = histos[9];
            int n11 = b2 - g2 & 0xFF;
            nArray10[n11] = nArray10[n11] + 1;
            int[] nArray11 = histos[10];
            int n12 = dr - dg & 0xFF;
            nArray11[n12] = nArray11[n12] + 1;
            int[] nArray12 = histos[11];
            int n13 = db - dg & 0xFF;
            nArray12[n13] = nArray12[n13] + 1;
            if (palette == null) continue;
            int[] nArray13 = histos[12];
            int n14 = (Integer)palette.indices.get(v2);
            nArray13[n14] = nArray13[n14] + 1;
        }
        return histos;
    }

    private static double[] computeTransformEntropies(double[] entropies) {
        return new double[]{entropies[0] + entropies[1] + entropies[2] + entropies[3], entropies[12], entropies[8] + entropies[1] + entropies[9] + entropies[3], entropies[4] + entropies[5] + entropies[6] + entropies[7], entropies[10] + entropies[5] + entropies[11] + entropies[7]};
    }

    private static Palette createPalette(int[] pixels) {
        Palette palette = new Palette();
        for (int v2 : pixels) {
            if (palette.indices.containsKey(v2)) continue;
            palette.indices.put(v2, palette.colors.size());
            palette.colors.add(v2);
            if (palette.colors.size() <= 256) continue;
            return null;
        }
        return palette;
    }

    private static int deduct(int ip, int pp) {
        int a10 = (ip >>> 24) - (pp >>> 24) & 0xFF;
        int r2 = (ip >> 16 & 0xFF) - (pp >> 16 & 0xFF) & 0xFF;
        int g2 = (ip >> 8 & 0xFF) - (pp >> 8 & 0xFF) & 0xFF;
        int b2 = (ip & 0xFF) - (pp & 0xFF) & 0xFF;
        return a10 << 24 | r2 << 16 | g2 << 8 | b2;
    }

    private static int[] paletteTransform(EBit b2, int[] image, int iw, int ih, Palette palette) {
        b2.putBits(1, 1);
        b2.putBits(3, 2);
        EVP8L.writePalette(b2, palette);
        int pc = palette.colors.size();
        int packSize = pc <= 2 ? 8 : (pc <= 4 ? 4 : (pc <= 16 ? 2 : 1));
        int packedWidth = (iw + packSize - 1) / packSize;
        int[] palettized = new int[packedWidth * ih];
        for (int y2 = 0; y2 < ih; ++y2) {
            for (int i2 = 0; i2 < packedWidth; ++i2) {
                int x2;
                int pack = 0;
                for (int j2 = 0; j2 < packSize && (x2 = i2 * packSize + j2) < iw; ++j2) {
                    int colorIndex = (Integer)palette.indices.get(image[x2 + y2 * iw]);
                    pack |= colorIndex << j2 * (8 / packSize);
                }
                palettized[i2 + packedWidth * y2] = 0xFF000000 | pack << 8;
            }
        }
        return palettized;
    }

    private static void writePalette(EBit b2, Palette palette) {
        int iw = palette.colors.size();
        boolean ih = true;
        int[] image = new int[iw * 1];
        for (int i2 = 0; i2 < iw; ++i2) {
            image[i2] = i2 == 0 ? (Integer)palette.colors.get(0) : EVP8L.deduct((Integer)palette.colors.get(i2), (Integer)palette.colors.get(i2 - 1));
        }
        b2.putBits(iw - 1, 8);
        EVP8L.writeImageData(b2, image, iw, 1, false, 0);
    }

    private static int[] subtractGreenTransform(EBit bw, int[] image) {
        bw.putBits(1, 1);
        bw.putBits(2, 2);
        for (int i2 = 0; i2 < image.length; ++i2) {
            int v2 = image[i2];
            int a10 = v2 >>> 24;
            int r2 = v2 >> 16 & 0xFF;
            int g2 = v2 >> 8 & 0xFF;
            int b2 = v2 & 0xFF;
            int r_g = r2 - g2;
            int b_g = b2 - g2;
            image[i2] = v2 = a10 << 24 | (r_g & 0xFF) << 16 | g2 << 8 | b_g & 0xFF;
        }
        return image;
    }

    private static int[] predictTransform(EBit b2, int[] image, int iw, int ih) {
        b2.putBits(1, 1);
        b2.putBits(0, 2);
        int tileBits = 9;
        int tileSize = 512;
        int blockedWidth = (iw + 512 - 1) / 512;
        int blockedHeight = (ih + 512 - 1) / 512;
        b2.putBits(7, 3);
        int[] blocks = new int[blockedWidth * blockedHeight];
        int[] residuals = new int[iw * ih];
        int[][] accumHistos = new int[4][256];
        for (int y2 = 0; y2 < blockedHeight; ++y2) {
            for (int x2 = 0; x2 < blockedWidth; ++x2) {
                int bestPrediction = 0;
                double bestEntropy = EVP8L.predictEntropy(image, iw, ih, 9, x2, y2, 0, accumHistos);
                for (int i2 = 1; i2 < 8; ++i2) {
                    double entropy = EVP8L.predictEntropy(image, iw, ih, 9, x2, y2, i2, accumHistos);
                    if (!(entropy < bestEntropy)) continue;
                    bestPrediction = i2;
                    bestEntropy = entropy;
                }
                blocks[x2 + y2 * blockedWidth] = 0xFF000000 | bestPrediction << 8;
                EVP8L.predictBlock(image, iw, ih, residuals, 9, x2, y2, bestPrediction, accumHistos);
            }
        }
        EVP8L.writeImageData(b2, blocks, blockedWidth, blockedHeight, false, 0);
        return residuals;
    }

    private static double predictEntropy(int[] image, int iw, int height, int tileBits, int tileX, int tileY, int prediction, int[][] histos) {
        int maxX = Math.min(tileX + 1 << tileBits, iw);
        int maxY = Math.min(tileY + 1 << tileBits, height);
        for (int x2 = tileX << tileBits; x2 < maxX; ++x2) {
            for (int y2 = tileY << tileBits; y2 < maxY; ++y2) {
                int ip = image[x2 + y2 * iw];
                int pp = EVP8L.predict(image, iw, x2, y2, prediction);
                int da = (ip >>> 24) - (pp >>> 24) & 0xFF;
                int dr = (ip >> 16 & 0xFF) - (pp >> 16 & 0xFF) & 0xFF;
                int dg = (ip >> 8 & 0xFF) - (pp >> 8 & 0xFF) & 0xFF;
                int db = (ip & 0xFF) - (pp & 0xFF) & 0xFF;
                int[] nArray = histos[0];
                int n2 = dr;
                nArray[n2] = nArray[n2] + 1;
                int[] nArray2 = histos[1];
                int n3 = dg;
                nArray2[n3] = nArray2[n3] + 1;
                int[] nArray3 = histos[2];
                int n4 = db;
                nArray3[n4] = nArray3[n4] + 1;
                int[] nArray4 = histos[3];
                int n5 = da;
                nArray4[n5] = nArray4[n5] + 1;
            }
        }
        double sum = 0.0;
        for (int[] histo : histos) {
            sum += EVP8L.entropy(histo);
        }
        return sum;
    }

    private static void predictBlock(int[] image, int iw, int ih, int[] residuals, int tileBits, int tileX, int tileY, int prediction, int[][] histos) {
        int maxX = Math.min(tileX + 1 << tileBits, iw);
        int maxY = Math.min(tileY + 1 << tileBits, ih);
        for (int x2 = tileX << tileBits; x2 < maxX; ++x2) {
            for (int y2 = tileY << tileBits; y2 < maxY; ++y2) {
                int ip = image[x2 + y2 * iw];
                int pp = EVP8L.predict(image, iw, x2, y2, prediction);
                int da = (ip >>> 24) - (pp >>> 24) & 0xFF;
                int dr = (ip >> 16 & 0xFF) - (pp >> 16 & 0xFF) & 0xFF;
                int dg = (ip >> 8 & 0xFF) - (pp >> 8 & 0xFF) & 0xFF;
                int db = (ip & 0xFF) - (pp & 0xFF) & 0xFF;
                int[] nArray = histos[0];
                int n2 = dr;
                nArray[n2] = nArray[n2] + 1;
                int[] nArray2 = histos[1];
                int n3 = dg;
                nArray2[n3] = nArray2[n3] + 1;
                int[] nArray3 = histos[2];
                int n4 = db;
                nArray3[n4] = nArray3[n4] + 1;
                int[] nArray4 = histos[3];
                int n5 = da;
                nArray4[n5] = nArray4[n5] + 1;
                residuals[x2 + y2 * iw] = da << 24 | dr << 16 | dg << 8 | db;
            }
        }
    }

    private static int predict(int[] image, int iw, int x2, int y2, int pred) {
        if (x2 == 0 && y2 == 0) {
            return -16777216;
        }
        if (x2 == 0) {
            return image[x2 + (y2 - 1) * iw];
        }
        if (y2 == 0) {
            return image[x2 - 1 + iw * y2];
        }
        int i2 = y2 * iw + x2;
        int top = image[i2 - iw];
        int left = image[i2 - 1];
        int topLeft = image[i2 - iw - 1];
        int topRight = image[i2 - iw + 1];
        return EVP8L.predictSelect(pred, top, left, topLeft, topRight);
    }

    private static int predictSelect(int type, int top, int left, int topLeft, int topRight) {
        switch (type) {
            case 0: {
                return -16777216;
            }
            case 1: {
                return left;
            }
            case 2: {
                return top;
            }
            case 3: {
                return topRight;
            }
            case 4: {
                return topLeft;
            }
            case 5: {
                return EVP8L.average3(left, top, topRight);
            }
            case 6: {
                return EVP8L.average2(left, topLeft);
            }
            case 7: {
                return EVP8L.average2(left, top);
            }
            case 8: {
                return EVP8L.average2(topLeft, top);
            }
            case 9: {
                return EVP8L.average2(top, topRight);
            }
        }
        return 0;
    }

    private static int average2(int a10, int b2) {
        int xa = (a10 >>> 24) + (b2 >>> 24) >> 1;
        int xr = (a10 >> 16 & 0xFF) + (b2 >> 16 & 0xFF) >> 1;
        int xg = (a10 >> 8 & 0xFF) + (b2 >> 8 & 0xFF) >> 1;
        int xb = (a10 & 0xFF) + (b2 & 0xFF) >> 1;
        return xa << 24 | xr << 16 | xg << 8 | xb;
    }

    private static int average3(int a02, int a12, int a22) {
        return EVP8L.average2(EVP8L.average2(a02, a22), a12);
    }

    private static class EBit {
        private final ByteWriter byteBuffer = new ByteWriter();
        private int buffer;
        private int bufferLen;

        private EBit() {
        }

        private void putBits(int bits, int count) {
            this.put();
            this.buffer |= bits << this.bufferLen;
            this.bufferLen += count;
        }

        private void putCode(Code code) {
            int i2 = code.len;
            while (i2-- > 0) {
                this.putBits((code.bits & 1 << i2) == 0 ? 0 : 1, 1);
            }
        }

        private void align() {
            this.bufferLen = this.bufferLen + 7 & 0xFFFFFFF8;
            this.put();
            if (this.byteBuffer.bp % 2 != 0) {
                this.byteBuffer.putU8(0);
            }
        }

        private void put() {
            while (this.bufferLen >= 8) {
                this.byteBuffer.putU8(this.buffer & 0xFF);
                this.buffer >>>= 8;
                this.bufferLen -= 8;
            }
        }
    }

    private static class CodeComparer
    implements Comparator<Code> {
        private CodeComparer() {
        }

        @Override
        public int compare(Code c1, Code c2) {
            return c1.len == c2.len ? c1.symbol - c2.symbol : c1.len - c2.len;
        }
    }

    private static final class Code {
        private final boolean present;
        private final int symbol;
        private final int bits;
        private final int len;

        private Code(int sym) {
            this.present = false;
            this.symbol = sym;
            this.bits = 0;
            this.len = 0;
        }

        private Code(int sym, int bits, int length) {
            this.present = true;
            this.symbol = sym;
            this.bits = bits;
            this.len = length;
        }
    }

    private static class EStack {
        private final ArrayList<Node> arr = new ArrayList();
        private final NodeComparer comparer;

        EStack(NodeComparer comparer) {
            this.comparer = comparer;
        }

        private void add(Node n2) {
            this.arr.add(n2);
            this.sortUp(this.arr.size() - 1);
        }

        private Node remove() {
            Node min = this.arr.get(0);
            Node temp = this.arr.get(this.arr.size() - 1);
            this.arr.set(0, temp);
            this.arr.remove(this.arr.size() - 1);
            this.sortDown(0);
            return min;
        }

        private Node min() {
            return this.arr.get(0);
        }

        private void sortUp(int idx) {
            if (idx <= 0) {
                return;
            }
            int parentIdx = (idx - 1) / 2;
            Node elem = this.arr.get(idx);
            Node parent = this.arr.get(parentIdx);
            if (this.comparer.compare(parent, elem) > 0) {
                this.arr.set(parentIdx, elem);
                this.arr.set(idx, parent);
                this.sortUp(parentIdx);
            }
        }

        private void sortDown(int idx) {
            Node left;
            if (idx >= this.arr.size()) {
                return;
            }
            Node elem = this.arr.get(idx);
            int leftIdx = idx * 2 + 1;
            int rightIdx = idx * 2 + 2;
            if (rightIdx < this.arr.size()) {
                Node right;
                Node left2 = this.arr.get(leftIdx);
                if (this.comparer.compare(left2, right = this.arr.get(rightIdx)) < 0) {
                    if (this.comparer.compare(elem, left2) > 0) {
                        this.arr.set(leftIdx, elem);
                        this.arr.set(idx, left2);
                        this.sortDown(leftIdx);
                    }
                } else if (this.comparer.compare(elem, right) > 0) {
                    this.arr.set(rightIdx, elem);
                    this.arr.set(idx, right);
                    this.sortDown(rightIdx);
                }
            } else if (rightIdx == this.arr.size() && this.comparer.compare(elem, left = this.arr.get(leftIdx)) > 0) {
                this.arr.set(idx, left);
                this.arr.set(leftIdx, elem);
            }
        }
    }

    private static class NodeComparer {
        private NodeComparer() {
        }

        private int compare(Node n1, Node n2) {
            return n1.weight - n2.weight;
        }
    }

    private static class ColorCache {
        private int bits;
        private int[] arr;
        private final boolean isPresent;

        ColorCache(int bits) {
            this.bits = bits;
            this.arr = new int[1 << bits];
            this.isPresent = bits > 0;
        }

        private boolean lookup(int color, int[] index) {
            if (this.bits <= 0) {
                index[0] = 0;
                return false;
            }
            index[0] = this.index(color);
            return this.arr[index[0]] == color;
        }

        private void insert(int color) {
            if (this.bits > 0) {
                this.arr[this.index((int)color)] = color;
            }
        }

        private int index(int color) {
            return color * 506832829 >> 32 - this.bits;
        }
    }

    private static class Node {
        private final boolean isBranch;
        private final int weight;
        private int leafSymbol;
        private Node left;
        private Node right;

        Node(int symbol, int weight) {
            this.isBranch = false;
            this.weight = weight;
            this.leafSymbol = symbol;
        }

        Node(Node left, Node right) {
            this.isBranch = true;
            this.weight = left.weight + right.weight;
            this.left = left;
            this.right = right;
        }
    }

    private static class Palette {
        private final List<Integer> colors = new ArrayList<Integer>();
        private final HashMap<Integer, Integer> indices = new HashMap();

        private Palette() {
        }
    }

    private static class ChainTable {
        private final Chain[] chains = new Chain[16];
        private int count;

        private ChainTable() {
        }

        private Chain get(int a12, int a22, int a32) {
            for (Chain chain : this.chains) {
                if (chain == null || !chain.equals(a12, a22, a32)) continue;
                return chain;
            }
            return null;
        }

        private void add(int a12, int a22, int a32, int index) {
            for (Chain chain : this.chains) {
                if (chain == null || !chain.equals(a12, a22, a32)) continue;
                this.count = this.count + 1 & 0xF;
                this.chains[this.count] = new Chain(chain, index, a12, a22, a32);
                return;
            }
            this.count = this.count + 1 & 0xF;
            this.chains[this.count] = new Chain(null, index, a12, a22, a32);
        }
    }

    private static class Chain {
        private Chain next;
        private int index;
        private final int c1;
        private final int c2;
        private final int c3;

        Chain(Chain next, int index, int c1, int c2, int c3) {
            this.next = next;
            this.index = index;
            this.c1 = c1;
            this.c2 = c2;
            this.c3 = c3;
        }

        boolean equals(int t1, int t2, int t3) {
            return this.c1 == t1 && this.c2 == t2 && this.c3 == t3;
        }
    }

    private static class Analysis {
        private boolean hasAlpha;
        private boolean useSubtractGreen;
        private boolean usePredict;
        private Palette paletteOrNull;
        private int colorCacheBits;

        private Analysis() {
        }
    }
}

