/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.data;

import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import com.idrsolutions.image.utility.WriterByteLittle;
import com.idrsolutions.image.webp.data.BitEncoder;
import com.idrsolutions.image.webp.data.EBool;
import com.idrsolutions.image.webp.data.EQuantizer;
import com.idrsolutions.image.webp.data.LBuffer;
import com.idrsolutions.image.webp.data.LookUp;
import com.idrsolutions.image.webp.data.Picture;
import com.idrsolutions.image.webp.data.Transform;
import com.idrsolutions.image.webp.data.Util;
import com.idrsolutions.image.webp.data.WebpYUV;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class EVP8 {
    private BitEncoder bitstream;
    private byte[][] leftRow;
    private byte[][] topLine;
    private final int[] tmp = new int[16];

    public static void encode(BufferedImage bImg, OutputStream out, int qp) throws IOException {
        int dim;
        int len;
        LBuffer buf;
        EVP8 enc = new EVP8();
        Picture pic = EVP8.getPictureFromBuffer(bImg);
        int frameSize = enc.encodeFrame(pic, buf = new LBuffer(new byte[len = Math.max(512, (dim = bImg.getWidth() * bImg.getHeight()) * 3)]), qp);
        int frameAdd = frameSize % 2 != 0 ? frameSize + 1 : frameSize;
        byte[] temp = new byte[frameAdd];
        System.arraycopy(buf.data, 0, temp, 0, frameAdd);
        int dataLen = 20 + frameAdd;
        byte[] data = new byte[dataLen];
        WriterByteLittle endian = new WriterByteLittle(data);
        endian.write("RIFF".getBytes());
        endian.putU32(data.length - 8);
        endian.write("WEBP".getBytes());
        endian.write("VP8 ".getBytes());
        endian.putU32(frameAdd);
        endian.write(temp);
        out.write(data);
    }

    private static Picture getPictureFromBuffer(BufferedImage img) {
        int b2;
        int g2;
        int r2;
        int p2;
        int x2;
        int y2;
        int w2 = img.getWidth();
        int h2 = img.getHeight();
        int dim = w2 * h2;
        int strideC = w2 / 2;
        int cw = (w2 + 1) / 2;
        int ch = (h2 + 1) / 2;
        byte[][] data = new byte[][]{new byte[dim], new byte[ch * cw], new byte[ch * cw]};
        PixGet pg = Access.getPixGet(img);
        for (y2 = 0; y2 < h2; ++y2) {
            for (x2 = 0; x2 < w2; ++x2) {
                p2 = pg.getRGB(x2, y2);
                r2 = p2 >> 16 & 0xFF;
                g2 = p2 >> 8 & 0xFF;
                b2 = p2 & 0xFF;
                data[0][y2 * w2 + x2] = (byte)((128 + 66 * r2 + 129 * g2 + 25 * b2 >> 8) - 112);
            }
        }
        for (y2 = 0; y2 < h2; y2 += 2) {
            for (x2 = 0; x2 < w2; x2 += 2) {
                p2 = pg.getRGB(x2, y2);
                r2 = p2 >> 16 & 0xFF;
                g2 = p2 >> 8 & 0xFF;
                b2 = p2 & 0xFF;
                p2 = y2 / 2 * strideC + x2 / 2;
                data[1][p2] = (byte)(128 - 38 * r2 - 74 * g2 + 112 * b2 >> 8);
                data[2][p2] = (byte)(128 + 112 * r2 - 94 * g2 - 18 * b2 >> 8);
            }
        }
        return new Picture(w2, h2, data, WebpYUV.YUV420);
    }

    private EVP8() {
    }

    private int encodeFrame(Picture pic, LBuffer out, int qp) {
        int mbWidth = pic.width + 15 >> 4;
        int mbHeight = pic.height + 15 >> 4;
        this.bitstream = new BitEncoder(mbWidth);
        this.leftRow = new byte[][]{new byte[16], new byte[8], new byte[8]};
        this.topLine = new byte[][]{new byte[mbWidth << 4], new byte[mbWidth << 3], new byte[mbWidth << 3]};
        EVP8.initValue(this.leftRow, (byte)-127);
        EVP8.initValue(this.topLine, (byte)127);
        Picture outMB = Picture.create();
        EVP8.writeHeader1(out, pic.width, pic.height);
        int start = out.position();
        EBool boolEnc = new EBool(out);
        EVP8.writeHeader2(boolEnc, qp);
        for (int mbY = 0; mbY < mbHeight; ++mbY) {
            for (int mbX = 0; mbX < mbWidth; ++mbX) {
                boolEnc.writeBit(145, 1);
                boolEnc.writeBit(156, 0);
                boolEnc.writeBit(163, 0);
                boolEnc.writeBit(142, 0);
            }
        }
        boolEnc.stop();
        int firstPart = out.position() - start;
        boolEnc = new EBool(out);
        for (int mbY = 0; mbY < mbHeight; ++mbY) {
            EVP8.initValue(this.leftRow, (byte)-127);
            for (int mbX = 0; mbX < mbWidth; ++mbX) {
                this.luma(pic, mbX, mbY, boolEnc, qp, outMB);
                this.chroma(pic, mbX, mbY, boolEnc, qp, outMB);
                this.collectPredictors(outMB, mbX);
            }
        }
        boolEnc.stop();
        int length = out.position();
        out.position(0);
        EVP8.writeHeader(out, firstPart);
        out.position(length);
        return length;
    }

    private static void writeHeader(LBuffer duplicate, int firstPart) {
        boolean showFrame = true;
        int header = firstPart << 5 | 0x10;
        duplicate.put((byte)(header & 0xFF));
        duplicate.put((byte)(header >> 8 & 0xFF));
        duplicate.put((byte)(header >> 16 & 0xFF));
    }

    private static void writeHeader1(LBuffer out, int width, int height) {
        out.put(new byte[]{0, 0, 0});
        out.put((byte)-99);
        out.put((byte)1);
        out.put((byte)42);
        out.putShort((short)width);
        out.putShort((short)height);
    }

    private static void initValue(byte[][] leftRow2, byte val) {
        Arrays.fill(leftRow2[0], val);
        Arrays.fill(leftRow2[1], val);
        Arrays.fill(leftRow2[2], val);
    }

    private static void writeHeader2(EBool boolEnc, int qp) {
        int[][][][] probFlags;
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        EVP8.writeInt(boolEnc, 1, 6);
        EVP8.writeInt(boolEnc, 0, 3);
        boolEnc.writeBit(128, 0);
        EVP8.writeInt(boolEnc, 0, 2);
        EVP8.writeInt(boolEnc, qp, 7);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        int[][][][] nArray = probFlags = LookUp.tokenProbUpdateFlagProbs;
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int[][][] probFlag;
            int[][][] nArray2 = probFlag = nArray[i2];
            int n3 = nArray2.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                int[][] ints;
                int[][] nArray3 = ints = nArray2[i3];
                int n4 = nArray3.length;
                for (int i4 = 0; i4 < n4; ++i4) {
                    int[] anInt;
                    for (int i5 : anInt = nArray3[i4]) {
                        boolEnc.writeBit(i5, 0);
                    }
                }
            }
        }
        boolEnc.writeBit(128, 0);
    }

    private static void writeInt(EBool boolEnc, int data, int bits) {
        for (int bit = bits - 1; bit >= 0; --bit) {
            boolEnc.writeBit(128, 1 & data >> bit);
        }
    }

    private void collectPredictors(Picture outMB, int mbX) {
        System.arraycopy(outMB.getPlaneData(0), 240, this.topLine[0], mbX << 4, 16);
        System.arraycopy(outMB.getPlaneData(1), 56, this.topLine[1], mbX << 3, 8);
        System.arraycopy(outMB.getPlaneData(2), 56, this.topLine[2], mbX << 3, 8);
        EVP8.copyCol(outMB.getPlaneData(0), 15, 16, this.leftRow[0]);
        EVP8.copyCol(outMB.getPlaneData(1), 7, 8, this.leftRow[1]);
        EVP8.copyCol(outMB.getPlaneData(2), 7, 8, this.leftRow[2]);
    }

    private static void copyCol(byte[] planeData, int off, int stride, byte[] out) {
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = planeData[off];
            off += stride;
        }
    }

    private void luma(Picture pic, int mbX, int mbY, EBool out, int qp, Picture outMB) {
        int x2 = mbX << 4;
        int y2 = mbY << 4;
        int[][] ac2 = this.transform(pic, x2, y2);
        int[] dc = EVP8.extractDC(ac2);
        this.writeLumaDC(mbX, out, qp, dc);
        this.writeLumaAC(mbX, out, ac2, qp);
        EVP8.restorePlaneLuma(dc, ac2, qp);
        EVP8.putLuma(outMB.getPlaneData(0), this.lumaDCPred(x2, y2), ac2);
    }

    private void writeLumaAC(int mbX, EBool out, int[][] ac2, int qp) {
        for (int i2 = 0; i2 < 16; ++i2) {
            EQuantizer.quantizeY(ac2[i2], qp);
            this.bitstream.encodeCoeffsDCT15(out, EVP8.zigzag(ac2[i2], this.tmp), mbX, i2 & 3, i2 >> 2);
        }
    }

    private void writeLumaDC(int mbX, EBool out, int qp, int[] dc) {
        Transform.walsh4x4(dc);
        EQuantizer.quantizeY2(dc, qp);
        this.bitstream.encodeCoeffsWHT(out, EVP8.zigzag(dc, this.tmp), mbX);
    }

    private void writeChroma(int comp, int mbX, EBool boolEnc, int[][] ac2, int qp) {
        for (int i2 = 0; i2 < 4; ++i2) {
            EQuantizer.quantizeUV(ac2[i2], qp);
            this.bitstream.encodeCoeffsDCTUV(boolEnc, EVP8.zigzag(ac2[i2], this.tmp), comp, mbX, i2 & 1, i2 >> 1);
        }
    }

    private static int[] zigzag(int[] zz, int[] tmp2) {
        for (int i2 = 0; i2 < 16; ++i2) {
            tmp2[i2] = zz[LookUp.ZIGZAGS[i2]];
        }
        return tmp2;
    }

    private void chroma(Picture pic, int mbX, int mbY, EBool boolEnc, int qp, Picture outMB) {
        int x2 = mbX << 3;
        int y2 = mbY << 3;
        byte chromaPred1 = this.chromaPredBlk(1, x2, y2);
        byte chromaPred2 = this.chromaPredBlk(2, x2, y2);
        int[][] ac1 = EVP8.transformChroma(pic, 1, x2, y2, chromaPred1);
        int[][] ac2 = EVP8.transformChroma(pic, 2, x2, y2, chromaPred2);
        this.writeChroma(1, mbX, boolEnc, ac1, qp);
        this.writeChroma(2, mbX, boolEnc, ac2, qp);
        EVP8.restorePlaneChroma(ac1, qp);
        EVP8.putChroma(outMB.data[1], ac1, chromaPred1);
        EVP8.restorePlaneChroma(ac2, qp);
        EVP8.putChroma(outMB.data[2], ac2, chromaPred2);
    }

    private static int[][] transformChroma(Picture pic, int comp, int x2, int y2, int chromaPred) {
        int[][] ac2 = new int[4][16];
        for (int blk = 0; blk < ac2.length; ++blk) {
            int blkOffX = (blk & 1) << 2;
            int blkOffY = blk >> 1 << 2;
            EVP8.takeSubtract(pic.getPlaneData(comp), pic.getPlaneWidth(comp), pic.getPlaneHeight(comp), x2 + blkOffX, y2 + blkOffY, ac2[blk], chromaPred);
            Transform.fdct4x4(ac2[blk]);
        }
        return ac2;
    }

    private static void putChroma(byte[] mb, int[][] ac2, int chromaPred) {
        for (int blk = 0; blk < 4; ++blk) {
            EVP8.putBlk(mb, chromaPred, ac2[blk], 3, (blk & 1) << 2, blk >> 1 << 2);
        }
    }

    private static byte chromaPredOne(byte[] pix, int x2) {
        return (byte)(pix[x2] + pix[x2 + 1] + pix[x2 + 2] + pix[x2 + 3] + pix[x2 + 4] + pix[x2 + 5] + pix[x2 + 6] + pix[x2 + 7] + 4 >> 3);
    }

    private static byte chromaPredTwo(byte[] pix1, byte[] pix2, int x2, int y2) {
        return (byte)(pix1[x2] + pix1[x2 + 1] + pix1[x2 + 2] + pix1[x2 + 3] + pix1[x2 + 4] + pix1[x2 + 5] + pix1[x2 + 6] + pix1[x2 + 7] + pix2[y2] + pix2[y2 + 1] + pix2[y2 + 2] + pix2[y2 + 3] + pix2[y2 + 4] + pix2[y2 + 5] + pix2[y2 + 6] + pix2[y2 + 7] + 8 >> 4);
    }

    private byte chromaPredBlk(int comp, int x2, int y2) {
        int predY = y2 & 7;
        if (x2 != 0 && y2 != 0) {
            return EVP8.chromaPredTwo(this.leftRow[comp], this.topLine[comp], predY, x2);
        }
        if (x2 != 0) {
            return EVP8.chromaPredOne(this.leftRow[comp], predY);
        }
        if (y2 != 0) {
            return EVP8.chromaPredOne(this.topLine[comp], x2);
        }
        return 0;
    }

    private static void putLuma(byte[] planeData, int pred, int[][] ac2) {
        for (int blk = 0; blk < ac2.length; ++blk) {
            int blkOffX = (blk & 3) << 2;
            int blkOffY = blk & 0xFFFFFFFC;
            EVP8.putBlk(planeData, pred, ac2[blk], 4, blkOffX, blkOffY);
        }
    }

    private static void putBlk(byte[] planeData, int pred, int[] block, int log2stride, int blkX, int blkY) {
        int stride = 1 << log2stride;
        int[] lastVal = new int[4];
        for (int pos = 0; pos < 4; ++pos) {
            lastVal[pos] = block[pos] - 1;
        }
        byte[] vals = new byte[4];
        int srcOff = 0;
        int dstOff = (blkY << log2stride) + blkX;
        for (int line = 0; line < 4; ++line) {
            for (int pos = 0; pos < 4; ++pos) {
                if (lastVal[pos] != block[srcOff + pos]) {
                    lastVal[pos] = block[srcOff + pos];
                    vals[pos] = (byte)Util.clip(block[srcOff + pos] + pred);
                }
                planeData[dstOff + pos] = vals[pos];
            }
            srcOff += 4;
            dstOff += stride;
        }
    }

    private static void restorePlaneChroma(int[][] ac2, int qp) {
        for (int i2 = 0; i2 < 4; ++i2) {
            EQuantizer.dequantUV(ac2[i2], qp);
            Transform.idct4x4(ac2[i2]);
        }
    }

    private static void restorePlaneLuma(int[] dc, int[][] ac2, int qp) {
        EQuantizer.dequantY2(dc, qp);
        Transform.iwalsh4x4(dc);
        for (int i2 = 0; i2 < 16; ++i2) {
            EQuantizer.dequantY(ac2[i2], qp);
            ac2[i2][0] = dc[i2];
            Transform.idct4x4(ac2[i2]);
        }
    }

    private static int[] extractDC(int[][] ac2) {
        int[] dc = new int[ac2.length];
        for (int i2 = 0; i2 < ac2.length; ++i2) {
            dc[i2] = ac2[i2][0];
        }
        return dc;
    }

    private byte lumaDCPred(int x2, int y2) {
        if (x2 == 0 && y2 == 0) {
            return 0;
        }
        if (y2 == 0) {
            return (byte)(Util.sumByte(this.leftRow[0]) + 8 >> 4);
        }
        if (x2 == 0) {
            return (byte)(Util.sumByte3(this.topLine[0], 0) + 8 >> 4);
        }
        return (byte)(Util.sumByte(this.leftRow[0]) + Util.sumByte3(this.topLine[0], x2) + 16 >> 5);
    }

    private int[][] transform(Picture pic, int x2, int y2) {
        byte dcc = this.lumaDCPred(x2, y2);
        int[][] ac2 = new int[16][16];
        for (int i2 = 0; i2 < ac2.length; ++i2) {
            int[] coeff = ac2[i2];
            int blkOffX = (i2 & 3) << 2;
            int blkOffY = i2 & 0xFFFFFFFC;
            EVP8.takeSubtract(pic.getPlaneData(0), pic.getPlaneWidth(0), pic.getPlaneHeight(0), x2 + blkOffX, y2 + blkOffY, coeff, dcc);
            Transform.fdct4x4(coeff);
        }
        return ac2;
    }

    private static void takeSubtract(byte[] planeData, int planeWidth, int planeHeight, int x2, int y2, int[] coeff, int dc) {
        if (x2 + 4 < planeWidth && y2 + 4 < planeHeight) {
            EVP8.takeSubtractSafe(planeData, planeWidth, x2, y2, coeff, dc);
        } else {
            EVP8.takeSubtractUnsafe(planeData, planeWidth, planeHeight, x2, y2, coeff, dc);
        }
    }

    private static void takeSubtractSafe(byte[] planeData, int planeWidth, int x2, int y2, int[] coeff, int dc) {
        int i2 = 0;
        int srcOff = y2 * planeWidth + x2;
        int dstOff = 0;
        while (i2 < 4) {
            coeff[dstOff] = planeData[srcOff] - dc;
            coeff[dstOff + 1] = planeData[srcOff + 1] - dc;
            coeff[dstOff + 2] = planeData[srcOff + 2] - dc;
            coeff[dstOff + 3] = planeData[srcOff + 3] - dc;
            ++i2;
            srcOff += planeWidth;
            dstOff += 4;
        }
    }

    private static void takeSubtractUnsafe(byte[] planeData, int planeWidth, int planeHeight, int x2, int y2, int[] coeff, int dc) {
        int j2;
        int off;
        int i2;
        int outOff = 0;
        for (i2 = y2; i2 < Math.min(y2 + 4, planeHeight); ++i2) {
            off = i2 * planeWidth + Math.min(x2, planeWidth);
            for (j2 = x2; j2 < Math.min(x2 + 4, planeWidth); ++j2) {
                coeff[outOff++] = planeData[off++] - dc;
            }
            --off;
            while (j2 < x2 + 4) {
                coeff[outOff++] = planeData[off] - dc;
                ++j2;
            }
        }
        while (i2 < y2 + 4) {
            off = planeHeight * planeWidth - planeWidth + Math.min(x2, planeWidth);
            for (j2 = x2; j2 < Math.min(x2 + 4, planeWidth); ++j2) {
                coeff[outOff++] = planeData[off++] - dc;
            }
            --off;
            while (j2 < x2 + 4) {
                coeff[outOff++] = planeData[off] - dc;
                ++j2;
            }
            ++i2;
        }
    }
}

