/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.data;

import com.idrsolutions.image.webp.data.LookUp;

final class EQuantizer {
    private EQuantizer() {
    }

    static void quantizeY(int[] coeffs, int qp) {
        int factDC = LookUp.QDC[qp];
        int invFactAC = LookUp.QAC[qp];
        EQuantizer.quantize(coeffs, factDC, invFactAC);
    }

    static void quantizeUV(int[] coeffs, int qp) {
        int factDC = LookUp.QDC[qp];
        if (factDC > 132) {
            factDC = 132;
        }
        int invFactAC = LookUp.QAC[qp];
        EQuantizer.quantize(coeffs, factDC, invFactAC);
    }

    static void quantizeY2(int[] coeffs, int qp) {
        int factDC = LookUp.QDC[qp] << 1;
        int factAC = 155 * LookUp.QAC[qp] / 100;
        if (factAC < 8) {
            factAC = 8;
        }
        EQuantizer.quantize(coeffs, factDC, factAC);
    }

    private static void quantize(int[] coeffs, int factDC, int factAC) {
        coeffs[0] = coeffs[0] / factDC;
        int i2 = 1;
        while (i2 < 16) {
            int n2 = i2++;
            coeffs[n2] = coeffs[n2] / factAC;
        }
    }

    static void dequantY(int[] coeffs, int qp) {
        int factDC = LookUp.QDC[qp];
        int factAC = LookUp.QAC[qp];
        EQuantizer.dequant(coeffs, factDC, factAC);
    }

    static void dequantUV(int[] coeffs, int qp) {
        int factDC = LookUp.QDC[qp];
        if (factDC > 132) {
            factDC = 132;
        }
        int factAC = LookUp.QAC[qp];
        EQuantizer.dequant(coeffs, factDC, factAC);
    }

    static void dequantY2(int[] coeffs, int qp) {
        int factDC = LookUp.QDC[qp] << 1;
        int factAC = 155 * LookUp.QAC[qp] / 100;
        if (factAC < 8) {
            factAC = 8;
        }
        EQuantizer.dequant(coeffs, factDC, factAC);
    }

    private static void dequant(int[] coeffs, int factDC, int factAC) {
        coeffs[0] = coeffs[0] * factDC;
        int i2 = 1;
        while (i2 < 16) {
            int n2 = i2++;
            coeffs[n2] = coeffs[n2] * factAC;
        }
    }
}

