/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.data;

import com.idrsolutions.image.webp.data.EBool;
import com.idrsolutions.image.webp.data.LookUp;

class BitEncoder {
    private final int[][][][] tokenBinProbs;
    private int whtNzLeft;
    private final int[] whtNzTop;
    private final int[][] dctNzLeft = new int[][]{new int[4], new int[2], new int[2]};
    private final int[][] dctNzTop;

    BitEncoder(int mbWidth) {
        this.tokenBinProbs = LookUp.tokenDefaultBinProbs;
        this.whtNzTop = new int[mbWidth];
        this.dctNzTop = new int[][]{new int[mbWidth << 2], new int[mbWidth << 1], new int[mbWidth << 1]};
    }

    void encodeCoeffsWHT(EBool bc2, int[] coeffs, int mbX) {
        int nCoeff = BitEncoder.fastCountCoeffWHT(coeffs);
        this.encodeCoeffs(bc2, coeffs, 0, nCoeff, 1, (mbX == 0 || this.whtNzLeft <= 0 ? 0 : 1) + (this.whtNzTop[mbX] > 0 ? 1 : 0));
        this.whtNzLeft = nCoeff;
        this.whtNzTop[mbX] = nCoeff;
    }

    void encodeCoeffsDCT15(EBool bc2, int[] coeffs, int mbX, int blkX, int blkY) {
        int nCoeff = BitEncoder.countCoeff(coeffs, 16);
        int blkAbsX = (mbX << 2) + blkX;
        this.encodeCoeffs(bc2, coeffs, 1, nCoeff, 0, (blkAbsX == 0 || this.dctNzLeft[0][blkY] <= 0 ? 0 : 1) + (this.dctNzTop[0][blkAbsX] > 0 ? 1 : 0));
        this.dctNzLeft[0][blkY] = Math.max(nCoeff - 1, 0);
        this.dctNzTop[0][blkAbsX] = Math.max(nCoeff - 1, 0);
    }

    void encodeCoeffsDCTUV(EBool bc2, int[] coeffs, int comp, int mbX, int blkX, int blkY) {
        int nCoeff = BitEncoder.countCoeff(coeffs, 16);
        int blkAbsX = (mbX << 1) + blkX;
        this.encodeCoeffs(bc2, coeffs, 0, nCoeff, 2, (blkAbsX == 0 || this.dctNzLeft[comp][blkY] <= 0 ? 0 : 1) + (this.dctNzTop[comp][blkAbsX] > 0 ? 1 : 0));
        this.dctNzLeft[comp][blkY] = nCoeff;
        this.dctNzTop[comp][blkAbsX] = nCoeff;
    }

    private void encodeCoeffs(EBool bc2, int[] coeffs, int firstCoeff, int nCoeff, int blkType, int ctx) {
        int[] probs;
        int i2;
        boolean prevZero = false;
        for (i2 = firstCoeff; i2 < nCoeff; ++i2) {
            probs = this.tokenBinProbs[blkType][LookUp.CO_BANDS[i2]][ctx];
            int coeffAbs = BitEncoder.abs(coeffs[i2]);
            if (!prevZero) {
                bc2.writeBit(probs[0], 1);
            }
            if (coeffAbs == 0) {
                bc2.writeBit(probs[1], 0);
                ctx = 0;
            } else {
                bc2.writeBit(probs[1], 1);
                if (coeffAbs == 1) {
                    bc2.writeBit(probs[2], 0);
                    ctx = 1;
                } else {
                    ctx = 2;
                    bc2.writeBit(probs[2], 1);
                    if (coeffAbs <= 4) {
                        bc2.writeBit(probs[3], 0);
                        if (coeffAbs == 2) {
                            bc2.writeBit(probs[4], 0);
                        } else {
                            bc2.writeBit(probs[4], 1);
                            bc2.writeBit(probs[5], coeffAbs - 3);
                        }
                    } else {
                        bc2.writeBit(probs[3], 1);
                        if (coeffAbs <= 10) {
                            bc2.writeBit(probs[6], 0);
                            if (coeffAbs <= 6) {
                                bc2.writeBit(probs[7], 0);
                                bc2.writeBit(159, coeffAbs - 5);
                            } else {
                                bc2.writeBit(probs[7], 1);
                                int d2 = coeffAbs - 7;
                                bc2.writeBit(165, d2 >> 1);
                                bc2.writeBit(145, d2 & 1);
                            }
                        } else {
                            bc2.writeBit(probs[6], 1);
                            if (coeffAbs <= 34) {
                                bc2.writeBit(probs[8], 0);
                                if (coeffAbs <= 18) {
                                    bc2.writeBit(probs[9], 0);
                                    BitEncoder.writeCat3Ext(bc2, coeffAbs);
                                } else {
                                    bc2.writeBit(probs[9], 1);
                                    BitEncoder.writeCat4Ext(bc2, coeffAbs);
                                }
                            } else {
                                bc2.writeBit(probs[8], 1);
                                if (coeffAbs <= 66) {
                                    bc2.writeBit(probs[10], 0);
                                    BitEncoder.writeCatExt(bc2, coeffAbs, 35, LookUp.probCoeffExtCat5);
                                } else {
                                    bc2.writeBit(probs[10], 1);
                                    BitEncoder.writeCatExt(bc2, coeffAbs, 67, LookUp.probCoeffExtCat6);
                                }
                            }
                        }
                    }
                }
                bc2.writeBit(128, BitEncoder.sign(coeffs[i2]));
            }
            prevZero = coeffAbs == 0;
        }
        if (nCoeff < 16) {
            probs = this.tokenBinProbs[blkType][LookUp.CO_BANDS[i2]][ctx];
            bc2.writeBit(probs[0], 0);
        }
    }

    private static void writeCat3Ext(EBool bc2, int coeff) {
        int d2 = coeff - 11;
        bc2.writeBit(173, d2 >> 2);
        bc2.writeBit(148, d2 >> 1 & 1);
        bc2.writeBit(140, d2 & 1);
    }

    private static void writeCat4Ext(EBool bc2, int coeff) {
        int d2 = coeff - 19;
        bc2.writeBit(176, d2 >> 3);
        bc2.writeBit(155, d2 >> 2 & 1);
        bc2.writeBit(140, d2 >> 1 & 1);
        bc2.writeBit(135, d2 & 1);
    }

    private static void writeCatExt(EBool bc2, int coeff, int catOff, int[] cat) {
        int d2 = coeff - catOff;
        int i2 = 0;
        for (int b2 = cat.length - 1; b2 >= 0; --b2) {
            bc2.writeBit(cat[i2++], d2 >> b2 & 1);
        }
    }

    private static int fastCountCoeffWHT(int[] coeffs) {
        if (coeffs[15] != 0) {
            return 16;
        }
        return BitEncoder.countCoeff(coeffs, 15);
    }

    private static int countCoeff(int[] coeffs, int nCoeff) {
        while (nCoeff > 0) {
            if (coeffs[--nCoeff] == 0) continue;
            return nCoeff + 1;
        }
        return nCoeff;
    }

    private static int abs(int val) {
        int sign = val >> 31;
        return (val ^ sign) - sign;
    }

    private static int sign(int val) {
        return -(val >> 31);
    }
}

