/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.Tooler;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;

public class ToolIndex
implements Tooler {
    private final byte[] dd;
    private final int s;
    private final int wp;
    private final int m;
    private final BufferedImage img;
    private final int stripPixels;

    public ToolIndex(int width, int height, int bps, byte[] rr, byte[] gg, byte[] bb2) {
        if (bps > 4) {
            IndexColorModel cm = new IndexColorModel(bps, 1 << bps, rr, gg, bb2);
            this.img = new BufferedImage(width, height, 13, cm);
        } else {
            IndexColorModel cm = new IndexColorModel(bps, 1 << bps, rr, gg, bb2);
            this.img = new BufferedImage(width, height, 12, cm);
        }
        this.s = bps;
        this.wp = width + 7 >> 3 << 3;
        this.m = (bps << 1) - 1;
        this.dd = ((DataBufferByte)this.img.getRaster().getDataBuffer()).getData();
        this.stripPixels = (width * bps + 7) / 8;
    }

    @Override
    public void set(int x2, int y2, int v2) {
        if (this.s == 8) {
            this.dd[y2 * this.wp + x2] = (byte)v2;
        } else {
            v2 &= this.m;
            int a10 = y2 * this.wp + x2 * this.s;
            int b2 = a10 >> 3;
            int c2 = a10 & 7;
            int d2 = this.dd[b2] & 0xFF;
            int r2 = 8 - c2 - this.s;
            if (r2 >= 0) {
                int mm = ~(0xFFFFFF00 | this.m << r2);
                this.dd[b2] = (byte)(v2 << r2 | d2 & mm);
            } else {
                d2 = d2 << 8 | this.dd[b2 + 1] & 0xFF;
                r2 = 16 - c2 - this.s;
                int mm = ~(0xFFFF0000 | this.m << r2);
                d2 = v2 << r2 | d2 & mm;
                this.dd[b2] = (byte)(d2 >> 8);
                this.dd[b2 + 1] = (byte)(d2 & 0xFF);
            }
        }
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.img;
    }

    @Override
    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.dd, 0, data.length);
    }

    @Override
    public void setStrips(int y2, byte[] data) {
        System.arraycopy(data, 0, this.dd, y2 * this.stripPixels, data.length);
    }
}

