/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.ImageFormat;
import com.idrsolutions.image.bmp.BmpEncoder;
import com.idrsolutions.image.bmp.options.BmpEncoderOptions;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.gif.GifEncoder;
import com.idrsolutions.image.gif.options.GifEncoderOptions;
import com.idrsolutions.image.heic.HeicEncoder;
import com.idrsolutions.image.heic.options.HeicEncoderOptions;
import com.idrsolutions.image.jpeg.JpegEncoder;
import com.idrsolutions.image.jpeg.options.JpegEncoderOptions;
import com.idrsolutions.image.jpeg2000.Jpeg2000Encoder;
import com.idrsolutions.image.jpeg2000.options.Jpeg2000EncoderOptions;
import com.idrsolutions.image.pdf.PdfEncoder;
import com.idrsolutions.image.pdf.options.PdfEncoderOptions;
import com.idrsolutions.image.png.PngEncoder;
import com.idrsolutions.image.png.options.PngCompressionFormat;
import com.idrsolutions.image.png.options.PngEncoderOptions;
import com.idrsolutions.image.tiff.TiffEncoder;
import com.idrsolutions.image.tiff.options.TiffCompressionFormat;
import com.idrsolutions.image.tiff.options.TiffEncoderOptions;
import com.idrsolutions.image.webp.WebpEncoder;
import com.idrsolutions.image.webp.options.WebpCompressionFormat;
import com.idrsolutions.image.webp.options.WebpEncoderOptions;
import javax.imageio.ImageWriteParam;

public final class SupportedFormats {
    private static final String[][] supportedEncoders;
    private static final String[][] supportedDecoders;
    private static final String[][] supportedMetadatas;
    private static final Object[][] outputEnumFromString;
    private static final Object[][] inputEnumFromString;

    private SupportedFormats() {
    }

    public static Encoder getEncoder(OutputFormat format, EncoderOptions options) {
        switch (format) {
            case BMP: {
                return new BmpEncoder(options);
            }
            case GIF: {
                return new GifEncoder(options);
            }
            case HEIC: {
                return new HeicEncoder(options);
            }
            case JPEG: {
                return new JpegEncoder(options);
            }
            case JPEG2000: {
                return new Jpeg2000Encoder(options);
            }
            case PDF: {
                return new PdfEncoder(options);
            }
            case PNG: {
                return new PngEncoder(options);
            }
            case TIFF: {
                return new TiffEncoder((TiffEncoderOptions)options);
            }
            case WEBP: {
                return new WebpEncoder(options);
            }
        }
        return null;
    }

    public static EncoderOptions getEncoderOptions(OutputFormat format) {
        switch (format) {
            case BMP: {
                return new BmpEncoderOptions();
            }
            case GIF: {
                return new GifEncoderOptions();
            }
            case HEIC: {
                return new HeicEncoderOptions();
            }
            case JPEG: {
                return new JpegEncoderOptions();
            }
            case JPEG2000: {
                return new Jpeg2000EncoderOptions();
            }
            case PDF: {
                return new PdfEncoderOptions();
            }
            case PNG: {
                return new PngEncoderOptions();
            }
            case TIFF: {
                return new TiffEncoderOptions();
            }
            case WEBP: {
                return new WebpEncoderOptions();
            }
        }
        return null;
    }

    public static String[][] getSupportedImageEncoders() {
        return supportedEncoders;
    }

    public static String[][] getSupportedImageDecoders() {
        return supportedDecoders;
    }

    public static String[][] getSupportedImageMetadatas() {
        return supportedMetadatas;
    }

    public static boolean hasEncoderSupportForImageFormat(String format) {
        if (format != null && !format.isEmpty()) {
            String[][] stringArray = supportedEncoders;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] supportedAlternative;
                for (String supported : supportedAlternative = stringArray[i2]) {
                    if (!supported.equalsIgnoreCase(format)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasDecoderSupportForImageFormat(String format) {
        if (format != null && !format.isEmpty()) {
            String[][] stringArray = supportedDecoders;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] supportedAlternative;
                for (String supported : supportedAlternative = stringArray[i2]) {
                    if (!supported.equalsIgnoreCase(format)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static OutputFormat getEnumFromString(String format) {
        if (format != null && !format.isEmpty()) {
            format = format.toLowerCase();
            Object[][] objectArray = outputEnumFromString;
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] supported;
                for (Object supportedl : supported = objectArray[i2]) {
                    if (!supportedl.equals(format)) continue;
                    return (OutputFormat)((Object)supported[0]);
                }
            }
        }
        return null;
    }

    public static ImageFormat getInputEnumFromString(String format) {
        if (format != null && !format.isEmpty()) {
            format = format.toLowerCase();
            Object[][] objectArray = inputEnumFromString;
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] supported;
                for (Object supportedf : supported = objectArray[i2]) {
                    if (!supportedf.equals(format)) continue;
                    return (ImageFormat)((Object)supported[0]);
                }
            }
        }
        return null;
    }

    public static String getInputStringFromEnum(ImageFormat imageFormat) {
        if (imageFormat != null) {
            for (Object[] supported : inputEnumFromString) {
                if (supported[0] != imageFormat) continue;
                return (String)supported[1];
            }
        }
        return "";
    }

    public static EncoderOptions getEncoderOptions(ImageWriteParam param, OutputFormat output) {
        if (param.getCompressionMode() == 2) {
            switch (output) {
                case JPEG: {
                    JpegEncoderOptions options = new JpegEncoderOptions();
                    options.setQuality((int)(param.getCompressionQuality() * 100.0f));
                    return options;
                }
                case JPEG2000: {
                    Jpeg2000EncoderOptions options = new Jpeg2000EncoderOptions();
                    options.setQuality((int)(param.getCompressionQuality() * 100.0f));
                    return options;
                }
                case PNG: {
                    PngEncoderOptions options = new PngEncoderOptions();
                    if (!param.getCompressionType().isEmpty()) {
                        options.setCompressionFormat(PngCompressionFormat.valueOf(param.getCompressionType().toUpperCase()));
                    }
                    return options;
                }
                case TIFF: {
                    TiffEncoderOptions options = new TiffEncoderOptions();
                    if (!param.getCompressionType().isEmpty()) {
                        options.setCompressionFormat(TiffCompressionFormat.valueOf(param.getCompressionType().toUpperCase()));
                    }
                    return options;
                }
                case WEBP: {
                    WebpEncoderOptions options = new WebpEncoderOptions();
                    options.setQuality((int)(param.getCompressionQuality() * 100.0f));
                    options.setCompressionFormat(WebpCompressionFormat.valueOf(param.getCompressionType()));
                    return options;
                }
            }
            return SupportedFormats.getEncoderOptions(output);
        }
        return SupportedFormats.getEncoderOptions(output);
    }

    static {
        boolean iSJDeliPresent;
        String jdeliClassPath = "/com/idrsolutions/image/JDeli.class";
        boolean bl2 = iSJDeliPresent = SupportedFormats.class.getResource("/com/idrsolutions/image/JDeli.class") != null;
        if (iSJDeliPresent) {
            supportedDecoders = new String[][]{{"bmp"}, {"dcm"}, {"emf"}, {"gif"}, {"heic", "heif"}, {"jpx", "jp2"}, {"jpeg", "jpg"}, {"jxl"}, {"png"}, {"psd"}, {"sgi", "rgb"}, {"tif", "tiff"}, {"webp"}, {"wmf"}};
            supportedMetadatas = new String[][]{{"bmp"}, {"gif"}, {"heic", "heif"}, {"jpx", "jp2"}, {"jpeg", "jpg"}, {"png"}, {"tif", "tiff"}, {"webp"}};
        } else {
            supportedDecoders = new String[][]{{"bmp"}, {"gif"}, {"jpx", "jp2"}, {"jpeg", "jpg"}, {"png"}, {"tif", "tiff"}};
            supportedMetadatas = new String[][]{{"bmp"}, {"gif"}, {"jpx", "jp2"}, {"jpeg", "jpg"}, {"png"}, {"tif", "tiff"}};
        }
        supportedEncoders = new String[][]{{"bmp"}, {"gif"}, {"heic", "heif"}, {"jpeg", "jpg"}, {"jpx", "jp2"}, {"pdf"}, {"png"}, {"tif", "tiff"}, {"webp"}};
        outputEnumFromString = new Object[][]{{OutputFormat.BMP, "bmp"}, {OutputFormat.GIF, "gif"}, {OutputFormat.HEIC, "heic", "heif"}, {OutputFormat.JPEG, "jpeg", "jpg"}, {OutputFormat.JPEG2000, "jpx", "jp2"}, {OutputFormat.PDF, "pdf"}, {OutputFormat.PNG, "png"}, {OutputFormat.TIFF, "tif", "tiff"}, {OutputFormat.WEBP, "webp"}};
        inputEnumFromString = new Object[][]{{ImageFormat.BMP_IMAGE, "bmp"}, {ImageFormat.DICOM_IMAGE, "dcm"}, {ImageFormat.EMF_IMAGE, "emf"}, {ImageFormat.GIF_IMAGE, "gif"}, {ImageFormat.ANIMATED_GIF, "gif"}, {ImageFormat.HEIC_IMAGE, "heic"}, {ImageFormat.HEIC_MULTI_FRAME_IMAGE, "heif"}, {ImageFormat.JPEG_IMAGE, "jpeg", "jpg"}, {ImageFormat.JPEG2000_IMAGE, "jpx", "jp2"}, {ImageFormat.JPEGXL_IMAGE, "jxl"}, {ImageFormat.PNG_IMAGE, "png"}, {ImageFormat.PSD_IMAGE, "psd"}, {ImageFormat.SGI_IMAGE, "sgi", "rgb"}, {ImageFormat.TIFF_IMAGE, "tif", "tiff"}, {ImageFormat.WEBP_IMAGE, "webp"}, {ImageFormat.WMF_IMAGE, "wmf"}};
    }
}

