/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class PixGet5
implements PixGet {
    private final byte[] pix;
    private final int stripe;
    private int r;
    private int g;
    private int b;
    private int p;

    public PixGet5(BufferedImage image) {
        this.pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.stripe = image.getWidth() * 3;
    }

    @Override
    public boolean hasAlpha() {
        return false;
    }

    @Override
    public int getRGB(int x2, int y2) {
        this.p = y2 * this.stripe + x2 * 3;
        this.b = this.pix[this.p] & 0xFF;
        this.g = this.pix[this.p + 1] & 0xFF;
        this.r = this.pix[this.p + 2] & 0xFF;
        return this.r << 16 | this.g << 8 | this.b;
    }

    @Override
    public int getARGB(int x2, int y2) {
        this.p = y2 * this.stripe + x2 * 3;
        this.b = this.pix[this.p] & 0xFF;
        this.g = this.pix[this.p + 1] & 0xFF;
        this.r = this.pix[this.p + 2] & 0xFF;
        return 0xFF000000 | this.r << 16 | this.g << 8 | this.b;
    }
}

