/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class PixGet4
implements PixGet {
    private final int[] pix;
    private final int stripe;
    private int r;
    private int g;
    private int b;
    private int p;

    public PixGet4(BufferedImage image) {
        this.pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        this.stripe = image.getWidth();
    }

    @Override
    public boolean hasAlpha() {
        return false;
    }

    @Override
    public int getRGB(int x2, int y2) {
        this.p = this.pix[y2 * this.stripe + x2];
        this.r = this.p & 0xFF;
        this.g = this.p >> 8 & 0xFF;
        this.b = this.p >> 16 & 0xFF;
        return this.r << 16 | this.g << 8 | this.b;
    }

    @Override
    public int getARGB(int x2, int y2) {
        this.p = this.pix[y2 * this.stripe + x2];
        this.r = this.p & 0xFF;
        this.g = this.p >> 8 & 0xFF;
        this.b = this.p >> 16 & 0xFF;
        return 0xFF000000 | this.r << 16 | this.g << 8 | this.b;
    }
}

