/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;

public class PixGet12
implements PixGet {
    private final byte[] pix;
    private final int stripe;
    private final int[] argb = new int[256];
    private final int bps;
    private final int msk;
    private final IndexColorModel icm;
    private final int mod;
    private final int sft0;

    public PixGet12(BufferedImage image) {
        this.icm = (IndexColorModel)image.getColorModel();
        this.icm.getRGBs(this.argb);
        this.bps = this.icm.getPixelSize();
        this.msk = (1 << this.bps) - 1;
        this.pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.stripe = (image.getWidth() * this.bps + 7) / 8;
        this.mod = 8 / this.bps;
        this.sft0 = 8 - this.bps;
    }

    @Override
    public boolean hasAlpha() {
        return this.icm.hasAlpha();
    }

    @Override
    public int getRGB(int x2, int y2) {
        int loc = y2 * this.stripe + (x2 * this.bps >> 3);
        int v2 = this.pix[loc] & 0xFF;
        int sft = this.sft0 - x2 % this.mod * this.bps;
        return this.argb[v2 >> sft & this.msk];
    }

    @Override
    public int getARGB(int x2, int y2) {
        int loc = y2 * this.stripe + (x2 * this.bps >> 3);
        int v2 = this.pix[loc] & 0xFF;
        int sft = this.sft0 - x2 % this.mod * this.bps;
        return this.argb[v2 >> sft & this.msk];
    }
}

