/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;

public class ImageInfo {
    private byte[] pBytes;
    private int iw;
    private int ih;
    private int nComp = 3;
    private int bps = 24;

    public static ImageInfo getImageInfoWithBytes(BufferedImage image) {
        ImageInfo info = new ImageInfo();
        info.iw = image.getWidth();
        info.ih = image.getHeight();
        int dim = info.iw * info.ih;
        switch (image.getType()) {
            case 12: {
                info.nComp = 1;
                info.bps = 1;
                info.pBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                break;
            }
            case 10: {
                info.nComp = 1;
                info.bps = 8;
                info.pBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                break;
            }
            case 5: {
                info.pBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                break;
            }
            case 6: 
            case 7: {
                info.nComp = 4;
                info.bps = 32;
                info.pBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                break;
            }
            case 1: {
                ImageInfo.setRGB(image, info, dim);
                break;
            }
            case 2: 
            case 3: {
                ImageInfo.setARGB(image, info, dim);
                break;
            }
            case 4: {
                ImageInfo.setBGR(image, info, dim);
                break;
            }
            case 13: {
                ImageInfo.setIndexed(image, info, dim);
                break;
            }
            case 11: {
                ImageInfo.setGray(image, info, dim);
            }
        }
        return info;
    }

    private static void setBGR(BufferedImage image, ImageInfo info, int dim) {
        info.nComp = 4;
        info.bps = 32;
        int p2 = 0;
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        info.pBytes = new byte[dim * 3];
        for (int i2 = 0; i2 < dim; ++i2) {
            int pix = pixels[i2];
            info.pBytes[p2++] = (byte)(pix >> 24 & 0xFF);
            info.pBytes[p2++] = (byte)(pix >> 16 & 0xFF);
            info.pBytes[p2++] = (byte)(pix >> 8 & 0xFF);
            info.pBytes[p2++] = (byte)(pix & 0xFF);
        }
    }

    private static void setARGB(BufferedImage image, ImageInfo info, int dim) {
        info.nComp = 4;
        info.bps = 32;
        int p2 = 0;
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        info.pBytes = new byte[dim * 4];
        for (int i2 = 0; i2 < dim; ++i2) {
            int pix = pixels[i2];
            info.pBytes[p2++] = (byte)(pix >> 24 & 0xFF);
            info.pBytes[p2++] = (byte)(pix & 0xFF);
            info.pBytes[p2++] = (byte)(pix >> 8 & 0xFF);
            info.pBytes[p2++] = (byte)(pix >> 16 & 0xFF);
        }
    }

    private static void setGray(BufferedImage image, ImageInfo info, int dim) {
        short[] sPixels = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        info.nComp = 1;
        info.bps = 8;
        info.pBytes = new byte[dim];
        int p2 = 0;
        for (int i2 = 0; i2 < dim; ++i2) {
            int pix = sPixels[i2] & 0xFFFF;
            info.pBytes[p2++] = (byte)(pix >> 8 & 0xFF);
        }
    }

    private static void setIndexed(BufferedImage image, ImageInfo info, int dim) {
        int[] argb = new int[256];
        info.nComp = 4;
        info.bps = 32;
        IndexColorModel icm = (IndexColorModel)image.getColorModel();
        icm.getRGBs(argb);
        info.pBytes = new byte[dim * 4];
        int p2 = 0;
        byte[] temp = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < dim; ++i2) {
            int pix = argb[temp[i2] * 255];
            info.pBytes[p2++] = (byte)(pix >> 24 & 0xFF);
            info.pBytes[p2++] = (byte)(pix & 0xFF);
            info.pBytes[p2++] = (byte)(pix >> 8 & 0xFF);
            info.pBytes[p2++] = (byte)(pix >> 16 & 0xFF);
        }
    }

    private static void setRGB(BufferedImage image, ImageInfo info, int dim) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        info.pBytes = new byte[dim * 3];
        for (int i2 = 0; i2 < dim; ++i2) {
            int pix = pixels[i2];
            info.pBytes[p2++] = (byte)(pix & 0xFF);
            info.pBytes[p2++] = (byte)(pix >> 8 & 0xFF);
            info.pBytes[p2++] = (byte)(pix >> 16 & 0xFF);
        }
    }

    public String toString() {
        return "ImageInfo{iw=" + this.iw + ", ih=" + this.ih + ", nComp=" + this.nComp + ", bps=" + this.bps + '}';
    }
}

