/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.DataReader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class DataFileReader
implements DataReader {
    int pos;
    RandomAccessFile ra;
    int len;
    byte[] temp;
    int tSize;
    int ts;
    int te;

    DataFileReader(File f2) throws IOException {
        this.ra = new RandomAccessFile(f2, "r");
        this.len = (int)f2.length();
        this.tSize = Math.min(8192, this.len);
        this.temp = new byte[this.tSize];
        this.te = this.tSize;
        this.ra.read(this.temp);
    }

    DataFileReader(RandomAccessFile raf) throws IOException {
        this.ra = raf;
        this.len = (int)raf.length();
        this.tSize = Math.min(8192, this.len);
        this.temp = new byte[this.tSize];
        this.te = this.tSize;
        this.ra.read(this.temp);
    }

    @Override
    public int getU8() throws IOException {
        if (this.pos >= this.ts && this.pos < this.te) {
            int v2 = this.temp[this.pos - this.ts] & 0xFF;
            ++this.pos;
            return v2;
        }
        this.ts = this.pos;
        this.te = this.ts + this.tSize;
        this.ra.seek(this.pos);
        int max = Math.min(this.len - this.pos, this.tSize);
        this.ra.read(this.temp, 0, max);
        ++this.pos;
        return this.temp[0] & 0xFF;
    }

    @Override
    public void read(byte[] copyTo) throws IOException {
        int ii = Math.min(copyTo.length, this.len - this.pos);
        for (int i2 = 0; i2 < ii; ++i2) {
            copyTo[i2] = (byte)this.getU8();
        }
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public void skip(int n2) {
        this.pos += n2;
    }

    @Override
    public void moveTo(int p2) {
        this.pos = p2;
    }

    @Override
    public int getLength() {
        return this.len;
    }

    @Override
    public void close() throws IOException {
        this.ra.close();
    }
}

